/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/common"),require("@angular/core"),require("@angular/material/core")):"function"==typeof define&&define.amd?define("@angular/material/badge",["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/common","@angular/core","@angular/material/core"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.badge={}),e.ng.cdk.a11y,e.ng.cdk.coercion,e.ng.common,e.ng.core,e.ng.material.core)}(this,function(e,t,n,r,o,a){"use strict";function i(e,t){function n(){this.constructor=e}s(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}var s=function(e,t){return(s=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},c=0,d=function(){function e(){}return e}(),l=a.mixinDisabled(d),p=function(e){function a(t,n,r,o,a){var i=e.call(this)||this;return i._document=t,i._ngZone=n,i._elementRef=r,i._ariaDescriber=o,i._renderer=a,i._hasContent=!1,i._color="primary",i._overlap=!0,i.position="above after",i.size="medium",i._id=c++,i}return i(a,e),Object.defineProperty(a.prototype,"color",{get:function(){return this._color},set:function(e){this._setColor(e),this._color=e},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"overlap",{get:function(){return this._overlap},set:function(e){this._overlap=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"content",{get:function(){return this._content},set:function(e){this._content=e,this._hasContent=null!=e&&(""+e).trim().length>0,this._updateTextContent()},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"description",{get:function(){return this._description},set:function(e){e!==this._description&&(this._updateHostAriaDescription(e,this._description),this._description=e)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"hidden",{get:function(){return this._hidden},set:function(e){this._hidden=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),a.prototype.isAbove=function(){return-1===this.position.indexOf("below")},a.prototype.isAfter=function(){return-1===this.position.indexOf("before")},a.prototype.ngOnDestroy=function(){this.description&&this._badgeElement&&this._ariaDescriber.removeDescription(this._badgeElement,this.description)},a.prototype._updateTextContent=function(){return this._badgeElement?this._badgeElement.textContent=this.content:this._badgeElement=this._createBadgeElement(),this._badgeElement},a.prototype._createBadgeElement=function(){var e=this._renderer||this._document,t=e.createElement("span");return t.setAttribute("id","mat-badge-content-"+this._id),t.classList.add("mat-badge-content"),t.textContent=this.content,this.description&&t.setAttribute("aria-label",this.description),this._elementRef.nativeElement.appendChild(t),"function"==typeof requestAnimationFrame?this._ngZone.runOutsideAngular(function(){requestAnimationFrame(function(){t.classList.add("mat-badge-active")})}):t.classList.add("mat-badge-active"),t},a.prototype._updateHostAriaDescription=function(e,t){var n=this._updateTextContent();t&&this._ariaDescriber.removeDescription(n,t),e&&this._ariaDescriber.describe(n,e)},a.prototype._setColor=function(e){e!==this._color&&(this._color&&this._elementRef.nativeElement.classList.remove("mat-badge-"+this._color),e&&this._elementRef.nativeElement.classList.add("mat-badge-"+e))},a.decorators=[{type:o.Directive,args:[{selector:"[matBadge]",inputs:["disabled: matBadgeDisabled"],host:{class:"mat-badge","[class.mat-badge-overlap]":"overlap","[class.mat-badge-above]":"isAbove()","[class.mat-badge-below]":"!isAbove()","[class.mat-badge-before]":"!isAfter()","[class.mat-badge-after]":"isAfter()","[class.mat-badge-small]":'size === "small"',"[class.mat-badge-medium]":'size === "medium"',"[class.mat-badge-large]":'size === "large"',"[class.mat-badge-hidden]":"hidden || !_hasContent","[class.mat-badge-disabled]":"disabled"}}]}],a.ctorParameters=function(){return[{type:void 0,decorators:[{type:o.Optional},{type:o.Inject,args:[r.DOCUMENT]}]},{type:o.NgZone},{type:o.ElementRef},{type:t.AriaDescriber},{type:o.Renderer2}]},a.propDecorators={color:[{type:o.Input,args:["matBadgeColor"]}],overlap:[{type:o.Input,args:["matBadgeOverlap"]}],position:[{type:o.Input,args:["matBadgePosition"]}],content:[{type:o.Input,args:["matBadge"]}],description:[{type:o.Input,args:["matBadgeDescription"]}],size:[{type:o.Input,args:["matBadgeSize"]}],hidden:[{type:o.Input,args:["matBadgeHidden"]}]},a}(l),u=function(){function e(){}return e.decorators=[{type:o.NgModule,args:[{imports:[t.A11yModule,a.MatCommonModule],exports:[p],declarations:[p]}]}],e}();e.MatBadgeModule=u,e.MatBadgeBase=d,e._MatBadgeMixinBase=l,e.MatBadge=p,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-badge.umd.min.js.map
