/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/animations"),require("@angular/material/core"),require("@angular/cdk/portal"),require("@angular/cdk/layout"),require("@angular/common"),require("@angular/cdk/a11y"),require("@angular/cdk/overlay"),require("@angular/cdk/keycodes"),require("rxjs"),require("rxjs/operators"),require("@angular/cdk/bidi")):"function"==typeof define&&define.amd?define("@angular/material/bottomSheet",["exports","@angular/core","@angular/animations","@angular/material/core","@angular/cdk/portal","@angular/cdk/layout","@angular/common","@angular/cdk/a11y","@angular/cdk/overlay","@angular/cdk/keycodes","rxjs","rxjs/operators","@angular/cdk/bidi"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.bottomSheet={}),t.ng.core,t.ng.animations,t.ng.material.core,t.ng.cdk.portal,t.ng.cdk.layout,t.ng.common,t.ng.cdk.a11y,t.ng.cdk.overlay,t.ng.cdk.keycodes,t.rxjs,t.rxjs.operators,t.ng.cdk.bidi)}(this,function(t,e,o,n,a,i,r,s,c,l,u,p,h){"use strict";function d(t,e){function o(){this.constructor=t}f(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}function m(t,e){return _({},t,e)}var f=function(t,e){return(f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},_=function(){return _=Object.assign||function(t){for(var e,o=1,n=arguments.length;o<n;o++){e=arguments[o];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[a]=e[a])}return t},_.apply(this,arguments)},y=new e.InjectionToken("MatBottomSheetData"),g=function(){function t(){this.data=null,this.hasBackdrop=!0,this.disableClose=!1,this.ariaLabel=null,this.closeOnNavigation=!0,this.autoFocus=!0}return t}(),b={bottomSheetState:o.trigger("state",[o.state("void, hidden",o.style({transform:"translateY(100%)"})),o.state("visible",o.style({transform:"translateY(0%)"})),o.transition("visible => void, visible => hidden",o.animate(n.AnimationDurations.COMPLEX+" "+n.AnimationCurves.ACCELERATION_CURVE)),o.transition("void => visible",o.animate(n.AnimationDurations.EXITING+" "+n.AnimationCurves.DECELERATION_CURVE))])},v=function(t){function o(o,n,a,r,s,c){var l=t.call(this)||this;return l._elementRef=o,l._changeDetectorRef=n,l._focusTrapFactory=a,l.bottomSheetConfig=c,l._animationState="void",l._animationStateChanged=new e.EventEmitter,l._elementFocusedBeforeOpened=null,l._document=s,l._breakpointSubscription=r.observe([i.Breakpoints.Medium,i.Breakpoints.Large,i.Breakpoints.XLarge]).subscribe(function(){l._toggleClass("mat-bottom-sheet-container-medium",r.isMatched(i.Breakpoints.Medium)),l._toggleClass("mat-bottom-sheet-container-large",r.isMatched(i.Breakpoints.Large)),l._toggleClass("mat-bottom-sheet-container-xlarge",r.isMatched(i.Breakpoints.XLarge))}),l}return d(o,t),o.prototype.attachComponentPortal=function(t){return this._validatePortalAttached(),this._setPanelClass(),this._savePreviouslyFocusedElement(),this._portalOutlet.attachComponentPortal(t)},o.prototype.attachTemplatePortal=function(t){return this._validatePortalAttached(),this._setPanelClass(),this._savePreviouslyFocusedElement(),this._portalOutlet.attachTemplatePortal(t)},o.prototype.enter=function(){this._destroyed||(this._animationState="visible",this._changeDetectorRef.detectChanges())},o.prototype.exit=function(){this._destroyed||(this._animationState="hidden",this._changeDetectorRef.markForCheck())},o.prototype.ngOnDestroy=function(){this._breakpointSubscription.unsubscribe(),this._destroyed=!0},o.prototype._onAnimationDone=function(t){"hidden"===t.toState?this._restoreFocus():"visible"===t.toState&&this.bottomSheetConfig.autoFocus&&this._trapFocus(),this._animationStateChanged.emit(t)},o.prototype._onAnimationStart=function(t){this._animationStateChanged.emit(t)},o.prototype._toggleClass=function(t,e){var o=this._elementRef.nativeElement.classList;e?o.add(t):o.remove(t)},o.prototype._validatePortalAttached=function(){if(this._portalOutlet.hasAttached())throw Error("Attempting to attach bottom sheet content after content is already attached")},o.prototype._setPanelClass=function(){var t=this._elementRef.nativeElement,e=this.bottomSheetConfig.panelClass;Array.isArray(e)?e.forEach(function(e){return t.classList.add(e)}):e&&t.classList.add(e)},o.prototype._trapFocus=function(){this._focusTrap||(this._focusTrap=this._focusTrapFactory.create(this._elementRef.nativeElement)),this._focusTrap.focusInitialElementWhenReady()},o.prototype._restoreFocus=function(){var t=this._elementFocusedBeforeOpened;t&&"function"==typeof t.focus&&t.focus(),this._focusTrap&&this._focusTrap.destroy()},o.prototype._savePreviouslyFocusedElement=function(){var t=this;this._elementFocusedBeforeOpened=this._document.activeElement,this._elementRef.nativeElement.focus&&Promise.resolve().then(function(){return t._elementRef.nativeElement.focus()})},o.decorators=[{type:e.Component,args:[{selector:"mat-bottom-sheet-container",template:"<ng-template cdkPortalOutlet></ng-template>",styles:[".mat-bottom-sheet-container{padding:8px 16px;min-width:100vw;box-sizing:border-box;display:block;outline:0;max-height:80vh;overflow:auto}@media screen and (-ms-high-contrast:active){.mat-bottom-sheet-container{outline:1px solid}}.mat-bottom-sheet-container-large,.mat-bottom-sheet-container-medium,.mat-bottom-sheet-container-xlarge{border-top-left-radius:4px;border-top-right-radius:4px}.mat-bottom-sheet-container-medium{min-width:384px;max-width:calc(100vw - 128px)}.mat-bottom-sheet-container-large{min-width:512px;max-width:calc(100vw - 256px)}.mat-bottom-sheet-container-xlarge{min-width:576px;max-width:calc(100vw - 384px)}"],changeDetection:e.ChangeDetectionStrategy.OnPush,encapsulation:e.ViewEncapsulation.None,animations:[b.bottomSheetState],host:{class:"mat-bottom-sheet-container",tabindex:"-1",role:"dialog","aria-modal":"true","[attr.aria-label]":"bottomSheetConfig?.ariaLabel","[@state]":"_animationState","(@state.start)":"_onAnimationStart($event)","(@state.done)":"_onAnimationDone($event)"}}]}],o.ctorParameters=function(){return[{type:e.ElementRef},{type:e.ChangeDetectorRef},{type:s.FocusTrapFactory},{type:i.BreakpointObserver},{type:void 0,decorators:[{type:e.Optional},{type:e.Inject,args:[r.DOCUMENT]}]},{type:g}]},o.propDecorators={_portalOutlet:[{type:e.ViewChild,args:[a.CdkPortalOutlet]}]},o}(a.BasePortalOutlet),S=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{imports:[r.CommonModule,c.OverlayModule,n.MatCommonModule,a.PortalModule],exports:[v,n.MatCommonModule],declarations:[v],entryComponents:[v]}]}],t}(),C=function(){function t(t,e,o){var n=this;this._overlayRef=e,this._afterDismissed=new u.Subject,this._afterOpened=new u.Subject,this.containerInstance=t,t._animationStateChanged.pipe(p.filter(function(t){return"done"===t.phaseName&&"visible"===t.toState}),p.take(1)).subscribe(function(){n._afterOpened.next(),n._afterOpened.complete()}),t._animationStateChanged.pipe(p.filter(function(t){return"done"===t.phaseName&&"hidden"===t.toState}),p.take(1)).subscribe(function(){n._overlayRef.dispose(),n._afterDismissed.next(n._result),n._afterDismissed.complete()}),t.bottomSheetConfig.disableClose||u.merge(e.backdropClick(),e.keydownEvents().pipe(p.filter(function(t){return t.keyCode===l.ESCAPE}))).subscribe(function(){return n.dismiss()})}return t.prototype.dismiss=function(t){var e=this;this._afterDismissed.closed||(this.containerInstance._animationStateChanged.pipe(p.filter(function(t){return"start"===t.phaseName}),p.take(1)).subscribe(function(){return e._overlayRef.detachBackdrop()}),this._result=t,this.containerInstance.exit())},t.prototype.afterDismissed=function(){return this._afterDismissed.asObservable()},t.prototype.afterOpened=function(){return this._afterOpened.asObservable()},t.prototype.backdropClick=function(){return this._overlayRef.backdropClick()},t.prototype.keydownEvents=function(){return this._overlayRef.keydownEvents()},t}(),k=new e.InjectionToken("mat-bottom-sheet-default-options"),O=function(){function t(t,e,o,n,a){this._overlay=t,this._injector=e,this._parentBottomSheet=o,this._location=n,this._defaultOptions=a,this._bottomSheetRefAtThisLevel=null}return Object.defineProperty(t.prototype,"_openedBottomSheetRef",{get:function(){var t=this._parentBottomSheet;return t?t._openedBottomSheetRef:this._bottomSheetRefAtThisLevel},set:function(t){this._parentBottomSheet?this._parentBottomSheet._openedBottomSheetRef=t:this._bottomSheetRefAtThisLevel=t},enumerable:!0,configurable:!0}),t.prototype.open=function(t,o){var n=this,i=m(this._defaultOptions||new g,o),r=this._createOverlay(i),s=this._attachContainer(r,i),c=new C(s,r,this._location);if(t instanceof e.TemplateRef)s.attachTemplatePortal(new a.TemplatePortal(t,null,{$implicit:i.data,bottomSheetRef:c}));else{var l=new a.ComponentPortal(t,void 0,this._createInjector(i,c)),u=s.attachComponentPortal(l);c.instance=u.instance}return c.afterDismissed().subscribe(function(){n._openedBottomSheetRef==c&&(n._openedBottomSheetRef=null)}),this._openedBottomSheetRef?(this._openedBottomSheetRef.afterDismissed().subscribe(function(){return c.containerInstance.enter()}),this._openedBottomSheetRef.dismiss()):c.containerInstance.enter(),this._openedBottomSheetRef=c,c},t.prototype.dismiss=function(){this._openedBottomSheetRef&&this._openedBottomSheetRef.dismiss()},t.prototype.ngOnDestroy=function(){this._bottomSheetRefAtThisLevel&&this._bottomSheetRefAtThisLevel.dismiss()},t.prototype._attachContainer=function(t,e){var o=e&&e.viewContainerRef&&e.viewContainerRef.injector,n=new a.PortalInjector(o||this._injector,new WeakMap([[g,e]])),i=new a.ComponentPortal(v,e.viewContainerRef,n);return t.attach(i).instance},t.prototype._createOverlay=function(t){var e=new c.OverlayConfig({direction:t.direction,hasBackdrop:t.hasBackdrop,disposeOnNavigation:t.closeOnNavigation,maxWidth:"100%",scrollStrategy:this._overlay.scrollStrategies.block(),positionStrategy:this._overlay.position().global().centerHorizontally().bottom("0")});return t.backdropClass&&(e.backdropClass=t.backdropClass),this._overlay.create(e)},t.prototype._createInjector=function(t,e){var o=t&&t.viewContainerRef&&t.viewContainerRef.injector,n=new WeakMap([[C,e],[y,t.data]]);return!t.direction||o&&o.get(h.Directionality,null)||n.set(h.Directionality,{value:t.direction,change:u.of()}),new a.PortalInjector(o||this._injector,n)},t.decorators=[{type:e.Injectable,args:[{providedIn:S}]}],t.ctorParameters=function(){return[{type:c.Overlay},{type:e.Injector},{type:t,decorators:[{type:e.Optional},{type:e.SkipSelf}]},{type:r.Location,decorators:[{type:e.Optional}]},{type:g,decorators:[{type:e.Optional},{type:e.Inject,args:[k]}]}]},t.ngInjectableDef=e.defineInjectable({factory:function(){return new t(e.inject(c.Overlay),e.inject(e.INJECTOR),e.inject(t,12),e.inject(r.Location,8),e.inject(k,8))},token:t,providedIn:S}),t}();t.MatBottomSheetModule=S,t.MAT_BOTTOM_SHEET_DEFAULT_OPTIONS=k,t.MatBottomSheet=O,t.MAT_BOTTOM_SHEET_DATA=y,t.MatBottomSheetConfig=g,t.MatBottomSheetContainer=v,t.matBottomSheetAnimations=b,t.MatBottomSheetRef=C,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-bottom-sheet.umd.min.js.map
