/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/cdk/collections"),require("@angular/core"),require("@angular/forms"),require("@angular/material/core")):"function"==typeof define&&define.amd?define("@angular/material/buttonToggle",["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/cdk/collections","@angular/core","@angular/forms","@angular/material/core"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.buttonToggle={}),t.ng.cdk.a11y,t.ng.cdk.coercion,t.ng.cdk.collections,t.ng.core,t.ng.forms,t.ng.material.core)}(this,function(t,e,o,n,a,r,i){"use strict";function l(t,e){function o(){this.constructor=t}u(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}var u=function(t,e){return(u=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},c=new a.InjectionToken("MAT_BUTTON_TOGGLE_DEFAULT_OPTIONS"),s={provide:r.NG_VALUE_ACCESSOR,useExisting:a.forwardRef(function(){return h}),multi:!0},g=function(){function t(){}return t}(),p=0,d=function(){function t(t,e){this.source=t,this.value=e}return t}(),h=function(){function t(t,e){this._changeDetector=t,this._vertical=!1,this._multiple=!1,this._disabled=!1,this._controlValueAccessorChangeFn=function(){},this._onTouched=function(){},this._name="mat-button-toggle-group-"+p++,this.valueChange=new a.EventEmitter,this.change=new a.EventEmitter,this.appearance=e&&e.appearance?e.appearance:"standard"}return Object.defineProperty(t.prototype,"name",{get:function(){return this._name},set:function(t){var e=this;this._name=t,this._buttonToggles&&this._buttonToggles.forEach(function(t){return t.name=e._name})},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"vertical",{get:function(){return this._vertical},set:function(t){this._vertical=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){var t=this._selectionModel?this._selectionModel.selected:[];return this.multiple?t.map(function(t){return t.value}):t[0]?t[0].value:void 0},set:function(t){this._setSelectionByValue(t),this.valueChange.emit(this.value)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"selected",{get:function(){var t=this._selectionModel.selected;return this.multiple?t:t[0]||null},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"multiple",{get:function(){return this._multiple},set:function(t){this._multiple=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"disabled",{get:function(){return this._disabled},set:function(t){this._disabled=o.coerceBooleanProperty(t),this._buttonToggles&&this._buttonToggles.forEach(function(t){return t._markForCheck()})},enumerable:!0,configurable:!0}),t.prototype.ngOnInit=function(){this._selectionModel=new n.SelectionModel(this.multiple,void 0,!1)},t.prototype.ngAfterContentInit=function(){var t;(t=this._selectionModel).select.apply(t,this._buttonToggles.filter(function(t){return t.checked}))},t.prototype.writeValue=function(t){this.value=t,this._changeDetector.markForCheck()},t.prototype.registerOnChange=function(t){this._controlValueAccessorChangeFn=t},t.prototype.registerOnTouched=function(t){this._onTouched=t},t.prototype.setDisabledState=function(t){this.disabled=t},t.prototype._emitChangeEvent=function(){var t=this.selected,e=Array.isArray(t)?t[t.length-1]:t,o=new d(e,this.value);this._controlValueAccessorChangeFn(o.value),this.change.emit(o)},t.prototype._syncButtonToggle=function(t,e,o){void 0===o&&(o=!1),this.multiple||!this.selected||t.checked||(this.selected.checked=!1),e?this._selectionModel.select(t):this._selectionModel.deselect(t),o&&this._emitChangeEvent(),this.valueChange.emit(this.value)},t.prototype._isSelected=function(t){return this._selectionModel.isSelected(t)},t.prototype._isPrechecked=function(t){return void 0!==this._rawValue&&(this.multiple&&Array.isArray(this._rawValue)?this._rawValue.some(function(e){return null!=t.value&&e===t.value}):t.value===this._rawValue)},t.prototype._setSelectionByValue=function(t){var e=this;if(this._rawValue=t,this._buttonToggles)if(this.multiple&&t){if(!Array.isArray(t))throw Error("Value must be an array in multiple-selection mode.");this._clearSelection(),t.forEach(function(t){return e._selectValue(t)})}else this._clearSelection(),this._selectValue(t)},t.prototype._clearSelection=function(){this._selectionModel.clear(),this._buttonToggles.forEach(function(t){return t.checked=!1})},t.prototype._selectValue=function(t){var e=this._buttonToggles.find(function(e){return null!=e.value&&e.value===t});e&&(e.checked=!0,this._selectionModel.select(e))},t.decorators=[{type:a.Directive,args:[{selector:"mat-button-toggle-group",providers:[s,{provide:g,useExisting:t}],host:{role:"group",class:"mat-button-toggle-group","[attr.aria-disabled]":"disabled","[class.mat-button-toggle-vertical]":"vertical","[class.mat-button-toggle-group-appearance-standard]":'appearance === "standard"'},exportAs:"matButtonToggleGroup"}]}],t.ctorParameters=function(){return[{type:a.ChangeDetectorRef},{type:void 0,decorators:[{type:a.Optional},{type:a.Inject,args:[c]}]}]},t.propDecorators={_buttonToggles:[{type:a.ContentChildren,args:[a.forwardRef(function(){return f})]}],appearance:[{type:a.Input}],name:[{type:a.Input}],vertical:[{type:a.Input}],value:[{type:a.Input}],valueChange:[{type:a.Output}],multiple:[{type:a.Input}],disabled:[{type:a.Input}],change:[{type:a.Output}]},t}(),b=function(){function t(){}return t}(),m=i.mixinDisableRipple(b),f=function(t){function n(e,o,n,r,i,l){var u=t.call(this)||this;u._changeDetectorRef=o,u._elementRef=n,u._focusMonitor=r,u._isSingleSelector=!1,u._checked=!1,u.ariaLabelledby=null,u._disabled=!1,u.change=new a.EventEmitter;var c=Number(i);return u.tabIndex=c||0===c?c:null,u.buttonToggleGroup=e,u.appearance=l&&l.appearance?l.appearance:"standard",u}return l(n,t),Object.defineProperty(n.prototype,"buttonId",{get:function(){return this.id+"-button"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"appearance",{get:function(){return this.buttonToggleGroup?this.buttonToggleGroup.appearance:this._appearance},set:function(t){this._appearance=t},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"checked",{get:function(){return this.buttonToggleGroup?this.buttonToggleGroup._isSelected(this):this._checked},set:function(t){var e=o.coerceBooleanProperty(t);e!==this._checked&&(this._checked=e,this.buttonToggleGroup&&this.buttonToggleGroup._syncButtonToggle(this,this._checked),this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"disabled",{get:function(){return this._disabled||this.buttonToggleGroup&&this.buttonToggleGroup.disabled},set:function(t){this._disabled=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),n.prototype.ngOnInit=function(){this._isSingleSelector=this.buttonToggleGroup&&!this.buttonToggleGroup.multiple,this._type=this._isSingleSelector?"radio":"checkbox",this.id=this.id||"mat-button-toggle-"+p++,this._isSingleSelector&&(this.name=this.buttonToggleGroup.name),this.buttonToggleGroup&&this.buttonToggleGroup._isPrechecked(this)&&(this.checked=!0),this._focusMonitor.monitor(this._elementRef,!0)},n.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._elementRef)},n.prototype.focus=function(){this._buttonElement.nativeElement.focus()},n.prototype._onButtonClick=function(){var t=!!this._isSingleSelector||!this._checked;t!==this._checked&&(this._checked=t,this.buttonToggleGroup&&(this.buttonToggleGroup._syncButtonToggle(this,this._checked,!0),this.buttonToggleGroup._onTouched())),this.change.emit(new d(this,this.value))},n.prototype._markForCheck=function(){this._changeDetectorRef.markForCheck()},n.decorators=[{type:a.Component,args:[{selector:"mat-button-toggle",template:'<button #button class="mat-button-toggle-button" type="button" [id]="buttonId" [attr.tabindex]="disabled ? -1 : tabIndex" [attr.aria-pressed]="checked" [disabled]="disabled || null" [attr.name]="name || null" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" (click)="_onButtonClick()"><div class="mat-button-toggle-label-content"><ng-content></ng-content></div></button><div class="mat-button-toggle-focus-overlay"></div><div class="mat-button-toggle-ripple" matRipple [matRippleTrigger]="button" [matRippleDisabled]="this.disableRipple || this.disabled"></div>',styles:[".mat-button-toggle-group,.mat-button-toggle-standalone{position:relative;display:inline-flex;flex-direction:row;cursor:pointer;white-space:nowrap;overflow:hidden;border-radius:2px}@media screen and (-ms-high-contrast:active){.mat-button-toggle-group,.mat-button-toggle-standalone{outline:solid 1px}}.mat-button-toggle-group-appearance-standard,.mat-button-toggle-standalone.mat-button-toggle-appearance-standard{border-radius:4px}@media screen and (-ms-high-contrast:active){.mat-button-toggle-group-appearance-standard,.mat-button-toggle-standalone.mat-button-toggle-appearance-standard{outline:0}}.mat-button-toggle-vertical{flex-direction:column}.mat-button-toggle-vertical .mat-button-toggle-label-content{display:block}.mat-button-toggle{white-space:nowrap;position:relative;-webkit-tap-highlight-color:transparent}.mat-button-toggle.cdk-keyboard-focused .mat-button-toggle-focus-overlay{opacity:1}@media screen and (-ms-high-contrast:active){.mat-button-toggle.cdk-keyboard-focused .mat-button-toggle-focus-overlay{opacity:.5}}.mat-button-toggle-appearance-standard:not(.mat-button-toggle-disabled):hover .mat-button-toggle-focus-overlay{opacity:.04}.mat-button-toggle-appearance-standard.cdk-keyboard-focused:not(.mat-button-toggle-disabled) .mat-button-toggle-focus-overlay{opacity:.12}@media screen and (-ms-high-contrast:active){.mat-button-toggle-appearance-standard.cdk-keyboard-focused:not(.mat-button-toggle-disabled) .mat-button-toggle-focus-overlay{opacity:.5}}.mat-button-toggle-label-content{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:inline-block;line-height:36px;padding:0 16px}.mat-button-toggle-appearance-standard .mat-button-toggle-label-content{line-height:48px;padding:0 12px}.mat-button-toggle-label-content>*{vertical-align:middle}.mat-button-toggle-focus-overlay{border-radius:inherit;pointer-events:none;opacity:0;top:0;left:0;right:0;bottom:0;position:absolute}.mat-button-toggle-checked .mat-button-toggle-focus-overlay{border-bottom:solid 36px}@media screen and (-ms-high-contrast:active){.mat-button-toggle-checked .mat-button-toggle-focus-overlay{opacity:.5;height:0}}@media screen and (-ms-high-contrast:active){.mat-button-toggle-checked.mat-button-toggle-appearance-standard .mat-button-toggle-focus-overlay{border-bottom:solid 48px}}.mat-button-toggle .mat-button-toggle-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}.mat-button-toggle-button{border:0;background:0 0;color:inherit;padding:0;margin:0;font:inherit;outline:0;width:100%;cursor:pointer}.mat-button-toggle-disabled .mat-button-toggle-button{cursor:default}.mat-button-toggle-button::-moz-focus-inner{border:0}"],encapsulation:a.ViewEncapsulation.None,exportAs:"matButtonToggle",changeDetection:a.ChangeDetectionStrategy.OnPush,inputs:["disableRipple"],host:{"[class.mat-button-toggle-standalone]":"!buttonToggleGroup","[class.mat-button-toggle-checked]":"checked","[class.mat-button-toggle-disabled]":"disabled","[class.mat-button-toggle-appearance-standard]":'appearance === "standard"',class:"mat-button-toggle","[attr.tabindex]":"null","[attr.id]":"id"}}]}],n.ctorParameters=function(){return[{type:h,decorators:[{type:a.Optional}]},{type:a.ChangeDetectorRef},{type:a.ElementRef},{type:e.FocusMonitor},{type:String,decorators:[{type:a.Attribute,args:["tabindex"]}]},{type:void 0,decorators:[{type:a.Optional},{type:a.Inject,args:[c]}]}]},n.propDecorators={ariaLabel:[{type:a.Input,args:["aria-label"]}],ariaLabelledby:[{type:a.Input,args:["aria-labelledby"]}],_buttonElement:[{type:a.ViewChild,args:["button"]}],id:[{type:a.Input}],name:[{type:a.Input}],value:[{type:a.Input}],tabIndex:[{type:a.Input}],appearance:[{type:a.Input}],checked:[{type:a.Input}],disabled:[{type:a.Input}],change:[{type:a.Output}]},n}(m),y=function(){function t(){}return t.decorators=[{type:a.NgModule,args:[{imports:[i.MatCommonModule,i.MatRippleModule],exports:[i.MatCommonModule,h,f],declarations:[h,f]}]}],t}();t.MAT_BUTTON_TOGGLE_DEFAULT_OPTIONS=c,t.MAT_BUTTON_TOGGLE_GROUP_VALUE_ACCESSOR=s,t.MatButtonToggleGroupMultiple=g,t.MatButtonToggleChange=d,t.MatButtonToggleGroup=h,t.MatButtonToggleBase=b,t._MatButtonToggleMixinBase=m,t.MatButtonToggle=f,t.MatButtonToggleModule=y,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-button-toggle.umd.min.js.map
