/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/animations"),require("@angular/cdk/accordion"),require("@angular/cdk/coercion"),require("@angular/cdk/collections"),require("@angular/cdk/portal"),require("@angular/common"),require("@angular/platform-browser/animations"),require("rxjs"),require("rxjs/operators"),require("@angular/cdk/a11y"),require("@angular/cdk/keycodes")):"function"==typeof define&&define.amd?define("@angular/material/expansion",["exports","@angular/core","@angular/animations","@angular/cdk/accordion","@angular/cdk/coercion","@angular/cdk/collections","@angular/cdk/portal","@angular/common","@angular/platform-browser/animations","rxjs","rxjs/operators","@angular/cdk/a11y","@angular/cdk/keycodes"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.expansion={}),e.ng.core,e.ng.animations,e.ng.cdk.accordion,e.ng.cdk.coercion,e.ng.cdk.collections,e.ng.cdk.portal,e.ng.common,e.ng.platformBrowser.animations,e.rxjs,e.rxjs.operators,e.ng.cdk.a11y,e.ng.cdk.keycodes)}(this,function(e,t,n,a,o,i,r,s,p,d,c,l,u){"use strict";function g(e,t){function n(){this.constructor=e}m(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}var m=function(e,t){return(m=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},h=new t.InjectionToken("MAT_ACCORDION"),x={indicatorRotate:n.trigger("indicatorRotate",[n.state("collapsed, void",n.style({transform:"rotate(0deg)"})),n.state("expanded",n.style({transform:"rotate(180deg)"})),n.transition("expanded <=> collapsed, void => collapsed",n.animate("225ms cubic-bezier(0.4,0.0,0.2,1)"))]),expansionHeaderHeight:n.trigger("expansionHeight",[n.state("collapsed, void",n.style({height:"{{collapsedHeight}}"}),{params:{collapsedHeight:"48px"}}),n.state("expanded",n.style({height:"{{expandedHeight}}"}),{params:{expandedHeight:"64px"}}),n.transition("expanded <=> collapsed, void => collapsed",n.group([n.query("@indicatorRotate",n.animateChild(),{optional:!0}),n.animate("225ms cubic-bezier(0.4,0.0,0.2,1)")]))]),bodyExpansion:n.trigger("bodyExpansion",[n.state("collapsed, void",n.style({height:"0px",visibility:"hidden"})),n.state("expanded",n.style({height:"*",visibility:"visible"})),n.transition("expanded <=> collapsed, void => collapsed",n.animate("225ms cubic-bezier(0.4,0.0,0.2,1)"))])},f=function(){function e(e){this._template=e}return e.decorators=[{type:t.Directive,args:[{selector:"ng-template[matExpansionPanelContent]"}]}],e.ctorParameters=function(){return[{type:t.TemplateRef}]},e}(),y=a.CdkAccordionItem,b=0,_=function(e){function n(n,a,o,i,r,s){var p=e.call(this,n,a,o)||this;return p._viewContainerRef=i,p._animationMode=s,p._hideToggle=!1,p.afterExpand=new t.EventEmitter,p.afterCollapse=new t.EventEmitter,p._inputChanges=new d.Subject,p._headerId="mat-expansion-panel-header-"+b++,p.accordion=n,p._document=r,p}return g(n,e),Object.defineProperty(n.prototype,"hideToggle",{get:function(){return this._hideToggle||this.accordion&&this.accordion.hideToggle},set:function(e){this._hideToggle=o.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),n.prototype._hasSpacing=function(){return!!this.accordion&&"default"===(this.expanded?this.accordion.displayMode:this._getExpandedState())},n.prototype._getExpandedState=function(){return this.expanded?"expanded":"collapsed"},n.prototype.ngAfterContentInit=function(){var e=this;this._lazyContent&&this.opened.pipe(c.startWith(null),c.filter(function(){return e.expanded&&!e._portal}),c.take(1)).subscribe(function(){e._portal=new r.TemplatePortal(e._lazyContent._template,e._viewContainerRef)})},n.prototype.ngOnChanges=function(e){this._inputChanges.next(e)},n.prototype.ngOnDestroy=function(){e.prototype.ngOnDestroy.call(this),this._inputChanges.complete()},n.prototype._bodyAnimation=function(e){var t=e.phaseName,n=e.toState,a=e.fromState;"done"===t&&"expanded"===n&&"void"!==a&&this.afterExpand.emit(),"done"===t&&"collapsed"===n&&"void"!==a&&this.afterCollapse.emit()},n.prototype._containsFocus=function(){if(this._body&&this._document){var e=this._document.activeElement,t=this._body.nativeElement;return e===t||t.contains(e)}return!1},n.decorators=[{type:t.Component,args:[{styles:[".mat-expansion-panel{box-sizing:content-box;display:block;margin:0;border-radius:4px;overflow:hidden;transition:margin 225ms cubic-bezier(.4,0,.2,1),box-shadow 280ms cubic-bezier(.4,0,.2,1)}.mat-accordion .mat-expansion-panel:not(.mat-expanded),.mat-accordion .mat-expansion-panel:not(.mat-expansion-panel-spacing){border-radius:0}.mat-accordion .mat-expansion-panel:first-of-type{border-top-right-radius:4px;border-top-left-radius:4px}.mat-accordion .mat-expansion-panel:last-of-type{border-bottom-right-radius:4px;border-bottom-left-radius:4px}@media screen and (-ms-high-contrast:active){.mat-expansion-panel{outline:solid 1px}}.mat-expansion-panel._mat-animation-noopable,.mat-expansion-panel.ng-animate-disabled,.ng-animate-disabled .mat-expansion-panel{transition:none}.mat-expansion-panel-content{display:flex;flex-direction:column;overflow:visible}.mat-expansion-panel-body{padding:0 24px 16px}.mat-expansion-panel-spacing{margin:16px 0}.mat-accordion>.mat-expansion-panel-spacing:first-child,.mat-accordion>:first-child:not(.mat-expansion-panel) .mat-expansion-panel-spacing{margin-top:0}.mat-accordion>.mat-expansion-panel-spacing:last-child,.mat-accordion>:last-child:not(.mat-expansion-panel) .mat-expansion-panel-spacing{margin-bottom:0}.mat-action-row{border-top-style:solid;border-top-width:1px;display:flex;flex-direction:row;justify-content:flex-end;padding:16px 8px 16px 24px}.mat-action-row button.mat-button{margin-left:8px}[dir=rtl] .mat-action-row button.mat-button{margin-left:0;margin-right:8px}"],selector:"mat-expansion-panel",exportAs:"matExpansionPanel",template:'<ng-content select="mat-expansion-panel-header"></ng-content><div class="mat-expansion-panel-content" role="region" [@bodyExpansion]="_getExpandedState()" (@bodyExpansion.done)="_bodyAnimation($event)" [attr.aria-labelledby]="_headerId" [id]="id" #body><div class="mat-expansion-panel-body"><ng-content></ng-content><ng-template [cdkPortalOutlet]="_portal"></ng-template></div><ng-content select="mat-action-row"></ng-content></div>',encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush,inputs:["disabled","expanded"],outputs:["opened","closed","expandedChange"],animations:[x.bodyExpansion],providers:[{provide:h,useValue:void 0}],host:{class:"mat-expansion-panel","[class.mat-expanded]":"expanded","[class._mat-animation-noopable]":'_animationMode === "NoopAnimations"',"[class.mat-expansion-panel-spacing]":"_hasSpacing()"}}]}],n.ctorParameters=function(){return[{type:void 0,decorators:[{type:t.Optional},{type:t.SkipSelf},{type:t.Inject,args:[h]}]},{type:t.ChangeDetectorRef},{type:i.UniqueSelectionDispatcher},{type:t.ViewContainerRef},{type:void 0,decorators:[{type:t.Inject,args:[s.DOCUMENT]}]},{type:String,decorators:[{type:t.Optional},{type:t.Inject,args:[p.ANIMATION_MODULE_TYPE]}]}]},n.propDecorators={hideToggle:[{type:t.Input}],afterExpand:[{type:t.Output}],afterCollapse:[{type:t.Output}],_lazyContent:[{type:t.ContentChild,args:[f]}],_body:[{type:t.ViewChild,args:["body"]}]},n}(a.CdkAccordionItem),v=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-action-row",host:{class:"mat-action-row"}}]}],e}(),C=function(){function e(e,t,n,a){var o=this;this.panel=e,this._element=t,this._focusMonitor=n,this._changeDetectorRef=a,this._parentChangeSubscription=d.Subscription.EMPTY;var i=e.accordion?e.accordion._stateChanges.pipe(c.filter(function(e){return!!e.hideToggle})):d.EMPTY;this._parentChangeSubscription=d.merge(e.opened,e.closed,i,e._inputChanges.pipe(c.filter(function(e){return!(!e.hideToggle&&!e.disabled)}))).subscribe(function(){return o._changeDetectorRef.markForCheck()}),e.closed.pipe(c.filter(function(){return e._containsFocus()})).subscribe(function(){return n.focusVia(t,"program")}),n.monitor(t).subscribe(function(t){t&&e.accordion&&e.accordion._handleHeaderFocus(o)})}return Object.defineProperty(e.prototype,"disabled",{get:function(){return this.panel.disabled},enumerable:!0,configurable:!0}),e.prototype._toggle=function(){this.panel.toggle()},e.prototype._isExpanded=function(){return this.panel.expanded},e.prototype._getExpandedState=function(){return this.panel._getExpandedState()},e.prototype._getPanelId=function(){return this.panel.id},e.prototype._showToggle=function(){return!this.panel.hideToggle&&!this.panel.disabled},e.prototype._keydown=function(e){switch(e.keyCode){case u.SPACE:case u.ENTER:e.preventDefault(),this._toggle();break;default:return void(this.panel.accordion&&this.panel.accordion._handleHeaderKeydown(e))}},e.prototype.focus=function(e){void 0===e&&(e="program"),this._focusMonitor.focusVia(this._element,e)},e.prototype.ngOnDestroy=function(){this._parentChangeSubscription.unsubscribe(),this._focusMonitor.stopMonitoring(this._element)},e.decorators=[{type:t.Component,args:[{selector:"mat-expansion-panel-header",styles:[".mat-expansion-panel-header{display:flex;flex-direction:row;align-items:center;padding:0 24px;border-radius:inherit}.mat-expansion-panel-header:focus,.mat-expansion-panel-header:hover{outline:0}.mat-expansion-panel-header.mat-expanded:focus,.mat-expansion-panel-header.mat-expanded:hover{background:inherit}.mat-expansion-panel-header:not([aria-disabled=true]){cursor:pointer}.mat-content{display:flex;flex:1;flex-direction:row;overflow:hidden}.mat-expansion-panel-header-description,.mat-expansion-panel-header-title{display:flex;flex-grow:1;margin-right:16px}[dir=rtl] .mat-expansion-panel-header-description,[dir=rtl] .mat-expansion-panel-header-title{margin-right:0;margin-left:16px}.mat-expansion-panel-header-description{flex-grow:2}.mat-expansion-indicator::after{border-style:solid;border-width:0 2px 2px 0;content:'';display:inline-block;padding:3px;transform:rotate(45deg);vertical-align:middle}"],template:'<span class="mat-content"><ng-content select="mat-panel-title"></ng-content><ng-content select="mat-panel-description"></ng-content><ng-content></ng-content></span><span [@indicatorRotate]="_getExpandedState()" *ngIf="_showToggle()" class="mat-expansion-indicator"></span>',encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush,animations:[x.indicatorRotate,x.expansionHeaderHeight],host:{class:"mat-expansion-panel-header",role:"button","[attr.id]":"panel._headerId","[attr.tabindex]":"disabled ? -1 : 0","[attr.aria-controls]":"_getPanelId()","[attr.aria-expanded]":"_isExpanded()","[attr.aria-disabled]":"panel.disabled","[class.mat-expanded]":"_isExpanded()","(click)":"_toggle()","(keydown)":"_keydown($event)","[@expansionHeight]":"{\n        value: _getExpandedState(),\n        params: {\n          collapsedHeight: collapsedHeight,\n          expandedHeight: expandedHeight\n        }\n    }"}}]}],e.ctorParameters=function(){return[{type:_,decorators:[{type:t.Host}]},{type:t.ElementRef},{type:l.FocusMonitor},{type:t.ChangeDetectorRef}]},e.propDecorators={expandedHeight:[{type:t.Input}],collapsedHeight:[{type:t.Input}]},e}(),E=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-panel-description",host:{class:"mat-expansion-panel-header-description"}}]}],e}(),k=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-panel-title",host:{class:"mat-expansion-panel-header-title"}}]}],e}(),w=function(e){function n(){var t=null!==e&&e.apply(this,arguments)||this;return t._hideToggle=!1,t.displayMode="default",t}return g(n,e),Object.defineProperty(n.prototype,"hideToggle",{get:function(){return this._hideToggle},set:function(e){this._hideToggle=o.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),n.prototype.ngAfterContentInit=function(){this._keyManager=new l.FocusKeyManager(this._headers).withWrap()},n.prototype._handleHeaderKeydown=function(e){var t=e.keyCode,n=this._keyManager;t===u.HOME?(n.setFirstItemActive(),e.preventDefault()):t===u.END?(n.setLastItemActive(),e.preventDefault()):this._keyManager.onKeydown(e)},n.prototype._handleHeaderFocus=function(e){this._keyManager.updateActiveItem(e)},n.decorators=[{type:t.Directive,args:[{selector:"mat-accordion",exportAs:"matAccordion",inputs:["multi"],providers:[{provide:h,useExisting:n}],host:{class:"mat-accordion"}}]}],n.propDecorators={_headers:[{type:t.ContentChildren,args:[C,{descendants:!0}]}],hideToggle:[{type:t.Input}],displayMode:[{type:t.Input}]},n}(a.CdkAccordion),M=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[s.CommonModule,a.CdkAccordionModule,r.PortalModule],exports:[w,_,v,C,k,E,f],declarations:[w,_,v,C,k,E,f]}]}],e}();e.MatExpansionModule=M,e.MatAccordion=w,e.MAT_ACCORDION=h,e._CdkAccordionItem=y,e.MatExpansionPanel=_,e.MatExpansionPanelActionRow=v,e.MatExpansionPanelHeader=C,e.MatExpansionPanelDescription=E,e.MatExpansionPanelTitle=k,e.MatExpansionPanelContent=f,e.EXPANSION_PANEL_ANIMATION_TIMING="225ms cubic-bezier(0.4,0.0,0.2,1)",e.matExpansionAnimations=x,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-expansion.umd.min.js.map
