/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/cdk/portal"),require("@angular/common"),require("rxjs"),require("@angular/animations"),require("@angular/cdk/a11y"),require("@angular/material/core"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("rxjs/operators"),require("@angular/cdk/bidi"),require("@angular/cdk/overlay")):"function"==typeof define&&define.amd?define("@angular/material/menu",["exports","@angular/core","@angular/cdk/portal","@angular/common","rxjs","@angular/animations","@angular/cdk/a11y","@angular/material/core","@angular/cdk/coercion","@angular/cdk/keycodes","rxjs/operators","@angular/cdk/bidi","@angular/cdk/overlay"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.menu={}),e.ng.core,e.ng.cdk.portal,e.ng.common,e.rxjs,e.ng.animations,e.ng.cdk.a11y,e.ng.material.core,e.ng.cdk.coercion,e.ng.cdk.keycodes,e.rxjs.operators,e.ng.cdk.bidi,e.ng.cdk.overlay)}(this,function(e,t,n,i,o,r,s,a,u,p,c,l,m){"use strict";function h(e,t){function n(){this.constructor=e}b(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}function d(){throw Error('matMenuTriggerFor: must pass in an mat-menu instance.\n\n    Example:\n      <mat-menu #menu="matMenu"></mat-menu>\n      <button [matMenuTriggerFor]="menu"></button>')}function g(){throw Error('xPosition value must be either \'before\' or after\'.\n      Example: <mat-menu xPosition="before" #menu="matMenu"></mat-menu>')}function f(){throw Error('yPosition value must be either \'above\' or below\'.\n      Example: <mat-menu yPosition="above" #menu="matMenu"></mat-menu>')}function _(){return{overlapTrigger:!1,xPosition:"after",yPosition:"below",backdropClass:"cdk-overlay-transparent-backdrop"}}function y(e){return function(){return e.scrollStrategies.reposition()}}var b=function(e,t){return(b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},v=function(){function e(e,t,n,i,r,s){this._template=e,this._componentFactoryResolver=t,this._appRef=n,this._injector=i,this._viewContainerRef=r,this._document=s,this._attached=new o.Subject}return e.prototype.attach=function(e){void 0===e&&(e={}),this._portal||(this._portal=new n.TemplatePortal(this._template,this._viewContainerRef)),this.detach(),this._outlet||(this._outlet=new n.DomPortalOutlet(this._document.createElement("div"),this._componentFactoryResolver,this._appRef,this._injector));var t=this._template.elementRef.nativeElement;t.parentNode.insertBefore(this._outlet.outletElement,t),this._portal.attach(this._outlet,e),this._attached.next()},e.prototype.detach=function(){this._portal.isAttached&&this._portal.detach()},e.prototype.ngOnDestroy=function(){this._outlet&&this._outlet.dispose()},e.decorators=[{type:t.Directive,args:[{selector:"ng-template[matMenuContent]"}]}],e.ctorParameters=function(){return[{type:t.TemplateRef},{type:t.ComponentFactoryResolver},{type:t.ApplicationRef},{type:t.Injector},{type:t.ViewContainerRef},{type:void 0,decorators:[{type:t.Inject,args:[i.DOCUMENT]}]}]},e}(),M={transformMenu:r.trigger("transformMenu",[r.state("void",r.style({opacity:0,transform:"scale(0.8)"})),r.transition("void => enter",r.group([r.query(".mat-menu-content",r.animate("100ms linear",r.style({opacity:1}))),r.animate("120ms cubic-bezier(0, 0, 0.2, 1)",r.style({transform:"scale(1)"}))])),r.transition("* => void",r.animate("100ms 25ms linear",r.style({opacity:0})))]),fadeInItems:r.trigger("fadeInItems",[r.state("showing",r.style({opacity:1})),r.transition("void => *",[r.style({opacity:0}),r.animate("400ms 100ms cubic-bezier(0.55, 0, 0.55, 0.2)")])])},k=M.fadeInItems,O=M.transformMenu,C=new t.InjectionToken("MAT_MENU_PANEL"),x=function(){function e(){}return e}(),w=a.mixinDisableRipple(a.mixinDisabled(x)),P=function(e){function n(t,n,i,r){var s=e.call(this)||this;return s._elementRef=t,s._focusMonitor=i,s._parentMenu=r,s._hovered=new o.Subject,s._highlighted=!1,s._triggersSubmenu=!1,i&&i.monitor(s._elementRef,!1),r&&r.addItem&&r.addItem(s),s._document=n,s}return h(n,e),n.prototype.focus=function(e){void 0===e&&(e="program"),this._focusMonitor?this._focusMonitor.focusVia(this._getHostElement(),e):this._getHostElement().focus()},n.prototype.ngOnDestroy=function(){this._focusMonitor&&this._focusMonitor.stopMonitoring(this._elementRef),this._parentMenu&&this._parentMenu.removeItem&&this._parentMenu.removeItem(this),this._hovered.complete()},n.prototype._getTabIndex=function(){return this.disabled?"-1":"0"},n.prototype._getHostElement=function(){return this._elementRef.nativeElement},n.prototype._checkDisabled=function(e){this.disabled&&(e.preventDefault(),e.stopPropagation())},n.prototype._handleMouseEnter=function(){this._hovered.next(this)},n.prototype.getLabel=function(){var e=this._elementRef.nativeElement,t=this._document?this._document.TEXT_NODE:3,n="";if(e.childNodes)for(var i=e.childNodes.length,o=0;o<i;o++)e.childNodes[o].nodeType===t&&(n+=e.childNodes[o].textContent);return n.trim()},n.decorators=[{type:t.Component,args:[{selector:"[mat-menu-item]",exportAs:"matMenuItem",inputs:["disabled","disableRipple"],host:{role:"menuitem",class:"mat-menu-item","[class.mat-menu-item-highlighted]":"_highlighted","[class.mat-menu-item-submenu-trigger]":"_triggersSubmenu","[attr.tabindex]":"_getTabIndex()","[attr.aria-disabled]":"disabled.toString()","[attr.disabled]":"disabled || null","(click)":"_checkDisabled($event)","(mouseenter)":"_handleMouseEnter()"},changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None,template:'<ng-content></ng-content><div class="mat-menu-ripple" matRipple [matRippleDisabled]="disableRipple || disabled" [matRippleTrigger]="_getHostElement()"></div>'}]}],n.ctorParameters=function(){return[{type:t.ElementRef},{type:void 0,decorators:[{type:t.Inject,args:[i.DOCUMENT]}]},{type:s.FocusMonitor},{type:void 0,decorators:[{type:t.Inject,args:[C]},{type:t.Optional}]}]},n}(w),I=new t.InjectionToken("mat-menu-default-options",{providedIn:"root",factory:_}),R=function(){function e(e,n,i){this._elementRef=e,this._ngZone=n,this._defaultOptions=i,this._xPosition=this._defaultOptions.xPosition,this._yPosition=this._defaultOptions.yPosition,this._items=[],this._itemChanges=new o.Subject,this._tabSubscription=o.Subscription.EMPTY,this._classList={},this._panelAnimationState="void",this._animationDone=new o.Subject,this.backdropClass=this._defaultOptions.backdropClass,this._overlapTrigger=this._defaultOptions.overlapTrigger,this._hasBackdrop=this._defaultOptions.hasBackdrop,this.closed=new t.EventEmitter,this.close=this.closed}return Object.defineProperty(e.prototype,"xPosition",{get:function(){return this._xPosition},set:function(e){"before"!==e&&"after"!==e&&g(),this._xPosition=e,this.setPositionClasses()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"yPosition",{get:function(){return this._yPosition},set:function(e){"above"!==e&&"below"!==e&&f(),this._yPosition=e,this.setPositionClasses()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"overlapTrigger",{get:function(){return this._overlapTrigger},set:function(e){this._overlapTrigger=u.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hasBackdrop",{get:function(){return this._hasBackdrop},set:function(e){this._hasBackdrop=u.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"panelClass",{set:function(e){e&&e.length&&(this._classList=e.split(" ").reduce(function(e,t){return e[t]=!0,e},{}),this._elementRef.nativeElement.className="")},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"classList",{get:function(){return this.panelClass},set:function(e){this.panelClass=e},enumerable:!0,configurable:!0}),e.prototype.ngOnInit=function(){this.setPositionClasses()},e.prototype.ngAfterContentInit=function(){var e=this;this._keyManager=new s.FocusKeyManager(this._items).withWrap().withTypeAhead(),this._tabSubscription=this._keyManager.tabOut.subscribe(function(){return e.closed.emit("tab")})},e.prototype.ngOnDestroy=function(){this._tabSubscription.unsubscribe(),this.closed.complete()},e.prototype._hovered=function(){return this._itemChanges.pipe(c.startWith(this._items),c.switchMap(function(e){return o.merge.apply(void 0,e.map(function(e){return e._hovered}))}))},e.prototype._handleKeydown=function(e){var t=e.keyCode;switch(t){case p.ESCAPE:this.closed.emit("keydown"),e.stopPropagation();break;case p.LEFT_ARROW:this.parentMenu&&"ltr"===this.direction&&this.closed.emit("keydown");break;case p.RIGHT_ARROW:this.parentMenu&&"rtl"===this.direction&&this.closed.emit("keydown");break;default:t!==p.UP_ARROW&&t!==p.DOWN_ARROW||this._keyManager.setFocusOrigin("keyboard"),this._keyManager.onKeydown(e)}},e.prototype.focusFirstItem=function(e){var t=this;void 0===e&&(e="program"),this.lazyContent?this._ngZone.onStable.asObservable().pipe(c.take(1)).subscribe(function(){return t._keyManager.setFocusOrigin(e).setFirstItemActive()}):this._keyManager.setFocusOrigin(e).setFirstItemActive()},e.prototype.resetActiveItem=function(){this._keyManager.setActiveItem(-1)},e.prototype.setElevation=function(e){var t="mat-elevation-z"+(4+e),n=Object.keys(this._classList).find(function(e){return e.startsWith("mat-elevation-z")});n&&n!==this._previousElevation||(this._previousElevation&&(this._classList[this._previousElevation]=!1),this._classList[t]=!0,this._previousElevation=t)},e.prototype.addItem=function(e){-1===this._items.indexOf(e)&&(this._items.push(e),this._itemChanges.next(this._items))},e.prototype.removeItem=function(e){var t=this._items.indexOf(e);this._items.indexOf(e)>-1&&(this._items.splice(t,1),this._itemChanges.next(this._items))},e.prototype.setPositionClasses=function(e,t){void 0===e&&(e=this.xPosition),void 0===t&&(t=this.yPosition);var n=this._classList;n["mat-menu-before"]="before"===e,n["mat-menu-after"]="after"===e,n["mat-menu-above"]="above"===t,n["mat-menu-below"]="below"===t},e.prototype._startAnimation=function(){this._panelAnimationState="enter"},e.prototype._resetAnimation=function(){this._panelAnimationState="void"},e.prototype._onAnimationDone=function(e){this._animationDone.next(e),this._isAnimating=!1,"enter"===e.toState&&0===this._keyManager.activeItemIndex&&(e.element.scrollTop=0)},e.decorators=[{type:t.Component,args:[{selector:"mat-menu",template:'<ng-template><div class="mat-menu-panel" [ngClass]="_classList" (keydown)="_handleKeydown($event)" (click)="closed.emit(\'click\')" [@transformMenu]="_panelAnimationState" (@transformMenu.start)="_isAnimating = true" (@transformMenu.done)="_onAnimationDone($event)" tabindex="-1" role="menu"><div class="mat-menu-content"><ng-content></ng-content></div></div></ng-template>',styles:[".mat-menu-panel{min-width:112px;max-width:280px;overflow:auto;-webkit-overflow-scrolling:touch;max-height:calc(100vh - 48px);border-radius:4px;outline:0}@media screen and (-ms-high-contrast:active){.mat-menu-panel{outline:solid 1px}}.mat-menu-content:not(:empty){padding-top:8px;padding-bottom:8px}.mat-menu-item{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;cursor:pointer;outline:0;border:none;-webkit-tap-highlight-color:transparent;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;display:block;line-height:48px;height:48px;padding:0 16px;text-align:left;text-decoration:none;max-width:100%;position:relative}.mat-menu-item::-moz-focus-inner{border:0}.mat-menu-item[disabled]{cursor:default}[dir=rtl] .mat-menu-item{text-align:right}.mat-menu-item .mat-icon{margin-right:16px;vertical-align:middle}.mat-menu-item .mat-icon svg{vertical-align:top}[dir=rtl] .mat-menu-item .mat-icon{margin-left:16px;margin-right:0}@media screen and (-ms-high-contrast:active){.mat-menu-item-highlighted,.mat-menu-item.cdk-keyboard-focused,.mat-menu-item.cdk-program-focused{outline:dotted 1px}}.mat-menu-item-submenu-trigger{padding-right:32px}.mat-menu-item-submenu-trigger::after{width:0;height:0;border-style:solid;border-width:5px 0 5px 5px;border-color:transparent transparent transparent currentColor;content:'';display:inline-block;position:absolute;top:50%;right:16px;transform:translateY(-50%)}[dir=rtl] .mat-menu-item-submenu-trigger{padding-right:16px;padding-left:32px}[dir=rtl] .mat-menu-item-submenu-trigger::after{right:auto;left:16px;transform:rotateY(180deg) translateY(-50%)}.mat-menu-panel.ng-animating .mat-menu-item-submenu-trigger{pointer-events:none}button.mat-menu-item{width:100%}.mat-menu-item .mat-menu-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}"],changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None,exportAs:"matMenu",animations:[M.transformMenu,M.fadeInItems],providers:[{provide:C,useExisting:e}]}]}],e.ctorParameters=function(){return[{type:t.ElementRef},{type:t.NgZone},{type:void 0,decorators:[{type:t.Inject,args:[I]}]}]},e.propDecorators={backdropClass:[{type:t.Input}],xPosition:[{type:t.Input}],yPosition:[{type:t.Input}],templateRef:[{type:t.ViewChild,args:[t.TemplateRef]}],items:[{type:t.ContentChildren,args:[P]}],lazyContent:[{type:t.ContentChild,args:[v]}],overlapTrigger:[{type:t.Input}],hasBackdrop:[{type:t.Input}],panelClass:[{type:t.Input,args:["class"]}],classList:[{type:t.Input}],closed:[{type:t.Output}],close:[{type:t.Output}]},e}(),S=new t.InjectionToken("mat-menu-scroll-strategy"),E={provide:S,deps:[m.Overlay],useFactory:y},T=function(){function e(e,n,i,r,s,a,u,p){this._overlay=e,this._element=n,this._viewContainerRef=i,this._parentMenu=s,this._menuItemInstance=a,this._dir=u,this._focusMonitor=p,this._overlayRef=null,this._menuOpen=!1,this._closeSubscription=o.Subscription.EMPTY,this._hoverSubscription=o.Subscription.EMPTY,this._openedByMouse=!1,this.menuOpened=new t.EventEmitter,this.onMenuOpen=this.menuOpened,this.menuClosed=new t.EventEmitter,this.onMenuClose=this.menuClosed,a&&(a._triggersSubmenu=this.triggersSubmenu()),this._scrollStrategy=r}return Object.defineProperty(e.prototype,"_deprecatedMatMenuTriggerFor",{get:function(){return this.menu},set:function(e){this.menu=e},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this._checkMenu(),this.menu.close.asObservable().subscribe(function(t){e._destroyMenu(),"click"!==t&&"tab"!==t||!e._parentMenu||e._parentMenu.closed.emit(t)}),this._handleHover()},e.prototype.ngOnDestroy=function(){this._overlayRef&&(this._overlayRef.dispose(),this._overlayRef=null),this._cleanUpSubscriptions()},Object.defineProperty(e.prototype,"menuOpen",{get:function(){return this._menuOpen},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"dir",{get:function(){return this._dir&&"rtl"===this._dir.value?"rtl":"ltr"},enumerable:!0,configurable:!0}),e.prototype.triggersSubmenu=function(){return!(!this._menuItemInstance||!this._parentMenu)},e.prototype.toggleMenu=function(){return this._menuOpen?this.closeMenu():this.openMenu()},e.prototype.openMenu=function(){var e=this;if(!this._menuOpen){this._checkMenu();var t=this._createOverlay();this._setPosition(t.getConfig().positionStrategy),t.attach(this._portal),this.menu.lazyContent&&this.menu.lazyContent.attach(this.menuData),this._closeSubscription=this._menuClosingActions().subscribe(function(){return e.closeMenu()}),this._initMenu(),this.menu instanceof R&&this.menu._startAnimation()}},e.prototype.closeMenu=function(){this.menu.close.emit()},e.prototype.focus=function(e){void 0===e&&(e="program"),this._focusMonitor?this._focusMonitor.focusVia(this._element,e):this._element.nativeElement.focus()},e.prototype._destroyMenu=function(){var e=this;if(this._overlayRef&&this.menuOpen){var t=this.menu;this._closeSubscription.unsubscribe(),this._overlayRef.detach(),t instanceof R?(t._resetAnimation(),t.lazyContent?t._animationDone.pipe(c.filter(function(e){return"void"===e.toState}),c.take(1),c.takeUntil(t.lazyContent._attached)).subscribe(function(){return t.lazyContent.detach()},void 0,function(){e._resetMenu()}):this._resetMenu()):(this._resetMenu(),t.lazyContent&&t.lazyContent.detach())}},e.prototype._initMenu=function(){this.menu.parentMenu=this.triggersSubmenu()?this._parentMenu:void 0,this.menu.direction=this.dir,this._setMenuElevation(),this._setIsMenuOpen(!0),this.menu.focusFirstItem(this._openedByMouse?"mouse":"program")},e.prototype._setMenuElevation=function(){if(this.menu.setElevation){for(var e=0,t=this.menu.parentMenu;t;)e++,t=t.parentMenu;this.menu.setElevation(e)}},e.prototype._resetMenu=function(){this._setIsMenuOpen(!1),this._openedByMouse?this.triggersSubmenu()||this.focus("mouse"):this.focus(),this._openedByMouse=!1},e.prototype._setIsMenuOpen=function(e){this._menuOpen=e,this._menuOpen?this.menuOpened.emit():this.menuClosed.emit(),this.triggersSubmenu()&&(this._menuItemInstance._highlighted=e)},e.prototype._checkMenu=function(){this.menu||d()},e.prototype._createOverlay=function(){if(!this._overlayRef){this._portal=new n.TemplatePortal(this.menu.templateRef,this._viewContainerRef);var e=this._getOverlayConfig();this._subscribeToPositions(e.positionStrategy),this._overlayRef=this._overlay.create(e)}return this._overlayRef},e.prototype._getOverlayConfig=function(){return new m.OverlayConfig({positionStrategy:this._overlay.position().flexibleConnectedTo(this._element).withLockedPosition().withTransformOriginOn(".mat-menu-panel"),hasBackdrop:null==this.menu.hasBackdrop?!this.triggersSubmenu():this.menu.hasBackdrop,backdropClass:this.menu.backdropClass||"cdk-overlay-transparent-backdrop",scrollStrategy:this._scrollStrategy(),direction:this._dir})},e.prototype._subscribeToPositions=function(e){var t=this;this.menu.setPositionClasses&&e.positionChanges.subscribe(function(e){var n="start"===e.connectionPair.overlayX?"after":"before",i="top"===e.connectionPair.overlayY?"below":"above";t.menu.setPositionClasses(n,i)})},e.prototype._setPosition=function(e){var t="before"===this.menu.xPosition?["end","start"]:["start","end"],n=t[0],i=t[1],o="above"===this.menu.yPosition?["bottom","top"]:["top","bottom"],r=o[0],s=o[1],a=[r,s],u=a[0],p=a[1],c=[n,i],l=c[0],m=c[1],h=0;this.triggersSubmenu()?(m=n="before"===this.menu.xPosition?"start":"end",i=l="end"===n?"start":"end",h="bottom"===r?8:-8):this.menu.overlapTrigger||(u="top"===r?"bottom":"top",p="top"===s?"bottom":"top"),e.withPositions([{originX:n,originY:u,overlayX:l,overlayY:r,offsetY:h},{originX:i,originY:u,overlayX:m,overlayY:r,offsetY:h},{originX:n,originY:p,overlayX:l,overlayY:s,offsetY:-h},{originX:i,originY:p,overlayX:m,overlayY:s,offsetY:-h}])},e.prototype._cleanUpSubscriptions=function(){this._closeSubscription.unsubscribe(),this._hoverSubscription.unsubscribe()},e.prototype._menuClosingActions=function(){var e=this,t=this._overlayRef.backdropClick(),n=this._overlayRef.detachments(),i=this._parentMenu?this._parentMenu.closed:o.of(),r=this._parentMenu?this._parentMenu._hovered().pipe(c.filter(function(t){return t!==e._menuItemInstance}),c.filter(function(){return e._menuOpen})):o.of();return o.merge(t,i,r,n)},e.prototype._handleMousedown=function(e){s.isFakeMousedownFromScreenReader(e)||(this._openedByMouse=0===e.button,this.triggersSubmenu()&&e.preventDefault())},e.prototype._handleKeydown=function(e){var t=e.keyCode;this.triggersSubmenu()&&(t===p.RIGHT_ARROW&&"ltr"===this.dir||t===p.LEFT_ARROW&&"rtl"===this.dir)&&this.openMenu()},e.prototype._handleClick=function(e){this.triggersSubmenu()?(e.stopPropagation(),this.openMenu()):this.toggleMenu()},e.prototype._handleHover=function(){var e=this;this.triggersSubmenu()&&(this._hoverSubscription=this._parentMenu._hovered().pipe(c.filter(function(t){return t===e._menuItemInstance&&!t.disabled}),c.delay(0,o.asapScheduler)).subscribe(function(){e._openedByMouse=!0,e.menu instanceof R&&e.menu._isAnimating?e.menu._animationDone.pipe(c.take(1),c.delay(0,o.asapScheduler),c.takeUntil(e._parentMenu._hovered())).subscribe(function(){return e.openMenu()}):e.openMenu()}))},e.decorators=[{type:t.Directive,args:[{selector:"[mat-menu-trigger-for], [matMenuTriggerFor]",host:{"aria-haspopup":"true","[attr.aria-expanded]":"menuOpen || null","(mousedown)":"_handleMousedown($event)","(keydown)":"_handleKeydown($event)","(click)":"_handleClick($event)"},exportAs:"matMenuTrigger"}]}],e.ctorParameters=function(){return[{type:m.Overlay},{type:t.ElementRef},{type:t.ViewContainerRef},{type:void 0,decorators:[{type:t.Inject,args:[S]}]},{type:R,decorators:[{type:t.Optional}]},{type:P,decorators:[{type:t.Optional},{type:t.Self}]},{type:l.Directionality,decorators:[{type:t.Optional}]},{type:s.FocusMonitor}]},e.propDecorators={_deprecatedMatMenuTriggerFor:[{type:t.Input,args:["mat-menu-trigger-for"]}],menu:[{type:t.Input,args:["matMenuTriggerFor"]}],menuData:[{type:t.Input,args:["matMenuTriggerData"]}],menuOpened:[{type:t.Output}],onMenuOpen:[{type:t.Output}],menuClosed:[{type:t.Output}],onMenuClose:[{type:t.Output}]},e}(),A=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[i.CommonModule,a.MatCommonModule,a.MatRippleModule,m.OverlayModule],exports:[R,P,T,v,a.MatCommonModule],declarations:[R,P,T,v],providers:[E]}]}],e}();e.MAT_MENU_SCROLL_STRATEGY=S,e.MatMenuModule=A,e.MatMenu=R,e.MAT_MENU_DEFAULT_OPTIONS=I,e.MatMenuItem=P,e.MatMenuTrigger=T,e.matMenuAnimations=M,e.fadeInItems=k,e.transformMenu=O,e.MatMenuContent=v,e.ɵa24=_,e.ɵb24=x,e.ɵc24=w,e.ɵf24=C,e.ɵd24=y,e.ɵe24=E,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-menu.umd.min.js.map
