/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/animations"),require("@angular/cdk/a11y"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/cdk/platform"),require("@angular/cdk/scrolling"),require("@angular/common"),require("@angular/core"),require("rxjs"),require("rxjs/operators"),require("@angular/platform-browser/animations"),require("@angular/material/core")):"function"==typeof define&&define.amd?define("@angular/material/sidenav",["exports","@angular/animations","@angular/cdk/a11y","@angular/cdk/bidi","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/cdk/platform","@angular/cdk/scrolling","@angular/common","@angular/core","rxjs","rxjs/operators","@angular/platform-browser/animations","@angular/material/core"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.sidenav={}),t.ng.animations,t.ng.cdk.a11y,t.ng.cdk.bidi,t.ng.cdk.coercion,t.ng.cdk.keycodes,t.ng.cdk.platform,t.ng.cdk.scrolling,t.ng.common,t.ng.core,t.rxjs,t.rxjs.operators,t.ng.platformBrowser.animations,t.ng.material.core)}(this,function(t,e,n,r,o,a,i,s,c,d,p,l,u,m){"use strict";function h(t,e){function n(){this.constructor=t}_(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)}function f(t){throw Error("A drawer was already declared for 'position=\""+t+"\"'")}function g(){return!1}var _=function(t,e){return(_=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)},w={transformDrawer:e.trigger("transform",[e.state("open, open-instant",e.style({transform:"none",visibility:"visible"})),e.state("void",e.style({"box-shadow":"none",visibility:"hidden"})),e.transition("void => open-instant",e.animate("0ms")),e.transition("void <=> open, open-instant => void",e.animate("400ms cubic-bezier(0.25, 0.8, 0.25, 1)"))])},b=new d.InjectionToken("MAT_DRAWER_DEFAULT_AUTOSIZE",{providedIn:"root",factory:g}),y=function(t){function e(e,n,r,o,a){var i=t.call(this,r,o,a)||this;return i._changeDetectorRef=e,i._container=n,i}return h(e,t),e.prototype.ngAfterContentInit=function(){var t=this;this._container._contentMarginChanges.subscribe(function(){t._changeDetectorRef.markForCheck()})},e.decorators=[{type:d.Component,args:[{selector:"mat-drawer-content",template:"<ng-content></ng-content>",host:{class:"mat-drawer-content","[style.margin-left.px]":"_container._contentMargins.left","[style.margin-right.px]":"_container._contentMargins.right"},changeDetection:d.ChangeDetectionStrategy.OnPush,encapsulation:d.ViewEncapsulation.None}]}],e.ctorParameters=function(){return[{type:d.ChangeDetectorRef},{type:k,decorators:[{type:d.Inject,args:[d.forwardRef(function(){return k})]}]},{type:d.ElementRef},{type:s.ScrollDispatcher},{type:d.NgZone}]},e}(s.CdkScrollable),v=function(){function t(t,e,n,r,o,i){var s=this;this._elementRef=t,this._focusTrapFactory=e,this._focusMonitor=n,this._platform=r,this._ngZone=o,this._doc=i,this._elementFocusedBeforeDrawerWasOpened=null,this._enableAnimations=!1,this._position="start",this._mode="over",this._disableClose=!1,this._autoFocus=!0,this._animationStarted=new d.EventEmitter,this._animationState="void",this.openedChange=new d.EventEmitter(!0),this.onPositionChanged=new d.EventEmitter,this._modeChanged=new p.Subject,this._opened=!1,this.openedChange.subscribe(function(t){t?(s._doc&&(s._elementFocusedBeforeDrawerWasOpened=s._doc.activeElement),s._isFocusTrapEnabled&&s._focusTrap&&s._trapFocus()):s._restoreFocus()}),this._ngZone.runOutsideAngular(function(){p.fromEvent(s._elementRef.nativeElement,"keydown").pipe(l.filter(function(t){return t.keyCode===a.ESCAPE&&!s.disableClose})).subscribe(function(t){return s._ngZone.run(function(){s.close(),t.stopPropagation()})})})}return Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(t){(t="end"===t?"end":"start")!=this._position&&(this._position=t,this.onPositionChanged.emit())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"mode",{get:function(){return this._mode},set:function(t){this._mode=t,this._modeChanged.next()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"disableClose",{get:function(){return this._disableClose},set:function(t){this._disableClose=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"autoFocus",{get:function(){return this._autoFocus},set:function(t){this._autoFocus=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_openedStream",{get:function(){return this.openedChange.pipe(l.filter(function(t){return t}),l.map(function(){}))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"openedStart",{get:function(){return this._animationStarted.pipe(l.filter(function(t){return t.fromState!==t.toState&&0===t.toState.indexOf("open")}),l.map(function(){}))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_closedStream",{get:function(){return this.openedChange.pipe(l.filter(function(t){return!t}),l.map(function(){}))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"closedStart",{get:function(){return this._animationStarted.pipe(l.filter(function(t){return t.fromState!==t.toState&&"void"===t.toState}),l.map(function(){}))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_isFocusTrapEnabled",{get:function(){return this.opened&&"side"!==this.mode},enumerable:!0,configurable:!0}),t.prototype._trapFocus=function(){var t=this;this.autoFocus&&this._focusTrap.focusInitialElementWhenReady().then(function(e){e||"function"!=typeof t._elementRef.nativeElement.focus||t._elementRef.nativeElement.focus()})},t.prototype._restoreFocus=function(){if(this.autoFocus){var t=this._doc&&this._doc.activeElement;t&&this._elementRef.nativeElement.contains(t)&&(this._elementFocusedBeforeDrawerWasOpened instanceof HTMLElement?this._focusMonitor.focusVia(this._elementFocusedBeforeDrawerWasOpened,this._openedVia):this._elementRef.nativeElement.blur()),this._elementFocusedBeforeDrawerWasOpened=null,this._openedVia=null}},t.prototype.ngAfterContentInit=function(){this._focusTrap=this._focusTrapFactory.create(this._elementRef.nativeElement),this._focusTrap.enabled=this._isFocusTrapEnabled},t.prototype.ngAfterContentChecked=function(){this._platform.isBrowser&&(this._enableAnimations=!0)},t.prototype.ngOnDestroy=function(){this._focusTrap&&this._focusTrap.destroy()},Object.defineProperty(t.prototype,"opened",{get:function(){return this._opened},set:function(t){this.toggle(o.coerceBooleanProperty(t))},enumerable:!0,configurable:!0}),t.prototype.open=function(t){return this.toggle(!0,t)},t.prototype.close=function(){return this.toggle(!1)},t.prototype.toggle=function(t,e){var n=this;return void 0===t&&(t=!this.opened),void 0===e&&(e="program"),this._opened=t,t?(this._animationState=this._enableAnimations?"open":"open-instant",this._openedVia=e):(this._animationState="void",this._restoreFocus()),this._focusTrap&&(this._focusTrap.enabled=this._isFocusTrapEnabled),new Promise(function(t){n.openedChange.pipe(l.take(1)).subscribe(function(e){return t(e?"open":"close")})})},t.prototype._onAnimationStart=function(t){this._animationStarted.emit(t)},t.prototype._onAnimationEnd=function(t){var e=t.fromState,n=t.toState;(0===n.indexOf("open")&&"void"===e||"void"===n&&0===e.indexOf("open"))&&this.openedChange.emit(this._opened)},Object.defineProperty(t.prototype,"_width",{get:function(){return this._elementRef.nativeElement?this._elementRef.nativeElement.offsetWidth||0:0},enumerable:!0,configurable:!0}),t.decorators=[{type:d.Component,args:[{selector:"mat-drawer",exportAs:"matDrawer",template:'<div class="mat-drawer-inner-container"><ng-content></ng-content></div>',animations:[w.transformDrawer],host:{class:"mat-drawer","[@transform]":"_animationState","(@transform.start)":"_onAnimationStart($event)","(@transform.done)":"_onAnimationEnd($event)","[attr.align]":"null","[class.mat-drawer-end]":'position === "end"',"[class.mat-drawer-over]":'mode === "over"',"[class.mat-drawer-push]":'mode === "push"',"[class.mat-drawer-side]":'mode === "side"',tabIndex:"-1"},changeDetection:d.ChangeDetectionStrategy.OnPush,encapsulation:d.ViewEncapsulation.None}]}],t.ctorParameters=function(){return[{type:d.ElementRef},{type:n.FocusTrapFactory},{type:n.FocusMonitor},{type:i.Platform},{type:d.NgZone},{type:void 0,decorators:[{type:d.Optional},{type:d.Inject,args:[c.DOCUMENT]}]}]},t.propDecorators={position:[{type:d.Input}],mode:[{type:d.Input}],disableClose:[{type:d.Input}],autoFocus:[{type:d.Input}],openedChange:[{type:d.Output}],_openedStream:[{type:d.Output,args:["opened"]}],openedStart:[{type:d.Output}],_closedStream:[{type:d.Output,args:["closed"]}],closedStart:[{type:d.Output}],onPositionChanged:[{type:d.Output,args:["positionChanged"]}],opened:[{type:d.Input}]},t}(),k=function(){function t(t,e,n,r,o,a){void 0===o&&(o=!1);var i=this;this._dir=t,this._element=e,this._ngZone=n,this._changeDetectorRef=r,this._animationMode=a,this.backdropClick=new d.EventEmitter,this._destroyed=new p.Subject,this._doCheckSubject=new p.Subject,this._contentMargins={left:null,right:null},this._contentMarginChanges=new p.Subject,t&&t.change.pipe(l.takeUntil(this._destroyed)).subscribe(function(){i._validateDrawers(),i._updateContentMargins()}),this._autosize=o}return Object.defineProperty(t.prototype,"start",{get:function(){return this._start},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"end",{get:function(){return this._end},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"autosize",{get:function(){return this._autosize},set:function(t){this._autosize=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasBackdrop",{get:function(){return null==this._backdropOverride?!this._start||"side"!==this._start.mode||!this._end||"side"!==this._end.mode:this._backdropOverride},set:function(t){this._backdropOverride=null==t?null:o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"scrollable",{get:function(){return this._userContent||this._content},enumerable:!0,configurable:!0}),t.prototype.ngAfterContentInit=function(){var t=this;this._drawers.changes.pipe(l.startWith(null)).subscribe(function(){t._validateDrawers(),t._drawers.forEach(function(e){t._watchDrawerToggle(e),t._watchDrawerPosition(e),t._watchDrawerMode(e)}),(!t._drawers.length||t._isDrawerOpen(t._start)||t._isDrawerOpen(t._end))&&t._updateContentMargins(),t._changeDetectorRef.markForCheck()}),this._doCheckSubject.pipe(l.debounceTime(10),l.takeUntil(this._destroyed)).subscribe(function(){return t._updateContentMargins()})},t.prototype.ngOnDestroy=function(){this._doCheckSubject.complete(),this._destroyed.next(),this._destroyed.complete()},t.prototype.open=function(){this._drawers.forEach(function(t){return t.open()})},t.prototype.close=function(){this._drawers.forEach(function(t){return t.close()})},t.prototype.ngDoCheck=function(){var t=this;this._autosize&&this._isPushed()&&this._ngZone.runOutsideAngular(function(){return t._doCheckSubject.next()})},t.prototype._watchDrawerToggle=function(t){var e=this;t._animationStarted.pipe(l.takeUntil(this._drawers.changes),l.filter(function(t){return t.fromState!==t.toState})).subscribe(function(t){"open-instant"!==t.toState&&"NoopAnimations"!==e._animationMode&&e._element.nativeElement.classList.add("mat-drawer-transition"),e._updateContentMargins(),e._changeDetectorRef.markForCheck()}),"side"!==t.mode&&t.openedChange.pipe(l.takeUntil(this._drawers.changes)).subscribe(function(){return e._setContainerClass(t.opened)})},t.prototype._watchDrawerPosition=function(t){var e=this;t&&t.onPositionChanged.pipe(l.takeUntil(this._drawers.changes)).subscribe(function(){e._ngZone.onMicrotaskEmpty.asObservable().pipe(l.take(1)).subscribe(function(){e._validateDrawers()})})},t.prototype._watchDrawerMode=function(t){var e=this;t&&t._modeChanged.pipe(l.takeUntil(p.merge(this._drawers.changes,this._destroyed))).subscribe(function(){e._updateContentMargins(),e._changeDetectorRef.markForCheck()})},t.prototype._setContainerClass=function(t){t?this._element.nativeElement.classList.add("mat-drawer-opened"):this._element.nativeElement.classList.remove("mat-drawer-opened")},t.prototype._validateDrawers=function(){var t=this;this._start=this._end=null,this._drawers.forEach(function(e){"end"==e.position?(null!=t._end&&f("end"),t._end=e):(null!=t._start&&f("start"),t._start=e)}),this._right=this._left=null,this._dir&&"rtl"===this._dir.value?(this._left=this._end,this._right=this._start):(this._left=this._start,this._right=this._end)},t.prototype._isPushed=function(){return this._isDrawerOpen(this._start)&&"over"!=this._start.mode||this._isDrawerOpen(this._end)&&"over"!=this._end.mode},t.prototype._onBackdropClicked=function(){this.backdropClick.emit(),this._closeModalDrawer()},t.prototype._closeModalDrawer=function(){var t=this;[this._start,this._end].filter(function(e){return e&&!e.disableClose&&t._canHaveBackdrop(e)}).forEach(function(t){return t.close()})},t.prototype._isShowingBackdrop=function(){return this._isDrawerOpen(this._start)&&this._canHaveBackdrop(this._start)||this._isDrawerOpen(this._end)&&this._canHaveBackdrop(this._end)},t.prototype._canHaveBackdrop=function(t){return"side"!==t.mode||!!this._backdropOverride},t.prototype._isDrawerOpen=function(t){return null!=t&&t.opened},t.prototype._updateContentMargins=function(){var t=this,e=0,n=0;if(this._left&&this._left.opened)if("side"==this._left.mode)e+=this._left._width;else if("push"==this._left.mode){var r=this._left._width;e+=r,n-=r}if(this._right&&this._right.opened)if("side"==this._right.mode)n+=this._right._width;else if("push"==this._right.mode){var r=this._right._width;n+=r,e-=r}e=e||null,n=n||null,e===this._contentMargins.left&&n===this._contentMargins.right||(this._contentMargins={left:e,right:n},this._ngZone.run(function(){return t._contentMarginChanges.next(t._contentMargins)}))},t.decorators=[{type:d.Component,args:[{selector:"mat-drawer-container",exportAs:"matDrawerContainer",template:'<div class="mat-drawer-backdrop" (click)="_onBackdropClicked()" *ngIf="hasBackdrop" [class.mat-drawer-shown]="_isShowingBackdrop()"></div><ng-content select="mat-drawer"></ng-content><ng-content select="mat-drawer-content"></ng-content><mat-drawer-content *ngIf="!_content"><ng-content></ng-content></mat-drawer-content>',styles:[".mat-drawer-container{position:relative;z-index:1;box-sizing:border-box;-webkit-overflow-scrolling:touch;display:block;overflow:hidden}.mat-drawer-container[fullscreen]{top:0;left:0;right:0;bottom:0;position:absolute}.mat-drawer-container[fullscreen].mat-drawer-opened{overflow:hidden}.mat-drawer-container.mat-drawer-container-explicit-backdrop .mat-drawer-side{z-index:3}.mat-drawer-container.ng-animate-disabled .mat-drawer-backdrop,.mat-drawer-container.ng-animate-disabled .mat-drawer-content,.ng-animate-disabled .mat-drawer-container .mat-drawer-backdrop,.ng-animate-disabled .mat-drawer-container .mat-drawer-content{transition:none}.mat-drawer-backdrop{top:0;left:0;right:0;bottom:0;position:absolute;display:block;z-index:3;visibility:hidden}.mat-drawer-backdrop.mat-drawer-shown{visibility:visible}.mat-drawer-transition .mat-drawer-backdrop{transition-duration:.4s;transition-timing-function:cubic-bezier(.25,.8,.25,1);transition-property:background-color,visibility}@media screen and (-ms-high-contrast:active){.mat-drawer-backdrop{opacity:.5}}.mat-drawer-content{position:relative;z-index:1;display:block;height:100%;overflow:auto}.mat-drawer-transition .mat-drawer-content{transition-duration:.4s;transition-timing-function:cubic-bezier(.25,.8,.25,1);transition-property:transform,margin-left,margin-right}.mat-drawer{position:relative;z-index:4;display:block;position:absolute;top:0;bottom:0;z-index:3;outline:0;box-sizing:border-box;overflow-y:auto;transform:translate3d(-100%,0,0)}@media screen and (-ms-high-contrast:active){.mat-drawer,[dir=rtl] .mat-drawer.mat-drawer-end{border-right:solid 1px currentColor}}@media screen and (-ms-high-contrast:active){.mat-drawer.mat-drawer-end,[dir=rtl] .mat-drawer{border-left:solid 1px currentColor;border-right:none}}.mat-drawer.mat-drawer-side{z-index:2}.mat-drawer.mat-drawer-end{right:0;transform:translate3d(100%,0,0)}[dir=rtl] .mat-drawer{transform:translate3d(100%,0,0)}[dir=rtl] .mat-drawer.mat-drawer-end{left:0;right:auto;transform:translate3d(-100%,0,0)}.mat-drawer-inner-container{width:100%;height:100%;overflow:auto;-webkit-overflow-scrolling:touch}.mat-sidenav-fixed{position:fixed}"],host:{class:"mat-drawer-container","[class.mat-drawer-container-explicit-backdrop]":"_backdropOverride"},changeDetection:d.ChangeDetectionStrategy.OnPush,encapsulation:d.ViewEncapsulation.None}]}],t.ctorParameters=function(){return[{type:r.Directionality,decorators:[{type:d.Optional}]},{type:d.ElementRef},{type:d.NgZone},{type:d.ChangeDetectorRef},{type:void 0,decorators:[{type:d.Inject,args:[b]}]},{type:String,decorators:[{type:d.Optional},{type:d.Inject,args:[u.ANIMATION_MODULE_TYPE]}]}]},t.propDecorators={_drawers:[{type:d.ContentChildren,args:[v]}],_content:[{type:d.ContentChild,args:[y]}],_userContent:[{type:d.ViewChild,args:[y]}],autosize:[{type:d.Input}],hasBackdrop:[{type:d.Input}],backdropClick:[{type:d.Output}]},t}(),C=function(t){function e(e,n,r,o,a){return t.call(this,e,n,r,o,a)||this}return h(e,t),e.decorators=[{type:d.Component,args:[{selector:"mat-sidenav-content",template:"<ng-content></ng-content>",host:{class:"mat-drawer-content mat-sidenav-content","[style.margin-left.px]":"_container._contentMargins.left","[style.margin-right.px]":"_container._contentMargins.right"},changeDetection:d.ChangeDetectionStrategy.OnPush,encapsulation:d.ViewEncapsulation.None}]}],e.ctorParameters=function(){return[{type:d.ChangeDetectorRef},{type:D,decorators:[{type:d.Inject,args:[d.forwardRef(function(){return D})]}]},{type:d.ElementRef},{type:s.ScrollDispatcher},{type:d.NgZone}]},e}(y),x=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._fixedInViewport=!1,e._fixedTopGap=0,e._fixedBottomGap=0,e}return h(e,t),Object.defineProperty(e.prototype,"fixedInViewport",{get:function(){return this._fixedInViewport},set:function(t){this._fixedInViewport=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fixedTopGap",{get:function(){return this._fixedTopGap},set:function(t){this._fixedTopGap=o.coerceNumberProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fixedBottomGap",{get:function(){return this._fixedBottomGap},set:function(t){this._fixedBottomGap=o.coerceNumberProperty(t)},enumerable:!0,configurable:!0}),e.decorators=[{type:d.Component,args:[{selector:"mat-sidenav",exportAs:"matSidenav",template:'<div class="mat-drawer-inner-container"><ng-content></ng-content></div>',animations:[w.transformDrawer],host:{class:"mat-drawer mat-sidenav",tabIndex:"-1","[@transform]":"_animationState","(@transform.start)":"_onAnimationStart($event)","(@transform.done)":"_onAnimationEnd($event)","[attr.align]":"null","[class.mat-drawer-end]":'position === "end"',"[class.mat-drawer-over]":'mode === "over"',"[class.mat-drawer-push]":'mode === "push"',"[class.mat-drawer-side]":'mode === "side"',"[class.mat-sidenav-fixed]":"fixedInViewport","[style.top.px]":"fixedInViewport ? fixedTopGap : null","[style.bottom.px]":"fixedInViewport ? fixedBottomGap : null"},changeDetection:d.ChangeDetectionStrategy.OnPush,encapsulation:d.ViewEncapsulation.None}]}],e.propDecorators={fixedInViewport:[{type:d.Input}],fixedTopGap:[{type:d.Input}],fixedBottomGap:[{type:d.Input}]},e}(v),D=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return h(e,t),e.decorators=[{type:d.Component,args:[{selector:"mat-sidenav-container",exportAs:"matSidenavContainer",template:'<div class="mat-drawer-backdrop" (click)="_onBackdropClicked()" *ngIf="hasBackdrop" [class.mat-drawer-shown]="_isShowingBackdrop()"></div><ng-content select="mat-sidenav"></ng-content><ng-content select="mat-sidenav-content"></ng-content><mat-sidenav-content *ngIf="!_content" cdkScrollable><ng-content></ng-content></mat-sidenav-content>',styles:[".mat-drawer-container{position:relative;z-index:1;box-sizing:border-box;-webkit-overflow-scrolling:touch;display:block;overflow:hidden}.mat-drawer-container[fullscreen]{top:0;left:0;right:0;bottom:0;position:absolute}.mat-drawer-container[fullscreen].mat-drawer-opened{overflow:hidden}.mat-drawer-container.mat-drawer-container-explicit-backdrop .mat-drawer-side{z-index:3}.mat-drawer-container.ng-animate-disabled .mat-drawer-backdrop,.mat-drawer-container.ng-animate-disabled .mat-drawer-content,.ng-animate-disabled .mat-drawer-container .mat-drawer-backdrop,.ng-animate-disabled .mat-drawer-container .mat-drawer-content{transition:none}.mat-drawer-backdrop{top:0;left:0;right:0;bottom:0;position:absolute;display:block;z-index:3;visibility:hidden}.mat-drawer-backdrop.mat-drawer-shown{visibility:visible}.mat-drawer-transition .mat-drawer-backdrop{transition-duration:.4s;transition-timing-function:cubic-bezier(.25,.8,.25,1);transition-property:background-color,visibility}@media screen and (-ms-high-contrast:active){.mat-drawer-backdrop{opacity:.5}}.mat-drawer-content{position:relative;z-index:1;display:block;height:100%;overflow:auto}.mat-drawer-transition .mat-drawer-content{transition-duration:.4s;transition-timing-function:cubic-bezier(.25,.8,.25,1);transition-property:transform,margin-left,margin-right}.mat-drawer{position:relative;z-index:4;display:block;position:absolute;top:0;bottom:0;z-index:3;outline:0;box-sizing:border-box;overflow-y:auto;transform:translate3d(-100%,0,0)}@media screen and (-ms-high-contrast:active){.mat-drawer,[dir=rtl] .mat-drawer.mat-drawer-end{border-right:solid 1px currentColor}}@media screen and (-ms-high-contrast:active){.mat-drawer.mat-drawer-end,[dir=rtl] .mat-drawer{border-left:solid 1px currentColor;border-right:none}}.mat-drawer.mat-drawer-side{z-index:2}.mat-drawer.mat-drawer-end{right:0;transform:translate3d(100%,0,0)}[dir=rtl] .mat-drawer{transform:translate3d(100%,0,0)}[dir=rtl] .mat-drawer.mat-drawer-end{left:0;right:auto;transform:translate3d(-100%,0,0)}.mat-drawer-inner-container{width:100%;height:100%;overflow:auto;-webkit-overflow-scrolling:touch}.mat-sidenav-fixed{position:fixed}"],host:{class:"mat-drawer-container mat-sidenav-container","[class.mat-drawer-container-explicit-backdrop]":"_backdropOverride"},changeDetection:d.ChangeDetectionStrategy.OnPush,encapsulation:d.ViewEncapsulation.None}]}],e.propDecorators={_drawers:[{type:d.ContentChildren,args:[x]}],_content:[{type:d.ContentChild,args:[C]}]},e}(k),O=function(){function t(){}return t.decorators=[{type:d.NgModule,args:[{imports:[c.CommonModule,m.MatCommonModule,s.ScrollingModule,i.PlatformModule],exports:[m.MatCommonModule,v,k,y,x,D,C],declarations:[v,k,y,x,D,C]}]}],t}();t.MatSidenavModule=O,t.throwMatDuplicatedDrawerError=f,t.MAT_DRAWER_DEFAULT_AUTOSIZE_FACTORY=g,t.MAT_DRAWER_DEFAULT_AUTOSIZE=b,t.MatDrawerContent=y,t.MatDrawer=v,t.MatDrawerContainer=k,t.MatSidenavContent=C,t.MatSidenav=x,t.MatSidenavContainer=D,t.matDrawerAnimations=w,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-sidenav.umd.min.js.map
