/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/cdk/a11y"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/cdk/platform"),require("@angular/forms"),require("@angular/material/core"),require("@angular/platform-browser/animations"),require("@angular/cdk/observers"),require("@angular/platform-browser")):"function"==typeof define&&define.amd?define("@angular/material/slideToggle",["exports","@angular/core","@angular/cdk/a11y","@angular/cdk/bidi","@angular/cdk/coercion","@angular/cdk/platform","@angular/forms","@angular/material/core","@angular/platform-browser/animations","@angular/cdk/observers","@angular/platform-browser"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.slideToggle={}),e.ng.core,e.ng.cdk.a11y,e.ng.cdk.bidi,e.ng.cdk.coercion,e.ng.cdk.platform,e.ng.forms,e.ng.material.core,e.ng.platformBrowser.animations,e.ng.cdk.observers,e.ng.platformBrowser)}(this,function(e,t,i,a,n,r,o,l,s,g,d){"use strict";function c(e,t){function i(){this.constructor=e}p(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}var p=function(e,t){return(p=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i])})(e,t)},u=new t.InjectionToken("mat-slide-toggle-default-options",{providedIn:"root",factory:function(){return{disableToggleValue:!1,disableDragValue:!1}}}),m=0,h={provide:o.NG_VALUE_ACCESSOR,useExisting:t.forwardRef(function(){return y}),multi:!0},b=function(){function e(e,t){this.source=e,this.checked=t}return e}(),f=function(){function e(e){this._elementRef=e}return e}(),_=l.mixinTabIndex(l.mixinColor(l.mixinDisableRipple(l.mixinDisabled(f)),"accent")),y=function(e){function o(i,a,n,r,o,l,s,g,d){var c=e.call(this,i)||this;return c._focusMonitor=n,c._changeDetectorRef=r,c._ngZone=l,c.defaults=s,c._animationMode=g,c._dir=d,c.onChange=function(e){},c.onTouched=function(){},c._uniqueId="mat-slide-toggle-"+ ++m,c._required=!1,c._checked=!1,c._dragging=!1,c.name=null,c.id=c._uniqueId,c.labelPosition="after",c.ariaLabel=null,c.ariaLabelledby=null,c.change=new t.EventEmitter,c.toggleChange=new t.EventEmitter,c.dragChange=new t.EventEmitter,c.tabIndex=parseInt(o)||0,c}return c(o,e),Object.defineProperty(o.prototype,"required",{get:function(){return this._required},set:function(e){this._required=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"checked",{get:function(){return this._checked},set:function(e){this._checked=n.coerceBooleanProperty(e),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"inputId",{get:function(){return(this.id||this._uniqueId)+"-input"},enumerable:!0,configurable:!0}),o.prototype.ngAfterContentInit=function(){var e=this;this._focusMonitor.monitor(this._elementRef,!0).subscribe(function(t){t||Promise.resolve().then(function(){return e.onTouched()})})},o.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._elementRef)},o.prototype._onChangeEvent=function(e){if(e.stopPropagation(),this._dragging||this.toggleChange.emit(),this._dragging||this.defaults.disableToggleValue)return void(this._inputElement.nativeElement.checked=this.checked);this.checked=this._inputElement.nativeElement.checked,this._emitChangeEvent()},o.prototype._onInputClick=function(e){e.stopPropagation()},o.prototype.writeValue=function(e){this.checked=!!e},o.prototype.registerOnChange=function(e){this.onChange=e},o.prototype.registerOnTouched=function(e){this.onTouched=e},o.prototype.setDisabledState=function(e){this.disabled=e,this._changeDetectorRef.markForCheck()},o.prototype.focus=function(){this._focusMonitor.focusVia(this._inputElement,"keyboard")},o.prototype.toggle=function(){this.checked=!this.checked,this.onChange(this.checked)},o.prototype._emitChangeEvent=function(){this.onChange(this.checked),this.change.emit(new b(this,this.checked))},o.prototype._getDragPercentage=function(e){var t=e/this._thumbBarWidth*100;return this._previousChecked&&(t+=100),Math.max(0,Math.min(t,100))},o.prototype._onDragStart=function(){if(!this.disabled&&!this._dragging){var e=this._thumbEl.nativeElement;this._thumbBarWidth=this._thumbBarEl.nativeElement.clientWidth-e.clientWidth,e.classList.add("mat-dragging"),this._previousChecked=this.checked,this._dragging=!0}},o.prototype._onDrag=function(e){if(this._dragging){var t=this._dir&&"rtl"===this._dir.value?-1:1;this._dragPercentage=this._getDragPercentage(e.deltaX*t);var i=this._dragPercentage/100*this._thumbBarWidth*t;this._thumbEl.nativeElement.style.transform="translate3d("+i+"px, 0, 0)"}},o.prototype._onDragEnd=function(){var e=this;if(this._dragging){var t=this._dragPercentage>50;t!==this.checked&&(this.dragChange.emit(),this.defaults.disableDragValue||(this.checked=t,this._emitChangeEvent())),this._ngZone.runOutsideAngular(function(){return setTimeout(function(){e._dragging&&(e._dragging=!1,e._thumbEl.nativeElement.classList.remove("mat-dragging"),e._thumbEl.nativeElement.style.transform="")})})}},o.prototype._onLabelTextChange=function(){this._changeDetectorRef.detectChanges()},o.decorators=[{type:t.Component,args:[{selector:"mat-slide-toggle",exportAs:"matSlideToggle",host:{class:"mat-slide-toggle","[id]":"id","[attr.tabindex]":"null","[class.mat-checked]":"checked","[class.mat-disabled]":"disabled","[class.mat-slide-toggle-label-before]":'labelPosition == "before"',"[class._mat-animation-noopable]":'_animationMode === "NoopAnimations"'},template:'<label class="mat-slide-toggle-label" #label><div #toggleBar class="mat-slide-toggle-bar" [class.mat-slide-toggle-bar-no-side-margin]="!labelContent.textContent || !labelContent.textContent.trim()"><input #input class="mat-slide-toggle-input cdk-visually-hidden" type="checkbox" [id]="inputId" [required]="required" [tabIndex]="tabIndex" [checked]="checked" [disabled]="disabled" [attr.name]="name" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" (change)="_onChangeEvent($event)" (click)="_onInputClick($event)"><div class="mat-slide-toggle-thumb-container" #thumbContainer (slidestart)="_onDragStart()" (slide)="_onDrag($event)" (slideend)="_onDragEnd()"><div class="mat-slide-toggle-thumb"></div><div class="mat-slide-toggle-ripple" mat-ripple [matRippleTrigger]="label" [matRippleDisabled]="disableRipple || disabled" [matRippleCentered]="true" [matRippleRadius]="20" [matRippleAnimation]="{enterDuration: 150}"><div class="mat-ripple-element mat-slide-toggle-persistent-ripple"></div></div></div></div><span class="mat-slide-toggle-content" #labelContent (cdkObserveContent)="_onLabelTextChange()"><ng-content></ng-content></span></label>',styles:[".mat-slide-toggle{display:inline-block;height:24px;max-width:100%;line-height:24px;white-space:nowrap;outline:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-tap-highlight-color:transparent}.mat-slide-toggle.mat-checked .mat-slide-toggle-thumb-container{transform:translate3d(16px,0,0)}[dir=rtl] .mat-slide-toggle.mat-checked .mat-slide-toggle-thumb-container{transform:translate3d(-16px,0,0)}.mat-slide-toggle.mat-disabled .mat-slide-toggle-label,.mat-slide-toggle.mat-disabled .mat-slide-toggle-thumb-container{cursor:default}.mat-slide-toggle-label{display:flex;flex:1;flex-direction:row;align-items:center;height:inherit;cursor:pointer}.mat-slide-toggle-content{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.mat-slide-toggle-label-before .mat-slide-toggle-label{order:1}.mat-slide-toggle-label-before .mat-slide-toggle-bar{order:2}.mat-slide-toggle-bar,[dir=rtl] .mat-slide-toggle-label-before .mat-slide-toggle-bar{margin-right:8px;margin-left:0}.mat-slide-toggle-label-before .mat-slide-toggle-bar,[dir=rtl] .mat-slide-toggle-bar{margin-left:8px;margin-right:0}.mat-slide-toggle-bar-no-side-margin{margin-left:0;margin-right:0}.mat-slide-toggle-thumb-container{position:absolute;z-index:1;width:20px;height:20px;top:-3px;left:0;transform:translate3d(0,0,0);transition:all 80ms linear;transition-property:transform;cursor:-webkit-grab;cursor:grab}.mat-slide-toggle-thumb-container.mat-dragging,.mat-slide-toggle-thumb-container:active{cursor:-webkit-grabbing;cursor:grabbing;transition-duration:0s}._mat-animation-noopable .mat-slide-toggle-thumb-container{transition:none}[dir=rtl] .mat-slide-toggle-thumb-container{left:auto;right:0}.mat-slide-toggle-thumb{height:20px;width:20px;border-radius:50%}.mat-slide-toggle-bar{position:relative;width:36px;height:14px;flex-shrink:0;border-radius:8px}.mat-slide-toggle-input{bottom:0;left:10px}[dir=rtl] .mat-slide-toggle-input{left:auto;right:10px}.mat-slide-toggle-bar,.mat-slide-toggle-thumb{transition:all 80ms linear;transition-property:background-color;transition-delay:50ms}._mat-animation-noopable .mat-slide-toggle-bar,._mat-animation-noopable .mat-slide-toggle-thumb{transition:none}.mat-slide-toggle .mat-slide-toggle-ripple{position:absolute;top:calc(50% - 20px);left:calc(50% - 20px);height:40px;width:40px;z-index:1;pointer-events:none}.mat-slide-toggle .mat-slide-toggle-ripple .mat-ripple-element:not(.mat-slide-toggle-persistent-ripple){opacity:.12}.mat-slide-toggle-persistent-ripple{width:100%;height:100%;transform:none}.mat-slide-toggle-bar:hover .mat-slide-toggle-persistent-ripple{opacity:.04}.mat-slide-toggle.cdk-focused .mat-slide-toggle-persistent-ripple{opacity:.12}.mat-slide-toggle-persistent-ripple,.mat-slide-toggle.mat-disabled .mat-slide-toggle-bar:hover .mat-slide-toggle-persistent-ripple{opacity:0}@media screen and (-ms-high-contrast:active){.mat-slide-toggle-thumb{background:#fff;border:1px solid #000}.mat-slide-toggle.mat-checked .mat-slide-toggle-thumb{background:#000;border:1px solid #fff}.mat-slide-toggle-bar{background:#fff}}@media screen and (-ms-high-contrast:black-on-white){.mat-slide-toggle-bar{border:1px solid #000}}"],providers:[h],inputs:["disabled","disableRipple","color","tabIndex"],encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],o.ctorParameters=function(){return[{type:t.ElementRef},{type:r.Platform},{type:i.FocusMonitor},{type:t.ChangeDetectorRef},{type:String,decorators:[{type:t.Attribute,args:["tabindex"]}]},{type:t.NgZone},{type:void 0,decorators:[{type:t.Inject,args:[u]}]},{type:String,decorators:[{type:t.Optional},{type:t.Inject,args:[s.ANIMATION_MODULE_TYPE]}]},{type:a.Directionality,decorators:[{type:t.Optional}]}]},o.propDecorators={_thumbEl:[{type:t.ViewChild,args:["thumbContainer"]}],_thumbBarEl:[{type:t.ViewChild,args:["toggleBar"]}],name:[{type:t.Input}],id:[{type:t.Input}],labelPosition:[{type:t.Input}],ariaLabel:[{type:t.Input,args:["aria-label"]}],ariaLabelledby:[{type:t.Input,args:["aria-labelledby"]}],required:[{type:t.Input}],checked:[{type:t.Input}],change:[{type:t.Output}],toggleChange:[{type:t.Output}],dragChange:[{type:t.Output}],_inputElement:[{type:t.ViewChild,args:["input"]}]},o}(_),k=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[l.MatRippleModule,l.MatCommonModule,g.ObserversModule],exports:[y,l.MatCommonModule],declarations:[y],providers:[{provide:d.HAMMER_GESTURE_CONFIG,useClass:l.GestureConfig}]}]}],e}();e.MatSlideToggleModule=k,e.MAT_SLIDE_TOGGLE_VALUE_ACCESSOR=h,e.MatSlideToggleChange=b,e.MatSlideToggleBase=f,e._MatSlideToggleMixinBase=_,e.MatSlideToggle=y,e.MAT_SLIDE_TOGGLE_DEFAULT_OPTIONS=u,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-slide-toggle.umd.min.js.map
