/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/cdk/a11y"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/core"),require("@angular/forms"),require("@angular/material/core"),require("@angular/platform-browser/animations"),require("rxjs"),require("@angular/common"),require("@angular/platform-browser")):"function"==typeof define&&define.amd?define("@angular/material/slider",["exports","@angular/cdk/a11y","@angular/cdk/bidi","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/core","@angular/forms","@angular/material/core","@angular/platform-browser/animations","rxjs","@angular/common","@angular/platform-browser"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.slider={}),t.ng.cdk.a11y,t.ng.cdk.bidi,t.ng.cdk.coercion,t.ng.cdk.keycodes,t.ng.core,t.ng.forms,t.ng.material.core,t.ng.platformBrowser.animations,t.rxjs,t.ng.common,t.ng.platformBrowser)}(this,function(t,e,i,r,a,s,n,o,l,c,d,u){"use strict";function m(t,e){function i(){this.constructor=t}h(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}var h=function(t,e){return(h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])})(t,e)},p={provide:n.NG_VALUE_ACCESSOR,useExisting:s.forwardRef(function(){return _}),multi:!0},b=function(){function t(){}return t}(),f=function(){function t(t){this._elementRef=t}return t}(),g=o.mixinTabIndex(o.mixinColor(o.mixinDisabled(f),"accent")),_=function(t){function n(e,i,r,a,n,o){var l=t.call(this,e)||this;return l._focusMonitor=i,l._changeDetectorRef=r,l._dir=a,l._animationMode=o,l._invert=!1,l._max=100,l._min=0,l._step=1,l._thumbLabel=!1,l._tickInterval=0,l._value=null,l._vertical=!1,l.change=new s.EventEmitter,l.input=new s.EventEmitter,l.valueChange=new s.EventEmitter,l.onTouched=function(){},l._percent=0,l._isSliding=!1,l._isActive=!1,l._tickIntervalPercent=0,l._sliderDimensions=null,l._controlValueAccessorChangeFn=function(){},l._dirChangeSubscription=c.Subscription.EMPTY,l.tabIndex=parseInt(n)||0,l}return m(n,t),Object.defineProperty(n.prototype,"invert",{get:function(){return this._invert},set:function(t){this._invert=r.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"max",{get:function(){return this._max},set:function(t){this._max=r.coerceNumberProperty(t,this._max),this._percent=this._calculatePercentage(this._value),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"min",{get:function(){return this._min},set:function(t){this._min=r.coerceNumberProperty(t,this._min),null===this._value&&(this.value=this._min),this._percent=this._calculatePercentage(this._value),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"step",{get:function(){return this._step},set:function(t){this._step=r.coerceNumberProperty(t,this._step),this._step%1!=0&&(this._roundToDecimal=this._step.toString().split(".").pop().length),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"thumbLabel",{get:function(){return this._thumbLabel},set:function(t){this._thumbLabel=r.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"tickInterval",{get:function(){return this._tickInterval},set:function(t){this._tickInterval="auto"===t?"auto":"number"==typeof t||"string"==typeof t?r.coerceNumberProperty(t,this._tickInterval):0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"value",{get:function(){return null===this._value&&(this.value=this._min),this._value},set:function(t){if(t!==this._value){var e=r.coerceNumberProperty(t);this._roundToDecimal&&(e=parseFloat(e.toFixed(this._roundToDecimal))),this._value=e,this._percent=this._calculatePercentage(this._value),this._changeDetectorRef.markForCheck()}},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"vertical",{get:function(){return this._vertical},set:function(t){this._vertical=r.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"displayValue",{get:function(){return this.displayWith?this.displayWith(this.value):this._roundToDecimal&&this.value&&this.value%1!=0?this.value.toFixed(this._roundToDecimal):this.value||0},enumerable:!0,configurable:!0}),n.prototype.focus=function(){this._focusHostElement()},n.prototype.blur=function(){this._blurHostElement()},Object.defineProperty(n.prototype,"percent",{get:function(){return this._clamp(this._percent)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_invertAxis",{get:function(){return this.vertical?!this.invert:this.invert},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isMinValue",{get:function(){return 0===this.percent},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_thumbGap",{get:function(){return this.disabled?7:this._isMinValue&&!this.thumbLabel?this._isActive?10:7:0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_trackBackgroundStyles",{get:function(){var t=this.vertical?"Y":"X",e=this.vertical?"1, "+(1-this.percent)+", 1":1-this.percent+", 1, 1";return{transform:"translate"+t+"("+(this._shouldInvertMouseCoords()?"-":"")+this._thumbGap+"px) scale3d("+e+")"}},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_trackFillStyles",{get:function(){var t=this.vertical?"Y":"X",e=this.vertical?"1, "+this.percent+", 1":this.percent+", 1, 1";return{transform:"translate"+t+"("+(this._shouldInvertMouseCoords()?"":"-")+this._thumbGap+"px) scale3d("+e+")"}},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ticksContainerStyles",{get:function(){return{transform:"translate"+(this.vertical?"Y":"X")+"("+(this.vertical||"rtl"!=this._getDirection()?"-":"")+this._tickIntervalPercent/2*100+"%)"}},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ticksStyles",{get:function(){var t=100*this._tickIntervalPercent,e=this.vertical?"2px "+t+"%":t+"% 2px",i=this.vertical?"Y":"X",r=this.vertical||"rtl"!=this._getDirection()?"":"-",a=this.vertical||"rtl"!=this._getDirection()?"":" rotate(180deg)",s={backgroundSize:e,transform:"translateZ(0) translate"+i+"("+r+t/2+"%)"+a};if(this._isMinValue&&this._thumbGap){s["padding"+(this.vertical?this._invertAxis?"Bottom":"Top":this._invertAxis?"Right":"Left")]=this._thumbGap+"px"}return s},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_thumbContainerStyles",{get:function(){return{transform:"translate"+(this.vertical?"Y":"X")+"(-"+100*(("rtl"!=this._getDirection()||this.vertical?this._invertAxis:!this._invertAxis)?this.percent:1-this.percent)+"%)"}},enumerable:!0,configurable:!0}),n.prototype._shouldInvertMouseCoords=function(){return"rtl"!=this._getDirection()||this.vertical?this._invertAxis:!this._invertAxis},n.prototype._getDirection=function(){return this._dir&&"rtl"==this._dir.value?"rtl":"ltr"},n.prototype.ngOnInit=function(){var t=this;this._focusMonitor.monitor(this._elementRef,!0).subscribe(function(e){t._isActive=!!e&&"keyboard"!==e,t._changeDetectorRef.detectChanges()}),this._dir&&(this._dirChangeSubscription=this._dir.change.subscribe(function(){t._changeDetectorRef.markForCheck()}))},n.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._elementRef),this._dirChangeSubscription.unsubscribe()},n.prototype._onMouseenter=function(){this.disabled||(this._sliderDimensions=this._getSliderDimensions(),this._updateTickIntervalPercent())},n.prototype._onClick=function(t){if(!this.disabled){var e=this.value;this._isSliding=!1,this._focusHostElement(),this._updateValueFromPosition({x:t.clientX,y:t.clientY}),e!=this.value&&(this._emitInputEvent(),this._emitChangeEvent())}},n.prototype._onSlide=function(t){if(!this.disabled){this._isSliding||this._onSlideStart(null),t.preventDefault();var e=this.value;this._updateValueFromPosition({x:t.center.x,y:t.center.y}),e!=this.value&&this._emitInputEvent()}},n.prototype._onSlideStart=function(t){this.disabled||this._isSliding||(this._onMouseenter(),this._isSliding=!0,this._focusHostElement(),this._valueOnSlideStart=this.value,t&&(this._updateValueFromPosition({x:t.center.x,y:t.center.y}),t.preventDefault()))},n.prototype._onSlideEnd=function(){this._isSliding=!1,this._valueOnSlideStart==this.value||this.disabled||this._emitChangeEvent(),this._valueOnSlideStart=null},n.prototype._onFocus=function(){this._sliderDimensions=this._getSliderDimensions(),this._updateTickIntervalPercent()},n.prototype._onBlur=function(){this.onTouched()},n.prototype._onKeydown=function(t){if(!this.disabled){var e=this.value;switch(t.keyCode){case a.PAGE_UP:this._increment(10);break;case a.PAGE_DOWN:this._increment(-10);break;case a.END:this.value=this.max;break;case a.HOME:this.value=this.min;break;case a.LEFT_ARROW:this._increment("rtl"==this._getDirection()?1:-1);break;case a.UP_ARROW:this._increment(1);break;case a.RIGHT_ARROW:this._increment("rtl"==this._getDirection()?-1:1);break;case a.DOWN_ARROW:this._increment(-1);break;default:return}e!=this.value&&(this._emitInputEvent(),this._emitChangeEvent()),this._isSliding=!0,t.preventDefault()}},n.prototype._onKeyup=function(){this._isSliding=!1},n.prototype._increment=function(t){this.value=this._clamp((this.value||0)+this.step*t,this.min,this.max)},n.prototype._updateValueFromPosition=function(t){if(this._sliderDimensions){var e=this.vertical?this._sliderDimensions.top:this._sliderDimensions.left,i=this.vertical?this._sliderDimensions.height:this._sliderDimensions.width,r=this.vertical?t.y:t.x,a=this._clamp((r-e)/i);if(this._shouldInvertMouseCoords()&&(a=1-a),0===a)this.value=this.min;else if(1===a)this.value=this.max;else{var s=this._calculateValue(a),n=Math.round((s-this.min)/this.step)*this.step+this.min;this.value=this._clamp(n,this.min,this.max)}}},n.prototype._emitChangeEvent=function(){this._controlValueAccessorChangeFn(this.value),this.valueChange.emit(this.value),this.change.emit(this._createChangeEvent())},n.prototype._emitInputEvent=function(){this.input.emit(this._createChangeEvent())},n.prototype._updateTickIntervalPercent=function(){if(this.tickInterval&&this._sliderDimensions)if("auto"==this.tickInterval){var t=this.vertical?this._sliderDimensions.height:this._sliderDimensions.width,e=t*this.step/(this.max-this.min),i=Math.ceil(30/e),r=i*this.step;this._tickIntervalPercent=r/t}else this._tickIntervalPercent=this.tickInterval*this.step/(this.max-this.min)},n.prototype._createChangeEvent=function(t){void 0===t&&(t=this.value);var e=new b;return e.source=this,e.value=t,e},n.prototype._calculatePercentage=function(t){return((t||0)-this.min)/(this.max-this.min)},n.prototype._calculateValue=function(t){return this.min+t*(this.max-this.min)},n.prototype._clamp=function(t,e,i){return void 0===e&&(e=0),void 0===i&&(i=1),Math.max(e,Math.min(t,i))},n.prototype._getSliderDimensions=function(){return this._sliderWrapper?this._sliderWrapper.nativeElement.getBoundingClientRect():null},n.prototype._focusHostElement=function(){this._elementRef.nativeElement.focus()},n.prototype._blurHostElement=function(){this._elementRef.nativeElement.blur()},n.prototype.writeValue=function(t){this.value=t},n.prototype.registerOnChange=function(t){this._controlValueAccessorChangeFn=t},n.prototype.registerOnTouched=function(t){this.onTouched=t},n.prototype.setDisabledState=function(t){this.disabled=t},n.decorators=[{type:s.Component,args:[{selector:"mat-slider",exportAs:"matSlider",providers:[p],host:{"(focus)":"_onFocus()","(blur)":"_onBlur()","(click)":"_onClick($event)","(keydown)":"_onKeydown($event)","(keyup)":"_onKeyup()","(mouseenter)":"_onMouseenter()","(slide)":"_onSlide($event)","(slideend)":"_onSlideEnd()","(slidestart)":"_onSlideStart($event)",class:"mat-slider",role:"slider","[tabIndex]":"tabIndex","[attr.aria-disabled]":"disabled","[attr.aria-valuemax]":"max","[attr.aria-valuemin]":"min","[attr.aria-valuenow]":"value","[attr.aria-orientation]":'vertical ? "vertical" : "horizontal"',"[class.mat-slider-disabled]":"disabled","[class.mat-slider-has-ticks]":"tickInterval","[class.mat-slider-horizontal]":"!vertical","[class.mat-slider-axis-inverted]":"_invertAxis","[class.mat-slider-sliding]":"_isSliding","[class.mat-slider-thumb-label-showing]":"thumbLabel","[class.mat-slider-vertical]":"vertical","[class.mat-slider-min-value]":"_isMinValue","[class.mat-slider-hide-last-tick]":"disabled || _isMinValue && _thumbGap && _invertAxis","[class._mat-animation-noopable]":'_animationMode === "NoopAnimations"'},template:'<div class="mat-slider-wrapper" #sliderWrapper><div class="mat-slider-track-wrapper"><div class="mat-slider-track-background" [ngStyle]="_trackBackgroundStyles"></div><div class="mat-slider-track-fill" [ngStyle]="_trackFillStyles"></div></div><div class="mat-slider-ticks-container" [ngStyle]="_ticksContainerStyles"><div class="mat-slider-ticks" [ngStyle]="_ticksStyles"></div></div><div class="mat-slider-thumb-container" [ngStyle]="_thumbContainerStyles"><div class="mat-slider-focus-ring"></div><div class="mat-slider-thumb"></div><div class="mat-slider-thumb-label"><span class="mat-slider-thumb-label-text">{{displayValue}}</span></div></div></div>',styles:[".mat-slider{display:inline-block;position:relative;box-sizing:border-box;padding:8px;outline:0;vertical-align:middle}.mat-slider-wrapper{position:absolute}.mat-slider-track-wrapper{position:absolute;top:0;left:0;overflow:hidden}.mat-slider-track-fill{position:absolute;transform-origin:0 0;transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-track-background{position:absolute;transform-origin:100% 100%;transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-ticks-container{position:absolute;left:0;top:0;overflow:hidden}.mat-slider-ticks{background-repeat:repeat;background-clip:content-box;box-sizing:border-box;opacity:0;transition:opacity .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-thumb-container{position:absolute;z-index:1;transition:transform .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-focus-ring{position:absolute;width:30px;height:30px;border-radius:50%;transform:scale(0);opacity:0;transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1),opacity .4s cubic-bezier(.25,.8,.25,1)}.cdk-keyboard-focused .mat-slider-focus-ring,.cdk-program-focused .mat-slider-focus-ring{transform:scale(1);opacity:1}.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb,.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb-label{cursor:-webkit-grab;cursor:grab}.mat-slider-sliding:not(.mat-slider-disabled) .mat-slider-thumb,.mat-slider-sliding:not(.mat-slider-disabled) .mat-slider-thumb-label,.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb-label:active,.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb:active{cursor:-webkit-grabbing;cursor:grabbing}.mat-slider-thumb{position:absolute;right:-10px;bottom:-10px;box-sizing:border-box;width:20px;height:20px;border:3px solid transparent;border-radius:50%;transform:scale(.7);transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1),border-color .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-thumb-label{display:none;align-items:center;justify-content:center;position:absolute;width:28px;height:28px;border-radius:50%;transition:transform .4s cubic-bezier(.25,.8,.25,1),border-radius .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1)}@media screen and (-ms-high-contrast:active){.mat-slider-thumb-label{outline:solid 1px}}.mat-slider-thumb-label-text{z-index:1;opacity:0;transition:opacity .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-sliding .mat-slider-thumb-container,.mat-slider-sliding .mat-slider-track-background,.mat-slider-sliding .mat-slider-track-fill{transition-duration:0s}.mat-slider-has-ticks .mat-slider-wrapper::after{content:'';position:absolute;border-width:0;border-style:solid;opacity:0;transition:opacity .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-has-ticks.cdk-focused:not(.mat-slider-hide-last-tick) .mat-slider-wrapper::after,.mat-slider-has-ticks:hover:not(.mat-slider-hide-last-tick) .mat-slider-wrapper::after{opacity:1}.mat-slider-has-ticks.cdk-focused:not(.mat-slider-disabled) .mat-slider-ticks,.mat-slider-has-ticks:hover:not(.mat-slider-disabled) .mat-slider-ticks{opacity:1}.mat-slider-thumb-label-showing .mat-slider-focus-ring{transform:scale(0);opacity:0}.mat-slider-thumb-label-showing .mat-slider-thumb-label{display:flex}.mat-slider-axis-inverted .mat-slider-track-fill{transform-origin:100% 100%}.mat-slider-axis-inverted .mat-slider-track-background{transform-origin:0 0}.mat-slider:not(.mat-slider-disabled).cdk-focused.mat-slider-thumb-label-showing .mat-slider-thumb{transform:scale(0)}.mat-slider:not(.mat-slider-disabled).cdk-focused .mat-slider-thumb-label{border-radius:50% 50% 0}.mat-slider:not(.mat-slider-disabled).cdk-focused .mat-slider-thumb-label-text{opacity:1}.mat-slider:not(.mat-slider-disabled).cdk-mouse-focused .mat-slider-thumb,.mat-slider:not(.mat-slider-disabled).cdk-program-focused .mat-slider-thumb,.mat-slider:not(.mat-slider-disabled).cdk-touch-focused .mat-slider-thumb{border-width:2px;transform:scale(1)}.mat-slider-disabled .mat-slider-focus-ring{transform:scale(0);opacity:0}.mat-slider-disabled .mat-slider-thumb{border-width:4px;transform:scale(.5)}.mat-slider-disabled .mat-slider-thumb-label{display:none}.mat-slider-horizontal{height:48px;min-width:128px}.mat-slider-horizontal .mat-slider-wrapper{height:2px;top:23px;left:8px;right:8px}.mat-slider-horizontal .mat-slider-wrapper::after{height:2px;border-left-width:2px;right:0;top:0}.mat-slider-horizontal .mat-slider-track-wrapper{height:2px;width:100%}.mat-slider-horizontal .mat-slider-track-fill{height:2px;width:100%;transform:scaleX(0)}.mat-slider-horizontal .mat-slider-track-background{height:2px;width:100%;transform:scaleX(1)}.mat-slider-horizontal .mat-slider-ticks-container{height:2px;width:100%}@media screen and (-ms-high-contrast:active){.mat-slider-horizontal .mat-slider-ticks-container{height:0;outline:solid 2px;top:1px}}.mat-slider-horizontal .mat-slider-ticks{height:2px;width:100%}.mat-slider-horizontal .mat-slider-thumb-container{width:100%;height:0;top:50%}.mat-slider-horizontal .mat-slider-focus-ring{top:-15px;right:-15px}.mat-slider-horizontal .mat-slider-thumb-label{right:-14px;top:-40px;transform:translateY(26px) scale(.01) rotate(45deg)}.mat-slider-horizontal .mat-slider-thumb-label-text{transform:rotate(-45deg)}.mat-slider-horizontal.cdk-focused .mat-slider-thumb-label{transform:rotate(45deg)}@media screen and (-ms-high-contrast:active){.mat-slider-horizontal.cdk-focused .mat-slider-thumb-label,.mat-slider-horizontal.cdk-focused .mat-slider-thumb-label-text{transform:none}}.mat-slider-vertical{width:48px;min-height:128px}.mat-slider-vertical .mat-slider-wrapper{width:2px;top:8px;bottom:8px;left:23px}.mat-slider-vertical .mat-slider-wrapper::after{width:2px;border-top-width:2px;bottom:0;left:0}.mat-slider-vertical .mat-slider-track-wrapper{height:100%;width:2px}.mat-slider-vertical .mat-slider-track-fill{height:100%;width:2px;transform:scaleY(0)}.mat-slider-vertical .mat-slider-track-background{height:100%;width:2px;transform:scaleY(1)}.mat-slider-vertical .mat-slider-ticks-container{width:2px;height:100%}@media screen and (-ms-high-contrast:active){.mat-slider-vertical .mat-slider-ticks-container{width:0;outline:solid 2px;left:1px}}.mat-slider-vertical .mat-slider-focus-ring{bottom:-15px;left:-15px}.mat-slider-vertical .mat-slider-ticks{width:2px;height:100%}.mat-slider-vertical .mat-slider-thumb-container{height:100%;width:0;left:50%}.mat-slider-vertical .mat-slider-thumb{-webkit-backface-visibility:hidden;backface-visibility:hidden}.mat-slider-vertical .mat-slider-thumb-label{bottom:-14px;left:-40px;transform:translateX(26px) scale(.01) rotate(-45deg)}.mat-slider-vertical .mat-slider-thumb-label-text{transform:rotate(45deg)}.mat-slider-vertical.cdk-focused .mat-slider-thumb-label{transform:rotate(-45deg)}[dir=rtl] .mat-slider-wrapper::after{left:0;right:auto}[dir=rtl] .mat-slider-horizontal .mat-slider-track-fill{transform-origin:100% 100%}[dir=rtl] .mat-slider-horizontal .mat-slider-track-background{transform-origin:0 0}[dir=rtl] .mat-slider-horizontal.mat-slider-axis-inverted .mat-slider-track-fill{transform-origin:0 0}[dir=rtl] .mat-slider-horizontal.mat-slider-axis-inverted .mat-slider-track-background{transform-origin:100% 100%}.mat-slider._mat-animation-noopable .mat-slider-focus-ring,.mat-slider._mat-animation-noopable .mat-slider-has-ticks .mat-slider-wrapper::after,.mat-slider._mat-animation-noopable .mat-slider-thumb,.mat-slider._mat-animation-noopable .mat-slider-thumb-container,.mat-slider._mat-animation-noopable .mat-slider-thumb-label,.mat-slider._mat-animation-noopable .mat-slider-thumb-label-text,.mat-slider._mat-animation-noopable .mat-slider-ticks,.mat-slider._mat-animation-noopable .mat-slider-track-background,.mat-slider._mat-animation-noopable .mat-slider-track-fill{transition:none}"],inputs:["disabled","color","tabIndex"],encapsulation:s.ViewEncapsulation.None,changeDetection:s.ChangeDetectionStrategy.OnPush}]}],n.ctorParameters=function(){return[{type:s.ElementRef},{type:e.FocusMonitor},{type:s.ChangeDetectorRef},{type:i.Directionality,decorators:[{type:s.Optional}]},{type:String,decorators:[{type:s.Attribute,args:["tabindex"]}]},{type:String,decorators:[{type:s.Optional},{type:s.Inject,args:[l.ANIMATION_MODULE_TYPE]}]}]},n.propDecorators={invert:[{type:s.Input}],max:[{type:s.Input}],min:[{type:s.Input}],step:[{type:s.Input}],thumbLabel:[{type:s.Input}],tickInterval:[{type:s.Input}],value:[{type:s.Input}],displayWith:[{type:s.Input}],vertical:[{type:s.Input}],change:[{type:s.Output}],input:[{type:s.Output}],valueChange:[{type:s.Output}],_sliderWrapper:[{type:s.ViewChild,args:["sliderWrapper"]}]},n}(g),v=function(){function t(){}return t.decorators=[{type:s.NgModule,args:[{imports:[d.CommonModule,o.MatCommonModule],exports:[_,o.MatCommonModule],declarations:[_],providers:[{provide:u.HAMMER_GESTURE_CONFIG,useClass:o.GestureConfig}]}]}],t}();t.MatSliderModule=v,t.MAT_SLIDER_VALUE_ACCESSOR=p,t.MatSliderChange=b,t.MatSliderBase=f,t._MatSliderMixinBase=g,t.MatSlider=_,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-slider.umd.min.js.map
