/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("rxjs"),require("@angular/core"),require("@angular/animations"),require("@angular/cdk/portal"),require("rxjs/operators"),require("@angular/cdk/overlay"),require("@angular/common"),require("@angular/material/core"),require("@angular/material/button"),require("@angular/cdk/a11y"),require("@angular/cdk/layout")):"function"==typeof define&&define.amd?define("@angular/material/snackBar",["exports","rxjs","@angular/core","@angular/animations","@angular/cdk/portal","rxjs/operators","@angular/cdk/overlay","@angular/common","@angular/material/core","@angular/material/button","@angular/cdk/a11y","@angular/cdk/layout"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.snackBar={}),t.rxjs,t.ng.core,t.ng.animations,t.ng.cdk.portal,t.rxjs.operators,t.ng.cdk.overlay,t.ng.common,t.ng.material.core,t.ng.material.button,t.ng.cdk.a11y,t.ng.cdk.layout)}(this,function(t,e,n,a,i,o,r,s,c,p,l,u){"use strict";function d(t,e){function n(){this.constructor=t}m(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)}function h(){return new g}var m=function(t,e){return(m=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)},f=function(){return f=Object.assign||function(t){for(var e,n=1,a=arguments.length;n<a;n++){e=arguments[n];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])}return t},f.apply(this,arguments)},_=function(){function t(t,n){var a=this;this._overlayRef=n,this._afterDismissed=new e.Subject,this._afterOpened=new e.Subject,this._onAction=new e.Subject,this._dismissedByAction=!1,this.containerInstance=t,this.onAction().subscribe(function(){return a.dismiss()}),t._onExit.subscribe(function(){return a._finishDismiss()})}return t.prototype.dismiss=function(){this._afterDismissed.closed||this.containerInstance.exit(),clearTimeout(this._durationTimeoutId)},t.prototype.dismissWithAction=function(){this._onAction.closed||(this._dismissedByAction=!0,this._onAction.next(),this._onAction.complete())},t.prototype.closeWithAction=function(){this.dismissWithAction()},t.prototype._dismissAfter=function(t){var e=this;this._durationTimeoutId=setTimeout(function(){return e.dismiss()},t)},t.prototype._open=function(){this._afterOpened.closed||(this._afterOpened.next(),this._afterOpened.complete())},t.prototype._finishDismiss=function(){this._overlayRef.dispose(),this._onAction.closed||this._onAction.complete(),this._afterDismissed.next({dismissedByAction:this._dismissedByAction}),this._afterDismissed.complete(),this._dismissedByAction=!1},t.prototype.afterDismissed=function(){return this._afterDismissed.asObservable()},t.prototype.afterOpened=function(){return this.containerInstance._onEnter},t.prototype.onAction=function(){return this._onAction.asObservable()},t}(),y=new n.InjectionToken("MatSnackBarData"),g=function(){function t(){this.politeness="assertive",this.announcementMessage="",this.duration=0,this.data=null,this.horizontalPosition="center",this.verticalPosition="bottom"}return t}(),k=function(){function t(t,e){this.snackBarRef=t,this.data=e}return t.prototype.action=function(){this.snackBarRef.dismissWithAction()},Object.defineProperty(t.prototype,"hasAction",{get:function(){return!!this.data.action},enumerable:!0,configurable:!0}),t.decorators=[{type:n.Component,args:[{selector:"simple-snack-bar",template:'<span>{{data.message}}</span><div class="mat-simple-snackbar-action" *ngIf="hasAction"><button mat-button (click)="action()">{{data.action}}</button></div>',styles:[".mat-simple-snackbar{display:flex;justify-content:space-between;align-items:center;height:100%;line-height:20px;opacity:1}.mat-simple-snackbar-action{flex-shrink:0;margin:-8px -8px -8px 8px}.mat-simple-snackbar-action button{max-height:36px;min-width:0}[dir=rtl] .mat-simple-snackbar-action{margin-left:-8px;margin-right:8px}"],encapsulation:n.ViewEncapsulation.None,changeDetection:n.ChangeDetectionStrategy.OnPush,host:{class:"mat-simple-snackbar"}}]}],t.ctorParameters=function(){return[{type:_},{type:void 0,decorators:[{type:n.Inject,args:[y]}]}]},t}(),b={snackBarState:a.trigger("state",[a.state("void, hidden",a.style({transform:"scale(0.8)",opacity:0})),a.state("visible",a.style({transform:"scale(1)",opacity:1})),a.transition("* => visible",a.animate("150ms cubic-bezier(0, 0, 0.2, 1)")),a.transition("* => void, * => hidden",a.animate("75ms cubic-bezier(0.4, 0.0, 1, 1)",a.style({opacity:0})))])},v=function(t){function a(n,a,i,o){var r=t.call(this)||this;return r._ngZone=n,r._elementRef=a,r._changeDetectorRef=i,r.snackBarConfig=o,r._destroyed=!1,r._onExit=new e.Subject,r._onEnter=new e.Subject,r._animationState="void",r}return d(a,t),a.prototype.attachComponentPortal=function(t){return this._assertNotAttached(),this._applySnackBarClasses(),this._portalOutlet.attachComponentPortal(t)},a.prototype.attachTemplatePortal=function(t){return this._assertNotAttached(),this._applySnackBarClasses(),this._portalOutlet.attachTemplatePortal(t)},a.prototype.onAnimationEnd=function(t){var e=t.fromState,n=t.toState;if(("void"===n&&"void"!==e||"hidden"===n)&&this._completeExit(),"visible"===n){var a=this._onEnter;this._ngZone.run(function(){a.next(),a.complete()})}},a.prototype.enter=function(){this._destroyed||(this._animationState="visible",this._changeDetectorRef.detectChanges())},a.prototype.exit=function(){return this._animationState="hidden",this._onExit},a.prototype.ngOnDestroy=function(){this._destroyed=!0,this._completeExit()},a.prototype._completeExit=function(){var t=this;this._ngZone.onMicrotaskEmpty.asObservable().pipe(o.take(1)).subscribe(function(){t._onExit.next(),t._onExit.complete()})},a.prototype._applySnackBarClasses=function(){var t=this._elementRef.nativeElement,e=this.snackBarConfig.panelClass;e&&(Array.isArray(e)?e.forEach(function(e){return t.classList.add(e)}):t.classList.add(e)),"center"===this.snackBarConfig.horizontalPosition&&t.classList.add("mat-snack-bar-center"),"top"===this.snackBarConfig.verticalPosition&&t.classList.add("mat-snack-bar-top")},a.prototype._assertNotAttached=function(){if(this._portalOutlet.hasAttached())throw Error("Attempting to attach snack bar content after content is already attached")},a.decorators=[{type:n.Component,args:[{selector:"snack-bar-container",template:"<ng-template cdkPortalOutlet></ng-template>",styles:[".mat-snack-bar-container{border-radius:4px;box-sizing:border-box;display:block;margin:24px;max-width:33vw;min-width:344px;padding:14px 16px;min-height:48px;transform-origin:center}@media screen and (-ms-high-contrast:active){.mat-snack-bar-container{border:solid 1px}}.mat-snack-bar-handset{width:100%}.mat-snack-bar-handset .mat-snack-bar-container{margin:8px;max-width:100%;width:100%}"],changeDetection:n.ChangeDetectionStrategy.OnPush,encapsulation:n.ViewEncapsulation.None,animations:[b.snackBarState],host:{role:"alert",class:"mat-snack-bar-container","[@state]":"_animationState","(@state.done)":"onAnimationEnd($event)"}}]}],a.ctorParameters=function(){return[{type:n.NgZone},{type:n.ElementRef},{type:n.ChangeDetectorRef},{type:g}]},a.propDecorators={_portalOutlet:[{type:n.ViewChild,args:[i.CdkPortalOutlet]}]},a}(i.BasePortalOutlet),B=function(){function t(){}return t.decorators=[{type:n.NgModule,args:[{imports:[r.OverlayModule,i.PortalModule,s.CommonModule,p.MatButtonModule,c.MatCommonModule],exports:[v,c.MatCommonModule],declarations:[v,k],entryComponents:[v,k]}]}],t}(),S=new n.InjectionToken("mat-snack-bar-default-options",{providedIn:"root",factory:h}),A=function(){function t(t,e,n,a,i,o){this._overlay=t,this._live=e,this._injector=n,this._breakpointObserver=a,this._parentSnackBar=i,this._defaultConfig=o,this._snackBarRefAtThisLevel=null}return Object.defineProperty(t.prototype,"_openedSnackBarRef",{get:function(){var t=this._parentSnackBar;return t?t._openedSnackBarRef:this._snackBarRefAtThisLevel},set:function(t){this._parentSnackBar?this._parentSnackBar._openedSnackBarRef=t:this._snackBarRefAtThisLevel=t},enumerable:!0,configurable:!0}),t.prototype.openFromComponent=function(t,e){return this._attach(t,e)},t.prototype.openFromTemplate=function(t,e){return this._attach(t,e)},t.prototype.open=function(t,e,n){void 0===e&&(e="");var a=f({},this._defaultConfig,n);return a.data={message:t,action:e},a.announcementMessage||(a.announcementMessage=t),this.openFromComponent(k,a)},t.prototype.dismiss=function(){this._openedSnackBarRef&&this._openedSnackBarRef.dismiss()},t.prototype.ngOnDestroy=function(){this._snackBarRefAtThisLevel&&this._snackBarRefAtThisLevel.dismiss()},t.prototype._attachSnackBarContainer=function(t,e){var n=e&&e.viewContainerRef&&e.viewContainerRef.injector,a=new i.PortalInjector(n||this._injector,new WeakMap([[g,e]])),o=new i.ComponentPortal(v,e.viewContainerRef,a),r=t.attach(o);return r.instance.snackBarConfig=e,r.instance},t.prototype._attach=function(t,e){var a=f({},new g,this._defaultConfig,e),r=this._createOverlay(a),s=this._attachSnackBarContainer(r,a),c=new _(s,r);if(t instanceof n.TemplateRef){var p=new i.TemplatePortal(t,null,{$implicit:a.data,snackBarRef:c});c.instance=s.attachTemplatePortal(p)}else{var l=this._createInjector(a,c),p=new i.ComponentPortal(t,void 0,l),d=s.attachComponentPortal(p);c.instance=d.instance}return this._breakpointObserver.observe(u.Breakpoints.Handset).pipe(o.takeUntil(r.detachments().pipe(o.take(1)))).subscribe(function(t){t.matches?r.overlayElement.classList.add("mat-snack-bar-handset"):r.overlayElement.classList.remove("mat-snack-bar-handset")}),this._animateSnackBar(c,a),this._openedSnackBarRef=c,this._openedSnackBarRef},t.prototype._animateSnackBar=function(t,e){var n=this;t.afterDismissed().subscribe(function(){n._openedSnackBarRef==t&&(n._openedSnackBarRef=null)}),this._openedSnackBarRef?(this._openedSnackBarRef.afterDismissed().subscribe(function(){t.containerInstance.enter()}),this._openedSnackBarRef.dismiss()):t.containerInstance.enter(),e.duration&&e.duration>0&&t.afterOpened().subscribe(function(){return t._dismissAfter(e.duration)}),e.announcementMessage&&this._live.announce(e.announcementMessage,e.politeness)},t.prototype._createOverlay=function(t){var e=new r.OverlayConfig;e.direction=t.direction;var n=this._overlay.position().global(),a="rtl"===t.direction,i="left"===t.horizontalPosition||"start"===t.horizontalPosition&&!a||"end"===t.horizontalPosition&&a,o=!i&&"center"!==t.horizontalPosition;return i?n.left("0"):o?n.right("0"):n.centerHorizontally(),"top"===t.verticalPosition?n.top("0"):n.bottom("0"),e.positionStrategy=n,this._overlay.create(e)},t.prototype._createInjector=function(t,e){var n=t&&t.viewContainerRef&&t.viewContainerRef.injector;return new i.PortalInjector(n||this._injector,new WeakMap([[_,e],[y,t.data]]))},t.decorators=[{type:n.Injectable,args:[{providedIn:B}]}],t.ctorParameters=function(){return[{type:r.Overlay},{type:l.LiveAnnouncer},{type:n.Injector},{type:u.BreakpointObserver},{type:t,decorators:[{type:n.Optional},{type:n.SkipSelf}]},{type:g,decorators:[{type:n.Inject,args:[S]}]}]},t.ngInjectableDef=n.defineInjectable({factory:function(){return new t(n.inject(r.Overlay),n.inject(l.LiveAnnouncer),n.inject(n.INJECTOR),n.inject(u.BreakpointObserver),n.inject(t,12),n.inject(S))},token:t,providedIn:B}),t}();t.MatSnackBarModule=B,t.MAT_SNACK_BAR_DEFAULT_OPTIONS_FACTORY=h,t.MAT_SNACK_BAR_DEFAULT_OPTIONS=S,t.MatSnackBar=A,t.MatSnackBarContainer=v,t.MAT_SNACK_BAR_DATA=y,t.MatSnackBarConfig=g,t.MatSnackBarRef=_,t.SimpleSnackBar=k,t.matSnackBarAnimations=b,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-snack-bar.umd.min.js.map
