/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/cdk/coercion"),require("@angular/core"),require("@angular/material/core"),require("rxjs"),require("@angular/animations"),require("@angular/cdk/table"),require("@angular/common")):"function"==typeof define&&define.amd?define("@angular/material/sort",["exports","@angular/cdk/coercion","@angular/core","@angular/material/core","rxjs","@angular/animations","@angular/cdk/table","@angular/common"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.sort={}),t.ng.cdk.coercion,t.ng.core,t.ng.material.core,t.rxjs,t.ng.animations,t.ng.cdk.table,t.ng.common)}(this,function(t,e,r,i,a,o,n,s){"use strict";function c(t,e){function r(){this.constructor=t}f(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}function d(t){return Error("Cannot have two MatSortables with the same id ("+t+").")}function l(){return Error("MatSortHeader must be placed within a parent element with the MatSort directive.")}function h(){return Error("MatSortHeader must be provided with a unique id.")}function u(t){return Error(t+" is not a valid sort direction ('asc' or 'desc').")}function p(t,e){var r=["asc","desc"];return"desc"==t&&r.reverse(),e||r.push(""),r}function m(t){return t||new v}var f=function(t,e){return(f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])})(t,e)},g=function(){function t(){}return t}(),_=i.mixinInitialized(i.mixinDisabled(g)),b=function(t){function i(){var e=null!==t&&t.apply(this,arguments)||this;return e.sortables=new Map,e._stateChanges=new a.Subject,e.start="asc",e._direction="",e.sortChange=new r.EventEmitter,e}return c(i,t),Object.defineProperty(i.prototype,"direction",{get:function(){return this._direction},set:function(t){if(r.isDevMode()&&t&&"asc"!==t&&"desc"!==t)throw u(t);this._direction=t},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"disableClear",{get:function(){return this._disableClear},set:function(t){this._disableClear=e.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),i.prototype.register=function(t){if(!t.id)throw h();if(this.sortables.has(t.id))throw d(t.id);this.sortables.set(t.id,t)},i.prototype.deregister=function(t){this.sortables.delete(t.id)},i.prototype.sort=function(t){this.active!=t.id?(this.active=t.id,this.direction=t.start?t.start:this.start):this.direction=this.getNextSortDirection(t),this.sortChange.emit({active:this.active,direction:this.direction})},i.prototype.getNextSortDirection=function(t){if(!t)return"";var e=null!=t.disableClear?t.disableClear:this.disableClear,r=p(t.start||this.start,e),i=r.indexOf(this.direction)+1;return i>=r.length&&(i=0),r[i]},i.prototype.ngOnInit=function(){this._markInitialized()},i.prototype.ngOnChanges=function(){this._stateChanges.next()},i.prototype.ngOnDestroy=function(){this._stateChanges.complete()},i.decorators=[{type:r.Directive,args:[{selector:"[matSort]",exportAs:"matSort",inputs:["disabled: matSortDisabled"]}]}],i.propDecorators={active:[{type:r.Input,args:["matSortActive"]}],start:[{type:r.Input,args:["matSortStart"]}],direction:[{type:r.Input,args:["matSortDirection"]}],disableClear:[{type:r.Input,args:["matSortDisableClear"]}],sortChange:[{type:r.Output,args:["matSortChange"]}]},i}(_),y=i.AnimationDurations.ENTERING+" "+i.AnimationCurves.STANDARD_CURVE,w={indicator:o.trigger("indicator",[o.state("active-asc, asc",o.style({transform:"translateY(0px)"})),o.state("active-desc, desc",o.style({transform:"translateY(10px)"})),o.transition("active-asc <=> active-desc",o.animate(y))]),leftPointer:o.trigger("leftPointer",[o.state("active-asc, asc",o.style({transform:"rotate(-45deg)"})),o.state("active-desc, desc",o.style({transform:"rotate(45deg)"})),o.transition("active-asc <=> active-desc",o.animate(y))]),rightPointer:o.trigger("rightPointer",[o.state("active-asc, asc",o.style({transform:"rotate(45deg)"})),o.state("active-desc, desc",o.style({transform:"rotate(-45deg)"})),o.transition("active-asc <=> active-desc",o.animate(y))]),arrowOpacity:o.trigger("arrowOpacity",[o.state("desc-to-active, asc-to-active, active",o.style({opacity:1})),o.state("desc-to-hint, asc-to-hint, hint",o.style({opacity:.54})),o.state("hint-to-desc, active-to-desc, desc, hint-to-asc, active-to-asc, asc, void",o.style({opacity:0})),o.transition("* => asc, * => desc, * => active, * => hint, * => void",o.animate("0ms")),o.transition("* <=> *",o.animate(y))]),arrowPosition:o.trigger("arrowPosition",[o.transition("* => desc-to-hint, * => desc-to-active",o.animate(y,o.keyframes([o.style({transform:"translateY(-25%)"}),o.style({transform:"translateY(0)"})]))),o.transition("* => hint-to-desc, * => active-to-desc",o.animate(y,o.keyframes([o.style({transform:"translateY(0)"}),o.style({transform:"translateY(25%)"})]))),o.transition("* => asc-to-hint, * => asc-to-active",o.animate(y,o.keyframes([o.style({transform:"translateY(25%)"}),o.style({transform:"translateY(0)"})]))),o.transition("* => hint-to-asc, * => active-to-asc",o.animate(y,o.keyframes([o.style({transform:"translateY(0)"}),o.style({transform:"translateY(-25%)"})]))),o.state("desc-to-hint, asc-to-hint, hint, desc-to-active, asc-to-active, active",o.style({transform:"translateY(0)"})),o.state("hint-to-desc, active-to-desc, desc",o.style({transform:"translateY(-25%)"})),o.state("hint-to-asc, active-to-asc, asc",o.style({transform:"translateY(25%)"}))]),allowChildren:o.trigger("allowChildren",[o.transition("* <=> *",[o.query("@*",o.animateChild(),{optional:!0})])])},v=function(){function t(){this.changes=new a.Subject,this.sortButtonLabel=function(t){return"Change sorting for "+t}}return t.decorators=[{type:r.Injectable,args:[{providedIn:"root"}]}],t.ngInjectableDef=r.defineInjectable({factory:function(){return new t},token:t,providedIn:"root"}),t}(),S={provide:v,deps:[[new r.Optional,new r.SkipSelf,v]],useFactory:m},D=function(){function t(){}return t}(),C=i.mixinDisabled(D),x=function(t){function i(e,r,i,o){var n=t.call(this)||this;if(n._intl=e,n._sort=i,n._cdkColumnDef=o,n._showIndicatorHint=!1,n._arrowDirection="",n._disableViewStateAnimation=!1,n.arrowPosition="after",!i)throw l();return n._rerenderSubscription=a.merge(i.sortChange,i._stateChanges,e.changes).subscribe(function(){n._isSorted()&&n._updateArrowDirection(),!n._isSorted()&&n._viewState&&"active"===n._viewState.toState&&(n._disableViewStateAnimation=!1,n._setAnimationTransitionState({fromState:"active",toState:n._arrowDirection})),r.markForCheck()}),n}return c(i,t),Object.defineProperty(i.prototype,"disableClear",{get:function(){return this._disableClear},set:function(t){this._disableClear=e.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),i.prototype.ngOnInit=function(){!this.id&&this._cdkColumnDef&&(this.id=this._cdkColumnDef.name),this._updateArrowDirection(),this._setAnimationTransitionState({toState:this._isSorted()?"active":this._arrowDirection}),this._sort.register(this)},i.prototype.ngOnDestroy=function(){this._sort.deregister(this),this._rerenderSubscription.unsubscribe()},i.prototype._setIndicatorHintVisible=function(t){this._isDisabled()&&t||(this._showIndicatorHint=t,this._isSorted()||(this._updateArrowDirection(),this._showIndicatorHint?this._setAnimationTransitionState({fromState:this._arrowDirection,toState:"hint"}):this._setAnimationTransitionState({fromState:"hint",toState:this._arrowDirection})))},i.prototype._setAnimationTransitionState=function(t){this._viewState=t,this._disableViewStateAnimation&&(this._viewState={toState:t.toState})},i.prototype._handleClick=function(){if(!this._isDisabled()){this._sort.sort(this),"hint"!==this._viewState.toState&&"active"!==this._viewState.toState||(this._disableViewStateAnimation=!0);var t=this._isSorted()?{fromState:this._arrowDirection,toState:"active"}:{fromState:"active",toState:this._arrowDirection};this._setAnimationTransitionState(t),this._showIndicatorHint=!1}},i.prototype._isSorted=function(){return this._sort.active==this.id&&("asc"===this._sort.direction||"desc"===this._sort.direction)},i.prototype._getArrowDirectionState=function(){return(this._isSorted()?"active-":"")+this._arrowDirection},i.prototype._getArrowViewState=function(){var t=this._viewState.fromState;return(t?t+"-to-":"")+this._viewState.toState},i.prototype._updateArrowDirection=function(){this._arrowDirection=this._isSorted()?this._sort.direction:this.start||this._sort.start},i.prototype._isDisabled=function(){return this._sort.disabled||this.disabled},i.prototype._getAriaSortAttribute=function(){return this._isSorted()?"asc"==this._sort.direction?"ascending":"descending":null},i.decorators=[{type:r.Component,args:[{selector:"[mat-sort-header]",exportAs:"matSortHeader",template:'<div class="mat-sort-header-container" [class.mat-sort-header-sorted]="_isSorted()" [class.mat-sort-header-position-before]="arrowPosition == \'before\'"><button class="mat-sort-header-button" type="button" [attr.disabled]="_isDisabled() || null" [attr.aria-label]="_intl.sortButtonLabel(id)" (focus)="_setIndicatorHintVisible(true)" (blur)="_setIndicatorHintVisible(false)"><ng-content></ng-content></button><div class="mat-sort-header-arrow" [@arrowOpacity]="_getArrowViewState()" [@arrowPosition]="_getArrowViewState()" [@allowChildren]="_getArrowDirectionState()" (@arrowPosition.start)="_disableViewStateAnimation = true" (@arrowPosition.done)="_disableViewStateAnimation = false"><div class="mat-sort-header-stem"></div><div class="mat-sort-header-indicator" [@indicator]="_getArrowDirectionState()"><div class="mat-sort-header-pointer-left" [@leftPointer]="_getArrowDirectionState()"></div><div class="mat-sort-header-pointer-right" [@rightPointer]="_getArrowDirectionState()"></div><div class="mat-sort-header-pointer-middle"></div></div></div></div>',styles:[".mat-sort-header-container{display:flex;cursor:pointer;align-items:center}.mat-sort-header-disabled .mat-sort-header-container{cursor:default}.mat-sort-header-position-before{flex-direction:row-reverse}.mat-sort-header-button{border:none;background:0 0;display:flex;align-items:center;padding:0;cursor:inherit;outline:0;font:inherit;color:currentColor}.mat-sort-header-arrow{height:12px;width:12px;min-width:12px;position:relative;display:flex;opacity:0}.mat-sort-header-arrow,[dir=rtl] .mat-sort-header-position-before .mat-sort-header-arrow{margin:0 0 0 6px}.mat-sort-header-position-before .mat-sort-header-arrow,[dir=rtl] .mat-sort-header-arrow{margin:0 6px 0 0}.mat-sort-header-stem{background:currentColor;height:10px;width:2px;margin:auto;display:flex;align-items:center}@media screen and (-ms-high-contrast:active){.mat-sort-header-stem{width:0;border-left:solid 2px}}.mat-sort-header-indicator{width:100%;height:2px;display:flex;align-items:center;position:absolute;top:0;left:0}.mat-sort-header-pointer-middle{margin:auto;height:2px;width:2px;background:currentColor;transform:rotate(45deg)}@media screen and (-ms-high-contrast:active){.mat-sort-header-pointer-middle{width:0;height:0;border-top:solid 2px;border-left:solid 2px}}.mat-sort-header-pointer-left,.mat-sort-header-pointer-right{background:currentColor;width:6px;height:2px;position:absolute;top:0}@media screen and (-ms-high-contrast:active){.mat-sort-header-pointer-left,.mat-sort-header-pointer-right{width:0;height:0;border-left:solid 6px;border-top:solid 2px}}.mat-sort-header-pointer-left{transform-origin:right;left:0}.mat-sort-header-pointer-right{transform-origin:left;right:0}"],host:{"(click)":"_handleClick()","(mouseenter)":"_setIndicatorHintVisible(true)","(longpress)":"_setIndicatorHintVisible(true)","(mouseleave)":"_setIndicatorHintVisible(false)","[attr.aria-sort]":"_getAriaSortAttribute()","[class.mat-sort-header-disabled]":"_isDisabled()"},encapsulation:r.ViewEncapsulation.None,changeDetection:r.ChangeDetectionStrategy.OnPush,inputs:["disabled"],animations:[w.indicator,w.leftPointer,w.rightPointer,w.arrowOpacity,w.arrowPosition,w.allowChildren]}]}],i.ctorParameters=function(){return[{type:v},{type:r.ChangeDetectorRef},{type:b,decorators:[{type:r.Optional}]},{type:n.CdkColumnDef,decorators:[{type:r.Optional}]}]},i.propDecorators={id:[{type:r.Input,args:["mat-sort-header"]}],arrowPosition:[{type:r.Input}],start:[{type:r.Input}],disableClear:[{type:r.Input}]},i}(C),A=function(){function t(){}return t.decorators=[{type:r.NgModule,args:[{imports:[s.CommonModule],exports:[b,x],declarations:[b,x],providers:[S]}]}],t}();t.MatSortModule=A,t.MatSortHeaderBase=D,t._MatSortHeaderMixinBase=C,t.MatSortHeader=x,t.MAT_SORT_HEADER_INTL_PROVIDER_FACTORY=m,t.MatSortHeaderIntl=v,t.MAT_SORT_HEADER_INTL_PROVIDER=S,t.MatSortBase=g,t._MatSortMixinBase=_,t.MatSort=b,t.matSortAnimations=w,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-sort.umd.min.js.map
