/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/cdk/stepper"),require("rxjs"),require("@angular/cdk/a11y"),require("@angular/animations"),require("@angular/cdk/bidi"),require("@angular/common"),require("@angular/material/core"),require("rxjs/operators"),require("@angular/cdk/portal"),require("@angular/material/button"),require("@angular/material/icon")):"function"==typeof define&&define.amd?define("@angular/material/stepper",["exports","@angular/core","@angular/cdk/stepper","rxjs","@angular/cdk/a11y","@angular/animations","@angular/cdk/bidi","@angular/common","@angular/material/core","rxjs/operators","@angular/cdk/portal","@angular/material/button","@angular/material/icon"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.stepper={}),t.ng.core,t.ng.cdk.stepper,t.rxjs,t.ng.cdk.a11y,t.ng.animations,t.ng.cdk.bidi,t.ng.common,t.ng.material.core,t.rxjs.operators,t.ng.cdk.portal,t.ng.material.button,t.ng.material.icon)}(this,function(t,e,r,a,i,n,o,p,s,l,c,d,m){"use strict";function h(t,e){function r(){this.constructor=t}g(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}var g=function(t,e){return(g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])})(t,e)},u=r.CdkStepLabel,b=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return h(r,t),r.decorators=[{type:e.Directive,args:[{selector:"[matStepLabel]"}]}],r}(u),f=function(){function t(){this.changes=new a.Subject,this.optionalLabel="Optional"}return t.decorators=[{type:e.Injectable,args:[{providedIn:"root"}]}],t.ngInjectableDef=e.defineInjectable({factory:function(){return new t},token:t,providedIn:"root"}),t}(),v=function(){function t(t,e,r,a){this._intl=t,this._focusMonitor=e,this._element=r,e.monitor(r,!0),this._intlSubscription=t.changes.subscribe(function(){return a.markForCheck()})}return t.prototype.ngOnDestroy=function(){this._intlSubscription.unsubscribe(),this._focusMonitor.stopMonitoring(this._element)},t.prototype._stringLabel=function(){return this.label instanceof b?null:this.label},t.prototype._templateLabel=function(){return this.label instanceof b?this.label:null},t.prototype._getHostElement=function(){return this._element.nativeElement},t.prototype._getIconContext=function(){return{index:this.index,active:this.active,optional:this.optional}},t.prototype.focus=function(){this._getHostElement().focus()},t.decorators=[{type:e.Component,args:[{selector:"mat-step-header",template:'<div class="mat-step-header-ripple" mat-ripple [matRippleTrigger]="_getHostElement()"></div><div class="mat-step-icon-state-{{state}} mat-step-icon" [class.mat-step-icon-selected]="selected" [ngSwitch]="state"><ng-container *ngSwitchCase="\'number\'" [ngSwitch]="!!(iconOverrides && iconOverrides.number)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.number" [ngTemplateOutletContext]="_getIconContext()"></ng-container><span class="mat-step-icon-content" *ngSwitchDefault>{{index + 1}}</span></ng-container><ng-container *ngSwitchCase="\'edit\'" [ngSwitch]="!!(iconOverrides && iconOverrides.edit)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.edit" [ngTemplateOutletContext]="_getIconContext()"></ng-container><mat-icon class="mat-step-icon-content" *ngSwitchDefault>create</mat-icon></ng-container><ng-container *ngSwitchCase="\'done\'" [ngSwitch]="!!(iconOverrides && iconOverrides.done)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.done" [ngTemplateOutletContext]="_getIconContext()"></ng-container><mat-icon class="mat-step-icon-content" *ngSwitchDefault>done</mat-icon></ng-container><ng-container *ngSwitchCase="\'error\'" [ngSwitch]="!!(iconOverrides && iconOverrides.error)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.error" [ngTemplateOutletContext]="_getIconContext()"></ng-container><mat-icon *ngSwitchDefault>warning</mat-icon></ng-container><ng-container *ngSwitchDefault [ngSwitch]="!!(iconOverrides && iconOverrides[state])"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides[state]" [ngTemplateOutletContext]="_getIconContext()"></ng-container><mat-icon *ngSwitchDefault>{{state}}</mat-icon></ng-container></div><div class="mat-step-label" [class.mat-step-label-active]="active" [class.mat-step-label-selected]="selected" [class.mat-step-label-error]="state == \'error\'"><ng-container *ngIf="_templateLabel()" [ngTemplateOutlet]="_templateLabel()!.template"></ng-container><div class="mat-step-text-label" *ngIf="_stringLabel()">{{label}}</div><div class="mat-step-optional" *ngIf="optional && state != \'error\'">{{_intl.optionalLabel}}</div><div class="mat-step-sub-label-error" *ngIf="state == \'error\'">{{errorMessage}}</div></div>',styles:[".mat-step-header{overflow:hidden;outline:0;cursor:pointer;position:relative;box-sizing:content-box;-webkit-tap-highlight-color:transparent}.mat-step-optional,.mat-step-sub-label-error{font-size:12px}.mat-step-icon{border-radius:50%;height:24px;width:24px;flex-shrink:0;position:relative}.mat-step-icon-content{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}.mat-step-icon .mat-icon{font-size:16px;height:16px;width:16px}.mat-step-icon-state-error .mat-icon{font-size:24px;height:24px;width:24px}.mat-step-label{display:inline-block;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;min-width:50px;vertical-align:middle}.mat-step-text-label{text-overflow:ellipsis;overflow:hidden}.mat-step-header .mat-step-header-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}"],host:{class:"mat-step-header",role:"tab"},encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush}]}],t.ctorParameters=function(){return[{type:f},{type:i.FocusMonitor},{type:e.ElementRef},{type:e.ChangeDetectorRef}]},t.propDecorators={state:[{type:e.Input}],label:[{type:e.Input}],errorMessage:[{type:e.Input}],iconOverrides:[{type:e.Input}],index:[{type:e.Input}],selected:[{type:e.Input}],active:[{type:e.Input}],optional:[{type:e.Input}]},t}(),x={horizontalStepTransition:n.trigger("stepTransition",[n.state("previous",n.style({transform:"translate3d(-100%, 0, 0)",visibility:"hidden"})),n.state("current",n.style({transform:"none",visibility:"visible"})),n.state("next",n.style({transform:"translate3d(100%, 0, 0)",visibility:"hidden"})),n.transition("* => *",n.animate("500ms cubic-bezier(0.35, 0, 0.25, 1)"))]),verticalStepTransition:n.trigger("stepTransition",[n.state("previous",n.style({height:"0px",visibility:"hidden"})),n.state("next",n.style({height:"0px",visibility:"hidden"})),n.state("current",n.style({height:"*",visibility:"visible"})),n.transition("* <=> current",n.animate("225ms cubic-bezier(0.4, 0.0, 0.2, 1)"))])},y=function(){function t(t){this.templateRef=t}return t.decorators=[{type:e.Directive,args:[{selector:"ng-template[matStepperIcon]"}]}],t.ctorParameters=function(){return[{type:e.TemplateRef}]},t.propDecorators={name:[{type:e.Input,args:["matStepperIcon"]}]},t}(),S=r.CdkStepper,_=function(t){function a(e,r,a){var i=t.call(this,e,a)||this;return i._errorStateMatcher=r,i}return h(a,t),a.prototype.isErrorState=function(t,e){var r=this._errorStateMatcher.isErrorState(t,e),a=!!(t&&t.invalid&&this.interacted);return r||a},a.decorators=[{type:e.Component,args:[{selector:"mat-step",template:"<ng-template><ng-content></ng-content></ng-template>",providers:[{provide:s.ErrorStateMatcher,useExisting:a}],encapsulation:e.ViewEncapsulation.None,exportAs:"matStep",changeDetection:e.ChangeDetectionStrategy.OnPush}]}],a.ctorParameters=function(){return[{type:w,decorators:[{type:e.Inject,args:[e.forwardRef(function(){return w})]}]},{type:s.ErrorStateMatcher,decorators:[{type:e.SkipSelf}]},{type:void 0,decorators:[{type:e.Optional},{type:e.Inject,args:[r.MAT_STEPPER_GLOBAL_OPTIONS]}]}]},a.propDecorators={stepLabel:[{type:e.ContentChild,args:[b]}]},a}(r.CdkStep),w=function(t){function r(){var r=null!==t&&t.apply(this,arguments)||this;return r.animationDone=new e.EventEmitter,r._iconOverrides={},r}return h(r,t),r.prototype.ngAfterContentInit=function(){var t=this;this._icons.toArray().forEach(function(e){var r=e.name,a=e.templateRef;return t._iconOverrides[r]=a}),this._steps.changes.pipe(l.takeUntil(this._destroyed)).subscribe(function(){return t._stateChanged()})},r.prototype._animationDone=function(t){"current"===t.toState&&this.animationDone.emit()},r.decorators=[{type:e.Directive,args:[{selector:"[matStepper]"}]}],r.propDecorators={_stepHeader:[{type:e.ViewChildren,args:[v]}],_steps:[{type:e.ContentChildren,args:[_]}],_icons:[{type:e.ContentChildren,args:[y]}],animationDone:[{type:e.Output}]},r}(S),z=function(t){function r(){var e=null!==t&&t.apply(this,arguments)||this;return e.labelPosition="end",e}return h(r,t),r.decorators=[{type:e.Component,args:[{selector:"mat-horizontal-stepper",exportAs:"matHorizontalStepper",template:'<div class="mat-horizontal-stepper-header-container"><ng-container *ngFor="let step of _steps; let i = index; let isLast = last"><mat-step-header class="mat-horizontal-stepper-header" (click)="step.select()" (keydown)="_onKeydown($event)" [tabIndex]="_getFocusIndex() === i ? 0 : -1" [id]="_getStepLabelId(i)" [attr.aria-posinset]="i + 1" [attr.aria-setsize]="_steps.length" [attr.aria-controls]="_getStepContentId(i)" [attr.aria-selected]="selectedIndex == i" [attr.aria-label]="step.ariaLabel || null" [attr.aria-labelledby]="(!step.ariaLabel && step.ariaLabelledby) ? step.ariaLabelledby : null" [index]="i" [state]="_getIndicatorType(i, step.state)" [label]="step.stepLabel || step.label" [selected]="selectedIndex === i" [active]="step.completed || selectedIndex === i || !linear" [optional]="step.optional" [errorMessage]="step.errorMessage" [iconOverrides]="_iconOverrides"></mat-step-header><div *ngIf="!isLast" class="mat-stepper-horizontal-line"></div></ng-container></div><div class="mat-horizontal-content-container"><div *ngFor="let step of _steps; let i = index" class="mat-horizontal-stepper-content" role="tabpanel" [@stepTransition]="_getAnimationDirection(i)" (@stepTransition.done)="_animationDone($event)" [id]="_getStepContentId(i)" [attr.aria-labelledby]="_getStepLabelId(i)" [attr.aria-expanded]="selectedIndex === i"><ng-container [ngTemplateOutlet]="step.content"></ng-container></div></div>',styles:[".mat-stepper-horizontal,.mat-stepper-vertical{display:block}.mat-horizontal-stepper-header-container{white-space:nowrap;display:flex;align-items:center}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header-container{align-items:flex-start}.mat-stepper-horizontal-line{border-top-width:1px;border-top-style:solid;flex:auto;height:0;margin:0 -16px;min-width:32px}.mat-stepper-label-position-bottom .mat-stepper-horizontal-line{margin:0;min-width:0;position:relative;top:36px}[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::before,[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::after,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::after,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::before{border-top-color:rgba(0,0,0,.12);border-top-width:1px;border-top-style:solid;content:'';display:inline-block;height:0;position:absolute;top:36px;width:calc(50% - 20px)}.mat-horizontal-stepper-header{display:flex;height:72px;overflow:hidden;align-items:center;padding:0 24px}.mat-horizontal-stepper-header .mat-step-icon{margin-right:8px;flex:none}[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon{margin-right:0;margin-left:8px}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header{box-sizing:border-box;flex-direction:column;height:auto;padding:24px}[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::after,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::after{right:0}[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::before,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::before{left:0}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header .mat-step-icon,.mat-stepper-label-position-bottom .mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:0}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header .mat-step-label{padding:16px 0 0 0;text-align:center;width:100%}.mat-vertical-stepper-header{display:flex;align-items:center;padding:24px;height:24px}.mat-vertical-stepper-header .mat-step-icon{margin-right:12px}[dir=rtl] .mat-vertical-stepper-header .mat-step-icon{margin-right:0;margin-left:12px}.mat-horizontal-stepper-content[aria-expanded=false]{height:0;overflow:hidden}.mat-horizontal-content-container{overflow:hidden;padding:0 24px 24px 24px}.mat-vertical-content-container{margin-left:36px;border:0;position:relative}[dir=rtl] .mat-vertical-content-container{margin-left:0;margin-right:36px}.mat-stepper-vertical-line::before{content:'';position:absolute;top:-16px;bottom:-16px;left:0;border-left-width:1px;border-left-style:solid}[dir=rtl] .mat-stepper-vertical-line::before{left:auto;right:0}.mat-vertical-stepper-content{overflow:hidden}.mat-vertical-content{padding:0 24px 24px 24px}.mat-step:last-child .mat-vertical-content-container{border:none}"],inputs:["selectedIndex"],host:{class:"mat-stepper-horizontal","[class.mat-stepper-label-position-end]":'labelPosition == "end"',"[class.mat-stepper-label-position-bottom]":'labelPosition == "bottom"',"aria-orientation":"horizontal",role:"tablist"},animations:[x.horizontalStepTransition],providers:[{provide:w,useExisting:r}],encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush}]}],r.propDecorators={labelPosition:[{type:e.Input}]},r}(w),C=function(t){function r(e,r,a,i){var n=t.call(this,e,r,a,i)||this;return n._orientation="vertical",n}return h(r,t),r.decorators=[{type:e.Component,args:[{selector:"mat-vertical-stepper",exportAs:"matVerticalStepper",template:'<div class="mat-step" *ngFor="let step of _steps; let i = index; let isLast = last"><mat-step-header class="mat-vertical-stepper-header" (click)="step.select()" (keydown)="_onKeydown($event)" [tabIndex]="_getFocusIndex() == i ? 0 : -1" [id]="_getStepLabelId(i)" [attr.aria-posinset]="i + 1" [attr.aria-setsize]="_steps.length" [attr.aria-controls]="_getStepContentId(i)" [attr.aria-selected]="selectedIndex === i" [attr.aria-label]="step.ariaLabel || null" [attr.aria-labelledby]="(!step.ariaLabel && step.ariaLabelledby) ? step.ariaLabelledby : null" [index]="i" [state]="_getIndicatorType(i, step.state)" [label]="step.stepLabel || step.label" [selected]="selectedIndex === i" [active]="step.completed || selectedIndex === i || !linear" [optional]="step.optional" [errorMessage]="step.errorMessage" [iconOverrides]="_iconOverrides"></mat-step-header><div class="mat-vertical-content-container" [class.mat-stepper-vertical-line]="!isLast"><div class="mat-vertical-stepper-content" role="tabpanel" [@stepTransition]="_getAnimationDirection(i)" (@stepTransition.done)="_animationDone($event)" [id]="_getStepContentId(i)" [attr.aria-labelledby]="_getStepLabelId(i)" [attr.aria-expanded]="selectedIndex === i"><div class="mat-vertical-content"><ng-container [ngTemplateOutlet]="step.content"></ng-container></div></div></div></div>',styles:[".mat-stepper-horizontal,.mat-stepper-vertical{display:block}.mat-horizontal-stepper-header-container{white-space:nowrap;display:flex;align-items:center}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header-container{align-items:flex-start}.mat-stepper-horizontal-line{border-top-width:1px;border-top-style:solid;flex:auto;height:0;margin:0 -16px;min-width:32px}.mat-stepper-label-position-bottom .mat-stepper-horizontal-line{margin:0;min-width:0;position:relative;top:36px}[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::before,[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::after,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::after,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::before{border-top-color:rgba(0,0,0,.12);border-top-width:1px;border-top-style:solid;content:'';display:inline-block;height:0;position:absolute;top:36px;width:calc(50% - 20px)}.mat-horizontal-stepper-header{display:flex;height:72px;overflow:hidden;align-items:center;padding:0 24px}.mat-horizontal-stepper-header .mat-step-icon{margin-right:8px;flex:none}[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon{margin-right:0;margin-left:8px}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header{box-sizing:border-box;flex-direction:column;height:auto;padding:24px}[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::after,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::after{right:0}[dir=ltr] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:first-child)::before,[dir=rtl] .mat-stepper-label-position-bottom .mat-horizontal-stepper-header:not(:last-child)::before{left:0}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header .mat-step-icon,.mat-stepper-label-position-bottom .mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:0}.mat-stepper-label-position-bottom .mat-horizontal-stepper-header .mat-step-label{padding:16px 0 0 0;text-align:center;width:100%}.mat-vertical-stepper-header{display:flex;align-items:center;padding:24px;height:24px}.mat-vertical-stepper-header .mat-step-icon{margin-right:12px}[dir=rtl] .mat-vertical-stepper-header .mat-step-icon{margin-right:0;margin-left:12px}.mat-horizontal-stepper-content[aria-expanded=false]{height:0;overflow:hidden}.mat-horizontal-content-container{overflow:hidden;padding:0 24px 24px 24px}.mat-vertical-content-container{margin-left:36px;border:0;position:relative}[dir=rtl] .mat-vertical-content-container{margin-left:0;margin-right:36px}.mat-stepper-vertical-line::before{content:'';position:absolute;top:-16px;bottom:-16px;left:0;border-left-width:1px;border-left-style:solid}[dir=rtl] .mat-stepper-vertical-line::before{left:auto;right:0}.mat-vertical-stepper-content{overflow:hidden}.mat-vertical-content{padding:0 24px 24px 24px}.mat-step:last-child .mat-vertical-content-container{border:none}"],inputs:["selectedIndex"],host:{class:"mat-stepper-vertical","aria-orientation":"vertical",role:"tablist"},animations:[x.verticalStepTransition],providers:[{provide:w,useExisting:r}],encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush}]}],r.ctorParameters=function(){return[{type:o.Directionality,decorators:[{type:e.Optional}]},{type:e.ChangeDetectorRef},{type:e.ElementRef},{type:void 0,decorators:[{type:e.Inject,args:[p.DOCUMENT]}]}]},r}(w),I=r.CdkStepperNext,O=r.CdkStepperPrevious,M=function(t){function a(){return null!==t&&t.apply(this,arguments)||this}return h(a,t),a.decorators=[{type:e.Directive,args:[{selector:"button[matStepperNext]",host:{"(click)":"_stepper.next()","[type]":"type"},inputs:["type"],providers:[{provide:r.CdkStepper,useExisting:w}]}]}],a}(I),k=function(t){function a(){return null!==t&&t.apply(this,arguments)||this}return h(a,t),a.decorators=[{type:e.Directive,args:[{selector:"button[matStepperPrevious]",host:{"(click)":"_stepper.previous()","[type]":"type"},inputs:["type"],providers:[{provide:r.CdkStepper,useExisting:w}]}]}],a}(O),D=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{imports:[s.MatCommonModule,p.CommonModule,c.PortalModule,d.MatButtonModule,r.CdkStepperModule,m.MatIconModule,s.MatRippleModule],exports:[s.MatCommonModule,z,C,_,b,w,M,k,v,y],declarations:[z,C,_,b,w,M,k,v,y],providers:[f,s.ErrorStateMatcher]}]}],t}();t.MatStepperModule=D,t._CdkStepLabel=u,t.MatStepLabel=b,t._CdkStepper=S,t.MatStep=_,t.MatStepper=w,t.MatHorizontalStepper=z,t.MatVerticalStepper=C,t._CdkStepperNext=I,t._CdkStepperPrevious=O,t.MatStepperNext=M,t.MatStepperPrevious=k,t.MatStepHeader=v,t.MatStepperIntl=f,t.matStepperAnimations=x,t.MatStepperIcon=y,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-stepper.umd.min.js.map
