/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/cdk/portal"),require("@angular/material/core"),require("rxjs"),require("@angular/animations"),require("@angular/cdk/bidi"),require("rxjs/operators"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/cdk/scrolling"),require("@angular/cdk/a11y"),require("@angular/cdk/platform"),require("@angular/cdk/observers"),require("@angular/common")):"function"==typeof define&&define.amd?define("@angular/material/tabs",["exports","@angular/core","@angular/cdk/portal","@angular/material/core","rxjs","@angular/animations","@angular/cdk/bidi","rxjs/operators","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/cdk/scrolling","@angular/cdk/a11y","@angular/cdk/platform","@angular/cdk/observers","@angular/common"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.tabs={}),t.ng.core,t.ng.cdk.portal,t.ng.material.core,t.rxjs,t.ng.animations,t.ng.cdk.bidi,t.rxjs.operators,t.ng.cdk.coercion,t.ng.cdk.keycodes,t.ng.cdk.scrolling,t.ng.cdk.a11y,t.ng.cdk.platform,t.ng.cdk.observers,t.ng.common)}(this,function(t,e,a,n,i,r,o,s,l,c,p,d,b,h,u){"use strict";function g(t,e){function a(){this.constructor=t}f(t,e),t.prototype=null===e?Object.create(e):(a.prototype=e.prototype,new a)}function m(){return function(t){return{left:t?(t.offsetLeft||0)+"px":"0",width:t?(t.offsetWidth||0)+"px":"0"}}}var f=function(t,e){return(f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var a in e)e.hasOwnProperty(a)&&(t[a]=e[a])})(t,e)},_=new e.InjectionToken("MatInkBarPositioner",{providedIn:"root",factory:m}),y=function(){function t(t,e,a){this._elementRef=t,this._ngZone=e,this._inkBarPositioner=a}return t.prototype.alignToElement=function(t){var e=this;this.show(),"undefined"!=typeof requestAnimationFrame?this._ngZone.runOutsideAngular(function(){requestAnimationFrame(function(){return e._setStyles(t)})}):this._setStyles(t)},t.prototype.show=function(){this._elementRef.nativeElement.style.visibility="visible"},t.prototype.hide=function(){this._elementRef.nativeElement.style.visibility="hidden"},t.prototype._setStyles=function(t){var e=this._inkBarPositioner(t),a=this._elementRef.nativeElement;a.style.left=e.left,a.style.width=e.width},t.decorators=[{type:e.Directive,args:[{selector:"mat-ink-bar",host:{class:"mat-ink-bar"}}]}],t.ctorParameters=function(){return[{type:e.ElementRef},{type:e.NgZone},{type:void 0,decorators:[{type:e.Inject,args:[_]}]}]},t}(),v=function(){function t(t){this.template=t}return t.decorators=[{type:e.Directive,args:[{selector:"[matTabContent]"}]}],t.ctorParameters=function(){return[{type:e.TemplateRef}]},t}(),x=a.CdkPortal,k=function(t){function a(){return null!==t&&t.apply(this,arguments)||this}return g(a,t),a.decorators=[{type:e.Directive,args:[{selector:"[mat-tab-label], [matTabLabel]"}]}],a}(x),C=function(){function t(){}return t}(),I=n.mixinDisabled(C),w=function(t){function n(e){var a=t.call(this)||this;return a._viewContainerRef=e,a.textLabel="",a._contentPortal=null,a._stateChanges=new i.Subject,a.position=null,a.origin=null,a.isActive=!1,a}return g(n,t),Object.defineProperty(n.prototype,"content",{get:function(){return this._contentPortal},enumerable:!0,configurable:!0}),n.prototype.ngOnChanges=function(t){(t.hasOwnProperty("textLabel")||t.hasOwnProperty("disabled"))&&this._stateChanges.next()},n.prototype.ngOnDestroy=function(){this._stateChanges.complete()},n.prototype.ngOnInit=function(){this._contentPortal=new a.TemplatePortal(this._explicitContent||this._implicitContent,this._viewContainerRef)},n.decorators=[{type:e.Component,args:[{selector:"mat-tab",template:"<ng-template><ng-content></ng-content></ng-template>",inputs:["disabled"],changeDetection:e.ChangeDetectionStrategy.OnPush,encapsulation:e.ViewEncapsulation.None,exportAs:"matTab"}]}],n.ctorParameters=function(){return[{type:e.ViewContainerRef}]},n.propDecorators={templateLabel:[{type:e.ContentChild,args:[k]}],_explicitContent:[{type:e.ContentChild,args:[v,{read:e.TemplateRef}]}],_implicitContent:[{type:e.ViewChild,args:[e.TemplateRef]}],textLabel:[{type:e.Input,args:["label"]}],ariaLabel:[{type:e.Input,args:["aria-label"]}],ariaLabelledby:[{type:e.Input,args:["aria-labelledby"]}]},n}(I),T={translateTab:r.trigger("translateTab",[r.state("center, void, left-origin-center, right-origin-center",r.style({transform:"none"})),r.state("left",r.style({transform:"translate3d(-100%, 0, 0)",minHeight:"1px"})),r.state("right",r.style({transform:"translate3d(100%, 0, 0)",minHeight:"1px"})),r.transition("* => left, * => right, left => center, right => center",r.animate("500ms cubic-bezier(0.35, 0, 0.25, 1)")),r.transition("void => left-origin-center",[r.style({transform:"translate3d(-100%, 0, 0)"}),r.animate("500ms cubic-bezier(0.35, 0, 0.25, 1)")]),r.transition("void => right-origin-center",[r.style({transform:"translate3d(100%, 0, 0)"}),r.animate("500ms cubic-bezier(0.35, 0, 0.25, 1)")])])},D=function(t){function a(e,a,n){var r=t.call(this,e,a)||this;return r._host=n,r._centeringSub=i.Subscription.EMPTY,r._leavingSub=i.Subscription.EMPTY,r}return g(a,t),a.prototype.ngOnInit=function(){var e=this;t.prototype.ngOnInit.call(this),this._centeringSub=this._host._beforeCentering.pipe(s.startWith(this._host._isCenterPosition(this._host._position))).subscribe(function(t){t&&!e.hasAttached()&&e.attach(e._host._content)}),this._leavingSub=this._host._afterLeavingCenter.subscribe(function(){e.detach()})},a.prototype.ngOnDestroy=function(){t.prototype.ngOnDestroy.call(this),this._centeringSub.unsubscribe(),this._leavingSub.unsubscribe()},a.decorators=[{type:e.Directive,args:[{selector:"[matTabBodyHost]"}]}],a.ctorParameters=function(){return[{type:e.ComponentFactoryResolver},{type:e.ViewContainerRef},{type:L,decorators:[{type:e.Inject,args:[e.forwardRef(function(){return L})]}]}]},a}(a.CdkPortalOutlet),L=function(){function t(t,a,n){var r=this;this._elementRef=t,this._dir=a,this._dirChangeSubscription=i.Subscription.EMPTY,this._onCentering=new e.EventEmitter,this._beforeCentering=new e.EventEmitter,this._afterLeavingCenter=new e.EventEmitter,this._onCentered=new e.EventEmitter(!0),this._dir&&n&&(this._dirChangeSubscription=this._dir.change.subscribe(function(t){r._computePositionAnimationState(t),n.markForCheck()}))}return Object.defineProperty(t.prototype,"position",{set:function(t){this._positionIndex=t,this._computePositionAnimationState()},enumerable:!0,configurable:!0}),t.prototype.ngOnInit=function(){"center"==this._position&&null!=this.origin&&(this._position=this._computePositionFromOrigin())},t.prototype.ngOnDestroy=function(){this._dirChangeSubscription.unsubscribe()},t.prototype._onTranslateTabStarted=function(t){var e=this._isCenterPosition(t.toState);this._beforeCentering.emit(e),e&&this._onCentering.emit(this._elementRef.nativeElement.clientHeight)},t.prototype._onTranslateTabComplete=function(t){this._isCenterPosition(t.toState)&&this._isCenterPosition(this._position)&&this._onCentered.emit(),this._isCenterPosition(t.fromState)&&!this._isCenterPosition(this._position)&&this._afterLeavingCenter.emit()},t.prototype._getLayoutDirection=function(){return this._dir&&"rtl"===this._dir.value?"rtl":"ltr"},t.prototype._isCenterPosition=function(t){return"center"==t||"left-origin-center"==t||"right-origin-center"==t},t.prototype._computePositionAnimationState=function(t){void 0===t&&(t=this._getLayoutDirection()),this._positionIndex<0?this._position="ltr"==t?"left":"right":this._positionIndex>0?this._position="ltr"==t?"right":"left":this._position="center"},t.prototype._computePositionFromOrigin=function(){var t=this._getLayoutDirection();return"ltr"==t&&this.origin<=0||"rtl"==t&&this.origin>0?"left-origin-center":"right-origin-center"},t.decorators=[{type:e.Component,args:[{selector:"mat-tab-body",template:'<div class="mat-tab-body-content" #content [@translateTab]="_position" (@translateTab.start)="_onTranslateTabStarted($event)" (@translateTab.done)="_onTranslateTabComplete($event)"><ng-template matTabBodyHost></ng-template></div>',styles:[".mat-tab-body-content{height:100%;overflow:auto}.mat-tab-group-dynamic-height .mat-tab-body-content{overflow:hidden}"],encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush,animations:[T.translateTab],host:{class:"mat-tab-body"}}]}],t.ctorParameters=function(){return[{type:e.ElementRef},{type:o.Directionality,decorators:[{type:e.Optional}]},{type:e.ChangeDetectorRef}]},t.propDecorators={_onCentering:[{type:e.Output}],_beforeCentering:[{type:e.Output}],_afterLeavingCenter:[{type:e.Output}],_onCentered:[{type:e.Output}],_portalHost:[{type:e.ViewChild,args:[a.PortalHostDirective]}],_content:[{type:e.Input,args:["content"]}],origin:[{type:e.Input}],position:[{type:e.Input}]},t}(),P=function(){function t(){}return t}(),R=n.mixinDisabled(P),E=function(t){function a(e){var a=t.call(this)||this;return a.elementRef=e,a}return g(a,t),a.prototype.focus=function(){this.elementRef.nativeElement.focus()},a.prototype.getOffsetLeft=function(){return this.elementRef.nativeElement.offsetLeft},a.prototype.getOffsetWidth=function(){return this.elementRef.nativeElement.offsetWidth},a.decorators=[{type:e.Directive,args:[{selector:"[matTabLabelWrapper]",inputs:["disabled"],host:{"[class.mat-tab-disabled]":"disabled","[attr.aria-disabled]":"!!disabled"}}]}],a.ctorParameters=function(){return[{type:e.ElementRef}]},a}(R),O=function(){function t(){}return t}(),S=n.mixinDisableRipple(O),M=function(t){function a(a,n,r,o,s){var l=t.call(this)||this;return l._elementRef=a,l._changeDetectorRef=n,l._viewportRuler=r,l._dir=o,l._ngZone=s,l._scrollDistance=0,l._selectedIndexChanged=!1,l._destroyed=new i.Subject,l._showPaginationControls=!1,l._disableScrollAfter=!0,l._disableScrollBefore=!0,l._selectedIndex=0,l.selectFocusedIndex=new e.EventEmitter,l.indexFocused=new e.EventEmitter,l}return g(a,t),Object.defineProperty(a.prototype,"selectedIndex",{get:function(){return this._selectedIndex},set:function(t){t=l.coerceNumberProperty(t),this._selectedIndexChanged=this._selectedIndex!=t,this._selectedIndex=t,this._keyManager&&this._keyManager.updateActiveItemIndex(t)},enumerable:!0,configurable:!0}),a.prototype.ngAfterContentChecked=function(){this._tabLabelCount!=this._labelWrappers.length&&(this._updatePagination(),this._tabLabelCount=this._labelWrappers.length,this._changeDetectorRef.markForCheck()),this._selectedIndexChanged&&(this._scrollToLabel(this._selectedIndex),this._checkScrollingControls(),this._alignInkBarToSelectedTab(),this._selectedIndexChanged=!1,this._changeDetectorRef.markForCheck()),this._scrollDistanceChanged&&(this._updateTabScrollPosition(),this._scrollDistanceChanged=!1,this._changeDetectorRef.markForCheck())},a.prototype._handleKeydown=function(t){switch(t.keyCode){case c.HOME:this._keyManager.setFirstItemActive(),t.preventDefault();break;case c.END:this._keyManager.setLastItemActive(),t.preventDefault();break;case c.ENTER:case c.SPACE:this.selectFocusedIndex.emit(this.focusIndex),t.preventDefault();break;default:this._keyManager.onKeydown(t)}},a.prototype.ngAfterContentInit=function(){var t=this,e=this._dir?this._dir.change:i.of(null),a=this._viewportRuler.change(150),n=function(){t._updatePagination(),t._alignInkBarToSelectedTab()};this._keyManager=new d.FocusKeyManager(this._labelWrappers).withHorizontalOrientation(this._getLayoutDirection()).withWrap(),this._keyManager.updateActiveItem(0),"undefined"!=typeof requestAnimationFrame?requestAnimationFrame(n):n(),i.merge(e,a).pipe(s.takeUntil(this._destroyed)).subscribe(function(){n(),t._keyManager.withHorizontalOrientation(t._getLayoutDirection())}),this._keyManager.change.pipe(s.takeUntil(this._destroyed)).subscribe(function(e){t.indexFocused.emit(e),t._setTabFocus(e)})},a.prototype.ngOnDestroy=function(){this._destroyed.next(),this._destroyed.complete()},a.prototype._onContentChanges=function(){var t=this,e=function(){t._updatePagination(),t._alignInkBarToSelectedTab(),t._changeDetectorRef.markForCheck()};this._ngZone?this._ngZone.run(e):e()},a.prototype._updatePagination=function(){this._checkPaginationEnabled(),this._checkScrollingControls(),this._updateTabScrollPosition()},Object.defineProperty(a.prototype,"focusIndex",{get:function(){return this._keyManager?this._keyManager.activeItemIndex:0},set:function(t){this._isValidIndex(t)&&this.focusIndex!==t&&this._keyManager&&this._keyManager.setActiveItem(t)},enumerable:!0,configurable:!0}),a.prototype._isValidIndex=function(t){if(!this._labelWrappers)return!0;var e=this._labelWrappers?this._labelWrappers.toArray()[t]:null;return!!e&&!e.disabled},a.prototype._setTabFocus=function(t){if(this._showPaginationControls&&this._scrollToLabel(t),this._labelWrappers&&this._labelWrappers.length){this._labelWrappers.toArray()[t].focus();var e=this._tabListContainer.nativeElement,a=this._getLayoutDirection();e.scrollLeft="ltr"==a?0:e.scrollWidth-e.offsetWidth}},a.prototype._getLayoutDirection=function(){return this._dir&&"rtl"===this._dir.value?"rtl":"ltr"},a.prototype._updateTabScrollPosition=function(){var t=this.scrollDistance,e="ltr"===this._getLayoutDirection()?-t:t;this._tabList.nativeElement.style.transform="translateX("+e+"px)"},Object.defineProperty(a.prototype,"scrollDistance",{get:function(){return this._scrollDistance},set:function(t){this._scrollDistance=Math.max(0,Math.min(this._getMaxScrollDistance(),t)),this._scrollDistanceChanged=!0,this._checkScrollingControls()},enumerable:!0,configurable:!0}),a.prototype._scrollHeader=function(t){var e=this._tabListContainer.nativeElement.offsetWidth;this.scrollDistance+=("before"==t?-1:1)*e/3},a.prototype._scrollToLabel=function(t){var e=this._labelWrappers?this._labelWrappers.toArray()[t]:null;if(e){var a,n,i=this._tabListContainer.nativeElement.offsetWidth;"ltr"==this._getLayoutDirection()?(a=e.getOffsetLeft(),n=a+e.getOffsetWidth()):(n=this._tabList.nativeElement.offsetWidth-e.getOffsetLeft(),a=n-e.getOffsetWidth());var r=this.scrollDistance,o=this.scrollDistance+i;a<r?this.scrollDistance-=r-a+60:n>o&&(this.scrollDistance+=n-o+60)}},a.prototype._checkPaginationEnabled=function(){var t=this._tabList.nativeElement.scrollWidth>this._elementRef.nativeElement.offsetWidth;t||(this.scrollDistance=0),t!==this._showPaginationControls&&this._changeDetectorRef.markForCheck(),this._showPaginationControls=t},a.prototype._checkScrollingControls=function(){this._disableScrollBefore=0==this.scrollDistance,this._disableScrollAfter=this.scrollDistance==this._getMaxScrollDistance(),this._changeDetectorRef.markForCheck()},a.prototype._getMaxScrollDistance=function(){return this._tabList.nativeElement.scrollWidth-this._tabListContainer.nativeElement.offsetWidth||0},a.prototype._alignInkBarToSelectedTab=function(){var t=this._labelWrappers&&this._labelWrappers.length?this._labelWrappers.toArray()[this.selectedIndex].elementRef.nativeElement:null;this._inkBar.alignToElement(t)},a.decorators=[{type:e.Component,args:[{selector:"mat-tab-header",template:'<div class="mat-tab-header-pagination mat-tab-header-pagination-before mat-elevation-z4" aria-hidden="true" mat-ripple [matRippleDisabled]="_disableScrollBefore || disableRipple" [class.mat-tab-header-pagination-disabled]="_disableScrollBefore" (click)="_scrollHeader(\'before\')"><div class="mat-tab-header-pagination-chevron"></div></div><div class="mat-tab-label-container" #tabListContainer (keydown)="_handleKeydown($event)"><div class="mat-tab-list" #tabList role="tablist" (cdkObserveContent)="_onContentChanges()"><div class="mat-tab-labels"><ng-content></ng-content></div><mat-ink-bar></mat-ink-bar></div></div><div class="mat-tab-header-pagination mat-tab-header-pagination-after mat-elevation-z4" aria-hidden="true" mat-ripple [matRippleDisabled]="_disableScrollAfter || disableRipple" [class.mat-tab-header-pagination-disabled]="_disableScrollAfter" (click)="_scrollHeader(\'after\')"><div class="mat-tab-header-pagination-chevron"></div></div>',styles:[".mat-tab-header{display:flex;overflow:hidden;position:relative;flex-shrink:0}.mat-tab-label{height:48px;padding:0 24px;cursor:pointer;box-sizing:border-box;opacity:.6;min-width:160px;text-align:center;display:inline-flex;justify-content:center;align-items:center;white-space:nowrap;position:relative}.mat-tab-label:focus{outline:0}.mat-tab-label:focus:not(.mat-tab-disabled){opacity:1}@media screen and (-ms-high-contrast:active){.mat-tab-label:focus{outline:dotted 2px}}.mat-tab-label.mat-tab-disabled{cursor:default}@media screen and (-ms-high-contrast:active){.mat-tab-label.mat-tab-disabled{opacity:.5}}.mat-tab-label .mat-tab-label-content{display:inline-flex;justify-content:center;align-items:center;white-space:nowrap}@media screen and (-ms-high-contrast:active){.mat-tab-label{opacity:1}}@media (max-width:599px){.mat-tab-label{min-width:72px}}.mat-ink-bar{position:absolute;bottom:0;height:2px;transition:.5s cubic-bezier(.35,0,.25,1)}.mat-tab-group-inverted-header .mat-ink-bar{bottom:auto;top:0}@media screen and (-ms-high-contrast:active){.mat-ink-bar{outline:solid 2px;height:0}}.mat-tab-header-pagination{position:relative;display:none;justify-content:center;align-items:center;min-width:32px;cursor:pointer;z-index:2}.mat-tab-header-pagination-controls-enabled .mat-tab-header-pagination{display:flex}.mat-tab-header-pagination-before,.mat-tab-header-rtl .mat-tab-header-pagination-after{padding-left:4px}.mat-tab-header-pagination-before .mat-tab-header-pagination-chevron,.mat-tab-header-rtl .mat-tab-header-pagination-after .mat-tab-header-pagination-chevron{transform:rotate(-135deg)}.mat-tab-header-pagination-after,.mat-tab-header-rtl .mat-tab-header-pagination-before{padding-right:4px}.mat-tab-header-pagination-after .mat-tab-header-pagination-chevron,.mat-tab-header-rtl .mat-tab-header-pagination-before .mat-tab-header-pagination-chevron{transform:rotate(45deg)}.mat-tab-header-pagination-chevron{border-style:solid;border-width:2px 2px 0 0;content:'';height:8px;width:8px}.mat-tab-header-pagination-disabled{box-shadow:none;cursor:default}.mat-tab-label-container{display:flex;flex-grow:1;overflow:hidden;z-index:1}.mat-tab-list{flex-grow:1;position:relative;transition:transform .5s cubic-bezier(.35,0,.25,1)}.mat-tab-labels{display:flex}[mat-align-tabs=center] .mat-tab-labels{justify-content:center}[mat-align-tabs=end] .mat-tab-labels{justify-content:flex-end}"],inputs:["disableRipple"],encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush,host:{class:"mat-tab-header","[class.mat-tab-header-pagination-controls-enabled]":"_showPaginationControls","[class.mat-tab-header-rtl]":"_getLayoutDirection() == 'rtl'"}}]}],a.ctorParameters=function(){return[{type:e.ElementRef},{type:e.ChangeDetectorRef},{type:p.ViewportRuler},{type:o.Directionality,decorators:[{type:e.Optional}]},{type:e.NgZone}]},a.propDecorators={_labelWrappers:[{type:e.ContentChildren,args:[E]}],_inkBar:[{type:e.ViewChild,args:[y]}],_tabListContainer:[{type:e.ViewChild,args:["tabListContainer"]}],_tabList:[{type:e.ViewChild,args:["tabList"]}],selectedIndex:[{type:e.Input}],selectFocusedIndex:[{type:e.Output}],indexFocused:[{type:e.Output}]},a}(S),A=0,B=function(){function t(){}return t}(),W=function(){function t(t){this._elementRef=t}return t}(),j=n.mixinColor(n.mixinDisableRipple(W),"primary"),H=function(t){function a(a,n){var r=t.call(this,a)||this;return r._changeDetectorRef=n,r._indexToSelect=0,r._tabBodyWrapperHeight=0,r._tabsSubscription=i.Subscription.EMPTY,r._tabLabelSubscription=i.Subscription.EMPTY,r._dynamicHeight=!1,r._selectedIndex=null,r.headerPosition="above",r.selectedIndexChange=new e.EventEmitter,r.focusChange=new e.EventEmitter,r.animationDone=new e.EventEmitter,r.selectedTabChange=new e.EventEmitter(!0),r._groupId=A++,r}return g(a,t),Object.defineProperty(a.prototype,"dynamicHeight",{get:function(){return this._dynamicHeight},set:function(t){this._dynamicHeight=l.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"selectedIndex",{get:function(){return this._selectedIndex},set:function(t){this._indexToSelect=l.coerceNumberProperty(t,null)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"backgroundColor",{get:function(){return this._backgroundColor},set:function(t){var e=this._elementRef.nativeElement;e.classList.remove("mat-background-"+this.backgroundColor),t&&e.classList.add("mat-background-"+t),this._backgroundColor=t},enumerable:!0,configurable:!0}),a.prototype.ngAfterContentChecked=function(){var t=this,e=this._indexToSelect=this._clampTabIndex(this._indexToSelect);if(this._selectedIndex!=e){var a=null==this._selectedIndex;a||this.selectedTabChange.emit(this._createChangeEvent(e)),Promise.resolve().then(function(){t._tabs.forEach(function(t,a){return t.isActive=a===e}),a||t.selectedIndexChange.emit(e)})}this._tabs.forEach(function(a,n){a.position=n-e,null==t._selectedIndex||0!=a.position||a.origin||(a.origin=e-t._selectedIndex)}),this._selectedIndex!==e&&(this._selectedIndex=e,this._changeDetectorRef.markForCheck())},a.prototype.ngAfterContentInit=function(){var t=this;this._subscribeToTabLabels(),this._tabsSubscription=this._tabs.changes.subscribe(function(){if(t._clampTabIndex(t._indexToSelect)===t._selectedIndex)for(var e=t._tabs.toArray(),a=0;a<e.length;a++)if(e[a].isActive){t._indexToSelect=t._selectedIndex=a;break}t._subscribeToTabLabels(),t._changeDetectorRef.markForCheck()})},a.prototype.ngOnDestroy=function(){this._tabsSubscription.unsubscribe(),this._tabLabelSubscription.unsubscribe()},a.prototype.realignInkBar=function(){this._tabHeader&&this._tabHeader._alignInkBarToSelectedTab()},a.prototype._focusChanged=function(t){this.focusChange.emit(this._createChangeEvent(t))},a.prototype._createChangeEvent=function(t){var e=new B;return e.index=t,this._tabs&&this._tabs.length&&(e.tab=this._tabs.toArray()[t]),e},a.prototype._subscribeToTabLabels=function(){var t=this;this._tabLabelSubscription&&this._tabLabelSubscription.unsubscribe(),this._tabLabelSubscription=i.merge.apply(void 0,this._tabs.map(function(t){return t._stateChanges})).subscribe(function(){return t._changeDetectorRef.markForCheck()})},a.prototype._clampTabIndex=function(t){return Math.min(this._tabs.length-1,Math.max(t||0,0))},a.prototype._getTabLabelId=function(t){return"mat-tab-label-"+this._groupId+"-"+t},a.prototype._getTabContentId=function(t){return"mat-tab-content-"+this._groupId+"-"+t},a.prototype._setTabBodyWrapperHeight=function(t){if(this._dynamicHeight&&this._tabBodyWrapperHeight){var e=this._tabBodyWrapper.nativeElement;e.style.height=this._tabBodyWrapperHeight+"px",this._tabBodyWrapper.nativeElement.offsetHeight&&(e.style.height=t+"px")}},a.prototype._removeTabBodyWrapperHeight=function(){this._tabBodyWrapperHeight=this._tabBodyWrapper.nativeElement.clientHeight,this._tabBodyWrapper.nativeElement.style.height="",this.animationDone.emit()},a.prototype._handleClick=function(t,e,a){t.disabled||(this.selectedIndex=e.focusIndex=a)},a.prototype._getTabIndex=function(t,e){return t.disabled?null:this.selectedIndex===e?0:-1},a.decorators=[{type:e.Component,args:[{selector:"mat-tab-group",exportAs:"matTabGroup",template:'<mat-tab-header #tabHeader [selectedIndex]="selectedIndex" [disableRipple]="disableRipple" (indexFocused)="_focusChanged($event)" (selectFocusedIndex)="selectedIndex = $event"><div class="mat-tab-label" role="tab" matTabLabelWrapper mat-ripple cdkMonitorElementFocus *ngFor="let tab of _tabs; let i = index" [id]="_getTabLabelId(i)" [attr.tabIndex]="_getTabIndex(tab, i)" [attr.aria-posinset]="i + 1" [attr.aria-setsize]="_tabs.length" [attr.aria-controls]="_getTabContentId(i)" [attr.aria-selected]="selectedIndex == i" [attr.aria-label]="tab.ariaLabel || null" [attr.aria-labelledby]="(!tab.ariaLabel && tab.ariaLabelledby) ? tab.ariaLabelledby : null" [class.mat-tab-label-active]="selectedIndex == i" [disabled]="tab.disabled" [matRippleDisabled]="tab.disabled || disableRipple" (click)="_handleClick(tab, tabHeader, i)"><div class="mat-tab-label-content"><ng-template [ngIf]="tab.templateLabel"><ng-template [cdkPortalOutlet]="tab.templateLabel"></ng-template></ng-template><ng-template [ngIf]="!tab.templateLabel">{{tab.textLabel}}</ng-template></div></div></mat-tab-header><div class="mat-tab-body-wrapper" #tabBodyWrapper><mat-tab-body role="tabpanel" *ngFor="let tab of _tabs; let i = index" [id]="_getTabContentId(i)" [attr.aria-labelledby]="_getTabLabelId(i)" [class.mat-tab-body-active]="selectedIndex == i" [content]="tab.content" [position]="tab.position" [origin]="tab.origin" (_onCentered)="_removeTabBodyWrapperHeight()" (_onCentering)="_setTabBodyWrapperHeight($event)"></mat-tab-body></div>',styles:[".mat-tab-group{display:flex;flex-direction:column}.mat-tab-group.mat-tab-group-inverted-header{flex-direction:column-reverse}.mat-tab-label{height:48px;padding:0 24px;cursor:pointer;box-sizing:border-box;opacity:.6;min-width:160px;text-align:center;display:inline-flex;justify-content:center;align-items:center;white-space:nowrap;position:relative}.mat-tab-label:focus{outline:0}.mat-tab-label:focus:not(.mat-tab-disabled){opacity:1}@media screen and (-ms-high-contrast:active){.mat-tab-label:focus{outline:dotted 2px}}.mat-tab-label.mat-tab-disabled{cursor:default}@media screen and (-ms-high-contrast:active){.mat-tab-label.mat-tab-disabled{opacity:.5}}.mat-tab-label .mat-tab-label-content{display:inline-flex;justify-content:center;align-items:center;white-space:nowrap}@media screen and (-ms-high-contrast:active){.mat-tab-label{opacity:1}}@media (max-width:599px){.mat-tab-label{padding:0 12px}}@media (max-width:959px){.mat-tab-label{padding:0 12px}}.mat-tab-group[mat-stretch-tabs]>.mat-tab-header .mat-tab-label{flex-basis:0;flex-grow:1}.mat-tab-body-wrapper{position:relative;overflow:hidden;display:flex;transition:height .5s cubic-bezier(.35,0,.25,1)}.mat-tab-body{top:0;left:0;right:0;bottom:0;position:absolute;display:block;overflow:hidden;flex-basis:100%}.mat-tab-body.mat-tab-body-active{position:relative;overflow-x:hidden;overflow-y:auto;z-index:1;flex-grow:1}.mat-tab-group.mat-tab-group-dynamic-height .mat-tab-body.mat-tab-body-active{overflow-y:hidden}"],encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush,inputs:["color","disableRipple"],host:{class:"mat-tab-group","[class.mat-tab-group-dynamic-height]":"dynamicHeight","[class.mat-tab-group-inverted-header]":'headerPosition === "below"'}}]}],a.ctorParameters=function(){return[{type:e.ElementRef},{type:e.ChangeDetectorRef}]},a.propDecorators={_tabs:[{type:e.ContentChildren,args:[w]}],_tabBodyWrapper:[{type:e.ViewChild,args:["tabBodyWrapper"]}],_tabHeader:[{type:e.ViewChild,args:["tabHeader"]}],dynamicHeight:[{type:e.Input}],selectedIndex:[{type:e.Input}],headerPosition:[{type:e.Input}],backgroundColor:[{type:e.Input}],selectedIndexChange:[{type:e.Output}],focusChange:[{type:e.Output}],animationDone:[{type:e.Output}],selectedTabChange:[{type:e.Output}]},a}(j),F=function(){function t(t){this._elementRef=t}return t}(),N=n.mixinDisableRipple(n.mixinColor(F,"primary")),V=function(t){function a(e,a,n,r,o){var s=t.call(this,e)||this;return s._dir=a,s._ngZone=n,s._changeDetectorRef=r,s._viewportRuler=o,s._onDestroy=new i.Subject,s}return g(a,t),Object.defineProperty(a.prototype,"backgroundColor",{get:function(){return this._backgroundColor},set:function(t){var e=this._elementRef.nativeElement;e.classList.remove("mat-background-"+this.backgroundColor),t&&e.classList.add("mat-background-"+t),this._backgroundColor=t},enumerable:!0,configurable:!0}),a.prototype.updateActiveLink=function(t){this._activeLinkChanged=!!t,this._changeDetectorRef.markForCheck()},a.prototype.ngAfterContentInit=function(){var t=this;this._ngZone.runOutsideAngular(function(){var e=t._dir?t._dir.change:i.of(null);return i.merge(e,t._viewportRuler.change(10)).pipe(s.takeUntil(t._onDestroy)).subscribe(function(){return t._alignInkBar()})})},a.prototype.ngAfterContentChecked=function(){if(this._activeLinkChanged){var t=this._tabLinks.find(function(t){return t.active});this._activeLinkElement=t?t._elementRef:null,this._alignInkBar(),this._activeLinkChanged=!1}},a.prototype.ngOnDestroy=function(){this._onDestroy.next(),this._onDestroy.complete()},a.prototype._alignInkBar=function(){this._activeLinkElement?(this._inkBar.show(),this._inkBar.alignToElement(this._activeLinkElement.nativeElement)):this._inkBar.hide()},a.decorators=[{type:e.Component,args:[{selector:"[mat-tab-nav-bar]",exportAs:"matTabNavBar, matTabNav",inputs:["color","disableRipple"],template:'<div class="mat-tab-links" (cdkObserveContent)="_alignInkBar()"><ng-content></ng-content><mat-ink-bar></mat-ink-bar></div>',styles:[".mat-tab-nav-bar{overflow:hidden;position:relative;flex-shrink:0}.mat-tab-links{position:relative;display:flex}.mat-tab-link{height:48px;padding:0 24px;cursor:pointer;box-sizing:border-box;opacity:.6;min-width:160px;text-align:center;display:inline-flex;justify-content:center;align-items:center;white-space:nowrap;vertical-align:top;text-decoration:none;position:relative;overflow:hidden;-webkit-tap-highlight-color:transparent}.mat-tab-link:focus{outline:0}.mat-tab-link:focus:not(.mat-tab-disabled){opacity:1}@media screen and (-ms-high-contrast:active){.mat-tab-link:focus{outline:dotted 2px}}.mat-tab-link.mat-tab-disabled{cursor:default}@media screen and (-ms-high-contrast:active){.mat-tab-link.mat-tab-disabled{opacity:.5}}.mat-tab-link .mat-tab-label-content{display:inline-flex;justify-content:center;align-items:center;white-space:nowrap}@media screen and (-ms-high-contrast:active){.mat-tab-link{opacity:1}}[mat-stretch-tabs] .mat-tab-link{flex-basis:0;flex-grow:1}.mat-tab-link.mat-tab-disabled{pointer-events:none}@media (max-width:599px){.mat-tab-link{min-width:72px}}.mat-ink-bar{position:absolute;bottom:0;height:2px;transition:.5s cubic-bezier(.35,0,.25,1)}.mat-tab-group-inverted-header .mat-ink-bar{bottom:auto;top:0}@media screen and (-ms-high-contrast:active){.mat-ink-bar{outline:solid 2px;height:0}}"],host:{class:"mat-tab-nav-bar"},encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush}]}],a.ctorParameters=function(){return[{type:e.ElementRef},{type:o.Directionality,decorators:[{type:e.Optional}]},{type:e.NgZone},{type:e.ChangeDetectorRef},{type:p.ViewportRuler}]},a.propDecorators={_inkBar:[{type:e.ViewChild,args:[y]}],_tabLinks:[{type:e.ContentChildren,args:[e.forwardRef(function(){return Z}),{descendants:!0}]}],backgroundColor:[{type:e.Input}]},a}(N),q=function(){function t(){}return t}(),z=n.mixinTabIndex(n.mixinDisableRipple(n.mixinDisabled(q))),Z=function(t){function a(e,a,i,r,o,s,l){var c=t.call(this)||this;return c._tabNavBar=e,c._elementRef=a,c._focusMonitor=l,c._isActive=!1,c._ripplesGloballyDisabled=!1,c.rippleConfig={},c._tabLinkRipple=new n.RippleRenderer(c,i,a,r),c._tabLinkRipple.setupTriggerEvents(a.nativeElement),c.tabIndex=parseInt(s)||0,o&&(c._ripplesGloballyDisabled=!!o.disabled,c.rippleConfig={terminateOnPointerUp:o.terminateOnPointerUp,animation:o.animation}),l&&l.monitor(a),c}return g(a,t),Object.defineProperty(a.prototype,"active",{get:function(){return this._isActive},set:function(t){t!==this._isActive&&(this._isActive=t,this._tabNavBar.updateActiveLink(this._elementRef))},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"rippleDisabled",{get:function(){return this.disabled||this.disableRipple||this._tabNavBar.disableRipple||this._ripplesGloballyDisabled},enumerable:!0,configurable:!0}),a.prototype.ngOnDestroy=function(){this._tabLinkRipple._removeTriggerEvents(),this._focusMonitor&&this._focusMonitor.stopMonitoring(this._elementRef)},a.decorators=[{type:e.Directive,args:[{selector:"[mat-tab-link], [matTabLink]",exportAs:"matTabLink",inputs:["disabled","disableRipple","tabIndex"],host:{class:"mat-tab-link","[attr.aria-current]":"active","[attr.aria-disabled]":"disabled.toString()","[attr.tabIndex]":"tabIndex",
"[class.mat-tab-disabled]":"disabled","[class.mat-tab-label-active]":"active"}}]}],a.ctorParameters=function(){return[{type:V},{type:e.ElementRef},{type:e.NgZone},{type:b.Platform},{type:void 0,decorators:[{type:e.Optional},{type:e.Inject,args:[n.MAT_RIPPLE_GLOBAL_OPTIONS]}]},{type:String,decorators:[{type:e.Attribute,args:["tabindex"]}]},{type:d.FocusMonitor}]},a.propDecorators={active:[{type:e.Input}]},a}(z),G=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{imports:[u.CommonModule,n.MatCommonModule,a.PortalModule,n.MatRippleModule,h.ObserversModule,d.A11yModule],exports:[n.MatCommonModule,H,k,w,V,Z,v],declarations:[H,k,w,y,E,V,Z,L,D,M,v]}]}],t}();t.MatInkBar=y,t._MAT_INK_BAR_POSITIONER=_,t.MatTabBody=L,t.MatTabBodyPortal=D,t.MatTabHeader=M,t.MatTabLabelWrapper=E,t.MatTab=w,t.MatTabLabel=k,t.MatTabNav=V,t.MatTabLink=Z,t.MatTabContent=v,t.MatTabsModule=G,t.MatTabChangeEvent=B,t.MatTabGroupBase=W,t._MatTabGroupMixinBase=j,t.MatTabGroup=H,t.matTabsAnimations=T,t.ɵa23=m,t.ɵf23=C,t.ɵg23=I,t.ɵb23=O,t.ɵc23=S,t.ɵd23=P,t.ɵe23=R,t.ɵj23=q,t.ɵh23=F,t.ɵk23=z,t.ɵi23=N,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-tabs.umd.min.js.map
