/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/animations"),require("@angular/cdk/a11y"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/cdk/layout"),require("@angular/cdk/overlay"),require("@angular/cdk/scrolling"),require("@angular/cdk/platform"),require("@angular/cdk/portal"),require("rxjs/operators"),require("@angular/core"),require("rxjs"),require("@angular/common"),require("@angular/material/core"),require("@angular/platform-browser")):"function"==typeof define&&define.amd?define("@angular/material/tooltip",["exports","@angular/animations","@angular/cdk/a11y","@angular/cdk/bidi","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/cdk/layout","@angular/cdk/overlay","@angular/cdk/scrolling","@angular/cdk/platform","@angular/cdk/portal","rxjs/operators","@angular/core","rxjs","@angular/common","@angular/material/core","@angular/platform-browser"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.tooltip={}),t.ng.animations,t.ng.cdk.a11y,t.ng.cdk.bidi,t.ng.cdk.coercion,t.ng.cdk.keycodes,t.ng.cdk.layout,t.ng.cdk.overlay,t.ng.cdk.scrolling,t.ng.cdk.platform,t.ng.cdk.portal,t.rxjs.operators,t.ng.core,t.rxjs,t.ng.common,t.ng.material.core,t.ng.platformBrowser)}(this,function(t,e,i,o,n,s,r,a,l,p,c,h,d,u,_,y,f){"use strict";function m(t){return Error('Tooltip position "'+t+'" is invalid.')}function g(t){return function(){return t.scrollStrategies.reposition({scrollThrottle:I})}}function v(){return{showDelay:0,hideDelay:0,touchendHideDelay:1500}}var b=function(){return b=Object.assign||function(t){for(var e,i=1,o=arguments.length;i<o;i++){e=arguments[i];for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])}return t},b.apply(this,arguments)},T={tooltipState:e.trigger("state",[e.state("initial, void, hidden",e.style({opacity:0,transform:"scale(0)"})),e.state("visible",e.style({transform:"scale(1)"})),e.transition("* => visible",e.animate("200ms cubic-bezier(0, 0, 0.2, 1)",e.keyframes([e.style({opacity:0,transform:"scale(0)",offset:0}),e.style({opacity:.5,transform:"scale(0.99)",offset:.5}),e.style({opacity:1,transform:"scale(1)",offset:1})]))),e.transition("* => hidden",e.animate("100ms cubic-bezier(0, 0, 0.2, 1)",e.style({opacity:0})))])},I=20,k=new d.InjectionToken("mat-tooltip-scroll-strategy"),O={provide:k,deps:[a.Overlay],useFactory:g},w=new d.InjectionToken("mat-tooltip-default-options",{providedIn:"root",factory:v}),C=function(){function t(t,e,i,o,n,s,r,a,l,p,c){var d=this;this._overlay=t,this._elementRef=e,this._scrollDispatcher=i,this._viewContainerRef=o,this._ngZone=n,this._platform=s,this._ariaDescriber=r,this._focusMonitor=a,this._dir=p,this._defaultOptions=c,this._position="below",this._disabled=!1,this.showDelay=this._defaultOptions.showDelay,this.hideDelay=this._defaultOptions.hideDelay,this._message="",this._manualListeners=new Map,this._destroyed=new u.Subject,this._scrollStrategy=l;var _=e.nativeElement,y=_.style;s.IOS||s.ANDROID||this._manualListeners.set("mouseenter",function(){return d.show()}).set("mouseleave",function(){return d.hide()}).forEach(function(t,e){return _.addEventListener(e,t)}),"INPUT"!==_.nodeName&&"TEXTAREA"!==_.nodeName||(y.webkitUserSelect=y.userSelect=y.msUserSelect=""),_.draggable&&"none"===y.webkitUserDrag&&(y.webkitUserDrag=""),a.monitor(e).pipe(h.takeUntil(this._destroyed)).subscribe(function(t){t?"keyboard"===t&&n.run(function(){return d.show()}):n.run(function(){return d.hide(0)})})}return Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(t){t!==this._position&&(this._position=t,this._overlayRef&&(this._updatePosition(),this._tooltipInstance&&this._tooltipInstance.show(0),this._overlayRef.updatePosition()))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"disabled",{get:function(){return this._disabled},set:function(t){this._disabled=n.coerceBooleanProperty(t),this._disabled&&this.hide(0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"message",{get:function(){return this._message},set:function(t){this._ariaDescriber.removeDescription(this._elementRef.nativeElement,this._message),this._message=null!=t?(""+t).trim():"",!this._message&&this._isTooltipVisible()?this.hide(0):(this._updateTooltipMessage(),this._ariaDescriber.describe(this._elementRef.nativeElement,this.message))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tooltipClass",{get:function(){return this._tooltipClass},set:function(t){this._tooltipClass=t,this._tooltipInstance&&this._setTooltipClass(this._tooltipClass)},enumerable:!0,configurable:!0}),t.prototype.ngOnDestroy=function(){var t=this;this._overlayRef&&(this._overlayRef.dispose(),this._tooltipInstance=null),this._platform.IOS||(this._manualListeners.forEach(function(e,i){return t._elementRef.nativeElement.removeEventListener(i,e)}),this._manualListeners.clear()),this._destroyed.next(),this._destroyed.complete(),this._ariaDescriber.removeDescription(this._elementRef.nativeElement,this.message),this._focusMonitor.stopMonitoring(this._elementRef)},t.prototype.show=function(t){var e=this;if(void 0===t&&(t=this.showDelay),!this.disabled&&this.message&&(!this._isTooltipVisible()||this._tooltipInstance._showTimeoutId||this._tooltipInstance._hideTimeoutId)){var i=this._createOverlay();this._detach(),this._portal=this._portal||new c.ComponentPortal(R,this._viewContainerRef),this._tooltipInstance=i.attach(this._portal).instance,this._tooltipInstance.afterHidden().pipe(h.takeUntil(this._destroyed)).subscribe(function(){return e._detach()}),this._setTooltipClass(this._tooltipClass),this._updateTooltipMessage(),this._tooltipInstance.show(t)}},t.prototype.hide=function(t){void 0===t&&(t=this.hideDelay),this._tooltipInstance&&this._tooltipInstance.hide(t)},t.prototype.toggle=function(){this._isTooltipVisible()?this.hide():this.show()},t.prototype._isTooltipVisible=function(){return!!this._tooltipInstance&&this._tooltipInstance.isVisible()},t.prototype._handleKeydown=function(t){this._isTooltipVisible()&&t.keyCode===s.ESCAPE&&(t.stopPropagation(),this.hide(0))},t.prototype._handleTouchend=function(){this.hide(this._defaultOptions.touchendHideDelay)},t.prototype._createOverlay=function(){var t=this;if(this._overlayRef)return this._overlayRef;var e=this._overlay.position().flexibleConnectedTo(this._elementRef).withTransformOriginOn(".mat-tooltip").withFlexibleDimensions(!1).withViewportMargin(8),i=this._scrollDispatcher.getAncestorScrollContainers(this._elementRef);return e.withScrollableContainers(i),e.positionChanges.pipe(h.takeUntil(this._destroyed)).subscribe(function(e){t._tooltipInstance&&e.scrollableViewProperties.isOverlayClipped&&t._tooltipInstance.isVisible()&&t._ngZone.run(function(){return t.hide(0)})}),this._overlayRef=this._overlay.create({direction:this._dir,positionStrategy:e,panelClass:"mat-tooltip-panel",scrollStrategy:this._scrollStrategy()}),this._updatePosition(),this._overlayRef.detachments().pipe(h.takeUntil(this._destroyed)).subscribe(function(){return t._detach()}),this._overlayRef},t.prototype._detach=function(){this._overlayRef&&this._overlayRef.hasAttached()&&this._overlayRef.detach(),this._tooltipInstance=null},t.prototype._updatePosition=function(){var t=this._overlayRef.getConfig().positionStrategy,e=this._getOrigin(),i=this._getOverlayPosition();t.withPositions([b({},e.main,i.main),b({},e.fallback,i.fallback)])},t.prototype._getOrigin=function(){var t,e=!this._dir||"ltr"==this._dir.value,i=this.position;if("above"==i||"below"==i)t={originX:"center",originY:"above"==i?"top":"bottom"};else if("before"==i||"left"==i&&e||"right"==i&&!e)t={originX:"start",originY:"center"};else{if(!("after"==i||"right"==i&&e||"left"==i&&!e))throw m(i);t={originX:"end",originY:"center"}}var o=this._invertPosition(t.originX,t.originY);return{main:t,fallback:{originX:o.x,originY:o.y}}},t.prototype._getOverlayPosition=function(){var t,e=!this._dir||"ltr"==this._dir.value,i=this.position;if("above"==i)t={overlayX:"center",overlayY:"bottom"};else if("below"==i)t={overlayX:"center",overlayY:"top"};else if("before"==i||"left"==i&&e||"right"==i&&!e)t={overlayX:"end",overlayY:"center"};else{if(!("after"==i||"right"==i&&e||"left"==i&&!e))throw m(i);t={overlayX:"start",overlayY:"center"}}var o=this._invertPosition(t.overlayX,t.overlayY);return{main:t,fallback:{overlayX:o.x,overlayY:o.y}}},t.prototype._updateTooltipMessage=function(){var t=this;this._tooltipInstance&&(this._tooltipInstance.message=this.message,this._tooltipInstance._markForCheck(),this._ngZone.onMicrotaskEmpty.asObservable().pipe(h.take(1),h.takeUntil(this._destroyed)).subscribe(function(){t._tooltipInstance&&t._overlayRef.updatePosition()}))},t.prototype._setTooltipClass=function(t){this._tooltipInstance&&(this._tooltipInstance.tooltipClass=t,this._tooltipInstance._markForCheck())},t.prototype._invertPosition=function(t,e){return"above"===this.position||"below"===this.position?"top"===e?e="bottom":"bottom"===e&&(e="top"):"end"===t?t="start":"start"===t&&(t="end"),{x:t,y:e}},t.decorators=[{type:d.Directive,args:[{selector:"[matTooltip]",exportAs:"matTooltip",host:{"(longpress)":"show()","(keydown)":"_handleKeydown($event)","(touchend)":"_handleTouchend()"}}]}],t.ctorParameters=function(){return[{type:a.Overlay},{type:d.ElementRef},{type:l.ScrollDispatcher},{type:d.ViewContainerRef},{type:d.NgZone},{type:p.Platform},{type:i.AriaDescriber},{type:i.FocusMonitor},{type:void 0,decorators:[{type:d.Inject,args:[k]}]},{type:o.Directionality,decorators:[{type:d.Optional}]},{type:void 0,decorators:[{type:d.Optional},{type:d.Inject,args:[w]}]}]},t.propDecorators={position:[{type:d.Input,args:["matTooltipPosition"]}],disabled:[{type:d.Input,args:["matTooltipDisabled"]}],showDelay:[{type:d.Input,args:["matTooltipShowDelay"]}],hideDelay:[{type:d.Input,args:["matTooltipHideDelay"]}],message:[{type:d.Input,args:["matTooltip"]}],tooltipClass:[{type:d.Input,args:["matTooltipClass"]}]},t}(),R=function(){function t(t,e){this._changeDetectorRef=t,this._breakpointObserver=e,this._visibility="initial",this._closeOnInteraction=!1,this._onHide=new u.Subject,this._isHandset=this._breakpointObserver.observe(r.Breakpoints.Handset)}return t.prototype.show=function(t){var e=this;this._hideTimeoutId&&(clearTimeout(this._hideTimeoutId),this._hideTimeoutId=null),this._closeOnInteraction=!0,this._showTimeoutId=setTimeout(function(){e._visibility="visible",e._showTimeoutId=null,e._markForCheck()},t)},t.prototype.hide=function(t){var e=this;this._showTimeoutId&&(clearTimeout(this._showTimeoutId),this._showTimeoutId=null),this._hideTimeoutId=setTimeout(function(){e._visibility="hidden",e._hideTimeoutId=null,e._markForCheck()},t)},t.prototype.afterHidden=function(){return this._onHide.asObservable()},t.prototype.isVisible=function(){return"visible"===this._visibility},t.prototype._animationStart=function(){this._closeOnInteraction=!1},t.prototype._animationDone=function(t){var e=t.toState;"hidden"!==e||this.isVisible()||this._onHide.next(),"visible"!==e&&"hidden"!==e||(this._closeOnInteraction=!0)},t.prototype._handleBodyInteraction=function(){this._closeOnInteraction&&this.hide(0)},t.prototype._markForCheck=function(){this._changeDetectorRef.markForCheck()},t.decorators=[{type:d.Component,args:[{selector:"mat-tooltip-component",template:'<div class="mat-tooltip" [ngClass]="tooltipClass" [class.mat-tooltip-handset]="(_isHandset | async)?.matches" [@state]="_visibility" (@state.start)="_animationStart()" (@state.done)="_animationDone($event)">{{message}}</div>',styles:[".mat-tooltip-panel{pointer-events:none!important}.mat-tooltip{color:#fff;border-radius:4px;margin:14px;max-width:250px;padding-left:8px;padding-right:8px;overflow:hidden;text-overflow:ellipsis}@media screen and (-ms-high-contrast:active){.mat-tooltip{outline:solid 1px}}.mat-tooltip-handset{margin:24px;padding-left:16px;padding-right:16px}"],encapsulation:d.ViewEncapsulation.None,changeDetection:d.ChangeDetectionStrategy.OnPush,animations:[T.tooltipState],host:{"[style.zoom]":'_visibility === "visible" ? 1 : null',"(body:click)":"this._handleBodyInteraction()","aria-hidden":"true"}}]}],t.ctorParameters=function(){return[{type:d.ChangeDetectorRef},{type:r.BreakpointObserver}]},t}(),D=function(){function t(){}return t.decorators=[{type:d.NgModule,args:[{imports:[i.A11yModule,_.CommonModule,a.OverlayModule,y.MatCommonModule],exports:[C,R,y.MatCommonModule],declarations:[C,R],entryComponents:[R],providers:[O,{provide:f.HAMMER_GESTURE_CONFIG,useClass:y.GestureConfig}]}]}],t}();t.MatTooltipModule=D,t.getMatTooltipInvalidPositionError=m,t.MAT_TOOLTIP_SCROLL_STRATEGY_FACTORY=g,t.MAT_TOOLTIP_DEFAULT_OPTIONS_FACTORY=v,t.SCROLL_THROTTLE_MS=I,t.TOOLTIP_PANEL_CLASS="mat-tooltip-panel",t.MAT_TOOLTIP_SCROLL_STRATEGY=k,t.MAT_TOOLTIP_SCROLL_STRATEGY_FACTORY_PROVIDER=O,t.MAT_TOOLTIP_DEFAULT_OPTIONS=w,t.MatTooltip=C,t.TooltipComponent=R,t.matTooltipAnimations=T,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-tooltip.umd.min.js.map
