/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { Identifiers, getUrlScheme, syntaxError } from '@angular/compiler';
import { ANALYZE_FOR_ENTRY_COMPONENTS, ChangeDetectionStrategy, ChangeDetectorRef, ComponentFactory, ComponentFactoryResolver, ComponentRef, ElementRef, Injector, LOCALE_ID, NgModuleFactory, NgModuleRef, QueryList, Renderer, SecurityContext, TRANSLATIONS_FORMAT, TemplateRef, ViewContainerRef, ViewEncapsulation, ɵCodegenComponentFactoryResolver, ɵEMPTY_ARRAY, ɵEMPTY_MAP, ɵReflectionCapabilities as ReflectionCapabilities, ɵand, ɵccf, ɵcmf, ɵcrt, ɵdid, ɵeld, ɵinlineInterpolate, ɵinterpolate, ɵmod, ɵmpd, ɵncd, ɵnov, ɵpad, ɵpid, ɵpod, ɵppd, ɵprd, ɵqud, ɵregisterModuleFactory, ɵstringify as stringify, ɵted, ɵunv, ɵvid } from '@angular/core';
export var MODULE_SUFFIX = '';
var builtinExternalReferences = createBuiltinExternalReferencesMap();
var JitReflector = /** @class */ (function () {
    function JitReflector() {
        this.builtinExternalReferences = new Map();
        this.reflectionCapabilities = new ReflectionCapabilities();
    }
    JitReflector.prototype.componentModuleUrl = function (type, cmpMetadata) {
        var moduleId = cmpMetadata.moduleId;
        if (typeof moduleId === 'string') {
            var scheme = getUrlScheme(moduleId);
            return scheme ? moduleId : "package:" + moduleId + MODULE_SUFFIX;
        }
        else if (moduleId !== null && moduleId !== void 0) {
            throw syntaxError("moduleId should be a string in \"" + stringify(type) + "\". See https://goo.gl/wIDDiL for more information.\n" +
                "If you're using Webpack you should inline the template and the styles, see https://goo.gl/X2J8zc.");
        }
        return "./" + stringify(type);
    };
    JitReflector.prototype.parameters = function (typeOrFunc) {
        return this.reflectionCapabilities.parameters(typeOrFunc);
    };
    JitReflector.prototype.tryAnnotations = function (typeOrFunc) { return this.annotations(typeOrFunc); };
    JitReflector.prototype.annotations = function (typeOrFunc) {
        return this.reflectionCapabilities.annotations(typeOrFunc);
    };
    JitReflector.prototype.shallowAnnotations = function (typeOrFunc) {
        throw new Error('Not supported in JIT mode');
    };
    JitReflector.prototype.propMetadata = function (typeOrFunc) {
        return this.reflectionCapabilities.propMetadata(typeOrFunc);
    };
    JitReflector.prototype.hasLifecycleHook = function (type, lcProperty) {
        return this.reflectionCapabilities.hasLifecycleHook(type, lcProperty);
    };
    JitReflector.prototype.guards = function (type) { return this.reflectionCapabilities.guards(type); };
    JitReflector.prototype.resolveExternalReference = function (ref) {
        return builtinExternalReferences.get(ref) || ref.runtime;
    };
    return JitReflector;
}());
export { JitReflector };
function createBuiltinExternalReferencesMap() {
    var map = new Map();
    map.set(Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS, ANALYZE_FOR_ENTRY_COMPONENTS);
    map.set(Identifiers.ElementRef, ElementRef);
    map.set(Identifiers.NgModuleRef, NgModuleRef);
    map.set(Identifiers.ViewContainerRef, ViewContainerRef);
    map.set(Identifiers.ChangeDetectorRef, ChangeDetectorRef);
    map.set(Identifiers.QueryList, QueryList);
    map.set(Identifiers.TemplateRef, TemplateRef);
    map.set(Identifiers.CodegenComponentFactoryResolver, ɵCodegenComponentFactoryResolver);
    map.set(Identifiers.ComponentFactoryResolver, ComponentFactoryResolver);
    map.set(Identifiers.ComponentFactory, ComponentFactory);
    map.set(Identifiers.ComponentRef, ComponentRef);
    map.set(Identifiers.NgModuleFactory, NgModuleFactory);
    map.set(Identifiers.createModuleFactory, ɵcmf);
    map.set(Identifiers.moduleDef, ɵmod);
    map.set(Identifiers.moduleProviderDef, ɵmpd);
    map.set(Identifiers.RegisterModuleFactoryFn, ɵregisterModuleFactory);
    map.set(Identifiers.Injector, Injector);
    map.set(Identifiers.ViewEncapsulation, ViewEncapsulation);
    map.set(Identifiers.ChangeDetectionStrategy, ChangeDetectionStrategy);
    map.set(Identifiers.SecurityContext, SecurityContext);
    map.set(Identifiers.LOCALE_ID, LOCALE_ID);
    map.set(Identifiers.TRANSLATIONS_FORMAT, TRANSLATIONS_FORMAT);
    map.set(Identifiers.inlineInterpolate, ɵinlineInterpolate);
    map.set(Identifiers.interpolate, ɵinterpolate);
    map.set(Identifiers.EMPTY_ARRAY, ɵEMPTY_ARRAY);
    map.set(Identifiers.EMPTY_MAP, ɵEMPTY_MAP);
    map.set(Identifiers.Renderer, Renderer);
    map.set(Identifiers.viewDef, ɵvid);
    map.set(Identifiers.elementDef, ɵeld);
    map.set(Identifiers.anchorDef, ɵand);
    map.set(Identifiers.textDef, ɵted);
    map.set(Identifiers.directiveDef, ɵdid);
    map.set(Identifiers.providerDef, ɵprd);
    map.set(Identifiers.queryDef, ɵqud);
    map.set(Identifiers.pureArrayDef, ɵpad);
    map.set(Identifiers.pureObjectDef, ɵpod);
    map.set(Identifiers.purePipeDef, ɵppd);
    map.set(Identifiers.pipeDef, ɵpid);
    map.set(Identifiers.nodeValue, ɵnov);
    map.set(Identifiers.ngContentDef, ɵncd);
    map.set(Identifiers.unwrapValue, ɵunv);
    map.set(Identifiers.createRendererType2, ɵcrt);
    map.set(Identifiers.createComponentFactory, ɵccf);
    return map;
}

//# sourceMappingURL=data:application/json;base64,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