/**
 * @license Angular v2.4.4
 * (c) 2010-2016 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/common"),require("@angular/core")):"function"==typeof define&&define.amd?define(["exports","@angular/common","@angular/core"],factory):factory((global.ng=global.ng||{},global.ng.platformBrowser=global.ng.platformBrowser||{}),global.ng.common,global.ng.core)}(this,function(exports,_angular_common,core){"use strict";function isPresent(obj){return null!=obj}function isBlank(obj){return null==obj}function stringify(token){if("string"==typeof token)return token;if(null==token)return""+token;if(token.overriddenName)return""+token.overriddenName;if(token.name)return""+token.name;var res=token.toString(),newLineIndex=res.indexOf("\n");return newLineIndex===-1?res:res.substring(0,newLineIndex)}function setValueOnPath(global,path,value){for(var parts=path.split("."),obj=global;parts.length>1;){var name_1=parts.shift();obj=obj.hasOwnProperty(name_1)&&null!=obj[name_1]?obj[name_1]:obj[name_1]={}}void 0!==obj&&null!==obj||(obj={}),obj[parts.shift()]=value}function getDOM(){return _DOM}function setRootDomAdapter(adapter){_DOM||(_DOM=adapter)}function _computeStyle(element,prop){return getDOM().getComputedStyle(element)[prop]}function _copyKeyframeStyles(styles){var newStyles={};return Object.keys(styles).forEach(function(prop){"offset"!=prop&&(newStyles[prop]=styles[prop])}),newStyles}function _populateStyles(styles,defaultStyles){var data={};return styles.styles.forEach(function(entry){Object.keys(entry).forEach(function(prop){data[prop]=entry[prop]})}),Object.keys(defaultStyles).forEach(function(prop){isPresent(data[prop])||(data[prop]=defaultStyles[prop])}),data}function filterWebAnimationPlayerFn(player){return player instanceof WebAnimationsPlayer}function getBaseElementHref(){return baseElement||(baseElement=document.querySelector("base"))?baseElement.getAttribute("href"):null}function relativePath(url){return urlParsingNode||(urlParsingNode=document.createElement("a")),urlParsingNode.setAttribute("href",url),"/"===urlParsingNode.pathname.charAt(0)?urlParsingNode.pathname:"/"+urlParsingNode.pathname}function parseCookieValue(cookieStr,name){name=encodeURIComponent(name);for(var _i=0,_a=cookieStr.split(";");_i<_a.length;_i++){var cookie=_a[_i],eqIndex=cookie.indexOf("="),_b=eqIndex==-1?[cookie,""]:[cookie.slice(0,eqIndex),cookie.slice(eqIndex+1)],cookieName=_b[0],cookieValue=_b[1];if(cookieName.trim()===name)return decodeURIComponent(cookieValue)}return null}/**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     * @return {?}
     */
function supportsState(){return!!window.history.pushState}function moveNodesAfterSibling(sibling,nodes){var parent=sibling.parentNode;if(nodes.length>0&&parent){var nextSibling=sibling.nextSibling;if(nextSibling)for(var i=0;i<nodes.length;i++)parent.insertBefore(nodes[i],nextSibling);else for(var i=0;i<nodes.length;i++)parent.appendChild(nodes[i])}}function appendNodes(parent,nodes){for(var i=0;i<nodes.length;i++)parent.appendChild(nodes[i])}function decoratePreventDefault(eventHandler){return function(event){var allowDefaultBehavior=eventHandler(event);allowDefaultBehavior===!1&&(event.preventDefault(),event.returnValue=!1)}}function shimContentAttribute(componentShortId){return CONTENT_ATTR.replace(COMPONENT_REGEX,componentShortId)}function shimHostAttribute(componentShortId){return HOST_ATTR.replace(COMPONENT_REGEX,componentShortId)}function flattenStyles(compId,styles,target){for(var i=0;i<styles.length;i++){var style=styles[i];Array.isArray(style)?flattenStyles(compId,style,target):(style=style.replace(COMPONENT_REGEX,compId),target.push(style))}return target}function isNamespaced(name){return":"===name[0]}function splitNamespace(name){var match=name.match(NS_PREFIX_RE);return[match[1],match[2]]}function inspectNativeElement(element){return core.getDebugNode(element)}function _createConditionalRootRenderer(rootRenderer,extraTokens,coreTokens){return core.isDevMode()?_createRootRenderer(rootRenderer,(extraTokens||[]).concat(coreTokens||[])):rootRenderer}function _createRootRenderer(rootRenderer,extraTokens){return getDOM().setGlobalVar(INSPECT_GLOBAL_NAME,inspectNativeElement),getDOM().setGlobalVar(CORE_TOKENS_GLOBAL_NAME,StringMapWrapper.merge(CORE_TOKENS,_ngProbeTokensToMap(extraTokens||[]))),new DebugDomRootRenderer(rootRenderer)}function _ngProbeTokensToMap(tokens){return tokens.reduce(function(prev,t){return prev[t.name]=t.token,prev},{})}function sanitizeUrl(url){return url=String(url),url.match(SAFE_URL_PATTERN)||url.match(DATA_URL_PATTERN)?url:(core.isDevMode()&&getDOM().log("WARNING: sanitizing unsafe URL value "+url+" (see http://g.co/ng/security#xss)"),"unsafe:"+url)}function sanitizeSrcset(srcset){return srcset=String(srcset),srcset.split(",").map(function(srcset){return sanitizeUrl(srcset.trim())}).join(", ")}function getInertElement(){if(inertElement)return inertElement;DOM=getDOM();var templateEl=DOM.createElement("template");if("content"in templateEl)return templateEl;var doc=DOM.createHtmlDocument();if(inertElement=DOM.querySelector(doc,"body"),null==inertElement){var html=DOM.createElement("html",doc);inertElement=DOM.createElement("body",doc),DOM.appendChild(html,inertElement),DOM.appendChild(doc,html)}return inertElement}function tagSet(tags){for(var res={},_i=0,_a=tags.split(",");_i<_a.length;_i++){var t=_a[_i];res[t]=!0}return res}function merge(){for(var sets=[],_i=0;_i<arguments.length;_i++)sets[_i-0]=arguments[_i];for(var res={},_a=0,sets_1=sets;_a<sets_1.length;_a++){var s=sets_1[_a];for(var v in s)s.hasOwnProperty(v)&&(res[v]=!0)}return res}function encodeEntities(value){return value.replace(/&/g,"&amp;").replace(SURROGATE_PAIR_REGEXP,function(match){var hi=match.charCodeAt(0),low=match.charCodeAt(1);return"&#"+(1024*(hi-55296)+(low-56320)+65536)+";"}).replace(NON_ALPHANUMERIC_REGEXP,function(match){return"&#"+match.charCodeAt(0)+";"}).replace(/</g,"&lt;").replace(/>/g,"&gt;")}function stripCustomNsAttrs(el){DOM.attributeMap(el).forEach(function(_,attrName){"xmlns:ns1"!==attrName&&0!==attrName.indexOf("ns1:")||DOM.removeAttribute(el,attrName)});for(var _i=0,_a=DOM.childNodesAsList(el);_i<_a.length;_i++){var n=_a[_i];DOM.isElementNode(n)&&stripCustomNsAttrs(n)}}function sanitizeHtml(unsafeHtmlInput){try{var containerEl=getInertElement(),unsafeHtml=unsafeHtmlInput?String(unsafeHtmlInput):"",mXSSAttempts=5,parsedHtml=unsafeHtml;do{if(0===mXSSAttempts)throw new Error("Failed to sanitize html because the input is unstable");mXSSAttempts--,unsafeHtml=parsedHtml,DOM.setInnerHTML(containerEl,unsafeHtml),DOM.defaultDoc().documentMode&&stripCustomNsAttrs(containerEl),parsedHtml=DOM.getInnerHTML(containerEl)}while(unsafeHtml!==parsedHtml);for(var sanitizer=new SanitizingHtmlSerializer,safeHtml=sanitizer.sanitizeChildren(DOM.getTemplateContent(containerEl)||containerEl),parent_1=DOM.getTemplateContent(containerEl)||containerEl,_i=0,_a=DOM.childNodesAsList(parent_1);_i<_a.length;_i++){var child=_a[_i];DOM.removeChild(parent_1,child)}return core.isDevMode()&&sanitizer.sanitizedSomething&&DOM.log("WARNING: sanitizing HTML stripped some content (see http://g.co/ng/security#xss)."),safeHtml}catch(e){throw inertElement=null,e}}function hasBalancedQuotes(value){for(var outsideSingle=!0,outsideDouble=!0,i=0;i<value.length;i++){var c=value.charAt(i);"'"===c&&outsideDouble?outsideSingle=!outsideSingle:'"'===c&&outsideSingle&&(outsideDouble=!outsideDouble)}return outsideSingle&&outsideDouble}function sanitizeStyle(value){if(value=String(value).trim(),!value)return"";var urlMatch=value.match(URL_RE);return urlMatch&&sanitizeUrl(urlMatch[1])===urlMatch[1]||value.match(SAFE_STYLE_VALUE)&&hasBalancedQuotes(value)?value:(core.isDevMode()&&getDOM().log("WARNING: sanitizing unsafe style value "+value+" (see http://g.co/ng/security#xss)."),"unsafe")}function initDomAdapter(){BrowserDomAdapter.makeCurrent(),BrowserGetTestability.init()}function errorHandler(){return new core.ErrorHandler}function _document(){return getDOM().defaultDoc()}function _resolveDefaultAnimationDriver(){return getDOM().supportsWebAnimation()?new WebAnimationsDriver:AnimationDriver.NOOP}function enableDebugTools(ref){return Object.assign(context.ng,new AngularTools(ref)),ref}function disableDebugTools(){context.ng&&delete context.ng.profiler}var globalScope,DebugDomRootRenderer=core.__core_private__.DebugDomRootRenderer,NoOpAnimationPlayer=core.__core_private__.NoOpAnimationPlayer,NoOpAnimationDriver=function(){function NoOpAnimationDriver(){}return NoOpAnimationDriver.prototype.animate=function(element,startingStyles,keyframes,duration,delay,easing,previousPlayers){return void 0===previousPlayers&&(previousPlayers=[]),new NoOpAnimationPlayer},NoOpAnimationDriver}(),AnimationDriver=function(){function AnimationDriver(){}return AnimationDriver.prototype.animate=function(element,startingStyles,keyframes,duration,delay,easing,previousPlayers){},AnimationDriver.NOOP=new NoOpAnimationDriver,AnimationDriver}();globalScope="undefined"==typeof window?"undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope?self:global:window;var global$1=globalScope;global$1.assert=function(condition){};/**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
var urlParsingNode,_DOM=null,DomAdapter=function(){function DomAdapter(){this.resourceLoaderType=null}return DomAdapter.prototype.hasProperty=function(element,name){},DomAdapter.prototype.setProperty=function(el,name,value){},DomAdapter.prototype.getProperty=function(el,name){},DomAdapter.prototype.invoke=function(el,methodName,args){},DomAdapter.prototype.logError=function(error){},DomAdapter.prototype.log=function(error){},DomAdapter.prototype.logGroup=function(error){},DomAdapter.prototype.logGroupEnd=function(){},Object.defineProperty(DomAdapter.prototype,"attrToPropMap",{get:function(){return this._attrToPropMap},set:function(value){this._attrToPropMap=value},enumerable:!0,configurable:!0}),DomAdapter.prototype.parse=function(templateHtml){},DomAdapter.prototype.query=function(selector){},DomAdapter.prototype.querySelector=function(el,selector){},DomAdapter.prototype.querySelectorAll=function(el,selector){},DomAdapter.prototype.on=function(el,evt,listener){},DomAdapter.prototype.onAndCancel=function(el,evt,listener){},DomAdapter.prototype.dispatchEvent=function(el,evt){},DomAdapter.prototype.createMouseEvent=function(eventType){},DomAdapter.prototype.createEvent=function(eventType){},DomAdapter.prototype.preventDefault=function(evt){},DomAdapter.prototype.isPrevented=function(evt){},DomAdapter.prototype.getInnerHTML=function(el){},DomAdapter.prototype.getTemplateContent=function(el){},DomAdapter.prototype.getOuterHTML=function(el){},DomAdapter.prototype.nodeName=function(node){},DomAdapter.prototype.nodeValue=function(node){},DomAdapter.prototype.type=function(node){},DomAdapter.prototype.content=function(node){},DomAdapter.prototype.firstChild=function(el){},DomAdapter.prototype.nextSibling=function(el){},DomAdapter.prototype.parentElement=function(el){},DomAdapter.prototype.childNodes=function(el){},DomAdapter.prototype.childNodesAsList=function(el){},DomAdapter.prototype.clearNodes=function(el){},DomAdapter.prototype.appendChild=function(el,node){},DomAdapter.prototype.removeChild=function(el,node){},DomAdapter.prototype.replaceChild=function(el,newNode,oldNode){},DomAdapter.prototype.remove=function(el){},DomAdapter.prototype.insertBefore=function(el,node){},DomAdapter.prototype.insertAllBefore=function(el,nodes){},DomAdapter.prototype.insertAfter=function(el,node){},DomAdapter.prototype.setInnerHTML=function(el,value){},DomAdapter.prototype.getText=function(el){},DomAdapter.prototype.setText=function(el,value){},DomAdapter.prototype.getValue=function(el){},DomAdapter.prototype.setValue=function(el,value){},DomAdapter.prototype.getChecked=function(el){},DomAdapter.prototype.setChecked=function(el,value){},DomAdapter.prototype.createComment=function(text){},DomAdapter.prototype.createTemplate=function(html){},DomAdapter.prototype.createElement=function(tagName,doc){},DomAdapter.prototype.createElementNS=function(ns,tagName,doc){},DomAdapter.prototype.createTextNode=function(text,doc){},DomAdapter.prototype.createScriptTag=function(attrName,attrValue,doc){},DomAdapter.prototype.createStyleElement=function(css,doc){},DomAdapter.prototype.createShadowRoot=function(el){},DomAdapter.prototype.getShadowRoot=function(el){},DomAdapter.prototype.getHost=function(el){},DomAdapter.prototype.getDistributedNodes=function(el){},DomAdapter.prototype.clone=function(node){},DomAdapter.prototype.getElementsByClassName=function(element,name){},DomAdapter.prototype.getElementsByTagName=function(element,name){},DomAdapter.prototype.classList=function(element){},DomAdapter.prototype.addClass=function(element,className){},DomAdapter.prototype.removeClass=function(element,className){},DomAdapter.prototype.hasClass=function(element,className){},DomAdapter.prototype.setStyle=function(element,styleName,styleValue){},DomAdapter.prototype.removeStyle=function(element,styleName){},DomAdapter.prototype.getStyle=function(element,styleName){},DomAdapter.prototype.hasStyle=function(element,styleName,styleValue){},DomAdapter.prototype.tagName=function(element){},DomAdapter.prototype.attributeMap=function(element){},DomAdapter.prototype.hasAttribute=function(element,attribute){},DomAdapter.prototype.hasAttributeNS=function(element,ns,attribute){},DomAdapter.prototype.getAttribute=function(element,attribute){},DomAdapter.prototype.getAttributeNS=function(element,ns,attribute){},DomAdapter.prototype.setAttribute=function(element,name,value){},DomAdapter.prototype.setAttributeNS=function(element,ns,name,value){},DomAdapter.prototype.removeAttribute=function(element,attribute){},DomAdapter.prototype.removeAttributeNS=function(element,ns,attribute){},DomAdapter.prototype.templateAwareRoot=function(el){},DomAdapter.prototype.createHtmlDocument=function(){},DomAdapter.prototype.defaultDoc=function(){},DomAdapter.prototype.getBoundingClientRect=function(el){},DomAdapter.prototype.getTitle=function(){},DomAdapter.prototype.setTitle=function(newTitle){},DomAdapter.prototype.elementMatches=function(n,selector){},DomAdapter.prototype.isTemplateElement=function(el){},DomAdapter.prototype.isTextNode=function(node){},DomAdapter.prototype.isCommentNode=function(node){},DomAdapter.prototype.isElementNode=function(node){},DomAdapter.prototype.hasShadowRoot=function(node){},DomAdapter.prototype.isShadowRoot=function(node){},DomAdapter.prototype.importIntoDoc=function(node){},DomAdapter.prototype.adoptNode=function(node){},DomAdapter.prototype.getHref=function(element){},DomAdapter.prototype.getEventKey=function(event){},DomAdapter.prototype.resolveAndSetHref=function(element,baseUrl,href){},DomAdapter.prototype.supportsDOMEvents=function(){},DomAdapter.prototype.supportsNativeShadowDOM=function(){},DomAdapter.prototype.getGlobalEventTarget=function(target){},DomAdapter.prototype.getHistory=function(){},DomAdapter.prototype.getLocation=function(){},DomAdapter.prototype.getBaseHref=function(){},DomAdapter.prototype.resetBaseElement=function(){},DomAdapter.prototype.getUserAgent=function(){},DomAdapter.prototype.setData=function(element,name,value){},DomAdapter.prototype.getComputedStyle=function(element){},DomAdapter.prototype.getData=function(element,name){},DomAdapter.prototype.setGlobalVar=function(name,value){},DomAdapter.prototype.supportsWebAnimation=function(){},DomAdapter.prototype.performanceNow=function(){},DomAdapter.prototype.getAnimationPrefix=function(){},DomAdapter.prototype.getTransitionEnd=function(){},DomAdapter.prototype.supportsAnimation=function(){},DomAdapter.prototype.supportsCookies=function(){},DomAdapter.prototype.getCookie=function(name){},DomAdapter.prototype.setCookie=function(name,value){},DomAdapter}(),WebAnimationsPlayer=function(){function WebAnimationsPlayer(element,keyframes,options,previousPlayers){var _this=this;void 0===previousPlayers&&(previousPlayers=[]),this.element=element,this.keyframes=keyframes,this.options=options,this._onDoneFns=[],this._onStartFns=[],this._initialized=!1,this._finished=!1,this._started=!1,this._destroyed=!1,this.parentPlayer=null,this._duration=options.duration,this.previousStyles={},previousPlayers.forEach(function(player){var styles=player._captureStyles();Object.keys(styles).forEach(function(prop){return _this.previousStyles[prop]=styles[prop]})})}return WebAnimationsPlayer.prototype._onFinish=function(){this._finished||(this._finished=!0,this._onDoneFns.forEach(function(fn){return fn()}),this._onDoneFns=[])},WebAnimationsPlayer.prototype.init=function(){var _this=this;if(!this._initialized){this._initialized=!0;var keyframes=this.keyframes.map(function(styles){var formattedKeyframe={};return Object.keys(styles).forEach(function(prop,index){var value=styles[prop];value==core.AUTO_STYLE&&(value=_computeStyle(_this.element,prop)),void 0!=value&&(formattedKeyframe[prop]=value)}),formattedKeyframe}),previousStyleProps=Object.keys(this.previousStyles);if(previousStyleProps.length){var startingKeyframe_1=keyframes[0],missingStyleProps_1=[];if(previousStyleProps.forEach(function(prop){isPresent(startingKeyframe_1[prop])||missingStyleProps_1.push(prop),startingKeyframe_1[prop]=_this.previousStyles[prop]}),missingStyleProps_1.length)for(var _loop_1=function(i){var kf=keyframes[i];missingStyleProps_1.forEach(function(prop){kf[prop]=_computeStyle(_this.element,prop)})},i=1;i<keyframes.length;i++)_loop_1(i)}this._player=this._triggerWebAnimation(this.element,keyframes,this.options),this._finalKeyframe=_copyKeyframeStyles(keyframes[keyframes.length-1]),this._resetDomPlayerState(),this._player.addEventListener("finish",function(){return _this._onFinish()})}},WebAnimationsPlayer.prototype._triggerWebAnimation=function(element,keyframes,options){return element.animate(keyframes,options)},Object.defineProperty(WebAnimationsPlayer.prototype,"domPlayer",{get:function(){return this._player},enumerable:!0,configurable:!0}),WebAnimationsPlayer.prototype.onStart=function(fn){this._onStartFns.push(fn)},WebAnimationsPlayer.prototype.onDone=function(fn){this._onDoneFns.push(fn)},WebAnimationsPlayer.prototype.play=function(){this.init(),this.hasStarted()||(this._onStartFns.forEach(function(fn){return fn()}),this._onStartFns=[],this._started=!0),this._player.play()},WebAnimationsPlayer.prototype.pause=function(){this.init(),this._player.pause()},WebAnimationsPlayer.prototype.finish=function(){this.init(),this._onFinish(),this._player.finish()},WebAnimationsPlayer.prototype.reset=function(){this._resetDomPlayerState(),this._destroyed=!1,this._finished=!1,this._started=!1},WebAnimationsPlayer.prototype._resetDomPlayerState=function(){this._player&&this._player.cancel()},WebAnimationsPlayer.prototype.restart=function(){this.reset(),this.play()},WebAnimationsPlayer.prototype.hasStarted=function(){return this._started},WebAnimationsPlayer.prototype.destroy=function(){this._destroyed||(this._resetDomPlayerState(),this._onFinish(),this._destroyed=!0)},Object.defineProperty(WebAnimationsPlayer.prototype,"totalTime",{get:function(){return this._duration},enumerable:!0,configurable:!0}),WebAnimationsPlayer.prototype.setPosition=function(p){this._player.currentTime=p*this.totalTime},WebAnimationsPlayer.prototype.getPosition=function(){return this._player.currentTime/this.totalTime},WebAnimationsPlayer.prototype._captureStyles=function(){var _this=this,styles={};return this.hasStarted()&&Object.keys(this._finalKeyframe).forEach(function(prop){"offset"!=prop&&(styles[prop]=_this._finished?_this._finalKeyframe[prop]:_computeStyle(_this.element,prop))}),styles},WebAnimationsPlayer}(),WebAnimationsDriver=function(){function WebAnimationsDriver(){}return WebAnimationsDriver.prototype.animate=function(element,startingStyles,keyframes,duration,delay,easing,previousPlayers){void 0===previousPlayers&&(previousPlayers=[]);var formattedSteps=[],startingStyleLookup={};if(isPresent(startingStyles)&&(startingStyleLookup=_populateStyles(startingStyles,{})),keyframes.forEach(function(keyframe){var data=_populateStyles(keyframe.styles,startingStyleLookup);data.offset=Math.max(0,Math.min(1,keyframe.offset)),formattedSteps.push(data)}),0==formattedSteps.length)formattedSteps=[startingStyleLookup,startingStyleLookup];else if(1==formattedSteps.length){var start=startingStyleLookup,end=formattedSteps[0];end.offset=null,formattedSteps=[start,end]}var playerOptions={duration:duration,delay:delay,fill:"both"};return easing&&(playerOptions.easing=easing),previousPlayers=previousPlayers.filter(filterWebAnimationPlayerFn),new WebAnimationsPlayer(element,formattedSteps,playerOptions,previousPlayers)},WebAnimationsDriver}(),__extends$1=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},GenericBrowserDomAdapter=function(_super){function GenericBrowserDomAdapter(){var _this=this;_super.call(this),this._animationPrefix=null,this._transitionEnd=null;try{var element_1=this.createElement("div",this.defaultDoc());if(isPresent(this.getStyle(element_1,"animationName")))this._animationPrefix="";else for(var domPrefixes=["Webkit","Moz","O","ms"],i=0;i<domPrefixes.length;i++)if(isPresent(this.getStyle(element_1,domPrefixes[i]+"AnimationName"))){this._animationPrefix="-"+domPrefixes[i].toLowerCase()+"-";break}var transEndEventNames_1={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd otransitionend",transition:"transitionend"};Object.keys(transEndEventNames_1).forEach(function(key){isPresent(_this.getStyle(element_1,key))&&(_this._transitionEnd=transEndEventNames_1[key])})}catch(e){this._animationPrefix=null,this._transitionEnd=null}}return __extends$1(GenericBrowserDomAdapter,_super),GenericBrowserDomAdapter.prototype.getDistributedNodes=function(el){return el.getDistributedNodes()},GenericBrowserDomAdapter.prototype.resolveAndSetHref=function(el,baseUrl,href){el.href=null==href?baseUrl:baseUrl+"/../"+href},GenericBrowserDomAdapter.prototype.supportsDOMEvents=function(){return!0},GenericBrowserDomAdapter.prototype.supportsNativeShadowDOM=function(){return"function"==typeof this.defaultDoc().body.createShadowRoot},GenericBrowserDomAdapter.prototype.getAnimationPrefix=function(){return this._animationPrefix?this._animationPrefix:""},GenericBrowserDomAdapter.prototype.getTransitionEnd=function(){return this._transitionEnd?this._transitionEnd:""},GenericBrowserDomAdapter.prototype.supportsAnimation=function(){return isPresent(this._animationPrefix)&&isPresent(this._transitionEnd)},GenericBrowserDomAdapter}(DomAdapter),__extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},_attrToPropMap={class:"className",innerHtml:"innerHTML",readonly:"readOnly",tabindex:"tabIndex"},DOM_KEY_LOCATION_NUMPAD=3,_keyMap={"\b":"Backspace","\t":"Tab","":"Delete","":"Escape",Del:"Delete",Esc:"Escape",Left:"ArrowLeft",Right:"ArrowRight",Up:"ArrowUp",Down:"ArrowDown",Menu:"ContextMenu",Scroll:"ScrollLock",Win:"OS"},_chromeNumKeyPadMap={A:"1",B:"2",C:"3",D:"4",E:"5",F:"6",G:"7",H:"8",I:"9",J:"*",K:"+",M:"-",N:".",O:"/","`":"0","":"NumLock"},BrowserDomAdapter=function(_super){function BrowserDomAdapter(){_super.apply(this,arguments)}return __extends(BrowserDomAdapter,_super),BrowserDomAdapter.prototype.parse=function(templateHtml){throw new Error("parse not implemented")},BrowserDomAdapter.makeCurrent=function(){setRootDomAdapter(new BrowserDomAdapter)},BrowserDomAdapter.prototype.hasProperty=function(element,name){return name in element},BrowserDomAdapter.prototype.setProperty=function(el,name,value){el[name]=value},BrowserDomAdapter.prototype.getProperty=function(el,name){return el[name]},BrowserDomAdapter.prototype.invoke=function(el,methodName,args){(_a=el)[methodName].apply(_a,args);var _a},BrowserDomAdapter.prototype.logError=function(error){window.console&&(console.error?console.error(error):console.log(error))},BrowserDomAdapter.prototype.log=function(error){window.console&&window.console.log&&window.console.log(error)},BrowserDomAdapter.prototype.logGroup=function(error){window.console&&window.console.group&&window.console.group(error)},BrowserDomAdapter.prototype.logGroupEnd=function(){window.console&&window.console.groupEnd&&window.console.groupEnd()},Object.defineProperty(BrowserDomAdapter.prototype,"attrToPropMap",{get:function(){return _attrToPropMap},enumerable:!0,configurable:!0}),BrowserDomAdapter.prototype.query=function(selector){return document.querySelector(selector)},BrowserDomAdapter.prototype.querySelector=function(el,selector){return el.querySelector(selector)},BrowserDomAdapter.prototype.querySelectorAll=function(el,selector){return el.querySelectorAll(selector)},BrowserDomAdapter.prototype.on=function(el,evt,listener){el.addEventListener(evt,listener,!1)},BrowserDomAdapter.prototype.onAndCancel=function(el,evt,listener){return el.addEventListener(evt,listener,!1),function(){el.removeEventListener(evt,listener,!1)}},BrowserDomAdapter.prototype.dispatchEvent=function(el,evt){el.dispatchEvent(evt)},BrowserDomAdapter.prototype.createMouseEvent=function(eventType){var evt=document.createEvent("MouseEvent");return evt.initEvent(eventType,!0,!0),evt},BrowserDomAdapter.prototype.createEvent=function(eventType){var evt=document.createEvent("Event");return evt.initEvent(eventType,!0,!0),evt},BrowserDomAdapter.prototype.preventDefault=function(evt){evt.preventDefault(),evt.returnValue=!1},BrowserDomAdapter.prototype.isPrevented=function(evt){return evt.defaultPrevented||isPresent(evt.returnValue)&&!evt.returnValue},BrowserDomAdapter.prototype.getInnerHTML=function(el){return el.innerHTML},BrowserDomAdapter.prototype.getTemplateContent=function(el){return"content"in el&&el instanceof HTMLTemplateElement?el.content:null},BrowserDomAdapter.prototype.getOuterHTML=function(el){return el.outerHTML},BrowserDomAdapter.prototype.nodeName=function(node){return node.nodeName},BrowserDomAdapter.prototype.nodeValue=function(node){return node.nodeValue},BrowserDomAdapter.prototype.type=function(node){return node.type},BrowserDomAdapter.prototype.content=function(node){return this.hasProperty(node,"content")?node.content:node},BrowserDomAdapter.prototype.firstChild=function(el){return el.firstChild},BrowserDomAdapter.prototype.nextSibling=function(el){return el.nextSibling},BrowserDomAdapter.prototype.parentElement=function(el){return el.parentNode},BrowserDomAdapter.prototype.childNodes=function(el){return el.childNodes},BrowserDomAdapter.prototype.childNodesAsList=function(el){for(var childNodes=el.childNodes,res=new Array(childNodes.length),i=0;i<childNodes.length;i++)res[i]=childNodes[i];return res},BrowserDomAdapter.prototype.clearNodes=function(el){for(;el.firstChild;)el.removeChild(el.firstChild)},BrowserDomAdapter.prototype.appendChild=function(el,node){el.appendChild(node)},BrowserDomAdapter.prototype.removeChild=function(el,node){el.removeChild(node)},BrowserDomAdapter.prototype.replaceChild=function(el,newChild,oldChild){el.replaceChild(newChild,oldChild)},BrowserDomAdapter.prototype.remove=function(node){return node.parentNode&&node.parentNode.removeChild(node),node},BrowserDomAdapter.prototype.insertBefore=function(el,node){el.parentNode.insertBefore(node,el)},BrowserDomAdapter.prototype.insertAllBefore=function(el,nodes){nodes.forEach(function(n){return el.parentNode.insertBefore(n,el)})},BrowserDomAdapter.prototype.insertAfter=function(el,node){el.parentNode.insertBefore(node,el.nextSibling)},BrowserDomAdapter.prototype.setInnerHTML=function(el,value){el.innerHTML=value},BrowserDomAdapter.prototype.getText=function(el){return el.textContent},BrowserDomAdapter.prototype.setText=function(el,value){el.textContent=value},BrowserDomAdapter.prototype.getValue=function(el){return el.value},BrowserDomAdapter.prototype.setValue=function(el,value){el.value=value},BrowserDomAdapter.prototype.getChecked=function(el){return el.checked},BrowserDomAdapter.prototype.setChecked=function(el,value){el.checked=value},BrowserDomAdapter.prototype.createComment=function(text){return document.createComment(text)},BrowserDomAdapter.prototype.createTemplate=function(html){var t=document.createElement("template");return t.innerHTML=html,t},BrowserDomAdapter.prototype.createElement=function(tagName,doc){return void 0===doc&&(doc=document),doc.createElement(tagName)},BrowserDomAdapter.prototype.createElementNS=function(ns,tagName,doc){return void 0===doc&&(doc=document),doc.createElementNS(ns,tagName)},BrowserDomAdapter.prototype.createTextNode=function(text,doc){return void 0===doc&&(doc=document),doc.createTextNode(text)},BrowserDomAdapter.prototype.createScriptTag=function(attrName,attrValue,doc){void 0===doc&&(doc=document);var el=doc.createElement("SCRIPT");return el.setAttribute(attrName,attrValue),el},BrowserDomAdapter.prototype.createStyleElement=function(css,doc){void 0===doc&&(doc=document);var style=doc.createElement("style");return this.appendChild(style,this.createTextNode(css)),style},BrowserDomAdapter.prototype.createShadowRoot=function(el){return el.createShadowRoot()},BrowserDomAdapter.prototype.getShadowRoot=function(el){return el.shadowRoot},BrowserDomAdapter.prototype.getHost=function(el){return el.host},BrowserDomAdapter.prototype.clone=function(node){return node.cloneNode(!0)},BrowserDomAdapter.prototype.getElementsByClassName=function(element,name){return element.getElementsByClassName(name)},BrowserDomAdapter.prototype.getElementsByTagName=function(element,name){return element.getElementsByTagName(name)},BrowserDomAdapter.prototype.classList=function(element){return Array.prototype.slice.call(element.classList,0)},BrowserDomAdapter.prototype.addClass=function(element,className){element.classList.add(className)},BrowserDomAdapter.prototype.removeClass=function(element,className){element.classList.remove(className)},BrowserDomAdapter.prototype.hasClass=function(element,className){return element.classList.contains(className)},BrowserDomAdapter.prototype.setStyle=function(element,styleName,styleValue){element.style[styleName]=styleValue},BrowserDomAdapter.prototype.removeStyle=function(element,stylename){element.style[stylename]=""},BrowserDomAdapter.prototype.getStyle=function(element,stylename){return element.style[stylename]},BrowserDomAdapter.prototype.hasStyle=function(element,styleName,styleValue){void 0===styleValue&&(styleValue=null);var value=this.getStyle(element,styleName)||"";return styleValue?value==styleValue:value.length>0},BrowserDomAdapter.prototype.tagName=function(element){return element.tagName},BrowserDomAdapter.prototype.attributeMap=function(element){for(var res=new Map,elAttrs=element.attributes,i=0;i<elAttrs.length;i++){var attrib=elAttrs[i];res.set(attrib.name,attrib.value)}return res},BrowserDomAdapter.prototype.hasAttribute=function(element,attribute){return element.hasAttribute(attribute)},BrowserDomAdapter.prototype.hasAttributeNS=function(element,ns,attribute){return element.hasAttributeNS(ns,attribute)},BrowserDomAdapter.prototype.getAttribute=function(element,attribute){return element.getAttribute(attribute)},BrowserDomAdapter.prototype.getAttributeNS=function(element,ns,name){return element.getAttributeNS(ns,name)},BrowserDomAdapter.prototype.setAttribute=function(element,name,value){element.setAttribute(name,value)},BrowserDomAdapter.prototype.setAttributeNS=function(element,ns,name,value){element.setAttributeNS(ns,name,value)},BrowserDomAdapter.prototype.removeAttribute=function(element,attribute){element.removeAttribute(attribute)},BrowserDomAdapter.prototype.removeAttributeNS=function(element,ns,name){element.removeAttributeNS(ns,name)},BrowserDomAdapter.prototype.templateAwareRoot=function(el){return this.isTemplateElement(el)?this.content(el):el},BrowserDomAdapter.prototype.createHtmlDocument=function(){return document.implementation.createHTMLDocument("fakeTitle")},BrowserDomAdapter.prototype.defaultDoc=function(){return document},BrowserDomAdapter.prototype.getBoundingClientRect=function(el){try{return el.getBoundingClientRect()}catch(e){return{top:0,bottom:0,left:0,right:0,width:0,height:0}}},BrowserDomAdapter.prototype.getTitle=function(){return document.title},BrowserDomAdapter.prototype.setTitle=function(newTitle){document.title=newTitle||""},BrowserDomAdapter.prototype.elementMatches=function(n,selector){return n instanceof HTMLElement&&(n.matches&&n.matches(selector)||n.msMatchesSelector&&n.msMatchesSelector(selector)||n.webkitMatchesSelector&&n.webkitMatchesSelector(selector))},BrowserDomAdapter.prototype.isTemplateElement=function(el){return el instanceof HTMLElement&&"TEMPLATE"==el.nodeName},BrowserDomAdapter.prototype.isTextNode=function(node){return node.nodeType===Node.TEXT_NODE},BrowserDomAdapter.prototype.isCommentNode=function(node){return node.nodeType===Node.COMMENT_NODE},BrowserDomAdapter.prototype.isElementNode=function(node){return node.nodeType===Node.ELEMENT_NODE},BrowserDomAdapter.prototype.hasShadowRoot=function(node){return isPresent(node.shadowRoot)&&node instanceof HTMLElement},BrowserDomAdapter.prototype.isShadowRoot=function(node){return node instanceof DocumentFragment},BrowserDomAdapter.prototype.importIntoDoc=function(node){return document.importNode(this.templateAwareRoot(node),!0)},BrowserDomAdapter.prototype.adoptNode=function(node){return document.adoptNode(node)},BrowserDomAdapter.prototype.getHref=function(el){return el.href},BrowserDomAdapter.prototype.getEventKey=function(event){var key=event.key;if(isBlank(key)){if(key=event.keyIdentifier,isBlank(key))return"Unidentified";key.startsWith("U+")&&(key=String.fromCharCode(parseInt(key.substring(2),16)),event.location===DOM_KEY_LOCATION_NUMPAD&&_chromeNumKeyPadMap.hasOwnProperty(key)&&(key=_chromeNumKeyPadMap[key]))}return _keyMap[key]||key},BrowserDomAdapter.prototype.getGlobalEventTarget=function(target){return"window"===target?window:"document"===target?document:"body"===target?document.body:void 0},BrowserDomAdapter.prototype.getHistory=function(){return window.history},BrowserDomAdapter.prototype.getLocation=function(){return window.location},BrowserDomAdapter.prototype.getBaseHref=function(){var href=getBaseElementHref();return isBlank(href)?null:relativePath(href)},BrowserDomAdapter.prototype.resetBaseElement=function(){baseElement=null},BrowserDomAdapter.prototype.getUserAgent=function(){return window.navigator.userAgent},BrowserDomAdapter.prototype.setData=function(element,name,value){this.setAttribute(element,"data-"+name,value)},BrowserDomAdapter.prototype.getData=function(element,name){return this.getAttribute(element,"data-"+name)},BrowserDomAdapter.prototype.getComputedStyle=function(element){return getComputedStyle(element)},BrowserDomAdapter.prototype.setGlobalVar=function(path,value){setValueOnPath(global$1,path,value)},BrowserDomAdapter.prototype.supportsWebAnimation=function(){return"function"==typeof Element.prototype.animate},BrowserDomAdapter.prototype.performanceNow=function(){return window.performance&&window.performance.now?window.performance.now():(new Date).getTime()},BrowserDomAdapter.prototype.supportsCookies=function(){return!0},BrowserDomAdapter.prototype.getCookie=function(name){return parseCookieValue(document.cookie,name)},BrowserDomAdapter.prototype.setCookie=function(name,value){document.cookie=encodeURIComponent(name)+"="+encodeURIComponent(value)},BrowserDomAdapter}(GenericBrowserDomAdapter),baseElement=null,__extends$2=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},BrowserPlatformLocation=function(_super){function BrowserPlatformLocation(){_super.call(this),this._init()}return __extends$2(BrowserPlatformLocation,_super),BrowserPlatformLocation.prototype._init=function(){this._location=getDOM().getLocation(),this._history=getDOM().getHistory()},Object.defineProperty(BrowserPlatformLocation.prototype,"location",{get:function(){return this._location},enumerable:!0,configurable:!0}),BrowserPlatformLocation.prototype.getBaseHrefFromDOM=function(){return getDOM().getBaseHref()},BrowserPlatformLocation.prototype.onPopState=function(fn){getDOM().getGlobalEventTarget("window").addEventListener("popstate",fn,!1)},BrowserPlatformLocation.prototype.onHashChange=function(fn){getDOM().getGlobalEventTarget("window").addEventListener("hashchange",fn,!1)},Object.defineProperty(BrowserPlatformLocation.prototype,"pathname",{get:function(){return this._location.pathname},set:function(newPath){this._location.pathname=newPath},enumerable:!0,configurable:!0}),Object.defineProperty(BrowserPlatformLocation.prototype,"search",{get:function(){return this._location.search},enumerable:!0,configurable:!0}),Object.defineProperty(BrowserPlatformLocation.prototype,"hash",{get:function(){return this._location.hash},enumerable:!0,configurable:!0}),BrowserPlatformLocation.prototype.pushState=function(state,title,url){supportsState()?this._history.pushState(state,title,url):this._location.hash=url},BrowserPlatformLocation.prototype.replaceState=function(state,title,url){supportsState()?this._history.replaceState(state,title,url):this._location.hash=url},BrowserPlatformLocation.prototype.forward=function(){this._history.forward()},BrowserPlatformLocation.prototype.back=function(){this._history.back()},BrowserPlatformLocation.decorators=[{type:core.Injectable}],BrowserPlatformLocation.ctorParameters=function(){return[]},BrowserPlatformLocation}(_angular_common.PlatformLocation),BrowserGetTestability=function(){function BrowserGetTestability(){}return BrowserGetTestability.init=function(){core.setTestabilityGetter(new BrowserGetTestability)},BrowserGetTestability.prototype.addToWindow=function(registry){global$1.getAngularTestability=function(elem,findInAncestors){void 0===findInAncestors&&(findInAncestors=!0);var testability=registry.findTestabilityInTree(elem,findInAncestors);if(null==testability)throw new Error("Could not find testability for element.");return testability},global$1.getAllAngularTestabilities=function(){return registry.getAllTestabilities()},global$1.getAllAngularRootElements=function(){return registry.getAllRootElements()};var whenAllStable=function(callback){var testabilities=global$1.getAllAngularTestabilities(),count=testabilities.length,didWork=!1,decrement=function(didWork_){didWork=didWork||didWork_,count--,0==count&&callback(didWork)};testabilities.forEach(function(testability){testability.whenStable(decrement)})};global$1.frameworkStabilizers||(global$1.frameworkStabilizers=[]),global$1.frameworkStabilizers.push(whenAllStable)},BrowserGetTestability.prototype.findTestabilityInTree=function(registry,elem,findInAncestors){if(null==elem)return null;var t=registry.getTestability(elem);return isPresent(t)?t:findInAncestors?getDOM().isShadowRoot(elem)?this.findTestabilityInTree(registry,getDOM().getHost(elem),!0):this.findTestabilityInTree(registry,getDOM().parentElement(elem),!0):null},BrowserGetTestability}(),Title=function(){function Title(){}return Title.prototype.getTitle=function(){return getDOM().getTitle()},Title.prototype.setTitle=function(newTitle){getDOM().setTitle(newTitle)},Title}(),StringMapWrapper=function(){function StringMapWrapper(){}return StringMapWrapper.merge=function(m1,m2){for(var m={},_i=0,_a=Object.keys(m1);_i<_a.length;_i++){var k=_a[_i];m[k]=m1[k]}for(var _b=0,_c=Object.keys(m2);_b<_c.length;_b++){var k=_c[_b];m[k]=m2[k]}return m},StringMapWrapper.equals=function(m1,m2){var k1=Object.keys(m1),k2=Object.keys(m2);if(k1.length!=k2.length)return!1;for(var i=0;i<k1.length;i++){var key=k1[i];if(m1[key]!==m2[key])return!1}return!0},StringMapWrapper}(),DOCUMENT=new core.OpaqueToken("DocumentToken"),EVENT_MANAGER_PLUGINS=new core.OpaqueToken("EventManagerPlugins"),EventManager=function(){function EventManager(plugins,_zone){var _this=this;this._zone=_zone,this._eventNameToPlugin=new Map,plugins.forEach(function(p){return p.manager=_this}),this._plugins=plugins.slice().reverse()}return EventManager.prototype.addEventListener=function(element,eventName,handler){var plugin=this._findPluginFor(eventName);return plugin.addEventListener(element,eventName,handler)},EventManager.prototype.addGlobalEventListener=function(target,eventName,handler){var plugin=this._findPluginFor(eventName);return plugin.addGlobalEventListener(target,eventName,handler)},EventManager.prototype.getZone=function(){return this._zone},EventManager.prototype._findPluginFor=function(eventName){var plugin=this._eventNameToPlugin.get(eventName);if(plugin)return plugin;for(var plugins=this._plugins,i=0;i<plugins.length;i++){var plugin_1=plugins[i];if(plugin_1.supports(eventName))return this._eventNameToPlugin.set(eventName,plugin_1),plugin_1}throw new Error("No event manager plugin found for event "+eventName)},EventManager.decorators=[{type:core.Injectable}],EventManager.ctorParameters=function(){return[{type:Array,decorators:[{type:core.Inject,args:[EVENT_MANAGER_PLUGINS]
}]},{type:core.NgZone}]},EventManager}(),EventManagerPlugin=function(){function EventManagerPlugin(){}return EventManagerPlugin.prototype.supports=function(eventName){},EventManagerPlugin.prototype.addEventListener=function(element,eventName,handler){},EventManagerPlugin.prototype.addGlobalEventListener=function(element,eventName,handler){var target=getDOM().getGlobalEventTarget(element);if(!target)throw new Error("Unsupported event target "+target+" for event "+eventName);return this.addEventListener(target,eventName,handler)},EventManagerPlugin}(),__extends$4=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},SharedStylesHost=function(){function SharedStylesHost(){this._styles=[],this._stylesSet=new Set}return SharedStylesHost.prototype.addStyles=function(styles){var _this=this,additions=[];styles.forEach(function(style){_this._stylesSet.has(style)||(_this._stylesSet.add(style),_this._styles.push(style),additions.push(style))}),this.onStylesAdded(additions)},SharedStylesHost.prototype.onStylesAdded=function(additions){},SharedStylesHost.prototype.getAllStyles=function(){return this._styles},SharedStylesHost.decorators=[{type:core.Injectable}],SharedStylesHost.ctorParameters=function(){return[]},SharedStylesHost}(),DomSharedStylesHost=function(_super){function DomSharedStylesHost(doc){_super.call(this),this._hostNodes=new Set,this._hostNodes.add(doc.head)}return __extends$4(DomSharedStylesHost,_super),DomSharedStylesHost.prototype._addStylesToHost=function(styles,host){for(var i=0;i<styles.length;i++){var styleEl=document.createElement("style");styleEl.textContent=styles[i],host.appendChild(styleEl)}},DomSharedStylesHost.prototype.addHost=function(hostNode){this._addStylesToHost(this._styles,hostNode),this._hostNodes.add(hostNode)},DomSharedStylesHost.prototype.removeHost=function(hostNode){this._hostNodes.delete(hostNode)},DomSharedStylesHost.prototype.onStylesAdded=function(additions){var _this=this;this._hostNodes.forEach(function(hostNode){_this._addStylesToHost(additions,hostNode)})},DomSharedStylesHost.decorators=[{type:core.Injectable}],DomSharedStylesHost.ctorParameters=function(){return[{type:void 0,decorators:[{type:core.Inject,args:[DOCUMENT]}]}]},DomSharedStylesHost}(SharedStylesHost),__extends$3=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},NAMESPACE_URIS={xlink:"http://www.w3.org/1999/xlink",svg:"http://www.w3.org/2000/svg",xhtml:"http://www.w3.org/1999/xhtml"},TEMPLATE_COMMENT_TEXT="template bindings={}",TEMPLATE_BINDINGS_EXP=/^template bindings=(.*)$/,DomRootRenderer=function(){function DomRootRenderer(document,eventManager,sharedStylesHost,animationDriver,appId){this.document=document,this.eventManager=eventManager,this.sharedStylesHost=sharedStylesHost,this.animationDriver=animationDriver,this.appId=appId,this.registeredComponents=new Map}return DomRootRenderer.prototype.renderComponent=function(componentProto){var renderer=this.registeredComponents.get(componentProto.id);return renderer||(renderer=new DomRenderer(this,componentProto,this.animationDriver,this.appId+"-"+componentProto.id),this.registeredComponents.set(componentProto.id,renderer)),renderer},DomRootRenderer}(),DomRootRenderer_=function(_super){function DomRootRenderer_(_document,_eventManager,sharedStylesHost,animationDriver,appId){_super.call(this,_document,_eventManager,sharedStylesHost,animationDriver,appId)}return __extends$3(DomRootRenderer_,_super),DomRootRenderer_.decorators=[{type:core.Injectable}],DomRootRenderer_.ctorParameters=function(){return[{type:void 0,decorators:[{type:core.Inject,args:[DOCUMENT]}]},{type:EventManager},{type:DomSharedStylesHost},{type:AnimationDriver},{type:void 0,decorators:[{type:core.Inject,args:[core.APP_ID]}]}]},DomRootRenderer_}(DomRootRenderer),DIRECT_DOM_RENDERER={remove:function(node){node.parentNode&&node.parentNode.removeChild(node)},appendChild:function(node,parent){parent.appendChild(node)},insertBefore:function(node,refNode){refNode.parentNode.insertBefore(node,refNode)},nextSibling:function(node){return node.nextSibling},parentElement:function(node){return node.parentNode}},DomRenderer=function(){function DomRenderer(_rootRenderer,componentProto,_animationDriver,styleShimId){this._rootRenderer=_rootRenderer,this.componentProto=componentProto,this._animationDriver=_animationDriver,this.directRenderer=DIRECT_DOM_RENDERER,this._styles=flattenStyles(styleShimId,componentProto.styles,[]),componentProto.encapsulation!==core.ViewEncapsulation.Native&&this._rootRenderer.sharedStylesHost.addStyles(this._styles),this.componentProto.encapsulation===core.ViewEncapsulation.Emulated?(this._contentAttr=shimContentAttribute(styleShimId),this._hostAttr=shimHostAttribute(styleShimId)):(this._contentAttr=null,this._hostAttr=null)}return DomRenderer.prototype.selectRootElement=function(selectorOrNode,debugInfo){var el;if("string"==typeof selectorOrNode){if(el=this._rootRenderer.document.querySelector(selectorOrNode),!el)throw new Error('The selector "'+selectorOrNode+'" did not match any elements')}else el=selectorOrNode;for(;el.firstChild;)el.removeChild(el.firstChild);return el},DomRenderer.prototype.createElement=function(parent,name,debugInfo){var el;if(isNamespaced(name)){var nsAndName=splitNamespace(name);el=document.createElementNS(NAMESPACE_URIS[nsAndName[0]],nsAndName[1])}else el=document.createElement(name);return this._contentAttr&&el.setAttribute(this._contentAttr,""),parent&&parent.appendChild(el),el},DomRenderer.prototype.createViewRoot=function(hostElement){var nodesParent;if(this.componentProto.encapsulation===core.ViewEncapsulation.Native){nodesParent=hostElement.createShadowRoot(),this._rootRenderer.sharedStylesHost.addHost(nodesParent);for(var i=0;i<this._styles.length;i++){var styleEl=document.createElement("style");styleEl.textContent=this._styles[i],nodesParent.appendChild(styleEl)}}else this._hostAttr&&hostElement.setAttribute(this._hostAttr,""),nodesParent=hostElement;return nodesParent},DomRenderer.prototype.createTemplateAnchor=function(parentElement,debugInfo){var comment=document.createComment(TEMPLATE_COMMENT_TEXT);return parentElement&&parentElement.appendChild(comment),comment},DomRenderer.prototype.createText=function(parentElement,value,debugInfo){var node=document.createTextNode(value);return parentElement&&parentElement.appendChild(node),node},DomRenderer.prototype.projectNodes=function(parentElement,nodes){parentElement&&appendNodes(parentElement,nodes)},DomRenderer.prototype.attachViewAfter=function(node,viewRootNodes){moveNodesAfterSibling(node,viewRootNodes)},DomRenderer.prototype.detachView=function(viewRootNodes){for(var i=0;i<viewRootNodes.length;i++){var node=viewRootNodes[i];node.parentNode&&node.parentNode.removeChild(node)}},DomRenderer.prototype.destroyView=function(hostElement,viewAllNodes){this.componentProto.encapsulation===core.ViewEncapsulation.Native&&hostElement&&this._rootRenderer.sharedStylesHost.removeHost(hostElement.shadowRoot)},DomRenderer.prototype.listen=function(renderElement,name,callback){return this._rootRenderer.eventManager.addEventListener(renderElement,name,decoratePreventDefault(callback))},DomRenderer.prototype.listenGlobal=function(target,name,callback){return this._rootRenderer.eventManager.addGlobalEventListener(target,name,decoratePreventDefault(callback))},DomRenderer.prototype.setElementProperty=function(renderElement,propertyName,propertyValue){renderElement[propertyName]=propertyValue},DomRenderer.prototype.setElementAttribute=function(renderElement,attributeName,attributeValue){var attrNs,attrNameWithoutNs=attributeName;if(isNamespaced(attributeName)){var nsAndName=splitNamespace(attributeName);attrNameWithoutNs=nsAndName[1],attributeName=nsAndName[0]+":"+nsAndName[1],attrNs=NAMESPACE_URIS[nsAndName[0]]}isPresent(attributeValue)?attrNs?renderElement.setAttributeNS(attrNs,attributeName,attributeValue):renderElement.setAttribute(attributeName,attributeValue):isPresent(attrNs)?renderElement.removeAttributeNS(attrNs,attrNameWithoutNs):renderElement.removeAttribute(attributeName)},DomRenderer.prototype.setBindingDebugInfo=function(renderElement,propertyName,propertyValue){if(renderElement.nodeType===Node.COMMENT_NODE){var existingBindings=renderElement.nodeValue.replace(/\n/g,"").match(TEMPLATE_BINDINGS_EXP),parsedBindings=JSON.parse(existingBindings[1]);parsedBindings[propertyName]=propertyValue,renderElement.nodeValue=TEMPLATE_COMMENT_TEXT.replace("{}",JSON.stringify(parsedBindings,null,2))}else this.setElementAttribute(renderElement,propertyName,propertyValue)},DomRenderer.prototype.setElementClass=function(renderElement,className,isAdd){isAdd?renderElement.classList.add(className):renderElement.classList.remove(className)},DomRenderer.prototype.setElementStyle=function(renderElement,styleName,styleValue){isPresent(styleValue)?renderElement.style[styleName]=stringify(styleValue):renderElement.style[styleName]=""},DomRenderer.prototype.invokeElementMethod=function(renderElement,methodName,args){renderElement[methodName].apply(renderElement,args)},DomRenderer.prototype.setText=function(renderNode,text){renderNode.nodeValue=text},DomRenderer.prototype.animate=function(element,startingStyles,keyframes,duration,delay,easing,previousPlayers){return void 0===previousPlayers&&(previousPlayers=[]),this._rootRenderer.document.body.contains(element)?this._animationDriver.animate(element,startingStyles,keyframes,duration,delay,easing,previousPlayers):new NoOpAnimationPlayer},DomRenderer}(),COMPONENT_REGEX=/%COMP%/g,COMPONENT_VARIABLE="%COMP%",HOST_ATTR="_nghost-"+COMPONENT_VARIABLE,CONTENT_ATTR="_ngcontent-"+COMPONENT_VARIABLE,NS_PREFIX_RE=/^:([^:]+):(.+)$/,CORE_TOKENS={ApplicationRef:core.ApplicationRef,NgZone:core.NgZone},INSPECT_GLOBAL_NAME="ng.probe",CORE_TOKENS_GLOBAL_NAME="ng.coreTokens",NgProbeToken=function(){function NgProbeToken(name,token){this.name=name,this.token=token}return NgProbeToken}(),ELEMENT_PROBE_PROVIDERS=[{provide:core.RootRenderer,useFactory:_createConditionalRootRenderer,deps:[DomRootRenderer,[NgProbeToken,new core.Optional],[core.NgProbeToken,new core.Optional]]}],__extends$5=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},DomEventsPlugin=function(_super){function DomEventsPlugin(){_super.apply(this,arguments)}return __extends$5(DomEventsPlugin,_super),DomEventsPlugin.prototype.supports=function(eventName){return!0},DomEventsPlugin.prototype.addEventListener=function(element,eventName,handler){return element.addEventListener(eventName,handler,!1),function(){return element.removeEventListener(eventName,handler,!1)}},DomEventsPlugin.decorators=[{type:core.Injectable}],DomEventsPlugin.ctorParameters=function(){return[]},DomEventsPlugin}(EventManagerPlugin),__extends$6=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},EVENT_NAMES={pan:!0,panstart:!0,panmove:!0,panend:!0,pancancel:!0,panleft:!0,panright:!0,panup:!0,pandown:!0,pinch:!0,pinchstart:!0,pinchmove:!0,pinchend:!0,pinchcancel:!0,pinchin:!0,pinchout:!0,press:!0,pressup:!0,rotate:!0,rotatestart:!0,rotatemove:!0,rotateend:!0,rotatecancel:!0,swipe:!0,swipeleft:!0,swiperight:!0,swipeup:!0,swipedown:!0,tap:!0},HAMMER_GESTURE_CONFIG=new core.OpaqueToken("HammerGestureConfig"),HammerGestureConfig=function(){function HammerGestureConfig(){this.events=[],this.overrides={}}return HammerGestureConfig.prototype.buildHammer=function(element){var mc=new Hammer(element);mc.get("pinch").set({enable:!0}),mc.get("rotate").set({enable:!0});for(var eventName in this.overrides)mc.get(eventName).set(this.overrides[eventName]);return mc},HammerGestureConfig.decorators=[{type:core.Injectable}],HammerGestureConfig.ctorParameters=function(){return[]},HammerGestureConfig}(),HammerGesturesPlugin=function(_super){function HammerGesturesPlugin(_config){_super.call(this),this._config=_config}return __extends$6(HammerGesturesPlugin,_super),HammerGesturesPlugin.prototype.supports=function(eventName){if(!EVENT_NAMES.hasOwnProperty(eventName.toLowerCase())&&!this.isCustomEvent(eventName))return!1;if(!window.Hammer)throw new Error("Hammer.js is not loaded, can not bind "+eventName+" event");return!0},HammerGesturesPlugin.prototype.addEventListener=function(element,eventName,handler){var _this=this,zone=this.manager.getZone();return eventName=eventName.toLowerCase(),zone.runOutsideAngular(function(){var mc=_this._config.buildHammer(element),callback=function(eventObj){zone.runGuarded(function(){handler(eventObj)})};return mc.on(eventName,callback),function(){return mc.off(eventName,callback)}})},HammerGesturesPlugin.prototype.isCustomEvent=function(eventName){return this._config.events.indexOf(eventName)>-1},HammerGesturesPlugin.decorators=[{type:core.Injectable}],HammerGesturesPlugin.ctorParameters=function(){return[{type:HammerGestureConfig,decorators:[{type:core.Inject,args:[HAMMER_GESTURE_CONFIG]}]}]},HammerGesturesPlugin}(EventManagerPlugin),__extends$7=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},MODIFIER_KEYS=["alt","control","meta","shift"],MODIFIER_KEY_GETTERS={alt:function(event){return event.altKey},control:function(event){return event.ctrlKey},meta:function(event){return event.metaKey},shift:function(event){return event.shiftKey}},KeyEventsPlugin=function(_super){function KeyEventsPlugin(){_super.call(this)}return __extends$7(KeyEventsPlugin,_super),KeyEventsPlugin.prototype.supports=function(eventName){return null!=KeyEventsPlugin.parseEventName(eventName)},KeyEventsPlugin.prototype.addEventListener=function(element,eventName,handler){var parsedEvent=KeyEventsPlugin.parseEventName(eventName),outsideHandler=KeyEventsPlugin.eventCallback(parsedEvent.fullKey,handler,this.manager.getZone());return this.manager.getZone().runOutsideAngular(function(){return getDOM().onAndCancel(element,parsedEvent.domEventName,outsideHandler)})},KeyEventsPlugin.parseEventName=function(eventName){var parts=eventName.toLowerCase().split("."),domEventName=parts.shift();if(0===parts.length||"keydown"!==domEventName&&"keyup"!==domEventName)return null;var key=KeyEventsPlugin._normalizeKey(parts.pop()),fullKey="";if(MODIFIER_KEYS.forEach(function(modifierName){var index=parts.indexOf(modifierName);index>-1&&(parts.splice(index,1),fullKey+=modifierName+".")}),fullKey+=key,0!=parts.length||0===key.length)return null;var result={};return result.domEventName=domEventName,result.fullKey=fullKey,result},KeyEventsPlugin.getEventFullKey=function(event){var fullKey="",key=getDOM().getEventKey(event);return key=key.toLowerCase()," "===key?key="space":"."===key&&(key="dot"),MODIFIER_KEYS.forEach(function(modifierName){if(modifierName!=key){var modifierGetter=MODIFIER_KEY_GETTERS[modifierName];modifierGetter(event)&&(fullKey+=modifierName+".")}}),fullKey+=key},KeyEventsPlugin.eventCallback=function(fullKey,handler,zone){return function(event){KeyEventsPlugin.getEventFullKey(event)===fullKey&&zone.runGuarded(function(){return handler(event)})}},KeyEventsPlugin._normalizeKey=function(keyName){switch(keyName){case"esc":return"escape";default:return keyName}},KeyEventsPlugin.decorators=[{type:core.Injectable}],KeyEventsPlugin.ctorParameters=function(){return[]},KeyEventsPlugin}(EventManagerPlugin),SAFE_URL_PATTERN=/^(?:(?:https?|mailto|ftp|tel|file):|[^&:\/?#]*(?:[\/?#]|$))/gi,DATA_URL_PATTERN=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[a-z0-9+\/]+=*$/i,inertElement=null,DOM=null,VOID_ELEMENTS=tagSet("area,br,col,hr,img,wbr"),OPTIONAL_END_TAG_BLOCK_ELEMENTS=tagSet("colgroup,dd,dt,li,p,tbody,td,tfoot,th,thead,tr"),OPTIONAL_END_TAG_INLINE_ELEMENTS=tagSet("rp,rt"),OPTIONAL_END_TAG_ELEMENTS=merge(OPTIONAL_END_TAG_INLINE_ELEMENTS,OPTIONAL_END_TAG_BLOCK_ELEMENTS),BLOCK_ELEMENTS=merge(OPTIONAL_END_TAG_BLOCK_ELEMENTS,tagSet("address,article,aside,blockquote,caption,center,del,details,dialog,dir,div,dl,figure,figcaption,footer,h1,h2,h3,h4,h5,h6,header,hgroup,hr,ins,main,map,menu,nav,ol,pre,section,summary,table,ul")),INLINE_ELEMENTS=merge(OPTIONAL_END_TAG_INLINE_ELEMENTS,tagSet("a,abbr,acronym,audio,b,bdi,bdo,big,br,cite,code,del,dfn,em,font,i,img,ins,kbd,label,map,mark,picture,q,ruby,rp,rt,s,samp,small,source,span,strike,strong,sub,sup,time,track,tt,u,var,video")),VALID_ELEMENTS=merge(VOID_ELEMENTS,BLOCK_ELEMENTS,INLINE_ELEMENTS,OPTIONAL_END_TAG_ELEMENTS),URI_ATTRS=tagSet("background,cite,href,itemtype,longdesc,poster,src,xlink:href"),SRCSET_ATTRS=tagSet("srcset"),HTML_ATTRS=tagSet("abbr,accesskey,align,alt,autoplay,axis,bgcolor,border,cellpadding,cellspacing,class,clear,color,cols,colspan,compact,controls,coords,datetime,default,dir,download,face,headers,height,hidden,hreflang,hspace,ismap,itemscope,itemprop,kind,label,lang,language,loop,media,muted,nohref,nowrap,open,preload,rel,rev,role,rows,rowspan,rules,scope,scrolling,shape,size,sizes,span,srclang,start,summary,tabindex,target,title,translate,type,usemap,valign,value,vspace,width"),VALID_ATTRS=merge(URI_ATTRS,SRCSET_ATTRS,HTML_ATTRS),SanitizingHtmlSerializer=function(){function SanitizingHtmlSerializer(){this.sanitizedSomething=!1,this.buf=[]}return SanitizingHtmlSerializer.prototype.sanitizeChildren=function(el){for(var current=el.firstChild;current;)if(DOM.isElementNode(current)?this.startElement(current):DOM.isTextNode(current)?this.chars(DOM.nodeValue(current)):this.sanitizedSomething=!0,DOM.firstChild(current))current=DOM.firstChild(current);else for(;current;){if(DOM.isElementNode(current)&&this.endElement(current),DOM.nextSibling(current)){current=DOM.nextSibling(current);break}current=DOM.parentElement(current)}return this.buf.join("")},SanitizingHtmlSerializer.prototype.startElement=function(element){var _this=this,tagName=DOM.nodeName(element).toLowerCase();return VALID_ELEMENTS.hasOwnProperty(tagName)?(this.buf.push("<"),this.buf.push(tagName),DOM.attributeMap(element).forEach(function(value,attrName){var lower=attrName.toLowerCase();return VALID_ATTRS.hasOwnProperty(lower)?(URI_ATTRS[lower]&&(value=sanitizeUrl(value)),SRCSET_ATTRS[lower]&&(value=sanitizeSrcset(value)),_this.buf.push(" "),_this.buf.push(attrName),_this.buf.push('="'),_this.buf.push(encodeEntities(value)),void _this.buf.push('"')):void(_this.sanitizedSomething=!0)}),void this.buf.push(">")):void(this.sanitizedSomething=!0)},SanitizingHtmlSerializer.prototype.endElement=function(current){var tagName=DOM.nodeName(current).toLowerCase();VALID_ELEMENTS.hasOwnProperty(tagName)&&!VOID_ELEMENTS.hasOwnProperty(tagName)&&(this.buf.push("</"),this.buf.push(tagName),this.buf.push(">"))},SanitizingHtmlSerializer.prototype.chars=function(chars){this.buf.push(encodeEntities(chars))},SanitizingHtmlSerializer}(),SURROGATE_PAIR_REGEXP=/[\uD800-\uDBFF][\uDC00-\uDFFF]/g,NON_ALPHANUMERIC_REGEXP=/([^\#-~ |!])/g,VALUES="[-,.\"'%_!# a-zA-Z0-9]+",TRANSFORMATION_FNS="(?:matrix|translate|scale|rotate|skew|perspective)(?:X|Y|3d)?",COLOR_FNS="(?:rgb|hsl)a?",GRADIENTS="(?:repeating-)?(?:linear|radial)-gradient",CSS3_FNS="(?:calc|attr)",FN_ARGS="\\([-0-9.%, #a-zA-Z]+\\)",SAFE_STYLE_VALUE=new RegExp("^("+VALUES+"|"+("(?:"+TRANSFORMATION_FNS+"|"+COLOR_FNS+"|"+GRADIENTS+"|"+CSS3_FNS+")")+(FN_ARGS+")$"),"g"),URL_RE=/^url\(([^)]+)\)$/,__extends$8=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},DomSanitizer=function(){function DomSanitizer(){}return DomSanitizer.prototype.sanitize=function(context,value){},DomSanitizer.prototype.bypassSecurityTrustHtml=function(value){},DomSanitizer.prototype.bypassSecurityTrustStyle=function(value){},DomSanitizer.prototype.bypassSecurityTrustScript=function(value){},DomSanitizer.prototype.bypassSecurityTrustUrl=function(value){},DomSanitizer.prototype.bypassSecurityTrustResourceUrl=function(value){},DomSanitizer}(),DomSanitizerImpl=function(_super){function DomSanitizerImpl(){_super.apply(this,arguments)}return __extends$8(DomSanitizerImpl,_super),DomSanitizerImpl.prototype.sanitize=function(ctx,value){if(null==value)return null;switch(ctx){case core.SecurityContext.NONE:return value;case core.SecurityContext.HTML:return value instanceof SafeHtmlImpl?value.changingThisBreaksApplicationSecurity:(this.checkNotSafeValue(value,"HTML"),sanitizeHtml(String(value)));case core.SecurityContext.STYLE:return value instanceof SafeStyleImpl?value.changingThisBreaksApplicationSecurity:(this.checkNotSafeValue(value,"Style"),sanitizeStyle(value));case core.SecurityContext.SCRIPT:if(value instanceof SafeScriptImpl)return value.changingThisBreaksApplicationSecurity;throw this.checkNotSafeValue(value,"Script"),new Error("unsafe value used in a script context");case core.SecurityContext.URL:return value instanceof SafeResourceUrlImpl||value instanceof SafeUrlImpl?value.changingThisBreaksApplicationSecurity:(this.checkNotSafeValue(value,"URL"),sanitizeUrl(String(value)));case core.SecurityContext.RESOURCE_URL:if(value instanceof SafeResourceUrlImpl)return value.changingThisBreaksApplicationSecurity;throw this.checkNotSafeValue(value,"ResourceURL"),new Error("unsafe value used in a resource URL context (see http://g.co/ng/security#xss)");default:throw new Error("Unexpected SecurityContext "+ctx+" (see http://g.co/ng/security#xss)")}},DomSanitizerImpl.prototype.checkNotSafeValue=function(value,expectedType){if(value instanceof SafeValueImpl)throw new Error("Required a safe "+expectedType+", got a "+value.getTypeName()+" (see http://g.co/ng/security#xss)")},DomSanitizerImpl.prototype.bypassSecurityTrustHtml=function(value){return new SafeHtmlImpl(value)},DomSanitizerImpl.prototype.bypassSecurityTrustStyle=function(value){return new SafeStyleImpl(value)},DomSanitizerImpl.prototype.bypassSecurityTrustScript=function(value){return new SafeScriptImpl(value)},DomSanitizerImpl.prototype.bypassSecurityTrustUrl=function(value){return new SafeUrlImpl(value)},DomSanitizerImpl.prototype.bypassSecurityTrustResourceUrl=function(value){return new SafeResourceUrlImpl(value)},DomSanitizerImpl.decorators=[{type:core.Injectable}],DomSanitizerImpl.ctorParameters=function(){return[]},DomSanitizerImpl}(DomSanitizer),SafeValueImpl=function(){function SafeValueImpl(changingThisBreaksApplicationSecurity){this.changingThisBreaksApplicationSecurity=changingThisBreaksApplicationSecurity}return SafeValueImpl.prototype.getTypeName=function(){},SafeValueImpl.prototype.toString=function(){return"SafeValue must use [property]=binding: "+this.changingThisBreaksApplicationSecurity+" (see http://g.co/ng/security#xss)"},SafeValueImpl}(),SafeHtmlImpl=function(_super){function SafeHtmlImpl(){_super.apply(this,arguments)}return __extends$8(SafeHtmlImpl,_super),SafeHtmlImpl.prototype.getTypeName=function(){return"HTML"},SafeHtmlImpl}(SafeValueImpl),SafeStyleImpl=function(_super){function SafeStyleImpl(){_super.apply(this,arguments)}return __extends$8(SafeStyleImpl,_super),SafeStyleImpl.prototype.getTypeName=function(){return"Style"},SafeStyleImpl}(SafeValueImpl),SafeScriptImpl=function(_super){function SafeScriptImpl(){_super.apply(this,arguments)}return __extends$8(SafeScriptImpl,_super),SafeScriptImpl.prototype.getTypeName=function(){return"Script"},SafeScriptImpl}(SafeValueImpl),SafeUrlImpl=function(_super){function SafeUrlImpl(){_super.apply(this,arguments)}return __extends$8(SafeUrlImpl,_super),SafeUrlImpl.prototype.getTypeName=function(){return"URL"},SafeUrlImpl}(SafeValueImpl),SafeResourceUrlImpl=function(_super){function SafeResourceUrlImpl(){_super.apply(this,arguments)}return __extends$8(SafeResourceUrlImpl,_super),SafeResourceUrlImpl.prototype.getTypeName=function(){return"ResourceURL"},SafeResourceUrlImpl}(SafeValueImpl),INTERNAL_BROWSER_PLATFORM_PROVIDERS=[{provide:core.PLATFORM_INITIALIZER,useValue:initDomAdapter,multi:!0},{provide:_angular_common.PlatformLocation,useClass:BrowserPlatformLocation}],BROWSER_SANITIZATION_PROVIDERS=[{provide:core.Sanitizer,useExisting:DomSanitizer},{provide:DomSanitizer,useClass:DomSanitizerImpl}],platformBrowser=core.createPlatformFactory(core.platformCore,"browser",INTERNAL_BROWSER_PLATFORM_PROVIDERS),BrowserModule=function(){function BrowserModule(parentModule){if(parentModule)throw new Error("BrowserModule has already been loaded. If you need access to common directives such as NgIf and NgFor from a lazy loaded module, import CommonModule instead.")}return BrowserModule.decorators=[{type:core.NgModule,args:[{providers:[BROWSER_SANITIZATION_PROVIDERS,{provide:core.ErrorHandler,useFactory:errorHandler,deps:[]},{provide:DOCUMENT,useFactory:_document,deps:[]},{provide:EVENT_MANAGER_PLUGINS,useClass:DomEventsPlugin,multi:!0},{provide:EVENT_MANAGER_PLUGINS,useClass:KeyEventsPlugin,multi:!0},{provide:EVENT_MANAGER_PLUGINS,useClass:HammerGesturesPlugin,multi:!0},{provide:HAMMER_GESTURE_CONFIG,useClass:HammerGestureConfig},{provide:DomRootRenderer,useClass:DomRootRenderer_},{provide:core.RootRenderer,useExisting:DomRootRenderer},{provide:SharedStylesHost,useExisting:DomSharedStylesHost},{provide:AnimationDriver,useFactory:_resolveDefaultAnimationDriver},DomSharedStylesHost,core.Testability,EventManager,ELEMENT_PROBE_PROVIDERS,Title],exports:[_angular_common.CommonModule,core.ApplicationModule]}]}],BrowserModule.ctorParameters=function(){return[{type:BrowserModule,decorators:[{type:core.Optional},{type:core.SkipSelf}]}]},BrowserModule}(),win="undefined"!=typeof window&&window||{},ChangeDetectionPerfRecord=function(){function ChangeDetectionPerfRecord(msPerTick,numTicks){this.msPerTick=msPerTick,this.numTicks=numTicks}return ChangeDetectionPerfRecord}(),AngularTools=function(){function AngularTools(ref){this.profiler=new AngularProfiler(ref)}return AngularTools}(),AngularProfiler=function(){function AngularProfiler(ref){this.appRef=ref.injector.get(core.ApplicationRef)}return AngularProfiler.prototype.timeChangeDetection=function(config){var record=config&&config.record,profileName="Change Detection",isProfilerAvailable=isPresent(win.console.profile);record&&isProfilerAvailable&&win.console.profile(profileName);for(var start=getDOM().performanceNow(),numTicks=0;numTicks<5||getDOM().performanceNow()-start<500;)this.appRef.tick(),numTicks++;var end=getDOM().performanceNow();record&&isProfilerAvailable&&win.console.profileEnd(profileName);var msPerTick=(end-start)/numTicks;return win.console.log("ran "+numTicks+" change detection cycles"),win.console.log(msPerTick.toFixed(2)+" ms per check"),new ChangeDetectionPerfRecord(msPerTick,numTicks)},AngularProfiler}(),context=global$1,By=function(){function By(){}return By.all=function(){return function(debugElement){return!0}},By.css=function(selector){return function(debugElement){return!!isPresent(debugElement.nativeElement)&&getDOM().elementMatches(debugElement.nativeElement,selector)}},By.directive=function(type){return function(debugElement){return debugElement.providerTokens.indexOf(type)!==-1}},By}(),__platform_browser_private__={BrowserPlatformLocation:BrowserPlatformLocation,DomAdapter:DomAdapter,BrowserDomAdapter:BrowserDomAdapter,BrowserGetTestability:BrowserGetTestability,getDOM:getDOM,setRootDomAdapter:setRootDomAdapter,DomRootRenderer_:DomRootRenderer_,DomRootRenderer:DomRootRenderer,NAMESPACE_URIS:NAMESPACE_URIS,shimContentAttribute:shimContentAttribute,shimHostAttribute:shimHostAttribute,flattenStyles:flattenStyles,splitNamespace:splitNamespace,isNamespaced:isNamespaced,DomSharedStylesHost:DomSharedStylesHost,SharedStylesHost:SharedStylesHost,ELEMENT_PROBE_PROVIDERS:ELEMENT_PROBE_PROVIDERS,DomEventsPlugin:DomEventsPlugin,KeyEventsPlugin:KeyEventsPlugin,HammerGesturesPlugin:HammerGesturesPlugin,initDomAdapter:initDomAdapter,INTERNAL_BROWSER_PLATFORM_PROVIDERS:INTERNAL_BROWSER_PLATFORM_PROVIDERS,BROWSER_SANITIZATION_PROVIDERS:BROWSER_SANITIZATION_PROVIDERS,WebAnimationsDriver:WebAnimationsDriver},VERSION=new core.Version("2.4.4");exports.BrowserModule=BrowserModule,exports.platformBrowser=platformBrowser,exports.Title=Title,exports.disableDebugTools=disableDebugTools,exports.enableDebugTools=enableDebugTools,exports.AnimationDriver=AnimationDriver,exports.By=By,exports.NgProbeToken=NgProbeToken,exports.DOCUMENT=DOCUMENT,exports.EVENT_MANAGER_PLUGINS=EVENT_MANAGER_PLUGINS,exports.EventManager=EventManager,exports.HAMMER_GESTURE_CONFIG=HAMMER_GESTURE_CONFIG,exports.HammerGestureConfig=HammerGestureConfig,exports.DomSanitizer=DomSanitizer,exports.VERSION=VERSION,exports.__platform_browser_private__=__platform_browser_private__});