import { DomAdapter } from '../dom/dom_adapter';
/**
 * Represents a meta element.
 *
 * @experimental
 */
export interface MetaDefinition {
    charset?: string;
    content?: string;
    httpEquiv?: string;
    id?: string;
    itemprop?: string;
    name?: string;
    property?: string;
    scheme?: string;
    url?: string;
    [prop: string]: string;
}
/**
 * A service that can be used to get and add meta tags.
 *
 * @experimental
 */
export declare class Meta {
    private _dom;
    constructor(_dom: DomAdapter);
    addTag(tag: MetaDefinition, forceCreation?: boolean): HTMLMetaElement;
    addTags(tags: MetaDefinition[], forceCreation?: boolean): HTMLMetaElement[];
    getTag(attrSelector: string): HTMLMetaElement;
    getTags(attrSelector: string): HTMLMetaElement[];
    updateTag(tag: MetaDefinition, selector?: string): HTMLMetaElement;
    removeTag(attrSelector: string): void;
    removeTagElement(meta: HTMLMetaElement): void;
    private _getOrCreateElement(meta, forceCreation?);
    private _setMetaElementAttributes(tag, el);
    private _parseSelector(tag);
    private _containsAttributes(tag, elem);
}
