/**
 * @license Angular v4.0.0-rc.1
 * (c) 2010-2017 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){if("function"==typeof define&&define.amd)define("@angular/platform-browser/animations",["exports","@angular/core","@angular/platform-browser","@angular/animations"],factory);else if("undefined"!=typeof exports)factory(exports,require("@angular/core"),require("@angular/platform-browser"),require("@angular/animations"));else{var mod={exports:{}};factory(mod.exports,global.ng.core,global.ng.platformBrowser,global.ng.animations),global.ng=global.ng||{},global.ng.platformBrowser=global.ng.platformBrowser||{},global.ng.platformBrowser.animations=mod.exports}}(this,function(exports,_core,_platformBrowser,_animations){"use strict";function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++)arr2[i]=arr[i];return arr2}return Array.from(arr)}function _possibleConstructorReturn(self,call){if(!self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!call||"object"!=typeof call&&"function"!=typeof call?self:call}function _inherits(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function, not "+typeof superClass);subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:!1,writable:!0,configurable:!0}}),superClass&&(Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function makeBooleanMap(keys){var map={};return keys.forEach(function(key){return map[key]=!0}),map}function dashCaseToCamelCase(input){return input.replace(DASH_CASE_REGEXP,function(){for(var _len=arguments.length,m=Array(_len),_key=0;_key<_len;_key++)m[_key]=arguments[_key];return m[1].toUpperCase()})}function resolveElementFromTarget(target){switch(target){case"body":return document.body;case"document":return document;case"window":return window;default:return target}}function parseTriggerCallbackName(triggerName){var dotIndex=triggerName.indexOf("."),trigger=triggerName.substring(0,dotIndex),phase=triggerName.substr(dotIndex+1);return[trigger,phase]}function namespaceify(namespaceId,value){return namespaceId+"#"+value}function deNamespaceify(namespaceId,value){return value.replace(namespaceId+"#","")}function parseTimeExpression(exp,errors){var regex=/^([\.\d]+)(m?s)(?:\s+([\.\d]+)(m?s))?(?:\s+([-a-z]+(?:\(.+?\))?))?$/i,duration=void 0,delay=0,easing=null;if("string"==typeof exp){var matches=exp.match(regex);if(null===matches)return errors.push('The provided timing value "'+exp+'" is invalid.'),{duration:0,delay:0,easing:null};var durationMatch=parseFloat(matches[1]),durationUnit=matches[2];"s"==durationUnit&&(durationMatch*=ONE_SECOND),duration=Math.floor(durationMatch);var delayMatch=matches[3],delayUnit=matches[4];if(null!=delayMatch){var delayVal=parseFloat(delayMatch);null!=delayUnit&&"s"==delayUnit&&(delayVal*=ONE_SECOND),delay=Math.floor(delayVal)}var easingVal=matches[5];easingVal&&(easing=easingVal)}else duration=exp;return{duration:duration,delay:delay,easing:easing}}function normalizeStyles(styles){var normalizedStyles={};return styles.forEach(function(data){return copyStyles(data,!1,normalizedStyles)}),normalizedStyles}function copyStyles(styles,readPrototype){var destination=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(readPrototype)for(var prop in styles)destination[prop]=styles[prop];else Object.keys(styles).forEach(function(prop){return destination[prop]=styles[prop]});return destination}function setStyles(element,styles){element.style&&Object.keys(styles).forEach(function(prop){return element.style[prop]=styles[prop]})}function eraseStyles(element,styles){element.style&&Object.keys(styles).forEach(function(prop){element.style[prop]=""})}function visitAnimationNode(visitor,node,context){switch(node.type){case 0:return visitor.visitState(node,context);case 1:return visitor.visitTransition(node,context);case 2:return visitor.visitSequence(node,context);case 3:return visitor.visitGroup(node,context);case 4:return visitor.visitAnimate(node,context);case 5:return visitor.visitKeyframeSequence(node,context);case 6:return visitor.visitStyle(node,context);default:throw new Error("Unable to resolve animation metadata node #"+node.type)}}function parseTransitionExpr(transitionValue,errors){var expressions=[];return"string"==typeof transitionValue?transitionValue.split(/\s*,\s*/).forEach(function(str){return parseInnerTransitionStr(str,expressions,errors)}):expressions.push(transitionValue),expressions}function parseInnerTransitionStr(eventStr,expressions,errors){":"==eventStr[0]&&(eventStr=parseAnimationAlias(eventStr,errors));var match=eventStr.match(/^(\*|[-\w]+)\s*(<?[=-]>)\s*(\*|[-\w]+)$/);if(null==match||match.length<4)return errors.push('The provided transition expression "'+eventStr+'" is not supported'),expressions;var fromState=match[1],separator=match[2],toState=match[3];expressions.push(makeLambdaFromStates(fromState,toState));var isFullAnyStateExpr=fromState==ANY_STATE&&toState==ANY_STATE;"<"!=separator[0]||isFullAnyStateExpr||expressions.push(makeLambdaFromStates(toState,fromState))}function parseAnimationAlias(alias,errors){switch(alias){case":enter":return"void => *";case":leave":return"* => void";default:return errors.push('The transition alias value "'+alias+'" is not supported'),"* => *"}}function makeLambdaFromStates(lhs,rhs){return function(fromState,toState){var lhsMatch=lhs==ANY_STATE||lhs==fromState,rhsMatch=rhs==ANY_STATE||rhs==toState;return lhsMatch&&rhsMatch}}function createTimelineInstruction(keyframes,duration,delay,easing){return{type:1,keyframes:keyframes,duration:duration,delay:delay,totalTime:duration+delay,easing:easing}}function buildAnimationKeyframes(ast){var startingStyles=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},finalStyles=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},normalizedAst=Array.isArray(ast)?(0,_animations.sequence)(ast):ast;return(new AnimationTimelineVisitor).buildKeyframes(normalizedAst,startingStyles,finalStyles)}function createTransitionInstruction(triggerName,fromState,toState,isRemovalTransition,fromStyles,toStyles,timelines){return{type:0,triggerName:triggerName,isRemovalTransition:isRemovalTransition,fromState:fromState,fromStyles:fromStyles,toState:toState,toStyles:toStyles,timelines:timelines}}function oneOrMoreTransitionsMatch(matchFns,currentState,nextState){return matchFns.some(function(fn){return fn(currentState,nextState)})}function validateAnimationSequence(ast){return(new AnimationValidatorVisitor).validate(ast)}function buildTrigger(name,definitions){return(new AnimationTriggerVisitor).buildTrigger(name,definitions)}function getOrSetAsInMap(map,key,defaultValue){var value=map.get(key);return value||map.set(key,value=defaultValue),value}function deleteFromArrayMap(map,key,value){var arr=map.get(key);if(arr){var index=arr.indexOf(value);index>=0&&(arr.splice(index,1),0==arr.length&&map.delete(key))}}function optimizeGroupPlayer(players){switch(players.length){case 0:return new _animations.NoopAnimationPlayer;case 1:return players[0];default:return new _animations.ɵAnimationGroupPlayer(players)}}function copyArray(source){return source?source.splice(0):[]}function validatePlayerEvent(triggerName,eventName){switch(eventName){case"start":case"done":return;default:throw new Error('The provided animation trigger event "'+eventName+'" for the animation trigger "'+triggerName+'" is not supported!')}}function listenOnPlayer(player,eventName,baseEvent,callback){switch(eventName){case"start":player.onStart(function(){var event=copyAnimationEvent(baseEvent);event.phaseName="start",callback(event)});break;case"done":player.onDone(function(){var event=copyAnimationEvent(baseEvent);event.phaseName="done",callback(event)})}}function copyAnimationEvent(e){return makeAnimationEvent(e.element,e.triggerName,e.fromState,e.toState,e.phaseName,e.totalTime)}function makeAnimationEvent(element,triggerName,fromState,toState,phaseName,totalTime){return{element:element,triggerName:triggerName,fromState:fromState,toState:toState,phaseName:phaseName,totalTime:totalTime}}function makeAnimationEvent$1(element,triggerName,fromState,toState,phaseName,totalTime){return{element:element,triggerName:triggerName,fromState:fromState,toState:toState,phaseName:phaseName,totalTime:totalTime}}function makeStorageProp(property){return"_@_"+property}function _computeStyle(element,prop){return window.getComputedStyle(element)[prop]}function _copyKeyframeStyles(styles){var newStyles={};return Object.keys(styles).forEach(function(prop){"offset"!=prop&&(newStyles[prop]=styles[prop])}),newStyles}function supportsWebAnimations(){return"undefined"!=typeof Element&&"function"==typeof Element.prototype.animate}function instantiateSupportedAnimationDriver(){return supportsWebAnimations()?new WebAnimationsDriver:new NoopAnimationDriver}function instantiateDefaultStyleNormalizer(){return new WebAnimationsStyleNormalizer}function instantiateRendererFactory(renderer,engine,zone){return new AnimationRendererFactory(renderer,engine,zone)}Object.defineProperty(exports,"__esModule",{value:!0}),exports.ɵh=exports.ɵb=exports.ɵd=exports.ɵc=exports.ɵa=exports.ɵf=exports.ɵe=exports.ɵg=exports.ɵDomAnimationEngine=exports.ɵAnimationRendererFactory=exports.ɵAnimationRenderer=exports.ɵNoopAnimationDriver=exports.ɵNoopAnimationStyleNormalizer=exports.ɵAnimationStyleNormalizer=exports.ɵAnimation=exports.ɵAnimationEngine=exports.AnimationDriver=exports.NoopAnimationsModule=exports.BrowserAnimationsModule=void 0;var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[],_n=!0,_d=!1,_e=void 0;try{for(var _s,_i=arr[Symbol.iterator]();!(_n=(_s=_i.next()).done)&&(_arr.push(_s.value),!i||_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err}finally{try{!_n&&_i.return&&_i.return()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr))return arr;if(Symbol.iterator in Object(arr))return sliceIterator(arr,i);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),_createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}(),AnimationEngine=function(){function AnimationEngine(){_classCallCheck(this,AnimationEngine)}return _createClass(AnimationEngine,[{key:"registerTrigger",value:function(trigger,name){}},{key:"onInsert",value:function(element,domFn){}},{key:"onRemove",value:function(element,domFn){}},{key:"setProperty",value:function(element,property,value){}},{key:"listen",value:function(element,eventName,eventPhase,callback){}},{key:"flush",value:function(){}},{key:"activePlayers",get:function(){throw new Error("...")}},{key:"queuedPlayers",get:function(){throw new Error("...")}}]),AnimationEngine}(),AnimationStyleNormalizer=function(){function AnimationStyleNormalizer(){_classCallCheck(this,AnimationStyleNormalizer)}return _createClass(AnimationStyleNormalizer,[{key:"normalizePropertyName",value:function(propertyName,errors){}},{key:"normalizeStyleValue",value:function(userProvidedProperty,normalizedProperty,value,errors){}}]),AnimationStyleNormalizer}(),NoopAnimationStyleNormalizer=function(){function NoopAnimationStyleNormalizer(){_classCallCheck(this,NoopAnimationStyleNormalizer)}return _createClass(NoopAnimationStyleNormalizer,[{key:"normalizePropertyName",value:function(propertyName,errors){return propertyName}},{key:"normalizeStyleValue",value:function(userProvidedProperty,normalizedProperty,value,errors){return value}}]),NoopAnimationStyleNormalizer}(),WebAnimationsStyleNormalizer=function(_AnimationStyleNormal){function WebAnimationsStyleNormalizer(){return _classCallCheck(this,WebAnimationsStyleNormalizer),_possibleConstructorReturn(this,(WebAnimationsStyleNormalizer.__proto__||Object.getPrototypeOf(WebAnimationsStyleNormalizer)).apply(this,arguments))}return _inherits(WebAnimationsStyleNormalizer,_AnimationStyleNormal),_createClass(WebAnimationsStyleNormalizer,[{key:"normalizePropertyName",value:function(propertyName,errors){return dashCaseToCamelCase(propertyName)}},{key:"normalizeStyleValue",value:function(userProvidedProperty,normalizedProperty,value,errors){var unit="",strVal=value.toString().trim();if(DIMENSIONAL_PROP_MAP[normalizedProperty]&&0!==value&&"0"!==value)if("number"==typeof value)unit="px";else{var valAndSuffixMatch=value.match(/^[+-]?[\d\.]+([a-z]*)$/);valAndSuffixMatch&&0==valAndSuffixMatch[1].length&&errors.push("Please provide a CSS unit value for "+userProvidedProperty+":"+value)}return strVal+unit}}]),WebAnimationsStyleNormalizer}(AnimationStyleNormalizer),DIMENSIONAL_PROP_MAP=makeBooleanMap("width,height,minWidth,minHeight,maxWidth,maxHeight,left,top,bottom,right,fontSize,outlineWidth,outlineOffset,paddingTop,paddingLeft,paddingBottom,paddingRight,marginTop,marginLeft,marginBottom,marginRight,borderRadius,borderWidth,borderTopWidth,borderLeftWidth,borderRightWidth,borderBottomWidth,textIndent".split(",")),DASH_CASE_REGEXP=/-+([a-z0-9])/g,NoopAnimationDriver=function(){function NoopAnimationDriver(){_classCallCheck(this,NoopAnimationDriver)}return _createClass(NoopAnimationDriver,[{key:"animate",value:function(element,keyframes,duration,delay,easing){arguments.length>5&&void 0!==arguments[5]?arguments[5]:[];return new _animations.NoopAnimationPlayer}}]),NoopAnimationDriver}(),AnimationDriver=function AnimationDriver(){_classCallCheck(this,AnimationDriver)};AnimationDriver.NOOP=new NoopAnimationDriver;var AnimationRendererFactory=function(){function AnimationRendererFactory(delegate,_engine,_zone){_classCallCheck(this,AnimationRendererFactory),this.delegate=delegate,this._engine=_engine,this._zone=_zone}return _createClass(AnimationRendererFactory,[{key:"createRenderer",value:function(hostElement,type){var _this2=this,delegate=this.delegate.createRenderer(hostElement,type);if(!(hostElement&&type&&type.data&&type.data.animation))return delegate;var namespaceId=type.id,animationTriggers=type.data.animation;return animationTriggers.forEach(function(trigger){return _this2._engine.registerTrigger(trigger,namespaceify(namespaceId,trigger.name))}),new AnimationRenderer(delegate,this._engine,this._zone,namespaceId)}}]),AnimationRendererFactory}();AnimationRendererFactory.decorators=[{type:_core.Injectable}],AnimationRendererFactory.ctorParameters=function(){return[{type:_core.RendererFactoryV2},{type:AnimationEngine},{type:_core.NgZone}]};var AnimationRenderer=function(){function AnimationRenderer(delegate,_engine,_zone,_namespaceId){_classCallCheck(this,AnimationRenderer),this.delegate=delegate,this._engine=_engine,this._zone=_zone,this._namespaceId=_namespaceId,this.destroyNode=null,this._flushPromise=null,this.destroyNode=this.delegate.destroyNode?function(n){return delegate.destroyNode(n)}:null}return _createClass(AnimationRenderer,[{key:"destroy",value:function(){this.delegate.destroy()}},{key:"createElement",value:function(name,namespace){return this.delegate.createElement(name,namespace)}},{key:"createComment",value:function(value){return this.delegate.createComment(value)}},{key:"createText",value:function(value){return this.delegate.createText(value)}},{key:"selectRootElement",value:function(selectorOrNode){return this.delegate.selectRootElement(selectorOrNode)}},{key:"parentNode",value:function(node){return this.delegate.parentNode(node)}},{key:"nextSibling",value:function(node){return this.delegate.nextSibling(node)}},{key:"setAttribute",value:function(el,name,value,namespace){this.delegate.setAttribute(el,name,value,namespace)}},{key:"removeAttribute",value:function(el,name,namespace){this.delegate.removeAttribute(el,name,namespace)}},{key:"addClass",value:function(el,name){this.delegate.addClass(el,name)}},{key:"removeClass",value:function(el,name){this.delegate.removeClass(el,name)}},{key:"setStyle",value:function(el,style,value,hasVendorPrefix,hasImportant){this.delegate.setStyle(el,style,value,hasVendorPrefix,hasImportant)}},{key:"removeStyle",value:function(el,style,hasVendorPrefix){this.delegate.removeStyle(el,style,hasVendorPrefix)}},{key:"setValue",value:function(node,value){this.delegate.setValue(node,value)}},{key:"appendChild",value:function(parent,newChild){var _this3=this;this._engine.onInsert(newChild,function(){return _this3.delegate.appendChild(parent,newChild)}),this._queueFlush()}},{key:"insertBefore",value:function(parent,newChild,refChild){var _this4=this;this._engine.onInsert(newChild,function(){return _this4.delegate.insertBefore(parent,newChild,refChild)}),this._queueFlush()}},{key:"removeChild",value:function(parent,oldChild){var _this5=this;this._engine.onRemove(oldChild,function(){return _this5.delegate.removeChild(parent,oldChild)}),this._queueFlush()}},{key:"setProperty",value:function(el,name,value){"@"==name.charAt(0)?(this._engine.setProperty(el,namespaceify(this._namespaceId,name.substr(1)),value),this._queueFlush()):this.delegate.setProperty(el,name,value)}},{key:"listen",value:function(target,eventName,callback){var _this6=this;if("@"==eventName.charAt(0)){var element=resolveElementFromTarget(target),_parseTriggerCallback=parseTriggerCallbackName(eventName.substr(1)),_parseTriggerCallback2=_slicedToArray(_parseTriggerCallback,2),name=_parseTriggerCallback2[0],phase=_parseTriggerCallback2[1];return this._engine.listen(element,namespaceify(this._namespaceId,name),phase,function(event){var e=event;e.triggerName&&(e.triggerName=deNamespaceify(_this6._namespaceId,e.triggerName)),_this6._zone.run(function(){return callback(event)})})}return this.delegate.listen(target,eventName,callback)}},{key:"_queueFlush",value:function(){var _this7=this;this._flushPromise||this._zone.runOutsideAngular(function(){_this7._flushPromise=Promise.resolve(null).then(function(){_this7._flushPromise=null,_this7._engine.flush()})})}},{key:"data",get:function(){return this.delegate.data}}]),AnimationRenderer}(),ONE_SECOND=1e3,ANY_STATE="*",AnimationTimelineContext=function(){function AnimationTimelineContext(errors,timelines){var initialTimeline=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;_classCallCheck(this,AnimationTimelineContext),this.errors=errors,this.timelines=timelines,this.previousNode={},this.subContextCount=0,this.currentTimeline=initialTimeline||new TimelineBuilder(0),timelines.push(this.currentTimeline)}return _createClass(AnimationTimelineContext,[{key:"createSubContext",value:function(){var context=new AnimationTimelineContext(this.errors,this.timelines,this.currentTimeline.fork());return context.previousNode=this.previousNode,context.currentAnimateTimings=this.currentAnimateTimings,this.subContextCount++,context}},{key:"transformIntoNewTimeline",value:function(){var newTime=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;return this.currentTimeline=this.currentTimeline.fork(newTime),this.timelines.push(this.currentTimeline),this.currentTimeline}},{key:"incrementTime",value:function(time){this.currentTimeline.forwardTime(this.currentTimeline.duration+time)}}]),AnimationTimelineContext}(),AnimationTimelineVisitor=function(){function AnimationTimelineVisitor(){_classCallCheck(this,AnimationTimelineVisitor)}return _createClass(AnimationTimelineVisitor,[{key:"buildKeyframes",value:function(ast,startingStyles,finalStyles){var context=new AnimationTimelineContext([],[]);context.currentTimeline.setStyles(startingStyles),visitAnimationNode(this,ast,context);var normalizedFinalStyles=copyStyles(finalStyles,!0);0==Object.keys(context.currentTimeline.getFinalKeyframe()).length&&context.currentTimeline.properties.forEach(function(prop){var val=normalizedFinalStyles[prop];null==val&&(normalizedFinalStyles[prop]=_animations.AUTO_STYLE)}),context.currentTimeline.setStyles(normalizedFinalStyles);var timelineInstructions=[];return context.timelines.forEach(function(timeline){timeline.hasStyling()&&timelineInstructions.push(timeline.buildKeyframes())}),0==timelineInstructions.length&&timelineInstructions.push(createTimelineInstruction([],0,0,"")),timelineInstructions}},{key:"visitState",value:function(ast,context){}},{key:"visitTransition",value:function(ast,context){}},{key:"visitSequence",value:function(ast,context){var _this8=this,subContextCount=context.subContextCount;6==context.previousNode.type&&(context.currentTimeline.forwardFrame(),context.currentTimeline.snapshotCurrentStyles()),ast.steps.forEach(function(s){return visitAnimationNode(_this8,s,context)}),context.subContextCount>subContextCount&&context.transformIntoNewTimeline(),context.previousNode=ast}},{key:"visitGroup",value:function(ast,context){var _this9=this,innerTimelines=[],furthestTime=context.currentTimeline.currentTime;ast.steps.forEach(function(s){var innerContext=context.createSubContext();visitAnimationNode(_this9,s,innerContext),furthestTime=Math.max(furthestTime,innerContext.currentTimeline.currentTime),innerTimelines.push(innerContext.currentTimeline)}),innerTimelines.forEach(function(timeline){return context.currentTimeline.mergeTimelineCollectedStyles(timeline)}),context.transformIntoNewTimeline(furthestTime),context.previousNode=ast}},{key:"visitAnimate",value:function(ast,context){var timings=ast.timings.hasOwnProperty("duration")?ast.timings:parseTimeExpression(ast.timings,context.errors);context.currentAnimateTimings=timings,timings.delay&&(context.incrementTime(timings.delay),context.currentTimeline.snapshotCurrentStyles());var astType=ast.styles?ast.styles.type:-1;5==astType?this.visitKeyframeSequence(ast.styles,context):(context.incrementTime(timings.duration),6==astType&&this.visitStyle(ast.styles,context)),context.currentAnimateTimings=null,context.previousNode=ast}},{key:"visitStyle",value:function(ast,context){context.currentAnimateTimings||4!=context.previousNode.type||context.currentTimeline.forwardFrame();var normalizedStyles=normalizeStyles(ast.styles),easing=context.currentAnimateTimings&&context.currentAnimateTimings.easing;easing&&(normalizedStyles.easing=easing),context.currentTimeline.setStyles(normalizedStyles),context.previousNode=ast}},{key:"visitKeyframeSequence",value:function(ast,context){var MAX_KEYFRAME_OFFSET=1,limit=ast.steps.length-1,firstKeyframe=ast.steps[0],offsetGap=0,containsOffsets=firstKeyframe.styles.find(function(styles){return styles.offset>=0});containsOffsets||(offsetGap=MAX_KEYFRAME_OFFSET/limit);var startTime=context.currentTimeline.duration,duration=context.currentAnimateTimings.duration,innerContext=context.createSubContext(),innerTimeline=innerContext.currentTimeline;innerTimeline.easing=context.currentAnimateTimings.easing,ast.steps.forEach(function(step,i){var normalizedStyles=normalizeStyles(step.styles),offset=containsOffsets?normalizedStyles.offset:i==limit?MAX_KEYFRAME_OFFSET:i*offsetGap;innerTimeline.forwardTime(offset*duration),innerTimeline.setStyles(normalizedStyles)}),context.currentTimeline.mergeTimelineCollectedStyles(innerTimeline),context.transformIntoNewTimeline(startTime+duration),context.previousNode=ast}}]),AnimationTimelineVisitor}(),TimelineBuilder=function(){function TimelineBuilder(startTime){var _globalTimelineStyles=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;_classCallCheck(this,TimelineBuilder),this.startTime=startTime,this._globalTimelineStyles=_globalTimelineStyles,this.duration=0,this.easing="",this._keyframes=new Map,this._styleSummary={},this._backFill={},this._localTimelineStyles=Object.create(this._backFill,{}),this._globalTimelineStyles||(this._globalTimelineStyles=this._localTimelineStyles),this._loadKeyframe()}return _createClass(TimelineBuilder,[{key:"hasStyling",value:function(){return this._keyframes.size>1}},{key:"fork",value:function(){var currentTime=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;return new TimelineBuilder(currentTime||this.currentTime,this._globalTimelineStyles)}},{key:"_loadKeyframe",value:function(){this._currentKeyframe=this._keyframes.get(this.duration),this._currentKeyframe||(this._currentKeyframe=Object.create(this._backFill,{}),this._keyframes.set(this.duration,this._currentKeyframe))}},{key:"forwardFrame",value:function(){this.duration++,this._loadKeyframe()}},{key:"forwardTime",value:function(time){this.duration=time,this._loadKeyframe()}},{key:"_updateStyle",value:function(prop,value){"easing"!=prop&&(this._localTimelineStyles[prop]=value,this._globalTimelineStyles[prop]=value,this._styleSummary[prop]={time:this.currentTime,value:value})}},{key:"setStyles",value:function(styles){var _this10=this;Object.keys(styles).forEach(function(prop){if("offset"!==prop){var val=styles[prop];_this10._currentKeyframe[prop]=val,"easing"===prop||_this10._localTimelineStyles[prop]||(_this10._backFill[prop]=_this10._globalTimelineStyles[prop]||_animations.AUTO_STYLE),_this10._updateStyle(prop,val)}}),Object.keys(this._localTimelineStyles).forEach(function(prop){_this10._currentKeyframe.hasOwnProperty(prop)||(_this10._currentKeyframe[prop]=_this10._localTimelineStyles[prop])})}},{key:"snapshotCurrentStyles",value:function(){copyStyles(this._localTimelineStyles,!1,this._currentKeyframe)}},{key:"getFinalKeyframe",value:function(){return this._keyframes.get(this.duration)}},{key:"mergeTimelineCollectedStyles",value:function(timeline){var _this11=this;Object.keys(timeline._styleSummary).forEach(function(prop){var details0=_this11._styleSummary[prop],details1=timeline._styleSummary[prop];(!details0||details1.time>details0.time)&&_this11._updateStyle(prop,details1.value)})}},{key:"buildKeyframes",value:function(){var _this12=this,finalKeyframes=[];if(0==this.duration){var targetKeyframe=this.getFinalKeyframe(),firstKeyframe=copyStyles(targetKeyframe,!0);firstKeyframe.offset=0,finalKeyframes.push(firstKeyframe);var lastKeyframe=copyStyles(targetKeyframe,!0);lastKeyframe.offset=1,finalKeyframes.push(lastKeyframe)}else this._keyframes.forEach(function(keyframe,time){var finalKeyframe=copyStyles(keyframe,!0);finalKeyframe.offset=time/_this12.duration,finalKeyframes.push(finalKeyframe)});return createTimelineInstruction(finalKeyframes,this.duration,this.startTime,this.easing)}},{key:"currentTime",get:function(){return this.startTime+this.duration}},{key:"properties",get:function(){var properties=[];for(var prop in this._currentKeyframe)properties.push(prop);return properties}}]),TimelineBuilder}(),AnimationTransitionFactory=function(){function AnimationTransitionFactory(_triggerName,ast,matchFns,_stateStyles){_classCallCheck(this,AnimationTransitionFactory),this._triggerName=_triggerName,this.matchFns=matchFns,this._stateStyles=_stateStyles,this._animationAst=ast.animation}return _createClass(AnimationTransitionFactory,[{key:"match",value:function(currentState,nextState){if(oneOrMoreTransitionsMatch(this.matchFns,currentState,nextState)){var backupStateStyles=this._stateStyles["*"]||{},currentStateStyles=this._stateStyles[currentState]||backupStateStyles,nextStateStyles=this._stateStyles[nextState]||backupStateStyles,timelines=buildAnimationKeyframes(this._animationAst,currentStateStyles,nextStateStyles);return createTransitionInstruction(this._triggerName,currentState,nextState,"void"===nextState,currentStateStyles,nextStateStyles,timelines)}}}]),AnimationTransitionFactory}(),AnimationValidatorVisitor=function(){function AnimationValidatorVisitor(){_classCallCheck(this,AnimationValidatorVisitor)}return _createClass(AnimationValidatorVisitor,[{key:"validate",value:function(ast){var context=new AnimationValidatorContext;return visitAnimationNode(this,ast,context),context.errors}},{key:"visitState",value:function(ast,context){}},{key:"visitTransition",value:function(ast,context){}},{key:"visitSequence",value:function(ast,context){var _this13=this;ast.steps.forEach(function(step){return visitAnimationNode(_this13,step,context)})}},{key:"visitGroup",value:function(ast,context){var _this14=this,currentTime=context.currentTime,furthestTime=0;ast.steps.forEach(function(step){context.currentTime=currentTime,visitAnimationNode(_this14,step,context),furthestTime=Math.max(furthestTime,context.currentTime)}),context.currentTime=furthestTime}},{key:"visitAnimate",value:function(ast,context){context.currentAnimateTimings=ast.timings=parseTimeExpression(ast.timings,context.errors);var astType=ast.styles&&ast.styles.type;5==astType?this.visitKeyframeSequence(ast.styles,context):(context.currentTime+=context.currentAnimateTimings.duration+context.currentAnimateTimings.delay,6==astType&&this.visitStyle(ast.styles,context)),context.currentAnimateTimings=null}},{key:"visitStyle",value:function(ast,context){var styleData=normalizeStyles(ast.styles),timings=context.currentAnimateTimings,endTime=context.currentTime,startTime=context.currentTime;timings&&startTime>0&&(startTime-=timings.duration+timings.delay),Object.keys(styleData).forEach(function(prop){var collectedEntry=context.collectedStyles[prop],updateCollectedStyle=!0;collectedEntry&&(startTime!=endTime&&startTime>=collectedEntry.startTime&&endTime<=collectedEntry.endTime&&(context.errors.push('The CSS property "'+prop+'" that exists between the times of "'+collectedEntry.startTime+'ms" and "'+collectedEntry.endTime+'ms" is also being animated in a parallel animation between the times of "'+startTime+'ms" and "'+endTime+'ms"'),updateCollectedStyle=!1),startTime=collectedEntry.startTime),updateCollectedStyle&&(context.collectedStyles[prop]={startTime:startTime,endTime:endTime})})}},{key:"visitKeyframeSequence",value:function(ast,context){var _this15=this,totalKeyframesWithOffsets=0,offsets=[],offsetsOutOfOrder=!1,keyframesOutOfRange=!1,previousOffset=0;ast.steps.forEach(function(step){var styleData=normalizeStyles(step.styles),offset=0;styleData.hasOwnProperty("offset")&&(totalKeyframesWithOffsets++,offset=styleData.offset),keyframesOutOfRange=keyframesOutOfRange||offset<0||offset>1,offsetsOutOfOrder=offsetsOutOfOrder||offset<previousOffset,previousOffset=offset,offsets.push(offset)}),keyframesOutOfRange&&context.errors.push("Please ensure that all keyframe offsets are between 0 and 1"),offsetsOutOfOrder&&context.errors.push("Please ensure that all keyframe offsets are in order");var length=ast.steps.length,generatedOffset=0;totalKeyframesWithOffsets>0&&totalKeyframesWithOffsets<length?context.errors.push("Not all style() steps within the declared keyframes() contain offsets"):0==totalKeyframesWithOffsets&&(generatedOffset=1/length);var limit=length-1,currentTime=context.currentTime,animateDuration=context.currentAnimateTimings.duration;ast.steps.forEach(function(step,i){var offset=generatedOffset>0?i==limit?1:generatedOffset*i:offsets[i],durationUpToThisFrame=offset*animateDuration;context.currentTime=currentTime+context.currentAnimateTimings.delay+durationUpToThisFrame,context.currentAnimateTimings.duration=durationUpToThisFrame,_this15.visitStyle(step,context)})}}]),AnimationValidatorVisitor}(),AnimationValidatorContext=function AnimationValidatorContext(){_classCallCheck(this,AnimationValidatorContext),this.errors=[],this.currentTime=0,this.collectedStyles={}},AnimationTrigger=function(){function AnimationTrigger(name,states,_transitionAsts){var _this16=this;_classCallCheck(this,AnimationTrigger),this.name=name,this._transitionAsts=_transitionAsts,this.transitionFactories=[],this.states={},Object.keys(states).forEach(function(stateName){_this16.states[stateName]=copyStyles(states[stateName],!1)});var errors=[];if(_transitionAsts.forEach(function(ast){var exprs=parseTransitionExpr(ast.expr,errors),sequenceErrors=validateAnimationSequence(ast);sequenceErrors.length?errors.push.apply(errors,_toConsumableArray(sequenceErrors)):_this16.transitionFactories.push(new AnimationTransitionFactory(_this16.name,ast,exprs,states));
}),errors.length){var LINE_START="\n - ";throw new Error("Animation parsing for the "+name+" trigger have failed:"+LINE_START+errors.join(LINE_START))}}return _createClass(AnimationTrigger,[{key:"createFallbackInstruction",value:function(currentState,nextState){var backupStateStyles=this.states["*"]||{},currentStateStyles=this.states[currentState]||backupStateStyles,nextStateStyles=this.states[nextState]||backupStateStyles;return createTransitionInstruction(this.name,currentState,nextState,"void"==nextState,currentStateStyles,nextStateStyles,[])}},{key:"matchTransition",value:function(currentState,nextState){for(var i=0;i<this.transitionFactories.length;i++){var result=this.transitionFactories[i].match(currentState,nextState);if(result)return result}}}]),AnimationTrigger}(),AnimationTriggerContext=function AnimationTriggerContext(){_classCallCheck(this,AnimationTriggerContext),this.errors=[],this.states={},this.transitions=[]},AnimationTriggerVisitor=function(){function AnimationTriggerVisitor(){_classCallCheck(this,AnimationTriggerVisitor)}return _createClass(AnimationTriggerVisitor,[{key:"buildTrigger",value:function(name,definitions){var _this17=this,context=new AnimationTriggerContext;return definitions.forEach(function(def){return visitAnimationNode(_this17,def,context)}),new AnimationTrigger(name,context.states,context.transitions)}},{key:"visitState",value:function(ast,context){context.states[ast.name]=normalizeStyles(ast.styles.styles)}},{key:"visitTransition",value:function(ast,context){context.transitions.push(ast)}},{key:"visitSequence",value:function(ast,context){}},{key:"visitGroup",value:function(ast,context){}},{key:"visitAnimate",value:function(ast,context){}},{key:"visitStyle",value:function(ast,context){}},{key:"visitKeyframeSequence",value:function(ast,context){}}]),AnimationTriggerVisitor}(),MARKED_FOR_ANIMATION="ng-animate",MARKED_FOR_REMOVAL="$$ngRemove",DomAnimationEngine=function(){function DomAnimationEngine(_driver,_normalizer){_classCallCheck(this,DomAnimationEngine),this._driver=_driver,this._normalizer=_normalizer,this._flaggedInserts=new Set,this._queuedRemovals=new Map,this._queuedTransitionAnimations=[],this._activeTransitionAnimations=new Map,this._activeElementAnimations=new Map,this._elementTriggerStates=new Map,this._triggers=Object.create(null),this._triggerListeners=new Map}return _createClass(DomAnimationEngine,[{key:"registerTrigger",value:function(trigger){var name=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;name=name||trigger.name,this._triggers[name]||(this._triggers[name]=buildTrigger(name,trigger.definitions))}},{key:"onInsert",value:function(element,domFn){this._flaggedInserts.add(element),domFn()}},{key:"onRemove",value:function(element,domFn){var _this18=this,lookupRef=this._elementTriggerStates.get(element);if(lookupRef){var possibleTriggers=Object.keys(lookupRef),hasRemoval=possibleTriggers.some(function(triggerName){var oldValue=lookupRef[triggerName],instruction=_this18._triggers[triggerName].matchTransition(oldValue,"void");return!!instruction});if(hasRemoval)return element[MARKED_FOR_REMOVAL]=!0,void this._queuedRemovals.set(element,domFn)}domFn()}},{key:"setProperty",value:function(element,property,value){var trigger=this._triggers[property];if(!trigger)throw new Error('The provided animation trigger "'+property+'" has not been registered!');var lookupRef=this._elementTriggerStates.get(element);lookupRef||this._elementTriggerStates.set(element,lookupRef={});var oldValue=lookupRef[property]||"void";if(oldValue!=value){var instruction=trigger.matchTransition(oldValue,value);instruction||(instruction=trigger.createFallbackInstruction(oldValue,value)),this.animateTransition(element,instruction),lookupRef[property]=value}}},{key:"listen",value:function(element,eventName,eventPhase,callback){if(!eventPhase)throw new Error('Unable to listen on the animation trigger "'+eventName+'" because the provided event is undefined!');if(!this._triggers[eventName])throw new Error('Unable to listen on the animation trigger event "'+eventPhase+'" because the animation trigger "'+eventName+"\" doesn't exist!");var elementListeners=this._triggerListeners.get(element);elementListeners||this._triggerListeners.set(element,elementListeners=[]),validatePlayerEvent(eventName,eventPhase);var tuple={triggerName:eventName,phase:eventPhase,callback:callback};return elementListeners.push(tuple),function(){var index=elementListeners.indexOf(tuple);index>=0&&elementListeners.splice(index,1)}}},{key:"_onRemovalTransition",value:function(element){for(var _this19=this,elms=element.querySelectorAll(MARKED_FOR_ANIMATION),_loop=function(i){var elm=elms[i],activePlayers=_this19._activeElementAnimations.get(elm);activePlayers&&activePlayers.forEach(function(player){return player.destroy()});var activeTransitions=_this19._activeTransitionAnimations.get(elm);activeTransitions&&Object.keys(activeTransitions).forEach(function(triggerName){var player=activeTransitions[triggerName];player&&player.destroy()})},i=0;i<elms.length;i++)_loop(i);return copyArray(this._activeElementAnimations.get(element))}},{key:"animateTransition",value:function(element,instruction){var _this20=this,triggerName=instruction.triggerName,previousPlayers=void 0;if(instruction.isRemovalTransition)previousPlayers=this._onRemovalTransition(element);else{previousPlayers=[];var existingTransitions=this._activeTransitionAnimations.get(element),existingPlayer=existingTransitions?existingTransitions[triggerName]:null;existingPlayer&&previousPlayers.push(existingPlayer)}eraseStyles(element,instruction.fromStyles);var totalTime=0,players=instruction.timelines.map(function(timelineInstruction){return totalTime=Math.max(totalTime,timelineInstruction.totalTime),_this20._buildPlayer(element,timelineInstruction,previousPlayers)});previousPlayers.forEach(function(previousPlayer){return previousPlayer.destroy()});var player=optimizeGroupPlayer(players);player.onDone(function(){player.destroy();var elmTransitionMap=_this20._activeTransitionAnimations.get(element);elmTransitionMap&&(delete elmTransitionMap[triggerName],0==Object.keys(elmTransitionMap).length&&_this20._activeTransitionAnimations.delete(element)),deleteFromArrayMap(_this20._activeElementAnimations,element,player),setStyles(element,instruction.toStyles)});var elmTransitionMap=getOrSetAsInMap(this._activeTransitionAnimations,element,{});return elmTransitionMap[triggerName]=player,this._queuePlayer(element,triggerName,player,makeAnimationEvent(element,triggerName,instruction.fromState,instruction.toState,null,totalTime)),player}},{key:"animateTimeline",value:function(element,instructions){var _this21=this,previousPlayers=arguments.length>2&&void 0!==arguments[2]?arguments[2]:[],players=instructions.map(function(instruction){var player=_this21._buildPlayer(element,instruction,previousPlayers);return player.onDestroy(function(){deleteFromArrayMap(_this21._activeElementAnimations,element,player)}),player.init(),_this21._markPlayerAsActive(element,player),player});return optimizeGroupPlayer(players)}},{key:"_buildPlayer",value:function(element,instruction,previousPlayers){return this._driver.animate(element,this._normalizeKeyframes(instruction.keyframes),instruction.duration,instruction.delay,instruction.easing,previousPlayers)}},{key:"_normalizeKeyframes",value:function(keyframes){var _this22=this,errors=[],normalizedKeyframes=[];if(keyframes.forEach(function(kf){var normalizedKeyframe={};Object.keys(kf).forEach(function(prop){var normalizedProp=prop,normalizedValue=kf[prop];"offset"!=prop&&(normalizedProp=_this22._normalizer.normalizePropertyName(prop,errors),normalizedValue=_this22._normalizer.normalizeStyleValue(prop,normalizedProp,kf[prop],errors)),normalizedKeyframe[normalizedProp]=normalizedValue}),normalizedKeyframes.push(normalizedKeyframe)}),errors.length){var LINE_START="\n - ";throw new Error("Unable to animate due to the following errors:"+LINE_START+errors.join(LINE_START))}return normalizedKeyframes}},{key:"_markPlayerAsActive",value:function(element,player){var elementAnimations=getOrSetAsInMap(this._activeElementAnimations,element,[]);elementAnimations.push(player)}},{key:"_queuePlayer",value:function(element,triggerName,player,event){var tuple={element:element,player:player,triggerName:triggerName,event:event};this._queuedTransitionAnimations.push(tuple),player.init(),element.classList.add(MARKED_FOR_ANIMATION),player.onDone(function(){element.classList.remove(MARKED_FOR_ANIMATION)})}},{key:"_flushQueuedAnimations",value:function(){var _this23=this,_loop2=function(){for(var _queuedTransitionAnim=_this23._queuedTransitionAnimations.shift(),player=_queuedTransitionAnim.player,element=_queuedTransitionAnim.element,triggerName=_queuedTransitionAnim.triggerName,event=_queuedTransitionAnim.event,parent=element;parent=parent.parentNode;)if(parent[MARKED_FOR_REMOVAL])return"continue|parentLoop";if(_this23._queuedRemovals.has(element))return player.destroy(),"continue";var listeners=_this23._triggerListeners.get(element);listeners&&listeners.forEach(function(tuple){tuple.triggerName==triggerName&&listenOnPlayer(player,tuple.phase,event,tuple.callback)}),_this23._markPlayerAsActive(element,player),player.hasStarted()||player.play()};parentLoop:for(;this._queuedTransitionAnimations.length;){var _ret2=_loop2();switch(_ret2){case"continue|parentLoop":continue parentLoop;case"continue":continue}}}},{key:"flush",value:function(){var _this24=this;this._flushQueuedAnimations();var flushAgain=!1;this._queuedRemovals.forEach(function(callback,element){if(!_this24._flaggedInserts.has(element)){for(var parent=element,players=[];parent=parent.parentNode;){if(parent[MARKED_FOR_REMOVAL])return void callback();var match=_this24._activeElementAnimations.get(parent);if(match){players.push.apply(players,_toConsumableArray(match));break}}if(0==players.length){var stateDetails=_this24._elementTriggerStates.get(element);stateDetails&&Object.keys(stateDetails).forEach(function(triggerName){var oldValue=stateDetails[triggerName],instruction=_this24._triggers[triggerName].matchTransition(oldValue,"void");instruction&&(players.push(_this24.animateTransition(element,instruction)),flushAgain=!0)})}players.length?optimizeGroupPlayer(players).onDone(callback):callback()}}),this._queuedRemovals.clear(),this._flaggedInserts.clear(),flushAgain&&this._flushQueuedAnimations()}},{key:"queuedPlayers",get:function(){return this._queuedTransitionAnimations.map(function(q){return q.player})}},{key:"activePlayers",get:function(){var players=[];return this._activeElementAnimations.forEach(function(activePlayers){return players.push.apply(players,_toConsumableArray(activePlayers))}),players}}]),DomAnimationEngine}(),DEFAULT_STATE_VALUE="void",DEFAULT_STATE_STYLES="*",NoopAnimationEngine=function(_AnimationEngine){function NoopAnimationEngine(){_classCallCheck(this,NoopAnimationEngine);var _this25=_possibleConstructorReturn(this,(NoopAnimationEngine.__proto__||Object.getPrototypeOf(NoopAnimationEngine)).apply(this,arguments));return _this25._listeners=new Map,_this25._changes=[],_this25._flaggedRemovals=new Set,_this25._onDoneFns=[],_this25._triggerStyles=Object.create(null),_this25}return _inherits(NoopAnimationEngine,_AnimationEngine),_createClass(NoopAnimationEngine,[{key:"registerTrigger",value:function(trigger){var name=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;if(name=name||trigger.name,!this._triggerStyles[name]){var stateMap={};trigger.definitions.forEach(function(def){if(0===def.type){var stateDef=def;stateMap[stateDef.name]=normalizeStyles(stateDef.styles.styles)}}),this._triggerStyles[name]=stateMap}}},{key:"onInsert",value:function(element,domFn){domFn()}},{key:"onRemove",value:function(element,domFn){domFn(),this._flaggedRemovals.add(element)}},{key:"setProperty",value:function(element,property,value){var storageProp=makeStorageProp(property),oldValue=element[storageProp]||DEFAULT_STATE_VALUE;this._changes.push({element:element,oldValue:oldValue,newValue:value,triggerName:property});var triggerStateStyles=this._triggerStyles[property]||{},fromStateStyles=triggerStateStyles[oldValue]||triggerStateStyles[DEFAULT_STATE_STYLES];fromStateStyles&&eraseStyles(element,fromStateStyles),element[storageProp]=value,this._onDoneFns.push(function(){var toStateStyles=triggerStateStyles[value]||triggerStateStyles[DEFAULT_STATE_STYLES];toStateStyles&&setStyles(element,toStateStyles)})}},{key:"listen",value:function(element,eventName,eventPhase,callback){var listeners=this._listeners.get(element);listeners||this._listeners.set(element,listeners=[]);var tuple={triggerName:eventName,eventPhase:eventPhase,callback:callback};return listeners.push(tuple),function(){return tuple.doRemove=!0}}},{key:"flush",value:function(){function handleListener(listener,data){var phase=listener.eventPhase,event=makeAnimationEvent$1(data.element,data.triggerName,data.oldValue,data.newValue,phase,0);"start"==phase?onStartCallbacks.push(function(){return listener.callback(event)}):"done"==phase&&onDoneCallbacks.push(function(){return listener.callback(event)})}var _this26=this,onStartCallbacks=[],onDoneCallbacks=[];this._changes.forEach(function(change){var element=change.element,listeners=_this26._listeners.get(element);listeners&&listeners.forEach(function(listener){listener.triggerName==change.triggerName&&handleListener(listener,change)})}),this._flaggedRemovals.forEach(function(element){var listeners=_this26._listeners.get(element);listeners&&listeners.forEach(function(listener){var triggerName=listener.triggerName,storageProp=makeStorageProp(triggerName);handleListener(listener,{element:element,triggerName:triggerName,oldValue:element[storageProp]||DEFAULT_STATE_VALUE,newValue:DEFAULT_STATE_VALUE})})}),Array.from(this._listeners.keys()).forEach(function(element){var listenersToKeep=_this26._listeners.get(element).filter(function(l){return!l.doRemove});listenersToKeep.length?_this26._listeners.set(element,listenersToKeep):_this26._listeners.delete(element)}),onStartCallbacks.forEach(function(fn){return fn()}),onDoneCallbacks.forEach(function(fn){return fn()}),this._flaggedRemovals.clear(),this._changes=[],this._onDoneFns.forEach(function(doneFn){return doneFn()}),this._onDoneFns=[]}},{key:"activePlayers",get:function(){return[]}},{key:"queuedPlayers",get:function(){return[]}}]),NoopAnimationEngine}(AnimationEngine),WebAnimationsPlayer=function(){function WebAnimationsPlayer(element,keyframes,options){var _this27=this,previousPlayers=arguments.length>3&&void 0!==arguments[3]?arguments[3]:[];_classCallCheck(this,WebAnimationsPlayer),this.element=element,this.keyframes=keyframes,this.options=options,this._onDoneFns=[],this._onStartFns=[],this._onDestroyFns=[],this._initialized=!1,this._finished=!1,this._started=!1,this._destroyed=!1,this.time=0,this.parentPlayer=null,this._duration=options.duration,this._delay=options.delay||0,this.time=this._duration+this._delay,this.previousStyles={},previousPlayers.forEach(function(player){var styles=player._captureStyles();Object.keys(styles).forEach(function(prop){return _this27.previousStyles[prop]=styles[prop]})})}return _createClass(WebAnimationsPlayer,[{key:"_onFinish",value:function(){this._finished||(this._finished=!0,this._onDoneFns.forEach(function(fn){return fn()}),this._onDoneFns=[])}},{key:"init",value:function(){var _this28=this;if(!this._initialized){this._initialized=!0;var keyframes=this.keyframes.map(function(styles){var formattedKeyframe={};return Object.keys(styles).forEach(function(prop,index){var value=styles[prop];value==_animations.AUTO_STYLE&&(value=_computeStyle(_this28.element,prop)),void 0!=value&&(formattedKeyframe[prop]=value)}),formattedKeyframe}),previousStyleProps=Object.keys(this.previousStyles);if(previousStyleProps.length){var startingKeyframe=keyframes[0],missingStyleProps=[];if(previousStyleProps.forEach(function(prop){null!=startingKeyframe[prop]&&missingStyleProps.push(prop),startingKeyframe[prop]=_this28.previousStyles[prop]}),missingStyleProps.length){var i;!function(){var self=_this28,_loop3=function(){var kf=keyframes[i];missingStyleProps.forEach(function(prop){kf[prop]=_computeStyle(self.element,prop)})};for(i=1;i<keyframes.length;i++)_loop3()}()}}this._player=this._triggerWebAnimation(this.element,keyframes,this.options),this._finalKeyframe=keyframes.length?_copyKeyframeStyles(keyframes[keyframes.length-1]):{},this._resetDomPlayerState(),this._player.addEventListener("finish",function(){return _this28._onFinish()})}}},{key:"_triggerWebAnimation",value:function(element,keyframes,options){return element.animate(keyframes,options)}},{key:"onStart",value:function(fn){this._onStartFns.push(fn)}},{key:"onDone",value:function(fn){this._onDoneFns.push(fn)}},{key:"onDestroy",value:function(fn){this._onDestroyFns.push(fn)}},{key:"play",value:function(){this.init(),this.hasStarted()||(this._onStartFns.forEach(function(fn){return fn()}),this._onStartFns=[],this._started=!0),this._player.play()}},{key:"pause",value:function(){this.init(),this._player.pause()}},{key:"finish",value:function(){this.init(),this._onFinish(),this._player.finish()}},{key:"reset",value:function(){this._resetDomPlayerState(),this._destroyed=!1,this._finished=!1,this._started=!1}},{key:"_resetDomPlayerState",value:function(){this._player&&this._player.cancel()}},{key:"restart",value:function(){this.reset(),this.play()}},{key:"hasStarted",value:function(){return this._started}},{key:"destroy",value:function(){this._destroyed||(this._resetDomPlayerState(),this._onFinish(),this._destroyed=!0,this._onDestroyFns.forEach(function(fn){return fn()}),this._onDestroyFns=[])}},{key:"setPosition",value:function(p){this._player.currentTime=p*this.time}},{key:"getPosition",value:function(){return this._player.currentTime/this.time}},{key:"_captureStyles",value:function(){var _this29=this,styles={};return this.hasStarted()&&Object.keys(this._finalKeyframe).forEach(function(prop){"offset"!=prop&&(styles[prop]=_this29._finished?_this29._finalKeyframe[prop]:_computeStyle(_this29.element,prop))}),styles}},{key:"domPlayer",get:function(){return this._player}}]),WebAnimationsPlayer}(),WebAnimationsDriver=function(){function WebAnimationsDriver(){_classCallCheck(this,WebAnimationsDriver)}return _createClass(WebAnimationsDriver,[{key:"animate",value:function(element,keyframes,duration,delay,easing){var previousPlayers=arguments.length>5&&void 0!==arguments[5]?arguments[5]:[],playerOptions={duration:duration,delay:delay,fill:"forwards"};easing&&(playerOptions.easing=easing);var previousWebAnimationPlayers=previousPlayers.filter(function(player){return player instanceof WebAnimationsPlayer});return new WebAnimationsPlayer(element,keyframes,playerOptions,previousWebAnimationPlayers)}}]),WebAnimationsDriver}(),InjectableAnimationEngine=function(_DomAnimationEngine){function InjectableAnimationEngine(driver,normalizer){return _classCallCheck(this,InjectableAnimationEngine),_possibleConstructorReturn(this,(InjectableAnimationEngine.__proto__||Object.getPrototypeOf(InjectableAnimationEngine)).call(this,driver,normalizer))}return _inherits(InjectableAnimationEngine,_DomAnimationEngine),InjectableAnimationEngine}(DomAnimationEngine);InjectableAnimationEngine.decorators=[{type:_core.Injectable}],InjectableAnimationEngine.ctorParameters=function(){return[{type:AnimationDriver},{type:AnimationStyleNormalizer}]};var BROWSER_ANIMATIONS_PROVIDERS=[{provide:AnimationDriver,useFactory:instantiateSupportedAnimationDriver},{provide:AnimationStyleNormalizer,useFactory:instantiateDefaultStyleNormalizer},{provide:AnimationEngine,useClass:InjectableAnimationEngine},{provide:_core.RendererFactoryV2,useFactory:instantiateRendererFactory,deps:[_platformBrowser.ɵDomRendererFactoryV2,AnimationEngine,_core.NgZone]}],BROWSER_NOOP_ANIMATIONS_PROVIDERS=[{provide:AnimationEngine,useClass:NoopAnimationEngine},{provide:_core.RendererFactoryV2,useFactory:instantiateRendererFactory,deps:[_platformBrowser.ɵDomRendererFactoryV2,AnimationEngine,_core.NgZone]}],BrowserAnimationsModule=function BrowserAnimationsModule(){_classCallCheck(this,BrowserAnimationsModule)};BrowserAnimationsModule.decorators=[{type:_core.NgModule,args:[{imports:[_platformBrowser.BrowserModule],providers:BROWSER_ANIMATIONS_PROVIDERS}]}],BrowserAnimationsModule.ctorParameters=function(){return[]};var NoopAnimationsModule=function NoopAnimationsModule(){_classCallCheck(this,NoopAnimationsModule)};NoopAnimationsModule.decorators=[{type:_core.NgModule,args:[{imports:[_platformBrowser.BrowserModule],providers:BROWSER_NOOP_ANIMATIONS_PROVIDERS}]}],NoopAnimationsModule.ctorParameters=function(){return[]};var Animation=function(){function Animation(input){_classCallCheck(this,Animation);var ast=Array.isArray(input)?(0,_animations.sequence)(input):input,errors=validateAnimationSequence(ast);if(errors.length){var errorMessage="animation validation failed:\n"+errors.join("\n");throw new Error(errorMessage)}this._animationAst=ast}return _createClass(Animation,[{key:"buildTimelines",value:function(startingStyles,destinationStyles){var start=Array.isArray(startingStyles)?normalizeStyles(startingStyles):startingStyles,dest=Array.isArray(destinationStyles)?normalizeStyles(destinationStyles):destinationStyles;return buildAnimationKeyframes(this._animationAst,start,dest)}},{key:"create",value:function(injector,element){var startingStyles=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},destinationStyles=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},instructions=this.buildTimelines(startingStyles,destinationStyles),driver=injector.get(AnimationDriver),normalizer=injector.get(AnimationStyleNormalizer),engine=new DomAnimationEngine(driver,normalizer);return engine.animateTimeline(element,instructions)}}]),Animation}();exports.BrowserAnimationsModule=BrowserAnimationsModule,exports.NoopAnimationsModule=NoopAnimationsModule,exports.AnimationDriver=AnimationDriver,exports.ɵAnimationEngine=AnimationEngine,exports.ɵAnimation=Animation,exports.ɵAnimationStyleNormalizer=AnimationStyleNormalizer,exports.ɵNoopAnimationStyleNormalizer=NoopAnimationStyleNormalizer,exports.ɵNoopAnimationDriver=NoopAnimationDriver,exports.ɵAnimationRenderer=AnimationRenderer,exports.ɵAnimationRendererFactory=AnimationRendererFactory,exports.ɵDomAnimationEngine=DomAnimationEngine,exports.ɵg=WebAnimationsStyleNormalizer,exports.ɵe=BROWSER_ANIMATIONS_PROVIDERS,exports.ɵf=BROWSER_NOOP_ANIMATIONS_PROVIDERS,exports.ɵa=InjectableAnimationEngine,exports.ɵc=instantiateDefaultStyleNormalizer,exports.ɵd=instantiateRendererFactory,exports.ɵb=instantiateSupportedAnimationDriver,exports.ɵh=NoopAnimationEngine});