/**
 * @license Angular v4.2.2
 * (c) 2010-2017 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/core"),require("@angular/platform-browser"),require("@angular/animations/browser"),require("@angular/common"),require("@angular/compiler"),require("@angular/http"),require("@angular/platform-browser/animations"),require("rxjs/Observable"),require("rxjs/Subject"),require("url"),require("rxjs/operator/filter"),require("rxjs/operator/first"),require("rxjs/operator/toPromise")):"function"==typeof define&&define.amd?define(["exports","@angular/core","@angular/platform-browser","@angular/animations/browser","@angular/common","@angular/compiler","@angular/http","@angular/platform-browser/animations","rxjs/Observable","rxjs/Subject","url","rxjs/operator/filter","rxjs/operator/first","rxjs/operator/toPromise"],factory):factory((global.ng=global.ng||{},global.ng.platformServer=global.ng.platformServer||{}),global.ng.core,global.ng.platformBrowser,global._angular_animations_browser,global.ng.common,global.ng.compiler,global._angular_http,global._angular_platformBrowser_animations,global.Rx,global.Rx,global.url,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable.prototype)}(this,function(exports,_angular_core,_angular_platformBrowser,_angular_animations_browser,_angular_common,_angular_compiler,_angular_http,_angular_platformBrowser_animations,rxjs_Observable,rxjs_Subject,url,rxjs_operator_filter,rxjs_operator_first,rxjs_operator_toPromise){"use strict";function __extends(d,b){function __(){this.constructor=d}extendStatics(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}function validateRequestUrl(url$$1){if(!isAbsoluteUrl.test(url$$1))throw new Error("URLs requested via Http on the server must be absolute. URL: "+url$$1)}function httpFactory(xhrBackend,options){var macroBackend=new ZoneMacroTaskBackend(xhrBackend);return new _angular_http.Http(macroBackend,options)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function parseUrl(urlStr){var parsedUrl=url.parse(urlStr);return{pathname:parsedUrl.pathname||"",search:parsedUrl.search||"",hash:parsedUrl.hash||""}}function scheduleMicroTask(fn){Zone.current.scheduleMicroTask("scheduleMicrotask",fn)}function _notImplemented(methodName){return new Error("This method is not implemented in Parse5DomAdapter: "+methodName)}function _getElement(el,name){for(var i=0;i<el.childNodes.length;i++){var node=el.childNodes[i];if(node.name===name)return node}return null}function parseDocument(html){var doc=parse5$1.parse(html,{treeAdapter:parse5$1.treeAdapters.htmlparser2}),docElement=_getElement(doc,"html");return doc.head=_getElement(docElement,"head"),doc.body=_getElement(docElement,"body"),doc._window={},doc}function remove(list,el){var index=list.indexOf(el);index>-1&&list.splice(index,1)}function checkNoSyntheticProp(name,nameKind){if(name.charCodeAt(0)===AT_CHARCODE)throw new Error("Found the synthetic "+nameKind+" "+name+'. Please include either "BrowserAnimationsModule" or "NoopAnimationsModule" in your application.')}function initParse5Adapter(injector){return function(){Parse5DomAdapter.makeCurrent()}}function instantiateServerRendererFactory(renderer,engine,zone){return new _angular_platformBrowser_animations.ɵAnimationRendererFactory(renderer,engine,zone)}function _document(injector){var config=injector.get(INITIAL_CONFIG,null);return config&&config.document?parseDocument(config.document):_angular_platformBrowser.ɵgetDOM().createHtmlDocument()}function _getPlatform(platformFactory,options){var extraProviders=options.extraProviders?options.extraProviders:[];return platformFactory([{provide:INITIAL_CONFIG,useValue:{document:options.document,url:options.url}},extraProviders])}function _render(platform,moduleRefPromise){return moduleRefPromise.then(function(moduleRef){var transitionId=moduleRef.injector.get(_angular_platformBrowser.ɵTRANSITION_ID,null);if(!transitionId)throw new Error("renderModule[Factory]() requires the use of BrowserModule.withServerTransition() to ensure\nthe server-rendered app can be properly bootstrapped into a client app.");var applicationRef=moduleRef.injector.get(_angular_core.ApplicationRef);return rxjs_operator_toPromise.toPromise.call(rxjs_operator_first.first.call(rxjs_operator_filter.filter.call(applicationRef.isStable,function(isStable){return isStable}))).then(function(){var output=platform.injector.get(PlatformState).renderToString();return platform.destroy(),output})})}function renderModule(module,options){var platform=_getPlatform(platformDynamicServer,options);return _render(platform,platform.bootstrapModule(module))}function renderModuleFactory(moduleFactory,options){var platform=_getPlatform(platformServer,options);return _render(platform,platform.bootstrapModuleFactory(moduleFactory))}var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])},PlatformState=(require("parse5"),function(){function PlatformState(_doc){this._doc=_doc}return PlatformState.prototype.renderToString=function(){return _angular_platformBrowser.ɵgetDOM().getInnerHTML(this._doc)},PlatformState.prototype.getDocument=function(){return this._doc},PlatformState}());PlatformState.decorators=[{type:_angular_core.Injectable}],PlatformState.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_platformBrowser.DOCUMENT]}]}]};/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var xhr2=require("xhr2"),isAbsoluteUrl=/^[a-zA-Z\-\+.]+:\/\//,ServerXhr=function(){function ServerXhr(){}return ServerXhr.prototype.build=function(){return new xhr2.XMLHttpRequest},ServerXhr}();ServerXhr.decorators=[{type:_angular_core.Injectable}],ServerXhr.ctorParameters=function(){return[]};var ServerXsrfStrategy=function(){function ServerXsrfStrategy(){}return ServerXsrfStrategy.prototype.configureRequest=function(req){},ServerXsrfStrategy}();ServerXsrfStrategy.decorators=[{type:_angular_core.Injectable}],ServerXsrfStrategy.ctorParameters=function(){return[]};var ZoneMacroTaskConnection=function(){function ZoneMacroTaskConnection(request,backend){var _this=this;this.request=request,validateRequestUrl(request.url),this.response=new rxjs_Observable.Observable(function(observer){var task=null,scheduled=!1,sub=null,savedResult=null,savedError=null,scheduleTask=function(_task){task=_task,scheduled=!0,_this.lastConnection=backend.createConnection(request),sub=_this.lastConnection.response.subscribe(function(res){return savedResult=res},function(err){if(!scheduled)throw new Error("invoke twice");savedError=err,scheduled=!1,task.invoke()},function(){if(!scheduled)throw new Error("invoke twice");scheduled=!1,task.invoke()})},cancelTask=function(_task){scheduled&&(scheduled=!1,sub&&(sub.unsubscribe(),sub=null))},onComplete=function(){null!==savedError?observer.error(savedError):(observer.next(savedResult),observer.complete())},_task=Zone.current.scheduleMacroTask("ZoneMacroTaskConnection.subscribe",onComplete,{},function(){return null},cancelTask);return scheduleTask(_task),function(){scheduled&&task&&(task.zone.cancelTask(task),scheduled=!1),sub&&(sub.unsubscribe(),sub=null)}})}return Object.defineProperty(ZoneMacroTaskConnection.prototype,"readyState",{get:function(){return this.lastConnection?this.lastConnection.readyState:_angular_http.ReadyState.Unsent},enumerable:!0,configurable:!0}),ZoneMacroTaskConnection}(),ZoneMacroTaskBackend=function(){function ZoneMacroTaskBackend(backend){this.backend=backend}return ZoneMacroTaskBackend.prototype.createConnection=function(request){return new ZoneMacroTaskConnection(request,this.backend)},ZoneMacroTaskBackend}(),SERVER_HTTP_PROVIDERS=[{provide:_angular_http.Http,useFactory:httpFactory,deps:[_angular_http.XHRBackend,_angular_http.RequestOptions]},{provide:_angular_http.BrowserXhr,useClass:ServerXhr},{provide:_angular_http.XSRFStrategy,useClass:ServerXsrfStrategy}],INITIAL_CONFIG=new _angular_core.InjectionToken("Server.INITIAL_CONFIG"),ServerPlatformLocation=function(){function ServerPlatformLocation(_doc,_config){this._doc=_doc,this._path="/",this._search="",this._hash="",this._hashUpdate=new rxjs_Subject.Subject;var config=_config;if(config&&config.url){var parsedUrl=parseUrl(config.url);this._path=parsedUrl.pathname,this._search=parsedUrl.search,this._hash=parsedUrl.hash}}return ServerPlatformLocation.prototype.getBaseHrefFromDOM=function(){return _angular_platformBrowser.ɵgetDOM().getBaseHref(this._doc)},ServerPlatformLocation.prototype.onPopState=function(fn){},ServerPlatformLocation.prototype.onHashChange=function(fn){this._hashUpdate.subscribe(fn)},Object.defineProperty(ServerPlatformLocation.prototype,"pathname",{get:function(){return this._path},enumerable:!0,configurable:!0}),Object.defineProperty(ServerPlatformLocation.prototype,"search",{get:function(){return this._search},enumerable:!0,configurable:!0}),Object.defineProperty(ServerPlatformLocation.prototype,"hash",{get:function(){return this._hash},enumerable:!0,configurable:!0}),Object.defineProperty(ServerPlatformLocation.prototype,"url",{get:function(){return""+this.pathname+this.search+this.hash},enumerable:!0,configurable:!0}),ServerPlatformLocation.prototype.setHash=function(value,oldUrl){var _this=this;if(this._hash!==value){this._hash=value;var newUrl=this.url;scheduleMicroTask(function(){return _this._hashUpdate.next({type:"hashchange",oldUrl:oldUrl,newUrl:newUrl})})}},ServerPlatformLocation.prototype.replaceState=function(state,title,newUrl){var oldUrl=this.url,parsedUrl=parseUrl(newUrl);this._path=parsedUrl.pathname,this._search=parsedUrl.search,this.setHash(parsedUrl.hash,oldUrl)},ServerPlatformLocation.prototype.pushState=function(state,title,newUrl){this.replaceState(state,title,newUrl)},ServerPlatformLocation.prototype.forward=function(){throw new Error("Not implemented")},ServerPlatformLocation.prototype.back=function(){throw new Error("Not implemented")},ServerPlatformLocation}();ServerPlatformLocation.decorators=[{type:_angular_core.Injectable}],ServerPlatformLocation.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_platformBrowser.DOCUMENT]}]},{type:void 0,decorators:[{type:_angular_core.Optional},{type:_angular_core.Inject,args:[INITIAL_CONFIG]}]}]};/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var treeAdapter,parse5$1=require("parse5"),_attrToPropMap={class:"className",innerHtml:"innerHTML",readonly:"readOnly",tabindex:"tabIndex"},mapProps=["attribs","x-attribsNamespace","x-attribsPrefix"],Parse5DomAdapter=function(_super){function Parse5DomAdapter(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Parse5DomAdapter,_super),Parse5DomAdapter.makeCurrent=function(){treeAdapter=parse5$1.treeAdapters.htmlparser2,_angular_platformBrowser.ɵsetRootDomAdapter(new Parse5DomAdapter)},Parse5DomAdapter.prototype.contains=function(nodeA,nodeB){for(var inner=nodeB;inner;){if(inner===nodeA)return!0;inner=inner.parent}return!1},Parse5DomAdapter.prototype.hasProperty=function(element,name){return _HTMLElementPropertyList.indexOf(name)>-1},Parse5DomAdapter.prototype.setProperty=function(el,name,value){"innerHTML"===name?this.setInnerHTML(el,value):"innerText"===name?this.setText(el,value):"className"===name?el.attribs.class=el.className=value:el[name]=value},Parse5DomAdapter.prototype.getProperty=function(el,name){return el[name]},Parse5DomAdapter.prototype.logError=function(error){console.error(error)},Parse5DomAdapter.prototype.log=function(error){console.log(error)},Parse5DomAdapter.prototype.logGroup=function(error){console.error(error)},Parse5DomAdapter.prototype.logGroupEnd=function(){},Object.defineProperty(Parse5DomAdapter.prototype,"attrToPropMap",{get:function(){return _attrToPropMap},enumerable:!0,configurable:!0}),Parse5DomAdapter.prototype.querySelector=function(el,selector){return this.querySelectorAll(el,selector)[0]||null},Parse5DomAdapter.prototype.querySelectorAll=function(el,selector){var _this=this,res=[],_recursive=function(result,node,selector,matcher){var cNodes=node.childNodes;if(cNodes&&cNodes.length>0)for(var i=0;i<cNodes.length;i++){var childNode=cNodes[i];_this.elementMatches(childNode,selector,matcher)&&result.push(childNode),_recursive(result,childNode,selector,matcher)}},matcher=new _angular_compiler.SelectorMatcher;return matcher.addSelectables(_angular_compiler.CssSelector.parse(selector)),_recursive(res,el,selector,matcher),res},Parse5DomAdapter.prototype.elementMatches=function(node,selector,matcher){if(void 0===matcher&&(matcher=null),this.isElementNode(node)&&"*"===selector)return!0;var result=!1;if(selector&&"#"==selector.charAt(0))result=this.getAttribute(node,"id")==selector.substring(1);else if(selector){matcher||(matcher=new _angular_compiler.SelectorMatcher,matcher.addSelectables(_angular_compiler.CssSelector.parse(selector)));var cssSelector=new _angular_compiler.CssSelector;if(cssSelector.setElement(this.tagName(node)),node.attribs)for(var attrName in node.attribs)cssSelector.addAttribute(attrName,node.attribs[attrName]);for(var classList=this.classList(node),i=0;i<classList.length;i++)cssSelector.addClassName(classList[i]);matcher.match(cssSelector,function(selector,cb){result=!0})}return result},Parse5DomAdapter.prototype.on=function(el,evt,listener){var listenersMap=el._eventListenersMap;listenersMap||(listenersMap={},el._eventListenersMap=listenersMap);var listeners=listenersMap[evt]||[];listenersMap[evt]=listeners.concat([listener])},Parse5DomAdapter.prototype.onAndCancel=function(el,evt,listener){return this.on(el,evt,listener),function(){remove(el._eventListenersMap[evt],listener)}},Parse5DomAdapter.prototype.dispatchEvent=function(el,evt){if(evt.target||(evt.target=el),el._eventListenersMap){var listeners=el._eventListenersMap[evt.type];if(listeners)for(var i=0;i<listeners.length;i++)listeners[i](evt)}el.parent&&this.dispatchEvent(el.parent,evt),el._window&&this.dispatchEvent(el._window,evt)},Parse5DomAdapter.prototype.createMouseEvent=function(eventType){return this.createEvent(eventType)},Parse5DomAdapter.prototype.createEvent=function(eventType){var event={type:eventType,defaultPrevented:!1,preventDefault:function(){event.defaultPrevented=!0}};return event},Parse5DomAdapter.prototype.preventDefault=function(event){event.returnValue=!1},Parse5DomAdapter.prototype.isPrevented=function(event){return null!=event.returnValue&&!event.returnValue},Parse5DomAdapter.prototype.getInnerHTML=function(el){return parse5$1.serialize(this.templateAwareRoot(el),{treeAdapter:treeAdapter})},Parse5DomAdapter.prototype.getTemplateContent=function(el){return null},Parse5DomAdapter.prototype.getOuterHTML=function(el){var fragment=treeAdapter.createDocumentFragment();return this.appendChild(fragment,el),parse5$1.serialize(fragment,{treeAdapter:treeAdapter})},Parse5DomAdapter.prototype.nodeName=function(node){return node.tagName},Parse5DomAdapter.prototype.nodeValue=function(node){return node.nodeValue},Parse5DomAdapter.prototype.type=function(node){throw _notImplemented("type")},Parse5DomAdapter.prototype.content=function(node){return node.childNodes[0]},Parse5DomAdapter.prototype.firstChild=function(el){return el.firstChild},Parse5DomAdapter.prototype.nextSibling=function(el){return el.nextSibling},Parse5DomAdapter.prototype.parentElement=function(el){return el.parent},Parse5DomAdapter.prototype.childNodes=function(el){return el.childNodes},Parse5DomAdapter.prototype.childNodesAsList=function(el){for(var childNodes=el.childNodes,res=new Array(childNodes.length),i=0;i<childNodes.length;i++)res[i]=childNodes[i];return res},Parse5DomAdapter.prototype.clearNodes=function(el){for(;el.childNodes.length>0;)this.remove(el.childNodes[0])},Parse5DomAdapter.prototype.appendChild=function(el,node){this.remove(node),treeAdapter.appendChild(this.templateAwareRoot(el),node)},Parse5DomAdapter.prototype.removeChild=function(el,node){el.childNodes.indexOf(node)>-1&&this.remove(node)},Parse5DomAdapter.prototype.remove=function(el){var parent=el.parent;if(parent){var index=parent.childNodes.indexOf(el);parent.childNodes.splice(index,1)}var prev=el.previousSibling,next=el.nextSibling;return prev&&(prev.next=next),next&&(next.prev=prev),el.prev=null,el.next=null,el.parent=null,el},Parse5DomAdapter.prototype.insertBefore=function(parent,ref,newNode){this.remove(newNode),ref?treeAdapter.insertBefore(parent,newNode,ref):this.appendChild(parent,newNode)},Parse5DomAdapter.prototype.insertAllBefore=function(parent,ref,nodes){var _this=this;nodes.forEach(function(n){return _this.insertBefore(parent,ref,n)})},Parse5DomAdapter.prototype.insertAfter=function(parent,ref,node){ref.nextSibling?this.insertBefore(parent,ref.nextSibling,node):this.appendChild(parent,node)},Parse5DomAdapter.prototype.setInnerHTML=function(el,value){this.clearNodes(el);for(var content=parse5$1.parseFragment(value,{treeAdapter:treeAdapter}),i=0;i<content.childNodes.length;i++)treeAdapter.appendChild(el,content.childNodes[i])},Parse5DomAdapter.prototype.getText=function(el,isRecursive){if(this.isTextNode(el))return el.data;if(this.isCommentNode(el))return isRecursive?"":el.data;if(!el.childNodes||0==el.childNodes.length)return"";for(var textContent="",i=0;i<el.childNodes.length;i++)textContent+=this.getText(el.childNodes[i],!0);return textContent},Parse5DomAdapter.prototype.setText=function(el,value){this.isTextNode(el)||this.isCommentNode(el)?el.data=value:(this.clearNodes(el),""!==value&&treeAdapter.insertText(el,value))},Parse5DomAdapter.prototype.getValue=function(el){return el.value},Parse5DomAdapter.prototype.setValue=function(el,value){el.value=value},Parse5DomAdapter.prototype.getChecked=function(el){return el.checked},Parse5DomAdapter.prototype.setChecked=function(el,value){el.checked=value},Parse5DomAdapter.prototype.createComment=function(text){return treeAdapter.createCommentNode(text)},Parse5DomAdapter.prototype.createTemplate=function(html){var template=treeAdapter.createElement("template","http://www.w3.org/1999/xhtml",[]),content=parse5$1.parseFragment(html,{treeAdapter:treeAdapter});return treeAdapter.setTemplateContent(template,content),template},Parse5DomAdapter.prototype.createElement=function(tagName){return treeAdapter.createElement(tagName,"http://www.w3.org/1999/xhtml",[])},Parse5DomAdapter.prototype.createElementNS=function(ns,tagName){return treeAdapter.createElement(tagName,ns,[])},Parse5DomAdapter.prototype.createTextNode=function(text){var t=this.createComment(text);return t.type="text",t},Parse5DomAdapter.prototype.createScriptTag=function(attrName,attrValue){return treeAdapter.createElement("script","http://www.w3.org/1999/xhtml",[{name:attrName,value:attrValue}])},Parse5DomAdapter.prototype.createStyleElement=function(css){var style=this.createElement("style");return this.setText(style,css),style},Parse5DomAdapter.prototype.createShadowRoot=function(el){return el.shadowRoot=treeAdapter.createDocumentFragment(),el.shadowRoot.parent=el,el.shadowRoot},Parse5DomAdapter.prototype.getShadowRoot=function(el){return el.shadowRoot},Parse5DomAdapter.prototype.getHost=function(el){return el.host},Parse5DomAdapter.prototype.getDistributedNodes=function(el){throw _notImplemented("getDistributedNodes")},Parse5DomAdapter.prototype.clone=function(node){var _recursive=function(node){var nodeClone=Object.create(Object.getPrototypeOf(node));for(var prop in node){var desc=Object.getOwnPropertyDescriptor(node,prop);desc&&"value"in desc&&"object"!=typeof desc.value&&(nodeClone[prop]=node[prop])}nodeClone.parent=null,nodeClone.prev=null,nodeClone.next=null,nodeClone.children=null,mapProps.forEach(function(mapName){if(null!=node[mapName]){nodeClone[mapName]={};for(var prop in node[mapName])nodeClone[mapName][prop]=node[mapName][prop]}});var cNodes=node.children;if(cNodes){for(var cNodesClone=new Array(cNodes.length),i=0;i<cNodes.length;i++){var childNode=cNodes[i],childNodeClone=_recursive(childNode);cNodesClone[i]=childNodeClone,i>0&&(childNodeClone.prev=cNodesClone[i-1],cNodesClone[i-1].next=childNodeClone),childNodeClone.parent=nodeClone}nodeClone.children=cNodesClone}return nodeClone};return _recursive(node)},Parse5DomAdapter.prototype.getElementsByClassName=function(element,name){return this.querySelectorAll(element,"."+name)},Parse5DomAdapter.prototype.getElementsByTagName=function(element,name){return this.querySelectorAll(element,name)},Parse5DomAdapter.prototype.classList=function(element){var classAttrValue=null,attributes=element.attribs;return attributes&&null!=attributes.class&&(classAttrValue=attributes.class),classAttrValue?classAttrValue.trim().split(/\s+/g):[]},Parse5DomAdapter.prototype.addClass=function(element,className){var classList=this.classList(element),index=classList.indexOf(className);index==-1&&(classList.push(className),element.attribs.class=element.className=classList.join(" "))},Parse5DomAdapter.prototype.removeClass=function(element,className){var classList=this.classList(element),index=classList.indexOf(className);index>-1&&(classList.splice(index,1),element.attribs.class=element.className=classList.join(" "))},Parse5DomAdapter.prototype.hasClass=function(element,className){return this.classList(element).indexOf(className)>-1},Parse5DomAdapter.prototype.hasStyle=function(element,styleName,styleValue){var value=this.getStyle(element,styleName)||"";return styleValue?value==styleValue:value.length>0},Parse5DomAdapter.prototype._readStyleAttribute=function(element){var styleMap={},attributes=element.attribs;if(attributes&&null!=attributes.style)for(var styleAttrValue=attributes.style,styleList=styleAttrValue.split(/;+/g),i=0;i<styleList.length;i++)if(styleList[i].length>0){var style=styleList[i],colon=style.indexOf(":");if(colon===-1)throw new Error("Invalid CSS style: "+style);styleMap[style.substr(0,colon).trim()]=style.substr(colon+1).trim()}return styleMap},Parse5DomAdapter.prototype._writeStyleAttribute=function(element,styleMap){var styleAttrValue="";for(var key in styleMap){var newValue=styleMap[key];newValue&&(styleAttrValue+=key+":"+styleMap[key]+";")}element.attribs.style=styleAttrValue},Parse5DomAdapter.prototype.setStyle=function(element,styleName,styleValue){var styleMap=this._readStyleAttribute(element);styleMap[styleName]=styleValue,this._writeStyleAttribute(element,styleMap)},Parse5DomAdapter.prototype.removeStyle=function(element,styleName){this.setStyle(element,styleName,null)},Parse5DomAdapter.prototype.getStyle=function(element,styleName){var styleMap=this._readStyleAttribute(element);return styleMap.hasOwnProperty(styleName)?styleMap[styleName]:""},Parse5DomAdapter.prototype.tagName=function(element){return"style"==element.tagName?"STYLE":element.tagName},Parse5DomAdapter.prototype.attributeMap=function(element){for(var res=new Map,elAttrs=treeAdapter.getAttrList(element),i=0;i<elAttrs.length;i++){var attrib=elAttrs[i];res.set(attrib.name,attrib.value)}return res},Parse5DomAdapter.prototype.hasAttribute=function(element,attribute){return element.attribs&&null!=element.attribs[attribute]},Parse5DomAdapter.prototype.hasAttributeNS=function(element,ns,attribute){return this.hasAttribute(element,attribute)},Parse5DomAdapter.prototype.getAttribute=function(element,attribute){return this.hasAttribute(element,attribute)?element.attribs[attribute]:null},Parse5DomAdapter.prototype.getAttributeNS=function(element,ns,attribute){return this.getAttribute(element,attribute)},Parse5DomAdapter.prototype.setAttribute=function(element,attribute,value){attribute&&(element.attribs[attribute]=value,"class"===attribute&&(element.className=value))},Parse5DomAdapter.prototype.setAttributeNS=function(element,ns,attribute,value){this.setAttribute(element,attribute,value)},Parse5DomAdapter.prototype.removeAttribute=function(element,attribute){attribute&&delete element.attribs[attribute]},Parse5DomAdapter.prototype.removeAttributeNS=function(element,ns,name){throw"not implemented"},Parse5DomAdapter.prototype.templateAwareRoot=function(el){return this.isTemplateElement(el)?treeAdapter.getTemplateContent(el):el},Parse5DomAdapter.prototype.createHtmlDocument=function(){var newDoc=treeAdapter.createDocument();newDoc.title="fakeTitle";var head=treeAdapter.createElement("head",null,[]),body=treeAdapter.createElement("body","http://www.w3.org/1999/xhtml",[]);return this.appendChild(newDoc,head),this.appendChild(newDoc,body),newDoc.head=head,newDoc.body=body,newDoc._window={},newDoc},Parse5DomAdapter.prototype.getBoundingClientRect=function(el){return{left:0,top:0,width:0,height:0}},Parse5DomAdapter.prototype.getTitle=function(doc){return this.getText(this.getTitleNode(doc))||""},Parse5DomAdapter.prototype.setTitle=function(doc,newTitle){this.setText(this.getTitleNode(doc),newTitle||"")},Parse5DomAdapter.prototype.isTemplateElement=function(el){return this.isElementNode(el)&&"template"===this.tagName(el)},Parse5DomAdapter.prototype.isTextNode=function(node){return treeAdapter.isTextNode(node)},Parse5DomAdapter.prototype.isCommentNode=function(node){return treeAdapter.isCommentNode(node)},Parse5DomAdapter.prototype.isElementNode=function(node){return!!node&&treeAdapter.isElementNode(node)},Parse5DomAdapter.prototype.hasShadowRoot=function(node){return null!=node.shadowRoot},Parse5DomAdapter.prototype.isShadowRoot=function(node){return this.getShadowRoot(node)==node},Parse5DomAdapter.prototype.importIntoDoc=function(node){return this.clone(node)},Parse5DomAdapter.prototype.adoptNode=function(node){return node},Parse5DomAdapter.prototype.getHref=function(el){return this.getAttribute(el,"href")},Parse5DomAdapter.prototype.resolveAndSetHref=function(el,baseUrl,href){null==href?el.href=baseUrl:el.href=baseUrl+"/../"+href},Parse5DomAdapter.prototype._buildRules=function(parsedRules,css){for(var rules=[],i=0;i<parsedRules.length;i++){var parsedRule=parsedRules[i],rule={};if(rule.cssText=css,rule.style={content:"",cssText:""},"rule"==parsedRule.type){if(rule.type=1,rule.selectorText=parsedRule.selectors.join(", ".replace(/\s{2,}/g," ").replace(/\s*~\s*/g," ~ ").replace(/\s*\+\s*/g," + ").replace(/\s*>\s*/g," > ").replace(/\[(\w+)=(\w+)\]/g,'[$1="$2"]')),null==parsedRule.declarations)continue;for(var j=0;j<parsedRule.declarations.length;j++){var declaration=parsedRule.declarations[j];rule.style=declaration.property[declaration.value],rule.style.cssText+=declaration.property+": "+declaration.value+";"}}else"media"==parsedRule.type&&(rule.type=4,rule.media={mediaText:parsedRule.media},parsedRule.rules&&(rule.cssRules=this._buildRules(parsedRule.rules)));rules.push(rule)}return rules},Parse5DomAdapter.prototype.supportsDOMEvents=function(){return!1},Parse5DomAdapter.prototype.supportsNativeShadowDOM=function(){return!1},Parse5DomAdapter.prototype.getGlobalEventTarget=function(doc,target){return"window"==target?doc._window:"document"==target?doc:"body"==target?doc.body:void 0},Parse5DomAdapter.prototype.getBaseHref=function(doc){var base=this.querySelector(doc,"base"),href="";return base&&(href=this.getHref(base)),null==href?null:href},Parse5DomAdapter.prototype.resetBaseElement=function(){throw"not implemented"},Parse5DomAdapter.prototype.getHistory=function(){throw"not implemented"},Parse5DomAdapter.prototype.getLocation=function(){throw"not implemented"},Parse5DomAdapter.prototype.getUserAgent=function(){return"Fake user agent"},Parse5DomAdapter.prototype.getData=function(el,name){return this.getAttribute(el,"data-"+name)},Parse5DomAdapter.prototype.getComputedStyle=function(el){throw"not implemented"},Parse5DomAdapter.prototype.setData=function(el,name,value){this.setAttribute(el,"data-"+name,value)},Parse5DomAdapter.prototype.supportsWebAnimation=function(){return!1},Parse5DomAdapter.prototype.performanceNow=function(){return Date.now()},Parse5DomAdapter.prototype.getAnimationPrefix=function(){return""},Parse5DomAdapter.prototype.getTransitionEnd=function(){return"transitionend"},Parse5DomAdapter.prototype.supportsAnimation=function(){return!0},Parse5DomAdapter.prototype.replaceChild=function(el,newNode,oldNode){throw new Error("not implemented")},Parse5DomAdapter.prototype.parse=function(templateHtml){throw new Error("not implemented")},Parse5DomAdapter.prototype.invoke=function(el,methodName,args){throw new Error("not implemented")},Parse5DomAdapter.prototype.getEventKey=function(event){throw new Error("not implemented")},Parse5DomAdapter.prototype.supportsCookies=function(){return!1},Parse5DomAdapter.prototype.getCookie=function(name){throw new Error("not implemented")},Parse5DomAdapter.prototype.setCookie=function(name,value){throw new Error("not implemented")},Parse5DomAdapter.prototype.animate=function(element,keyframes,options){throw new Error("not implemented")},Parse5DomAdapter.prototype.getTitleNode=function(doc){var title=this.querySelector(doc,"title");return title||(title=this.createElement("title"),this.appendChild(this.querySelector(doc,"head"),title)),title},Parse5DomAdapter}(_angular_platformBrowser.ɵDomAdapter),_HTMLElementPropertyList=["webkitEntries","incremental","webkitdirectory","selectionDirection","selectionEnd","selectionStart","labels","validationMessage","validity","willValidate","width","valueAsNumber","valueAsDate","value","useMap","defaultValue","type","step","src","size","required","readOnly","placeholder","pattern","name","multiple","min","minLength","maxLength","max","list","indeterminate","height","formTarget","formNoValidate","formMethod","formEnctype","formAction","files","form","disabled","dirName","checked","defaultChecked","autofocus","autocomplete","alt","align","accept","onautocompleteerror","onautocomplete","onwaiting","onvolumechange","ontoggle","ontimeupdate","onsuspend","onsubmit","onstalled","onshow","onselect","onseeking","onseeked","onscroll","onresize","onreset","onratechange","onprogress","onplaying","onplay","onpause","onmousewheel","onmouseup","onmouseover","onmouseout","onmousemove","onmouseleave","onmouseenter","onmousedown","onloadstart","onloadedmetadata","onloadeddata","onload","onkeyup","onkeypress","onkeydown","oninvalid","oninput","onfocus","onerror","onended","onemptied","ondurationchange","ondrop","ondragstart","ondragover","ondragleave","ondragenter","ondragend","ondrag","ondblclick","oncuechange","oncontextmenu","onclose","onclick","onchange","oncanplaythrough","oncanplay","oncancel","onblur","onabort","spellcheck","isContentEditable","contentEditable","outerText","innerText","accessKey","hidden","webkitdropzone","draggable","tabIndex","dir","translate","lang","title","childElementCount","lastElementChild","firstElementChild","children","onwebkitfullscreenerror","onwebkitfullscreenchange","nextElementSibling","previousElementSibling","onwheel","onselectstart","onsearch","onpaste","oncut","oncopy","onbeforepaste","onbeforecut","onbeforecopy","shadowRoot","dataset","classList","className","outerHTML","innerHTML","scrollHeight","scrollWidth","scrollTop","scrollLeft","clientHeight","clientWidth","clientTop","clientLeft","offsetParent","offsetHeight","offsetWidth","offsetTop","offsetLeft","localName","prefix","namespaceURI","id","style","attributes","tagName","parentElement","textContent","baseURI","ownerDocument","nextSibling","previousSibling","lastChild","firstChild","childNodes","parentNode","nodeType","nodeValue","nodeName","closure_lm_714617","__jsaction"],EMPTY_ARRAY=[],ServerRendererFactory2=function(){function ServerRendererFactory2(ngZone,document,sharedStylesHost){this.ngZone=ngZone,this.document=document,this.sharedStylesHost=sharedStylesHost,this.rendererByCompId=new Map,this.schema=new _angular_compiler.DomElementSchemaRegistry,this.defaultRenderer=new DefaultServerRenderer2(document,ngZone,this.schema)}return ServerRendererFactory2.prototype.createRenderer=function(element,type){if(!element||!type)return this.defaultRenderer;switch(type.encapsulation){case _angular_core.ViewEncapsulation.Native:case _angular_core.ViewEncapsulation.Emulated:var renderer=this.rendererByCompId.get(type.id);return renderer||(renderer=new EmulatedEncapsulationServerRenderer2(this.document,this.ngZone,this.sharedStylesHost,this.schema,type),this.rendererByCompId.set(type.id,renderer)),renderer.applyToHost(element),renderer;case _angular_core.ViewEncapsulation.Native:throw new Error("Native encapsulation is not supported on the server!");default:if(!this.rendererByCompId.has(type.id)){var styles=_angular_platformBrowser.ɵflattenStyles(type.id,type.styles,[]);this.sharedStylesHost.addStyles(styles),this.rendererByCompId.set(type.id,this.defaultRenderer)}return this.defaultRenderer}},ServerRendererFactory2.prototype.begin=function(){},ServerRendererFactory2.prototype.end=function(){},ServerRendererFactory2}();ServerRendererFactory2.decorators=[{type:_angular_core.Injectable}],ServerRendererFactory2.ctorParameters=function(){return[{type:_angular_core.NgZone},{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_platformBrowser.DOCUMENT]}]},{type:_angular_platformBrowser.ɵSharedStylesHost}]};var DefaultServerRenderer2=function(){function DefaultServerRenderer2(document,ngZone,schema){this.document=document,this.ngZone=ngZone,this.schema=schema,this.data=Object.create(null)}return DefaultServerRenderer2.prototype.destroy=function(){},DefaultServerRenderer2.prototype.createElement=function(name,namespace,debugInfo){return namespace?_angular_platformBrowser.ɵgetDOM().createElementNS(_angular_platformBrowser.ɵNAMESPACE_URIS[namespace],name):_angular_platformBrowser.ɵgetDOM().createElement(name)},DefaultServerRenderer2.prototype.createComment=function(value,debugInfo){return _angular_platformBrowser.ɵgetDOM().createComment(value)},DefaultServerRenderer2.prototype.createText=function(value,debugInfo){return _angular_platformBrowser.ɵgetDOM().createTextNode(value)},DefaultServerRenderer2.prototype.appendChild=function(parent,newChild){_angular_platformBrowser.ɵgetDOM().appendChild(parent,newChild)},DefaultServerRenderer2.prototype.insertBefore=function(parent,newChild,refChild){parent&&_angular_platformBrowser.ɵgetDOM().insertBefore(parent,refChild,newChild)},DefaultServerRenderer2.prototype.removeChild=function(parent,oldChild){parent&&_angular_platformBrowser.ɵgetDOM().removeChild(parent,oldChild)},DefaultServerRenderer2.prototype.selectRootElement=function(selectorOrNode,debugInfo){var el;if("string"==typeof selectorOrNode){if(el=_angular_platformBrowser.ɵgetDOM().querySelector(this.document,selectorOrNode),!el)throw new Error('The selector "'+selectorOrNode+'" did not match any elements')}else el=selectorOrNode;return _angular_platformBrowser.ɵgetDOM().clearNodes(el),el},DefaultServerRenderer2.prototype.parentNode=function(node){return _angular_platformBrowser.ɵgetDOM().parentElement(node)},DefaultServerRenderer2.prototype.nextSibling=function(node){return _angular_platformBrowser.ɵgetDOM().nextSibling(node)},DefaultServerRenderer2.prototype.setAttribute=function(el,name,value,namespace){namespace?_angular_platformBrowser.ɵgetDOM().setAttributeNS(el,_angular_platformBrowser.ɵNAMESPACE_URIS[namespace],namespace+":"+name,value):_angular_platformBrowser.ɵgetDOM().setAttribute(el,name,value)},DefaultServerRenderer2.prototype.removeAttribute=function(el,name,namespace){namespace?_angular_platformBrowser.ɵgetDOM().removeAttributeNS(el,_angular_platformBrowser.ɵNAMESPACE_URIS[namespace],name):_angular_platformBrowser.ɵgetDOM().removeAttribute(el,name)},DefaultServerRenderer2.prototype.addClass=function(el,name){_angular_platformBrowser.ɵgetDOM().addClass(el,name)},DefaultServerRenderer2.prototype.removeClass=function(el,name){_angular_platformBrowser.ɵgetDOM().removeClass(el,name)},DefaultServerRenderer2.prototype.setStyle=function(el,style,value,flags){_angular_platformBrowser.ɵgetDOM().setStyle(el,style,value)},DefaultServerRenderer2.prototype.removeStyle=function(el,style,flags){_angular_platformBrowser.ɵgetDOM().removeStyle(el,style)},DefaultServerRenderer2.prototype._isSafeToReflectProperty=function(tagName,propertyName){return this.schema.securityContext(tagName,propertyName,!0)===this.schema.securityContext(tagName,propertyName,!1)},DefaultServerRenderer2.prototype.setProperty=function(el,name,value){checkNoSyntheticProp(name,"property"),_angular_platformBrowser.ɵgetDOM().setProperty(el,name,value);var tagName=el.tagName.toLowerCase();null!=value&&("number"==typeof value||"string"==typeof value)&&this.schema.hasElement(tagName,EMPTY_ARRAY)&&this.schema.hasProperty(tagName,name,EMPTY_ARRAY)&&this._isSafeToReflectProperty(tagName,name)&&this.setAttribute(el,name,value.toString())},DefaultServerRenderer2.prototype.setValue=function(node,value){_angular_platformBrowser.ɵgetDOM().setText(node,value)},DefaultServerRenderer2.prototype.listen=function(target,eventName,callback){var _this=this;checkNoSyntheticProp(eventName,"listener");var el="string"==typeof target?_angular_platformBrowser.ɵgetDOM().getGlobalEventTarget(this.document,target):target,outsideHandler=function(event){return _this.ngZone.runGuarded(function(){return callback(event)})};return this.ngZone.runOutsideAngular(function(){return _angular_platformBrowser.ɵgetDOM().onAndCancel(el,eventName,outsideHandler)})},DefaultServerRenderer2}(),AT_CHARCODE="@".charCodeAt(0),EmulatedEncapsulationServerRenderer2=function(_super){function EmulatedEncapsulationServerRenderer2(document,ngZone,sharedStylesHost,schema,component){var _this=_super.call(this,document,ngZone,schema)||this;_this.component=component;var styles=_angular_platformBrowser.ɵflattenStyles(component.id,component.styles,[]);return sharedStylesHost.addStyles(styles),_this.contentAttr=_angular_platformBrowser.ɵshimContentAttribute(component.id),_this.hostAttr=_angular_platformBrowser.ɵshimHostAttribute(component.id),_this}return __extends(EmulatedEncapsulationServerRenderer2,_super),EmulatedEncapsulationServerRenderer2.prototype.applyToHost=function(element){_super.prototype.setAttribute.call(this,element,this.hostAttr,"")},EmulatedEncapsulationServerRenderer2.prototype.createElement=function(parent,name){var el=_super.prototype.createElement.call(this,parent,name);return _super.prototype.setAttribute.call(this,el,this.contentAttr,""),el},EmulatedEncapsulationServerRenderer2}(DefaultServerRenderer2),ServerStylesHost=function(_super){function ServerStylesHost(doc,transitionId){var _this=_super.call(this)||this;return _this.doc=doc,_this.transitionId=transitionId,_this.head=null,_this.head=_angular_platformBrowser.ɵgetDOM().getElementsByTagName(doc,"head")[0],_this}return __extends(ServerStylesHost,_super),ServerStylesHost.prototype._addStyle=function(style){var adapter=_angular_platformBrowser.ɵgetDOM(),el=adapter.createElement("style");adapter.setText(el,style),this.transitionId&&adapter.setAttribute(el,"ng-transition",this.transitionId),adapter.appendChild(this.head,el)},ServerStylesHost.prototype.onStylesAdded=function(additions){var _this=this;additions.forEach(function(style){return _this._addStyle(style)})},ServerStylesHost}(_angular_platformBrowser.ɵSharedStylesHost);ServerStylesHost.decorators=[{type:_angular_core.Injectable}],ServerStylesHost.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_platformBrowser.DOCUMENT]}]},{type:void 0,decorators:[{type:_angular_core.Optional},{type:_angular_core.Inject,args:[_angular_platformBrowser.ɵTRANSITION_ID]}]}]};/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var INTERNAL_SERVER_PLATFORM_PROVIDERS=[{provide:_angular_platformBrowser.DOCUMENT,useFactory:_document,deps:[_angular_core.Injector]},{provide:_angular_core.PLATFORM_ID,useValue:_angular_common.ɵPLATFORM_SERVER_ID},{provide:_angular_core.PLATFORM_INITIALIZER,useFactory:initParse5Adapter,multi:!0,deps:[_angular_core.Injector]},{provide:_angular_common.PlatformLocation,useClass:ServerPlatformLocation},PlatformState,{provide:_angular_core.ɵALLOW_MULTIPLE_PLATFORMS,useValue:!0}],SERVER_RENDER_PROVIDERS=[ServerRendererFactory2,{provide:_angular_core.RendererFactory2,useFactory:instantiateServerRendererFactory,deps:[ServerRendererFactory2,_angular_animations_browser.ɵAnimationEngine,_angular_core.NgZone]},ServerStylesHost,{provide:_angular_platformBrowser.ɵSharedStylesHost,useExisting:ServerStylesHost}],ServerModule=function(){function ServerModule(){}return ServerModule}();ServerModule.decorators=[{type:_angular_core.NgModule,args:[{exports:[_angular_platformBrowser.BrowserModule],imports:[_angular_http.HttpModule,_angular_platformBrowser_animations.NoopAnimationsModule],providers:[SERVER_RENDER_PROVIDERS,SERVER_HTTP_PROVIDERS,{provide:_angular_core.Testability,useValue:null}]}]}],ServerModule.ctorParameters=function(){return[]};var platformServer=_angular_core.createPlatformFactory(_angular_core.platformCore,"server",INTERNAL_SERVER_PLATFORM_PROVIDERS),platformDynamicServer=_angular_core.createPlatformFactory(_angular_compiler.platformCoreDynamic,"serverDynamic",INTERNAL_SERVER_PLATFORM_PROVIDERS),VERSION=(require("parse5"),new _angular_core.Version("4.2.2"));exports.PlatformState=PlatformState,exports.ServerModule=ServerModule,exports.platformDynamicServer=platformDynamicServer,exports.platformServer=platformServer,exports.INITIAL_CONFIG=INITIAL_CONFIG,exports.renderModule=renderModule,exports.renderModuleFactory=renderModuleFactory,exports.VERSION=VERSION,exports.ɵINTERNAL_SERVER_PLATFORM_PROVIDERS=INTERNAL_SERVER_PLATFORM_PROVIDERS,exports.ɵSERVER_RENDER_PROVIDERS=SERVER_RENDER_PROVIDERS,exports.ɵServerRendererFactory2=ServerRendererFactory2,exports.ɵf=SERVER_HTTP_PROVIDERS,exports.ɵc=ServerXhr,exports.ɵd=ServerXsrfStrategy,exports.ɵe=httpFactory,exports.ɵa=instantiateServerRendererFactory,exports.ɵb=ServerStylesHost,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=platform-server.umd.min.js.map
