/**
 * @license Angular v6.1.4
 * (c) 2010-2018 Google, Inc. https://angular.io/
 * License: MIT
 */

(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/platform-browser'), require('@angular/core'), require('@angular/http'), require('@angular/common/http'), require('rxjs'), require('url'), require('@angular/compiler'), require('@angular/animations/browser'), require('@angular/common'), require('@angular/platform-browser-dynamic'), require('@angular/platform-browser/animations'), require('rxjs/operators')) :
    typeof define === 'function' && define.amd ? define('@angular/platform-server', ['exports', '@angular/platform-browser', '@angular/core', '@angular/http', '@angular/common/http', 'rxjs', 'url', '@angular/compiler', '@angular/animations/browser', '@angular/common', '@angular/platform-browser-dynamic', '@angular/platform-browser/animations', 'rxjs/operators'], factory) :
    (factory((global.ng = global.ng || {}, global.ng.platformServer = {}),global.ng.platformBrowser,global.ng.core,global.ng.http,global.ng.common.http,global.rxjs,null,global.ng.compiler,global.ng.animations.browser,global.ng.common,global.ng.platformBrowserDynamic,global.ng.platformBrowser.animations,global.rxjs.operators));
}(this, (function (exports,platformBrowser,core,http,http$1,rxjs,url,compiler,browser,common,platformBrowserDynamic,animations,operators) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var domino = require('domino');
    function _notImplemented(methodName) {
        return new Error('This method is not implemented in DominoAdapter: ' + methodName);
    }
    function setDomTypes() {
        // Make all Domino types available as types in the global env.
        Object.assign(global, domino.impl);
        global['KeyboardEvent'] = domino.impl.Event;
    }
    /**
     * Parses a document string to a Document object.
     */
    function parseDocument(html, url$$1) {
        if (url$$1 === void 0) { url$$1 = '/'; }
        var window = domino.createWindow(html, url$$1);
        var doc = window.document;
        return doc;
    }
    /**
     * Serializes a document to string.
     */
    function serializeDocument(doc) {
        return doc.serialize();
    }
    /**
     * DOM Adapter for the server platform based on https://github.com/fgnass/domino.
     */
    var DominoAdapter = /** @class */ (function (_super) {
        __extends(DominoAdapter, _super);
        function DominoAdapter() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        DominoAdapter.makeCurrent = function () {
            setDomTypes();
            platformBrowser.ɵsetRootDomAdapter(new DominoAdapter());
        };
        DominoAdapter.prototype.logError = function (error) { console.error(error); };
        DominoAdapter.prototype.log = function (error) {
            // tslint:disable-next-line:no-console
            console.log(error);
        };
        DominoAdapter.prototype.logGroup = function (error) { console.error(error); };
        DominoAdapter.prototype.logGroupEnd = function () { };
        DominoAdapter.prototype.supportsDOMEvents = function () { return false; };
        DominoAdapter.prototype.supportsNativeShadowDOM = function () { return false; };
        DominoAdapter.prototype.contains = function (nodeA, nodeB) {
            var inner = nodeB;
            while (inner) {
                if (inner === nodeA)
                    return true;
                inner = inner.parent;
            }
            return false;
        };
        DominoAdapter.prototype.createHtmlDocument = function () {
            return parseDocument('<html><head><title>fakeTitle</title></head><body></body></html>');
        };
        DominoAdapter.prototype.getDefaultDocument = function () {
            if (!DominoAdapter.defaultDoc) {
                DominoAdapter.defaultDoc = domino.createDocument();
            }
            return DominoAdapter.defaultDoc;
        };
        DominoAdapter.prototype.createShadowRoot = function (el, doc) {
            if (doc === void 0) { doc = document; }
            el.shadowRoot = doc.createDocumentFragment();
            el.shadowRoot.parent = el;
            return el.shadowRoot;
        };
        DominoAdapter.prototype.getShadowRoot = function (el) { return el.shadowRoot; };
        DominoAdapter.prototype.isTextNode = function (node) { return node.nodeType === DominoAdapter.defaultDoc.TEXT_NODE; };
        DominoAdapter.prototype.isCommentNode = function (node) {
            return node.nodeType === DominoAdapter.defaultDoc.COMMENT_NODE;
        };
        DominoAdapter.prototype.isElementNode = function (node) {
            return node ? node.nodeType === DominoAdapter.defaultDoc.ELEMENT_NODE : false;
        };
        DominoAdapter.prototype.hasShadowRoot = function (node) { return node.shadowRoot != null; };
        DominoAdapter.prototype.isShadowRoot = function (node) { return this.getShadowRoot(node) == node; };
        DominoAdapter.prototype.getProperty = function (el, name) {
            if (name === 'href') {
                // Domino tries tp resolve href-s which we do not want. Just return the
                // attribute value.
                return this.getAttribute(el, 'href');
            }
            else if (name === 'innerText') {
                // Domino does not support innerText. Just map it to textContent.
                return el.textContent;
            }
            return el[name];
        };
        DominoAdapter.prototype.setProperty = function (el, name, value) {
            if (name === 'href') {
                // Even though the server renderer reflects any properties to attributes
                // map 'href' to attribute just to handle when setProperty is directly called.
                this.setAttribute(el, 'href', value);
            }
            else if (name === 'innerText') {
                // Domino does not support innerText. Just map it to textContent.
                el.textContent = value;
            }
            el[name] = value;
        };
        DominoAdapter.prototype.getGlobalEventTarget = function (doc, target) {
            if (target === 'window') {
                return doc.defaultView;
            }
            if (target === 'document') {
                return doc;
            }
            if (target === 'body') {
                return doc.body;
            }
            return null;
        };
        DominoAdapter.prototype.getBaseHref = function (doc) {
            var base = this.querySelector(doc.documentElement, 'base');
            var href = '';
            if (base) {
                href = this.getHref(base);
            }
            // TODO(alxhub): Need relative path logic from BrowserDomAdapter here?
            return href;
        };
        /** @internal */
        DominoAdapter.prototype._readStyleAttribute = function (element) {
            var styleMap = {};
            var styleAttribute = element.getAttribute('style');
            if (styleAttribute) {
                var styleList = styleAttribute.split(/;+/g);
                for (var i = 0; i < styleList.length; i++) {
                    var style = styleList[i].trim();
                    if (style.length > 0) {
                        var colonIndex = style.indexOf(':');
                        if (colonIndex === -1) {
                            throw new Error("Invalid CSS style: " + style);
                        }
                        var name_1 = style.substr(0, colonIndex).trim();
                        styleMap[name_1] = style.substr(colonIndex + 1).trim();
                    }
                }
            }
            return styleMap;
        };
        /** @internal */
        DominoAdapter.prototype._writeStyleAttribute = function (element, styleMap) {
            var styleAttrValue = '';
            for (var key in styleMap) {
                var newValue = styleMap[key];
                if (newValue) {
                    styleAttrValue += key + ':' + styleMap[key] + ';';
                }
            }
            element.setAttribute('style', styleAttrValue);
        };
        DominoAdapter.prototype.setStyle = function (element, styleName, styleValue) {
            styleName = styleName.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
            var styleMap = this._readStyleAttribute(element);
            styleMap[styleName] = styleValue || '';
            this._writeStyleAttribute(element, styleMap);
        };
        DominoAdapter.prototype.removeStyle = function (element, styleName) {
            // IE requires '' instead of null
            // see https://github.com/angular/angular/issues/7916
            this.setStyle(element, styleName, '');
        };
        DominoAdapter.prototype.getStyle = function (element, styleName) {
            var styleMap = this._readStyleAttribute(element);
            return styleMap[styleName] || '';
        };
        DominoAdapter.prototype.hasStyle = function (element, styleName, styleValue) {
            var value = this.getStyle(element, styleName);
            return styleValue ? value == styleValue : value.length > 0;
        };
        DominoAdapter.prototype.dispatchEvent = function (el, evt) {
            el.dispatchEvent(evt);
            // Dispatch the event to the window also.
            var doc = el.ownerDocument || el;
            var win = doc.defaultView;
            if (win) {
                win.dispatchEvent(evt);
            }
        };
        DominoAdapter.prototype.getHistory = function () { throw _notImplemented('getHistory'); };
        DominoAdapter.prototype.getLocation = function () { throw _notImplemented('getLocation'); };
        DominoAdapter.prototype.getUserAgent = function () { return 'Fake user agent'; };
        DominoAdapter.prototype.supportsWebAnimation = function () { return false; };
        DominoAdapter.prototype.performanceNow = function () { return Date.now(); };
        DominoAdapter.prototype.getAnimationPrefix = function () { return ''; };
        DominoAdapter.prototype.getTransitionEnd = function () { return 'transitionend'; };
        DominoAdapter.prototype.supportsAnimation = function () { return true; };
        DominoAdapter.prototype.getDistributedNodes = function (el) { throw _notImplemented('getDistributedNodes'); };
        DominoAdapter.prototype.supportsCookies = function () { return false; };
        DominoAdapter.prototype.getCookie = function (name) { throw _notImplemented('getCookie'); };
        DominoAdapter.prototype.setCookie = function (name, value) { throw _notImplemented('setCookie'); };
        return DominoAdapter;
    }(platformBrowser.ɵBrowserDomAdapter));

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Representation of the current platform state.
     *
     * @experimental
     */
    var PlatformState = /** @class */ (function () {
        function PlatformState(_doc) {
            this._doc = _doc;
        }
        /**
         * Renders the current state of the platform to string.
         */
        PlatformState.prototype.renderToString = function () { return serializeDocument(this._doc); };
        /**
         * Returns the current DOM state.
         */
        PlatformState.prototype.getDocument = function () { return this._doc; };
        PlatformState.decorators = [
            { type: core.Injectable }
        ];
        /** @nocollapse */
        PlatformState.ctorParameters = function () { return [
            { type: undefined, decorators: [{ type: core.Inject, args: [platformBrowser.DOCUMENT,] }] }
        ]; };
        return PlatformState;
    }());

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var xhr2 = require('xhr2');
    var isAbsoluteUrl = /^[a-zA-Z\-\+.]+:\/\//;
    function validateRequestUrl(url$$1) {
        if (!isAbsoluteUrl.test(url$$1)) {
            throw new Error("URLs requested via Http on the server must be absolute. URL: " + url$$1);
        }
    }
    var ServerXhr = /** @class */ (function () {
        function ServerXhr() {
        }
        ServerXhr.prototype.build = function () { return new xhr2.XMLHttpRequest(); };
        ServerXhr.decorators = [
            { type: core.Injectable }
        ];
        return ServerXhr;
    }());
    var ServerXsrfStrategy = /** @class */ (function () {
        function ServerXsrfStrategy() {
        }
        ServerXsrfStrategy.prototype.configureRequest = function (req) { };
        ServerXsrfStrategy.decorators = [
            { type: core.Injectable }
        ];
        return ServerXsrfStrategy;
    }());
    var ZoneMacroTaskWrapper = /** @class */ (function () {
        function ZoneMacroTaskWrapper() {
        }
        ZoneMacroTaskWrapper.prototype.wrap = function (request) {
            var _this = this;
            return new rxjs.Observable(function (observer) {
                var task = null;
                var scheduled = false;
                var sub = null;
                var savedResult = null;
                var savedError = null;
                var scheduleTask = function (_task) {
                    task = _task;
                    scheduled = true;
                    var delegate = _this.delegate(request);
                    sub = delegate.subscribe(function (res) { return savedResult = res; }, function (err) {
                        if (!scheduled) {
                            throw new Error('An http observable was completed twice. This shouldn\'t happen, please file a bug.');
                        }
                        savedError = err;
                        scheduled = false;
                        task.invoke();
                    }, function () {
                        if (!scheduled) {
                            throw new Error('An http observable was completed twice. This shouldn\'t happen, please file a bug.');
                        }
                        scheduled = false;
                        task.invoke();
                    });
                };
                var cancelTask = function (_task) {
                    if (!scheduled) {
                        return;
                    }
                    scheduled = false;
                    if (sub) {
                        sub.unsubscribe();
                        sub = null;
                    }
                };
                var onComplete = function () {
                    if (savedError !== null) {
                        observer.error(savedError);
                    }
                    else {
                        observer.next(savedResult);
                        observer.complete();
                    }
                };
                // MockBackend for Http is synchronous, which means that if scheduleTask is by
                // scheduleMacroTask, the request will hit MockBackend and the response will be
                // sent, causing task.invoke() to be called.
                var _task = Zone.current.scheduleMacroTask('ZoneMacroTaskWrapper.subscribe', onComplete, {}, function () { return null; }, cancelTask);
                scheduleTask(_task);
                return function () {
                    if (scheduled && task) {
                        task.zone.cancelTask(task);
                        scheduled = false;
                    }
                    if (sub) {
                        sub.unsubscribe();
                        sub = null;
                    }
                };
            });
        };
        return ZoneMacroTaskWrapper;
    }());
    var ZoneMacroTaskConnection = /** @class */ (function (_super) {
        __extends(ZoneMacroTaskConnection, _super);
        function ZoneMacroTaskConnection(request, backend) {
            var _this = _super.call(this) || this;
            _this.request = request;
            _this.backend = backend;
            validateRequestUrl(request.url);
            _this.response = _this.wrap(request);
            return _this;
        }
        ZoneMacroTaskConnection.prototype.delegate = function (request) {
            this.lastConnection = this.backend.createConnection(request);
            return this.lastConnection.response;
        };
        Object.defineProperty(ZoneMacroTaskConnection.prototype, "readyState", {
            get: function () {
                return !!this.lastConnection ? this.lastConnection.readyState : http.ReadyState.Unsent;
            },
            enumerable: true,
            configurable: true
        });
        return ZoneMacroTaskConnection;
    }(ZoneMacroTaskWrapper));
    var ZoneMacroTaskBackend = /** @class */ (function () {
        function ZoneMacroTaskBackend(backend) {
            this.backend = backend;
        }
        ZoneMacroTaskBackend.prototype.createConnection = function (request) {
            return new ZoneMacroTaskConnection(request, this.backend);
        };
        return ZoneMacroTaskBackend;
    }());
    var ZoneClientBackend = /** @class */ (function (_super) {
        __extends(ZoneClientBackend, _super);
        function ZoneClientBackend(backend) {
            var _this = _super.call(this) || this;
            _this.backend = backend;
            return _this;
        }
        ZoneClientBackend.prototype.handle = function (request) { return this.wrap(request); };
        ZoneClientBackend.prototype.delegate = function (request) {
            return this.backend.handle(request);
        };
        return ZoneClientBackend;
    }(ZoneMacroTaskWrapper));
    function httpFactory(xhrBackend, options) {
        var macroBackend = new ZoneMacroTaskBackend(xhrBackend);
        return new http.Http(macroBackend, options);
    }
    function zoneWrappedInterceptingHandler(backend, injector) {
        var realBackend = new http$1.ɵHttpInterceptingHandler(backend, injector);
        return new ZoneClientBackend(realBackend);
    }
    var SERVER_HTTP_PROVIDERS = [
        { provide: http.Http, useFactory: httpFactory, deps: [http.XHRBackend, http.RequestOptions] },
        { provide: http.BrowserXhr, useClass: ServerXhr }, { provide: http.XSRFStrategy, useClass: ServerXsrfStrategy },
        { provide: http$1.XhrFactory, useClass: ServerXhr }, {
            provide: http$1.HttpHandler,
            useFactory: zoneWrappedInterceptingHandler,
            deps: [http$1.HttpBackend, core.Injector]
        }
    ];

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * The DI token for setting the initial config for the platform.
     *
     * @experimental
     */
    var INITIAL_CONFIG = new core.InjectionToken('Server.INITIAL_CONFIG');
    /**
     * A function that will be executed when calling `renderModuleFactory` or `renderModule` just
     * before current platform state is rendered to string.
     *
     * @experimental
     */
    var BEFORE_APP_SERIALIZED = new core.InjectionToken('Server.RENDER_MODULE_HOOK');

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function parseUrl(urlStr) {
        var parsedUrl = url.parse(urlStr);
        return {
            pathname: parsedUrl.pathname || '',
            search: parsedUrl.search || '',
            hash: parsedUrl.hash || '',
        };
    }
    /**
     * Server-side implementation of URL state. Implements `pathname`, `search`, and `hash`
     * but not the state stack.
     */
    var ServerPlatformLocation = /** @class */ (function () {
        function ServerPlatformLocation(_doc, _config) {
            this._doc = _doc;
            this.pathname = '/';
            this.search = '';
            this.hash = '';
            this._hashUpdate = new rxjs.Subject();
            var config = _config;
            if (!!config && !!config.url) {
                var parsedUrl = parseUrl(config.url);
                this.pathname = parsedUrl.pathname;
                this.search = parsedUrl.search;
                this.hash = parsedUrl.hash;
            }
        }
        ServerPlatformLocation.prototype.getBaseHrefFromDOM = function () { return platformBrowser.ɵgetDOM().getBaseHref(this._doc); };
        ServerPlatformLocation.prototype.onPopState = function (fn) {
            // No-op: a state stack is not implemented, so
            // no events will ever come.
        };
        ServerPlatformLocation.prototype.onHashChange = function (fn) { this._hashUpdate.subscribe(fn); };
        Object.defineProperty(ServerPlatformLocation.prototype, "url", {
            get: function () { return "" + this.pathname + this.search + this.hash; },
            enumerable: true,
            configurable: true
        });
        ServerPlatformLocation.prototype.setHash = function (value, oldUrl) {
            var _this = this;
            if (this.hash === value) {
                // Don't fire events if the hash has not changed.
                return;
            }
            this.hash = value;
            var newUrl = this.url;
            scheduleMicroTask(function () { return _this._hashUpdate.next({
                type: 'hashchange', state: null, oldUrl: oldUrl, newUrl: newUrl
            }); });
        };
        ServerPlatformLocation.prototype.replaceState = function (state, title, newUrl) {
            var oldUrl = this.url;
            var parsedUrl = parseUrl(newUrl);
            this.pathname = parsedUrl.pathname;
            this.search = parsedUrl.search;
            this.setHash(parsedUrl.hash, oldUrl);
        };
        ServerPlatformLocation.prototype.pushState = function (state, title, newUrl) {
            this.replaceState(state, title, newUrl);
        };
        ServerPlatformLocation.prototype.forward = function () { throw new Error('Not implemented'); };
        ServerPlatformLocation.prototype.back = function () { throw new Error('Not implemented'); };
        ServerPlatformLocation.decorators = [
            { type: core.Injectable }
        ];
        /** @nocollapse */
        ServerPlatformLocation.ctorParameters = function () { return [
            { type: undefined, decorators: [{ type: core.Inject, args: [platformBrowser.DOCUMENT,] }] },
            { type: undefined, decorators: [{ type: core.Optional }, { type: core.Inject, args: [INITIAL_CONFIG,] }] }
        ]; };
        return ServerPlatformLocation;
    }());
    function scheduleMicroTask(fn) {
        Zone.current.scheduleMicroTask('scheduleMicrotask', fn);
    }

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ServerEventManagerPlugin = /** @class */ (function () {
        function ServerEventManagerPlugin(doc) {
            this.doc = doc;
        }
        // Handle all events on the server.
        ServerEventManagerPlugin.prototype.supports = function (eventName) { return true; };
        ServerEventManagerPlugin.prototype.addEventListener = function (element, eventName, handler) {
            return platformBrowser.ɵgetDOM().onAndCancel(element, eventName, handler);
        };
        ServerEventManagerPlugin.prototype.addGlobalEventListener = function (element, eventName, handler) {
            var target = platformBrowser.ɵgetDOM().getGlobalEventTarget(this.doc, element);
            if (!target) {
                throw new Error("Unsupported event target " + target + " for event " + eventName);
            }
            return this.addEventListener(target, eventName, handler);
        };
        ServerEventManagerPlugin.decorators = [
            { type: core.Injectable }
        ];
        /** @nocollapse */
        ServerEventManagerPlugin.ctorParameters = function () { return [
            { type: undefined, decorators: [{ type: core.Inject, args: [platformBrowser.DOCUMENT,] }] }
        ]; };
        return ServerEventManagerPlugin;
    }());

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var EMPTY_ARRAY = [];
    var ServerRendererFactory2 = /** @class */ (function () {
        function ServerRendererFactory2(eventManager, ngZone, document, sharedStylesHost) {
            this.eventManager = eventManager;
            this.ngZone = ngZone;
            this.document = document;
            this.sharedStylesHost = sharedStylesHost;
            this.rendererByCompId = new Map();
            this.schema = new compiler.DomElementSchemaRegistry();
            this.defaultRenderer = new DefaultServerRenderer2(eventManager, document, ngZone, this.schema);
        }
        ServerRendererFactory2.prototype.createRenderer = function (element, type) {
            if (!element || !type) {
                return this.defaultRenderer;
            }
            switch (type.encapsulation) {
                case core.ViewEncapsulation.Native:
                case core.ViewEncapsulation.Emulated: {
                    var renderer = this.rendererByCompId.get(type.id);
                    if (!renderer) {
                        renderer = new EmulatedEncapsulationServerRenderer2(this.eventManager, this.document, this.ngZone, this.sharedStylesHost, this.schema, type);
                        this.rendererByCompId.set(type.id, renderer);
                    }
                    renderer.applyToHost(element);
                    return renderer;
                }
                case core.ViewEncapsulation.Native:
                    throw new Error('Native encapsulation is not supported on the server!');
                default: {
                    if (!this.rendererByCompId.has(type.id)) {
                        var styles = platformBrowser.ɵflattenStyles(type.id, type.styles, []);
                        this.sharedStylesHost.addStyles(styles);
                        this.rendererByCompId.set(type.id, this.defaultRenderer);
                    }
                    return this.defaultRenderer;
                }
            }
        };
        ServerRendererFactory2.prototype.begin = function () { };
        ServerRendererFactory2.prototype.end = function () { };
        ServerRendererFactory2.decorators = [
            { type: core.Injectable }
        ];
        /** @nocollapse */
        ServerRendererFactory2.ctorParameters = function () { return [
            { type: platformBrowser.EventManager },
            { type: core.NgZone },
            { type: undefined, decorators: [{ type: core.Inject, args: [platformBrowser.DOCUMENT,] }] },
            { type: platformBrowser.ɵSharedStylesHost }
        ]; };
        return ServerRendererFactory2;
    }());
    var DefaultServerRenderer2 = /** @class */ (function () {
        function DefaultServerRenderer2(eventManager, document, ngZone, schema) {
            this.eventManager = eventManager;
            this.document = document;
            this.ngZone = ngZone;
            this.schema = schema;
            this.data = Object.create(null);
        }
        DefaultServerRenderer2.prototype.destroy = function () { };
        DefaultServerRenderer2.prototype.createElement = function (name, namespace, debugInfo) {
            if (namespace) {
                return platformBrowser.ɵgetDOM().createElementNS(platformBrowser.ɵNAMESPACE_URIS[namespace], name, this.document);
            }
            return platformBrowser.ɵgetDOM().createElement(name, this.document);
        };
        DefaultServerRenderer2.prototype.createComment = function (value, debugInfo) { return platformBrowser.ɵgetDOM().createComment(value); };
        DefaultServerRenderer2.prototype.createText = function (value, debugInfo) { return platformBrowser.ɵgetDOM().createTextNode(value); };
        DefaultServerRenderer2.prototype.appendChild = function (parent, newChild) { platformBrowser.ɵgetDOM().appendChild(parent, newChild); };
        DefaultServerRenderer2.prototype.insertBefore = function (parent, newChild, refChild) {
            if (parent) {
                platformBrowser.ɵgetDOM().insertBefore(parent, refChild, newChild);
            }
        };
        DefaultServerRenderer2.prototype.removeChild = function (parent, oldChild) {
            if (parent) {
                platformBrowser.ɵgetDOM().removeChild(parent, oldChild);
            }
        };
        DefaultServerRenderer2.prototype.selectRootElement = function (selectorOrNode, debugInfo) {
            var el;
            if (typeof selectorOrNode === 'string') {
                el = platformBrowser.ɵgetDOM().querySelector(this.document, selectorOrNode);
                if (!el) {
                    throw new Error("The selector \"" + selectorOrNode + "\" did not match any elements");
                }
            }
            else {
                el = selectorOrNode;
            }
            platformBrowser.ɵgetDOM().clearNodes(el);
            return el;
        };
        DefaultServerRenderer2.prototype.parentNode = function (node) { return platformBrowser.ɵgetDOM().parentElement(node); };
        DefaultServerRenderer2.prototype.nextSibling = function (node) { return platformBrowser.ɵgetDOM().nextSibling(node); };
        DefaultServerRenderer2.prototype.setAttribute = function (el, name, value, namespace) {
            if (namespace) {
                platformBrowser.ɵgetDOM().setAttributeNS(el, platformBrowser.ɵNAMESPACE_URIS[namespace], namespace + ':' + name, value);
            }
            else {
                platformBrowser.ɵgetDOM().setAttribute(el, name, value);
            }
        };
        DefaultServerRenderer2.prototype.removeAttribute = function (el, name, namespace) {
            if (namespace) {
                platformBrowser.ɵgetDOM().removeAttributeNS(el, platformBrowser.ɵNAMESPACE_URIS[namespace], name);
            }
            else {
                platformBrowser.ɵgetDOM().removeAttribute(el, name);
            }
        };
        DefaultServerRenderer2.prototype.addClass = function (el, name) { platformBrowser.ɵgetDOM().addClass(el, name); };
        DefaultServerRenderer2.prototype.removeClass = function (el, name) { platformBrowser.ɵgetDOM().removeClass(el, name); };
        DefaultServerRenderer2.prototype.setStyle = function (el, style, value, flags) {
            platformBrowser.ɵgetDOM().setStyle(el, style, value);
        };
        DefaultServerRenderer2.prototype.removeStyle = function (el, style, flags) {
            platformBrowser.ɵgetDOM().removeStyle(el, style);
        };
        // The value was validated already as a property binding, against the property name.
        // To know this value is safe to use as an attribute, the security context of the
        // attribute with the given name is checked against that security context of the
        // property.
        DefaultServerRenderer2.prototype._isSafeToReflectProperty = function (tagName, propertyName) {
            return this.schema.securityContext(tagName, propertyName, true) ===
                this.schema.securityContext(tagName, propertyName, false);
        };
        DefaultServerRenderer2.prototype.setProperty = function (el, name, value) {
            checkNoSyntheticProp(name, 'property');
            platformBrowser.ɵgetDOM().setProperty(el, name, value);
            // Mirror property values for known HTML element properties in the attributes.
            // Skip `innerhtml` which is conservatively marked as an attribute for security
            // purposes but is not actually an attribute.
            var tagName = el.tagName.toLowerCase();
            if (value != null && (typeof value === 'number' || typeof value == 'string') &&
                name.toLowerCase() !== 'innerhtml' && this.schema.hasElement(tagName, EMPTY_ARRAY) &&
                this.schema.hasProperty(tagName, name, EMPTY_ARRAY) &&
                this._isSafeToReflectProperty(tagName, name)) {
                this.setAttribute(el, name, value.toString());
            }
        };
        DefaultServerRenderer2.prototype.setValue = function (node, value) { platformBrowser.ɵgetDOM().setText(node, value); };
        DefaultServerRenderer2.prototype.listen = function (target, eventName, callback) {
            checkNoSyntheticProp(eventName, 'listener');
            if (typeof target === 'string') {
                return this.eventManager.addGlobalEventListener(target, eventName, this.decoratePreventDefault(callback));
            }
            return this.eventManager.addEventListener(target, eventName, this.decoratePreventDefault(callback));
        };
        DefaultServerRenderer2.prototype.decoratePreventDefault = function (eventHandler) {
            var _this = this;
            return function (event) {
                // Run the event handler inside the ngZone because event handlers are not patched
                // by Zone on the server. This is required only for tests.
                var allowDefaultBehavior = _this.ngZone.runGuarded(function () { return eventHandler(event); });
                if (allowDefaultBehavior === false) {
                    event.preventDefault();
                    event.returnValue = false;
                }
            };
        };
        return DefaultServerRenderer2;
    }());
    var AT_CHARCODE = '@'.charCodeAt(0);
    function checkNoSyntheticProp(name, nameKind) {
        if (name.charCodeAt(0) === AT_CHARCODE) {
            throw new Error("Found the synthetic " + nameKind + " " + name + ". Please include either \"BrowserAnimationsModule\" or \"NoopAnimationsModule\" in your application.");
        }
    }
    var EmulatedEncapsulationServerRenderer2 = /** @class */ (function (_super) {
        __extends(EmulatedEncapsulationServerRenderer2, _super);
        function EmulatedEncapsulationServerRenderer2(eventManager, document, ngZone, sharedStylesHost, schema, component) {
            var _this = _super.call(this, eventManager, document, ngZone, schema) || this;
            _this.component = component;
            // Add a 's' prefix to style attributes to indicate server.
            var componentId = 's' + component.id;
            var styles = platformBrowser.ɵflattenStyles(componentId, component.styles, []);
            sharedStylesHost.addStyles(styles);
            _this.contentAttr = platformBrowser.ɵshimContentAttribute(componentId);
            _this.hostAttr = platformBrowser.ɵshimHostAttribute(componentId);
            return _this;
        }
        EmulatedEncapsulationServerRenderer2.prototype.applyToHost = function (element) { _super.prototype.setAttribute.call(this, element, this.hostAttr, ''); };
        EmulatedEncapsulationServerRenderer2.prototype.createElement = function (parent, name) {
            var el = _super.prototype.createElement.call(this, parent, name, this.document);
            _super.prototype.setAttribute.call(this, el, this.contentAttr, '');
            return el;
        };
        return EmulatedEncapsulationServerRenderer2;
    }(DefaultServerRenderer2));

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ServerStylesHost = /** @class */ (function (_super) {
        __extends(ServerStylesHost, _super);
        function ServerStylesHost(doc, transitionId) {
            var _this = _super.call(this) || this;
            _this.doc = doc;
            _this.transitionId = transitionId;
            _this.head = null;
            _this.head = platformBrowser.ɵgetDOM().getElementsByTagName(doc, 'head')[0];
            return _this;
        }
        ServerStylesHost.prototype._addStyle = function (style) {
            var adapter = platformBrowser.ɵgetDOM();
            var el = adapter.createElement('style');
            adapter.setText(el, style);
            if (!!this.transitionId) {
                adapter.setAttribute(el, 'ng-transition', this.transitionId);
            }
            adapter.appendChild(this.head, el);
        };
        ServerStylesHost.prototype.onStylesAdded = function (additions) {
            var _this = this;
            additions.forEach(function (style) { return _this._addStyle(style); });
        };
        ServerStylesHost.decorators = [
            { type: core.Injectable }
        ];
        /** @nocollapse */
        ServerStylesHost.ctorParameters = function () { return [
            { type: undefined, decorators: [{ type: core.Inject, args: [platformBrowser.DOCUMENT,] }] },
            { type: String, decorators: [{ type: core.Optional }, { type: core.Inject, args: [platformBrowser.ɵTRANSITION_ID,] }] }
        ]; };
        return ServerStylesHost;
    }(platformBrowser.ɵSharedStylesHost));

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var INTERNAL_SERVER_PLATFORM_PROVIDERS = [
        { provide: platformBrowser.DOCUMENT, useFactory: _document, deps: [core.Injector] },
        { provide: core.PLATFORM_ID, useValue: common.ɵPLATFORM_SERVER_ID },
        { provide: core.PLATFORM_INITIALIZER, useFactory: initDominoAdapter, multi: true, deps: [core.Injector] }, {
            provide: common.PlatformLocation,
            useClass: ServerPlatformLocation,
            deps: [platformBrowser.DOCUMENT, [core.Optional, INITIAL_CONFIG]]
        },
        { provide: PlatformState, deps: [platformBrowser.DOCUMENT] },
        // Add special provider that allows multiple instances of platformServer* to be created.
        { provide: core.ɵALLOW_MULTIPLE_PLATFORMS, useValue: true }
    ];
    function initDominoAdapter(injector) {
        return function () { DominoAdapter.makeCurrent(); };
    }
    function instantiateServerRendererFactory(renderer, engine, zone) {
        return new animations.ɵAnimationRendererFactory(renderer, engine, zone);
    }
    var SERVER_RENDER_PROVIDERS = [
        ServerRendererFactory2,
        {
            provide: core.RendererFactory2,
            useFactory: instantiateServerRendererFactory,
            deps: [ServerRendererFactory2, browser.ɵAnimationEngine, core.NgZone]
        },
        ServerStylesHost,
        { provide: platformBrowser.ɵSharedStylesHost, useExisting: ServerStylesHost },
        { provide: platformBrowser.EVENT_MANAGER_PLUGINS, multi: true, useClass: ServerEventManagerPlugin },
    ];
    /**
     * The ng module for the server.
     *
     * @experimental
     */
    var ServerModule = /** @class */ (function () {
        function ServerModule() {
        }
        ServerModule.decorators = [
            { type: core.NgModule, args: [{
                        exports: [platformBrowser.BrowserModule],
                        imports: [http.HttpModule, http$1.HttpClientModule, animations.NoopAnimationsModule],
                        providers: [
                            SERVER_RENDER_PROVIDERS,
                            SERVER_HTTP_PROVIDERS,
                            { provide: core.Testability, useValue: null },
                            { provide: common.ViewportScroller, useClass: common.ɵNullViewportScroller },
                        ],
                    },] }
        ];
        return ServerModule;
    }());
    function _document(injector) {
        var config = injector.get(INITIAL_CONFIG, null);
        if (config && config.document) {
            return parseDocument(config.document, config.url);
        }
        else {
            return platformBrowser.ɵgetDOM().createHtmlDocument();
        }
    }
    /**
     * @experimental
     */
    var platformServer = core.createPlatformFactory(core.platformCore, 'server', INTERNAL_SERVER_PLATFORM_PROVIDERS);
    /**
     * The server platform that supports the runtime compiler.
     *
     * @experimental
     */
    var platformDynamicServer = core.createPlatformFactory(platformBrowserDynamic.ɵplatformCoreDynamic, 'serverDynamic', INTERNAL_SERVER_PLATFORM_PROVIDERS);

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function serializeTransferStateFactory(doc, appId, transferStore) {
        return function () {
            var script = doc.createElement('script');
            script.id = appId + '-state';
            script.setAttribute('type', 'application/json');
            script.textContent = platformBrowser.ɵescapeHtml(transferStore.toJson());
            doc.body.appendChild(script);
        };
    }
    /**
     * NgModule to install on the server side while using the `TransferState` to transfer state from
     * server to client.
     *
     * @experimental
     */
    var ServerTransferStateModule = /** @class */ (function () {
        function ServerTransferStateModule() {
        }
        ServerTransferStateModule.decorators = [
            { type: core.NgModule, args: [{
                        providers: [
                            platformBrowser.TransferState, {
                                provide: BEFORE_APP_SERIALIZED,
                                useFactory: serializeTransferStateFactory,
                                deps: [platformBrowser.DOCUMENT, core.APP_ID, platformBrowser.TransferState],
                                multi: true,
                            }
                        ]
                    },] }
        ];
        return ServerTransferStateModule;
    }());

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function _getPlatform(platformFactory, options) {
        var extraProviders = options.extraProviders ? options.extraProviders : [];
        return platformFactory([
            { provide: INITIAL_CONFIG, useValue: { document: options.document, url: options.url } },
            extraProviders
        ]);
    }
    function _render(platform, moduleRefPromise) {
        return moduleRefPromise.then(function (moduleRef) {
            var transitionId = moduleRef.injector.get(platformBrowser.ɵTRANSITION_ID, null);
            if (!transitionId) {
                throw new Error("renderModule[Factory]() requires the use of BrowserModule.withServerTransition() to ensure\nthe server-rendered app can be properly bootstrapped into a client app.");
            }
            var applicationRef = moduleRef.injector.get(core.ApplicationRef);
            return applicationRef.isStable.pipe((operators.first(function (isStable) { return isStable; })))
                .toPromise()
                .then(function () {
                var e_1, _a;
                var platformState = platform.injector.get(PlatformState);
                // Run any BEFORE_APP_SERIALIZED callbacks just before rendering to string.
                var callbacks = moduleRef.injector.get(BEFORE_APP_SERIALIZED, null);
                if (callbacks) {
                    try {
                        for (var callbacks_1 = __values(callbacks), callbacks_1_1 = callbacks_1.next(); !callbacks_1_1.done; callbacks_1_1 = callbacks_1.next()) {
                            var callback = callbacks_1_1.value;
                            try {
                                callback();
                            }
                            catch (e) {
                                // Ignore exceptions.
                                console.warn('Ignoring BEFORE_APP_SERIALIZED Exception: ', e);
                            }
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (callbacks_1_1 && !callbacks_1_1.done && (_a = callbacks_1.return)) _a.call(callbacks_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                }
                var output = platformState.renderToString();
                platform.destroy();
                return output;
            });
        });
    }
    /**
     * Renders a Module to string.
     *
     * `document` is the full document HTML of the page to render, as a string.
     * `url` is the URL for the current render request.
     * `extraProviders` are the platform level providers for the current render request.
     *
     * Do not use this in a production server environment. Use pre-compiled {@link NgModuleFactory} with
     * {@link renderModuleFactory} instead.
     *
     * @experimental
     */
    function renderModule(module, options) {
        var platform = _getPlatform(platformDynamicServer, options);
        return _render(platform, platform.bootstrapModule(module));
    }
    /**
     * Renders a {@link NgModuleFactory} to string.
     *
     * `document` is the full document HTML of the page to render, as a string.
     * `url` is the URL for the current render request.
     * `extraProviders` are the platform level providers for the current render request.
     *
     * @experimental
     */
    function renderModuleFactory(moduleFactory, options) {
        var platform = _getPlatform(platformServer, options);
        return _render(platform, platform.bootstrapModuleFactory(moduleFactory));
    }

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var VERSION = new core.Version('6.1.4');

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // This file only reexports content of the `src` folder. Keep it that way.

    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * Generated bundle index. Do not edit.
     */

    exports.ɵangular_packages_platform_server_platform_server_i = SERVER_HTTP_PROVIDERS;
    exports.ɵangular_packages_platform_server_platform_server_e = ServerXhr;
    exports.ɵangular_packages_platform_server_platform_server_f = ServerXsrfStrategy;
    exports.ɵangular_packages_platform_server_platform_server_g = httpFactory;
    exports.ɵangular_packages_platform_server_platform_server_h = zoneWrappedInterceptingHandler;
    exports.ɵangular_packages_platform_server_platform_server_a = instantiateServerRendererFactory;
    exports.ɵangular_packages_platform_server_platform_server_d = ServerEventManagerPlugin;
    exports.ɵangular_packages_platform_server_platform_server_c = ServerStylesHost;
    exports.ɵangular_packages_platform_server_platform_server_b = serializeTransferStateFactory;
    exports.PlatformState = PlatformState;
    exports.ServerModule = ServerModule;
    exports.platformDynamicServer = platformDynamicServer;
    exports.platformServer = platformServer;
    exports.BEFORE_APP_SERIALIZED = BEFORE_APP_SERIALIZED;
    exports.INITIAL_CONFIG = INITIAL_CONFIG;
    exports.ServerTransferStateModule = ServerTransferStateModule;
    exports.renderModule = renderModule;
    exports.renderModuleFactory = renderModuleFactory;
    exports.VERSION = VERSION;
    exports.ɵINTERNAL_SERVER_PLATFORM_PROVIDERS = INTERNAL_SERVER_PLATFORM_PROVIDERS;
    exports.ɵSERVER_RENDER_PROVIDERS = SERVER_RENDER_PROVIDERS;
    exports.ɵServerRendererFactory2 = ServerRendererFactory2;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=platform-server.umd.js.map
