import { BehaviorSubject } from 'rxjs/BehaviorSubject';
import { PRIMARY_OUTLET } from './shared';
import { UrlSegment } from './url_tree';
import { shallowEqual } from './utils/collection';
import { Tree, TreeNode } from './utils/tree';
export class RouterState extends Tree {
    constructor(root, queryParams, fragment, snapshot) {
        super(root);
        this.queryParams = queryParams;
        this.fragment = fragment;
        this.snapshot = snapshot;
    }
}
export function createEmptyState(rootComponent) {
    const snapshot = createEmptyStateSnapshot(rootComponent);
    const emptyUrl = new BehaviorSubject([new UrlSegment('', {}, PRIMARY_OUTLET)]);
    const emptyParams = new BehaviorSubject({});
    const emptyQueryParams = new BehaviorSubject({});
    const fragment = new BehaviorSubject('');
    const activated = new ActivatedRoute(emptyUrl, emptyParams, PRIMARY_OUTLET, rootComponent, snapshot.root);
    activated.snapshot = snapshot.root;
    return new RouterState(new TreeNode(activated, []), emptyQueryParams, fragment, snapshot);
}
function createEmptyStateSnapshot(rootComponent) {
    const rootUrlSegment = new UrlSegment('', {}, PRIMARY_OUTLET);
    const emptyUrl = [rootUrlSegment];
    const emptyParams = {};
    const emptyQueryParams = {};
    const fragment = '';
    const activated = new ActivatedRouteSnapshot(emptyUrl, emptyParams, PRIMARY_OUTLET, rootComponent, null, rootUrlSegment);
    return new RouterStateSnapshot(new TreeNode(activated, []), emptyQueryParams, fragment);
}
export class ActivatedRoute {
    constructor(urlSegments, params, outlet, component, futureSnapshot) {
        this.urlSegments = urlSegments;
        this.params = params;
        this.outlet = outlet;
        this.component = component;
        this._futureSnapshot = futureSnapshot;
    }
}
export class ActivatedRouteSnapshot {
    constructor(urlSegments, params, outlet, component, routeConfig, lastUrlSegment) {
        this.urlSegments = urlSegments;
        this.params = params;
        this.outlet = outlet;
        this.component = component;
        this._routeConfig = routeConfig;
        this._lastUrlSegment = lastUrlSegment;
    }
}
export class RouterStateSnapshot extends Tree {
    constructor(root, queryParams, fragment) {
        super(root);
        this.queryParams = queryParams;
        this.fragment = fragment;
    }
}
export function advanceActivatedRoute(route) {
    if (route.snapshot && !shallowEqual(route.snapshot.params, route._futureSnapshot.params)) {
        route.snapshot = route._futureSnapshot;
        route.urlSegments.next(route.snapshot.urlSegments);
        route.params.next(route.snapshot.params);
    }
    else {
        route.snapshot = route._futureSnapshot;
    }
}
//# sourceMappingURL=data:application/json;base64,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