import { PRIMARY_OUTLET } from './shared';
import { shallowEqual } from './utils/collection';
import { Tree, TreeNode } from './utils/tree';
export function createEmptyUrlTree() {
    return new UrlTree(new TreeNode(new UrlSegment('', {}, PRIMARY_OUTLET), []), {}, null);
}
export class UrlTree extends Tree {
    constructor(root, queryParams, fragment) {
        super(root);
        this.queryParams = queryParams;
        this.fragment = fragment;
    }
}
export class UrlSegment {
    constructor(path, parameters, outlet) {
        this.path = path;
        this.parameters = parameters;
        this.outlet = outlet;
    }
    toString() {
        const params = [];
        for (let prop in this.parameters) {
            if (this.parameters.hasOwnProperty(prop)) {
                params.push(`${prop}=${this.parameters[prop]}`);
            }
        }
        const paramsString = params.length > 0 ? `(${params.join(',')})` : '';
        const outlet = this.outlet === PRIMARY_OUTLET ? '' : `${this.outlet}:`;
        return `${outlet}${this.path}${paramsString}`;
    }
}
export function equalUrlSegments(a, b) {
    if (a.length !== b.length)
        return false;
    for (let i = 0; i < a.length; ++i) {
        if (a[i].path !== b[i].path)
            return false;
        if (!shallowEqual(a[i].parameters, b[i].parameters))
            return false;
    }
    return true;
}
//# sourceMappingURL=data:application/json;base64,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