import 'rxjs/add/operator/map';
import 'rxjs/add/operator/scan';
import 'rxjs/add/operator/mergeMap';
import 'rxjs/add/operator/concat';
import 'rxjs/add/operator/concatMap';
import 'rxjs/add/operator/every';
import 'rxjs/add/operator/mergeAll';
import 'rxjs/add/observable/from';
import { Location } from '@angular/common';
import { ComponentResolver, Injector, Type } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { RouterConfig } from './config';
import { RouterOutletMap } from './router_outlet_map';
import { ActivatedRoute, RouterState } from './router_state';
import { Params } from './shared';
import { UrlSerializer } from './url_serializer';
import { UrlTree } from './url_tree';
export interface NavigationExtras {
    relativeTo?: ActivatedRoute;
    queryParams?: Params;
    fragment?: string;
}
export declare class NavigationStart {
    id: number;
    url: UrlTree;
    constructor(id: number, url: UrlTree);
}
export declare class NavigationEnd {
    id: number;
    url: UrlTree;
    constructor(id: number, url: UrlTree);
}
export declare class NavigationCancel {
    id: number;
    url: UrlTree;
    constructor(id: number, url: UrlTree);
}
export declare class NavigationError {
    id: number;
    url: UrlTree;
    error: any;
    constructor(id: number, url: UrlTree, error: any);
}
export declare type Event = NavigationStart | NavigationEnd | NavigationCancel | NavigationError;
export declare class Router {
    private rootComponentType;
    private resolver;
    private urlSerializer;
    private outletMap;
    private location;
    private injector;
    private config;
    private currentUrlTree;
    private currentRouterState;
    private locationSubscription;
    private routerEvents;
    private navigationId;
    constructor(rootComponentType: Type, resolver: ComponentResolver, urlSerializer: UrlSerializer, outletMap: RouterOutletMap, location: Location, injector: Injector, config: RouterConfig);
    initialNavigation(): void;
    readonly routerState: RouterState;
    readonly urlTree: UrlTree;
    readonly events: Observable<Event>;
    navigateByUrl(url: string): Promise<boolean>;
    resetConfig(config: RouterConfig): void;
    dispose(): void;
    createUrlTree(commands: any[], {relativeTo, queryParams, fragment}?: NavigationExtras): UrlTree;
    navigate(commands: any[], extras?: NavigationExtras): Promise<boolean>;
    serializeUrl(url: UrlTree): string;
    parseUrl(url: string): UrlTree;
    private scheduleNavigation(url, pop);
    private setUpLocationChangeListener();
    private runNavigate(url, pop, id);
}
