"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var BehaviorSubject_1 = require('rxjs/BehaviorSubject');
var shared_1 = require('./shared');
var url_tree_1 = require('./url_tree');
var collection_1 = require('./utils/collection');
var tree_1 = require('./utils/tree');
var RouterState = (function (_super) {
    __extends(RouterState, _super);
    function RouterState(root, queryParams, fragment, snapshot) {
        _super.call(this, root);
        this.queryParams = queryParams;
        this.fragment = fragment;
        this.snapshot = snapshot;
    }
    return RouterState;
}(tree_1.Tree));
exports.RouterState = RouterState;
function createEmptyState(rootComponent) {
    var snapshot = createEmptyStateSnapshot(rootComponent);
    var emptyUrl = new BehaviorSubject_1.BehaviorSubject([new url_tree_1.UrlSegment('', {}, shared_1.PRIMARY_OUTLET)]);
    var emptyParams = new BehaviorSubject_1.BehaviorSubject({});
    var emptyQueryParams = new BehaviorSubject_1.BehaviorSubject({});
    var fragment = new BehaviorSubject_1.BehaviorSubject('');
    var activated = new ActivatedRoute(emptyUrl, emptyParams, shared_1.PRIMARY_OUTLET, rootComponent, snapshot.root);
    activated.snapshot = snapshot.root;
    return new RouterState(new tree_1.TreeNode(activated, []), emptyQueryParams, fragment, snapshot);
}
exports.createEmptyState = createEmptyState;
function createEmptyStateSnapshot(rootComponent) {
    var rootUrlSegment = new url_tree_1.UrlSegment('', {}, shared_1.PRIMARY_OUTLET);
    var emptyUrl = [rootUrlSegment];
    var emptyParams = {};
    var emptyQueryParams = {};
    var fragment = '';
    var activated = new ActivatedRouteSnapshot(emptyUrl, emptyParams, shared_1.PRIMARY_OUTLET, rootComponent, null, rootUrlSegment);
    return new RouterStateSnapshot(new tree_1.TreeNode(activated, []), emptyQueryParams, fragment);
}
var ActivatedRoute = (function () {
    function ActivatedRoute(urlSegments, params, outlet, component, futureSnapshot) {
        this.urlSegments = urlSegments;
        this.params = params;
        this.outlet = outlet;
        this.component = component;
        this._futureSnapshot = futureSnapshot;
    }
    return ActivatedRoute;
}());
exports.ActivatedRoute = ActivatedRoute;
var ActivatedRouteSnapshot = (function () {
    function ActivatedRouteSnapshot(urlSegments, params, outlet, component, routeConfig, lastUrlSegment) {
        this.urlSegments = urlSegments;
        this.params = params;
        this.outlet = outlet;
        this.component = component;
        this._routeConfig = routeConfig;
        this._lastUrlSegment = lastUrlSegment;
    }
    return ActivatedRouteSnapshot;
}());
exports.ActivatedRouteSnapshot = ActivatedRouteSnapshot;
var RouterStateSnapshot = (function (_super) {
    __extends(RouterStateSnapshot, _super);
    function RouterStateSnapshot(root, queryParams, fragment) {
        _super.call(this, root);
        this.queryParams = queryParams;
        this.fragment = fragment;
    }
    return RouterStateSnapshot;
}(tree_1.Tree));
exports.RouterStateSnapshot = RouterStateSnapshot;
function advanceActivatedRoute(route) {
    if (route.snapshot && !collection_1.shallowEqual(route.snapshot.params, route._futureSnapshot.params)) {
        route.snapshot = route._futureSnapshot;
        route.urlSegments.next(route.snapshot.urlSegments);
        route.params.next(route.snapshot.params);
    }
    else {
        route.snapshot = route._futureSnapshot;
    }
}
exports.advanceActivatedRoute = advanceActivatedRoute;
//# sourceMappingURL=data:application/json;base64,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