import { Location, LocationStrategy, PathLocationStrategy } from '@angular/common';
import { APP_INITIALIZER, ApplicationRef, ComponentResolver, Injector, OpaqueToken } from '@angular/core';
import { Router } from './router';
import { RouterOutletMap } from './router_outlet_map';
import { ActivatedRoute } from './router_state';
import { DefaultUrlSerializer, UrlSerializer } from './url_serializer';
export const ROUTER_CONFIG = new OpaqueToken('ROUTER_CONFIG');
export const ROUTER_OPTIONS = new OpaqueToken('ROUTER_OPTIONS');
export function setupRouter(ref, resolver, urlSerializer, outletMap, location, injector, config, opts) {
    if (ref.componentTypes.length == 0) {
        throw new Error('Bootstrap at least one component before injecting Router.');
    }
    const componentType = ref.componentTypes[0];
    const r = new Router(componentType, resolver, urlSerializer, outletMap, location, injector, config);
    ref.registerDisposeListener(() => r.dispose());
    if (opts.enableTracing) {
        r.events.subscribe(e => {
            console.group(`Router Event: ${e.constructor.name}`);
            console.log(e.toString());
            console.log(e);
            console.groupEnd();
        });
    }
    return r;
}
export function setupRouterInitializer(injector) {
    setTimeout(_ => {
        const appRef = injector.get(ApplicationRef);
        if (appRef.componentTypes.length == 0) {
            appRef.registerBootstrapListener((_) => { injector.get(Router).initialNavigation(); });
        }
        else {
            injector.get(Router).initialNavigation();
        }
    }, 0);
    return _ => null;
}
export function provideRouter(_config, _opts) {
    return [
        { provide: ROUTER_CONFIG, useValue: _config }, { provide: ROUTER_OPTIONS, useValue: _opts },
        Location, { provide: LocationStrategy, useClass: PathLocationStrategy },
        { provide: UrlSerializer, useClass: DefaultUrlSerializer },
        {
            provide: Router,
            useFactory: setupRouter,
            deps: [
                ApplicationRef, ComponentResolver, UrlSerializer, RouterOutletMap, Location, Injector,
                ROUTER_CONFIG, ROUTER_OPTIONS
            ]
        },
        RouterOutletMap,
        { provide: ActivatedRoute, useFactory: (r) => r.routerState.root, deps: [Router] },
        { provide: APP_INITIALIZER, multi: true, useFactory: setupRouterInitializer, deps: [Injector] }
    ];
}
//# sourceMappingURL=data:application/json;base64,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