import 'rxjs/add/operator/map';
import 'rxjs/add/operator/toPromise';
import { forkJoin } from 'rxjs/observable/forkJoin';
import { fromPromise } from 'rxjs/observable/fromPromise';
export function resolve(resolver, state) {
    return resolveNode(resolver, state._root).map(_ => state);
}
function resolveNode(resolver, node) {
    if (node.children.length === 0) {
        return fromPromise(resolver.resolveComponent(node.value.component).then(factory => {
            node.value._resolvedComponentFactory = factory;
            return node.value;
        }));
    }
    else {
        const c = node.children.map(c => resolveNode(resolver, c).toPromise());
        return forkJoin(c).map(_ => resolver.resolveComponent(node.value.component).then(factory => {
            node.value._resolvedComponentFactory = factory;
            return node.value;
        }));
    }
}
//# sourceMappingURL=data:application/json;base64,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