"use strict";
var shared_1 = require('./shared');
var url_serializer_1 = require('./url_serializer');
var collection_1 = require('./utils/collection');
function createEmptyUrlTree() {
    return new UrlTree(new UrlSegment([], {}), {}, null);
}
exports.createEmptyUrlTree = createEmptyUrlTree;
var UrlTree = (function () {
    function UrlTree(root, queryParams, fragment) {
        this.root = root;
        this.queryParams = queryParams;
        this.fragment = fragment;
    }
    UrlTree.prototype.toString = function () { return new url_serializer_1.DefaultUrlSerializer().serialize(this); };
    return UrlTree;
}());
exports.UrlTree = UrlTree;
var UrlSegment = (function () {
    function UrlSegment(pathsWithParams, children) {
        var _this = this;
        this.pathsWithParams = pathsWithParams;
        this.children = children;
        this.parent = null;
        collection_1.forEach(children, function (v, k) { return v.parent = _this; });
    }
    UrlSegment.prototype.toString = function () { return url_serializer_1.serializePaths(this); };
    return UrlSegment;
}());
exports.UrlSegment = UrlSegment;
var UrlPathWithParams = (function () {
    function UrlPathWithParams(path, parameters) {
        this.path = path;
        this.parameters = parameters;
    }
    UrlPathWithParams.prototype.toString = function () { return url_serializer_1.serializePath(this); };
    return UrlPathWithParams;
}());
exports.UrlPathWithParams = UrlPathWithParams;
function equalPathsWithParams(a, b) {
    if (a.length !== b.length)
        return false;
    for (var i = 0; i < a.length; ++i) {
        if (a[i].path !== b[i].path)
            return false;
        if (!collection_1.shallowEqual(a[i].parameters, b[i].parameters))
            return false;
    }
    return true;
}
exports.equalPathsWithParams = equalPathsWithParams;
function mapChildren(segment, fn) {
    var newChildren = {};
    collection_1.forEach(segment.children, function (child, childOutlet) {
        if (childOutlet === shared_1.PRIMARY_OUTLET) {
            newChildren[childOutlet] = fn(child, childOutlet);
        }
    });
    collection_1.forEach(segment.children, function (child, childOutlet) {
        if (childOutlet !== shared_1.PRIMARY_OUTLET) {
            newChildren[childOutlet] = fn(child, childOutlet);
        }
    });
    return newChildren;
}
exports.mapChildren = mapChildren;
function mapChildrenIntoArray(segment, fn) {
    var res = [];
    collection_1.forEach(segment.children, function (child, childOutlet) {
        if (childOutlet === shared_1.PRIMARY_OUTLET) {
            res = res.concat(fn(child, childOutlet));
        }
    });
    collection_1.forEach(segment.children, function (child, childOutlet) {
        if (childOutlet !== shared_1.PRIMARY_OUTLET) {
            res = res.concat(fn(child, childOutlet));
        }
    });
    return res;
}
exports.mapChildrenIntoArray = mapChildrenIntoArray;
//# sourceMappingURL=data:application/json;base64,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