/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/**
 * @whatItDoes Name of the primary outlet.
 *
 * @stable
 */
export var /** @type {?} */ PRIMARY_OUTLET = 'primary';
export var NavigationCancelingError = (function (_super) {
    __extends(NavigationCancelingError, _super);
    /**
     * @param {?} message
     */
    function NavigationCancelingError(message) {
        _super.call(this, message);
        this.message = message;
        this.stack = (new Error(message)).stack;
    }
    /**
     * @return {?}
     */
    NavigationCancelingError.prototype.toString = function () { return this.message; };
    return NavigationCancelingError;
}(Error));
function NavigationCancelingError_tsickle_Closure_declarations() {
    /** @type {?} */
    NavigationCancelingError.prototype.stack;
    /** @type {?} */
    NavigationCancelingError.prototype.message;
}
/**
 * @param {?} segments
 * @param {?} segmentGroup
 * @param {?} route
 * @return {?}
 */
export function defaultUrlMatcher(segments, segmentGroup, route) {
    var /** @type {?} */ path = route.path;
    var /** @type {?} */ parts = path.split('/');
    var /** @type {?} */ posParams = {};
    var /** @type {?} */ consumed = [];
    var /** @type {?} */ currentIndex = 0;
    for (var /** @type {?} */ i = 0; i < parts.length; ++i) {
        if (currentIndex >= segments.length)
            return null;
        var /** @type {?} */ current = segments[currentIndex];
        var /** @type {?} */ p = parts[i];
        var /** @type {?} */ isPosParam = p.startsWith(':');
        if (!isPosParam && p !== current.path)
            return null;
        if (isPosParam) {
            posParams[p.substring(1)] = current;
        }
        consumed.push(current);
        currentIndex++;
    }
    if (route.pathMatch === 'full' &&
        (segmentGroup.hasChildren() || currentIndex < segments.length)) {
        return null;
    }
    else {
        return { consumed: consumed, posParams: posParams };
    }
}
//# sourceMappingURL=shared.js.map