/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as tslib_1 from "tslib";
import { map, mergeMap } from 'rxjs/operators';
import { recognize as recognizeFn } from '../recognize';
export function recognize(rootComponentType, config, serializer, paramsInheritanceStrategy) {
    return function (source) {
        return source.pipe(mergeMap(function (t) { return recognizeFn(rootComponentType, config, t.urlAfterRedirects, serializer(t.urlAfterRedirects), paramsInheritanceStrategy)
            .pipe(map(function (targetSnapshot) { return (tslib_1.__assign({}, t, { targetSnapshot: targetSnapshot })); })); }));
    };
}

//# sourceMappingURL=data:application/json;base64,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