/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as tslib_1 from "tslib";
import { combineLatest } from 'rxjs';
import { filter, map, scan, startWith, switchMap, take } from 'rxjs/operators';
import { isUrlTree } from '../utils/type_guards';
var INITIAL_VALUE = Symbol('INITIAL_VALUE');
export function prioritizedGuardValue() {
    return switchMap(function (obs) {
        return combineLatest.apply(void 0, tslib_1.__spread(obs.map(function (o) { return o.pipe(take(1), startWith(INITIAL_VALUE)); }))).pipe(scan(function (acc, list) {
            var isPending = false;
            return list.reduce(function (innerAcc, val, i) {
                if (innerAcc !== INITIAL_VALUE)
                    return innerAcc;
                // Toggle pending flag if any values haven't been set yet
                if (val === INITIAL_VALUE)
                    isPending = true;
                // Any other return values are only valid if we haven't yet hit a pending call.
                // This guarantees that in the case of a guard at the bottom of the tree that
                // returns a redirect, we will wait for the higher priority guard at the top to
                // finish before performing the redirect.
                if (!isPending) {
                    // Early return when we hit a `false` value as that should always cancel
                    // navigation
                    if (val === false)
                        return val;
                    if (i === list.length - 1 || isUrlTree(val)) {
                        return val;
                    }
                }
                return innerAcc;
            }, acc);
        }, INITIAL_VALUE), filter(function (item) { return item !== INITIAL_VALUE; }), map(function (item) { return isUrlTree(item) ? item : item === true; }), //
        take(1));
    });
}

//# sourceMappingURL=data:application/json;base64,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