/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point for all public APIs of this package. allowing
 * Angular 1 and Angular 2+ to run side by side in the same application.
 */
export { getAngularJSGlobal, getAngularLib, setAngularJSGlobal, setAngularLib } from './src/common/angular1';
export { downgradeComponent } from './src/common/downgrade_component';
export { downgradeInjectable } from './src/common/downgrade_injectable';
export { VERSION } from './src/common/version';
export { downgradeModule } from './src/static/downgrade_module';
export { UpgradeComponent } from './src/static/upgrade_component';
export { UpgradeModule } from './src/static/upgrade_module';
// This file only re-exports content of the `src` folder. Keep it that way.

//# sourceMappingURL=data:application/json;base64,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