/*!
 * @license angularjs-gauge - A Gauge directive for Angular 1.x apps and dashboards
 * 
 * version: 2.2.0
 *
 * Copyright (c) 2016-2017 Ashish Chopra
 * Released under the MIT license
 * https://github.com/ashish-chopra/angular-gauge/blob/master/LICENSE
 */
!function(t){"use strict";function e(){var e={size:200,value:void 0,min:0,max:100,cap:"butt",thick:6,type:"full",foregroundColor:"rgba(0, 150, 136, 1)",backgroundColor:"rgba(0, 0, 0, 0.1)",duration:1500,fractionSize:null,labelOnly:!1};this.setOptions=function(i){if(!i||!t.isObject(i))throw new Error("Invalid option type specified in the ngGaugeProvider");e=t.merge(e,i)};var i={getOptions:function(){return t.extend({},e)}};this.$get=function(){return i}}function i(e){var i=function(t,e){this.element=t.find("canvas")[0],this.text=t.find("span"),this.legend=t.find("b"),this.unit=t.find("u"),this.context=this.element.getContext("2d"),this.options=e,this.init()};return i.prototype={init:function(){this.setupStyles(),this.create(null,null)},setupStyles:function(){this.context.canvas.width=this.options.size,this.context.canvas.height=this.options.size,this.context.lineCap=this.options.cap,this.context.lineWidth=this.options.thick;var t=.22*this.options.size,e=this.options.size;this.text.css({display:"inline-block",fontWeight:"normal",width:"100%",position:"absolute",textAlign:"center",overflow:"hidden",textOverflow:"ellipsis",fontSize:t+"px",lineHeight:e+"px"}),this.unit.css({textDecoration:"none",fontSize:"0.6em",fontWeight:200,opacity:.8});var i=this.options.labelOnly?.8*t:this.options.size/13,n=this.options.labelOnly?e:5*i+parseInt(this.options.size);this.legend.css({display:"inline-block",width:"100%",position:"absolute",textAlign:"center",overflow:"hidden",textOverflow:"ellipsis",fontWeight:"normal",fontSize:i+"px",lineHeight:n+"px"})},create:function(t,e){function i(t){t=t||(new Date).getTime();var s=t-o,a=Math.min(s/u,1),l=e?e*g:0,h=d+l+f*a;r.drawShell(d,h,p,m),s<u?n=window.requestAnimationFrame(function(t){i(t)}):cancelAnimationFrame(n)}var n,o,r=this,s=this.getType(),a=this.getBounds(s),u=this.getDuration(),l=this.getMin(),h=this.getMax(),c=this.clamp(this.getValue(),l,h),d=a.head,g=(a.tail-a.head)/(h-l),f=g*(c-l),p=a.tail,m=this.getForegroundColorByRange(c);t&&e&&(f=g*t-g*e),requestAnimationFrame(function(t){o=t||(new Date).getTime(),i(t)})},getBounds:function(t){var e,i;return"semi"==t?(e=Math.PI,i=2*Math.PI):"full"==t?(e=1.5*Math.PI,i=3.5*Math.PI):"arch"===t&&(e=.8*Math.PI,i=2.2*Math.PI),{head:e,tail:i}},drawShell:function(t,e,i,n){var o=this.context,r=this.getCenter(),s=this.getRadius(),a=n,u=this.getBackgroundColor();this.clear(),e=Math.max(e,t),e=Math.min(e,i),o.beginPath(),o.strokeStyle=u,o.arc(r.x,r.y,s,e,i,!1),o.stroke(),o.beginPath(),o.strokeStyle=a,o.arc(r.x,r.y,s,t,e,!1),o.stroke()},clear:function(){this.context.clearRect(0,0,this.getWidth(),this.getHeight())},update:function(t,e){this.create(t,e)},destroy:function(){this.clear()},getRadius:function(){return this.getCenter().x-this.getThickness()},getCenter:function(){return{x:this.getWidth()/2,y:this.getHeight()/2}},getValue:function(){return this.options.value},getMin:function(){return this.options.min},getMax:function(){return this.options.max},getWidth:function(){return this.context.canvas.width},getHeight:function(){return this.context.canvas.height},getThickness:function(){return this.options.thick},getBackgroundColor:function(){return this.options.backgroundColor},getForegroundColor:function(){return this.options.foregroundColor},getForegroundColorByRange:function(t){var e=function(t){return void 0!=t&&!isNaN(parseFloat(t))&&!isNaN(Number(t))},i=Object.keys(this.options.thresholds).filter(function(i){return e(i)&&Number(i)<=t}).sort(function(t,e){return Number(t)>Number(e)}).reverse()[0];return void 0!==i?this.options.thresholds[i].color||this.getForegroundColor():this.getForegroundColor()},getLineCap:function(){return this.options.cap},getType:function(){return this.options.type},getDuration:function(){return this.options.duration},clamp:function(t,e,i){return Math.max(e,Math.min(i,t))}},{restrict:"E",replace:!0,template:'<div style="display:inline-block;text-align:center;position:relative;"><span ng-show="{{!labelOnly}}"><u>{{prepend}}</u><span ng-if="fractionSize === null">{{value | number}}</span><span ng-if="fractionSize !== null">{{value | number: fractionSize}}</span><u>{{append}}</u></span><b>{{ label }}</b><canvas></canvas></div>',scope:{append:"@?",backgroundColor:"@?",cap:"@?",foregroundColor:"@?",label:"@?",labelOnly:"@?",prepend:"@?",size:"@?",thick:"@?",type:"@?",duration:"@?",value:"=?",min:"=?",max:"=?",thresholds:"=?",fractionSize:"=?"},link:function(n,o){function r(e,i){u&&t.isDefined(e)&&!t.equals(e,i)&&u.update(e,i)}function s(e,i){t.isDefined(e)&&!t.equals(e,i)&&(u.destroy(),u.init())}var a=e.getOptions();n.min=t.isDefined(n.min)?n.min:a.min,n.max=t.isDefined(n.max)?n.max:a.max,n.value=t.isDefined(n.value)?n.value:a.value,n.size=t.isDefined(n.size)?n.size:a.size,n.cap=t.isDefined(n.cap)?n.cap:a.cap,n.thick=t.isDefined(n.thick)?n.thick:a.thick,n.type=t.isDefined(n.type)?n.type:a.type,n.duration=t.isDefined(n.duration)?n.duration:a.duration,n.labelOnly=t.isDefined(n.labelOnly)?n.labelOnly:a.labelOnly,n.foregroundColor=t.isDefined(n.foregroundColor)?n.foregroundColor:a.foregroundColor,n.backgroundColor=t.isDefined(n.backgroundColor)?n.backgroundColor:a.backgroundColor,n.thresholds=t.isDefined(n.thresholds)?n.thresholds:{},n.fractionSize=t.isDefined(n.fractionSize)?n.fractionSize:a.fractionSize;var u=new i(o,n);n.$watch("value",r,!1),n.$watch("min",r,!1),n.$watch("max",r,!1),n.$watch("cap",s,!1),n.$watch("thick",s,!1),n.$watch("type",s,!1),n.$watch("size",s,!1),n.$watch("duration",s,!1),n.$watch("foregroundColor",s,!1),n.$watch("backgroundColor",s,!1),n.$watch("thresholds",s,!1),n.$watch("fractionSize",r,!1),n.$on("$destroy",function(){}),n.$on("$resize",function(){})}}}t.module("angularjs-gauge",[]).directive("ngGauge",i).provider("ngGauge",e),e.$inject=[],i.$inject=["ngGauge"]}(angular);
//# sourceMappingURL=angularjs-gauge.min.js.map
