/**
 * @license Angulartics
 * (c) 2013 Luis Farzati http://luisfarzati.github.io/angulartics
 * Google Tag Manager Plugin Contributed by http://github.com/danrowe49
 * License: MIT
 */
!function(a){"use strict";/**
 * @ngdoc overview
 * @name angulartics.google.analytics
 * Enables analytics support for Google Tag Manager (http://google.com/tagmanager)
 */
a.module("angulartics.google.tagmanager",["angulartics"]).config(["$analyticsProvider",function(a){/**
    * Send content views to the dataLayer
    *
    * @param {string} path Required 'content name' (string) describes the content loaded
    */
a.registerPageTrack(function(a){var b=window.dataLayer=window.dataLayer||[];b.push({event:"content-view","content-name":a})}),/**
   * Send interactions to the dataLayer, i.e. for event tracking in Google Analytics
   * @name eventTrack
   *
   * @param {string} action Required 'action' (string) associated with the event
   * @param {object} properties Comprised of the mandatory field 'category' (string) and optional  fields 'label' (string), 'value' (integer) and 'noninteraction' (boolean)
   */
a.registerEventTrack(function(a,b){var c=window.dataLayer=window.dataLayer||[];b=b||{},c.push({event:b.event||"interaction",target:b.category,action:a,"target-properties":b.label,value:b.value,"interaction-type":b.noninteraction})}),a.registerSetUsername(/**
  		 * Send user's data to the datalayer, i.e. for user tracking in Google Analytics
  		 * @param  {string} username   login of the username
  		 * @param  {object} properties List of attribute of the current username
  		 * @return {void}
  		 */
function(a,b){var c=window.dataLayer=window.dataLayer||[];b=b||{},c.push({username:a,user:b})})}])}(angular);