"use strict";
var core_1 = require('@angular/core');
var platform_browser_1 = require('@angular/platform-browser');
var angulartics2_1 = require('./angulartics2');
var Angulartics2On = (function () {
    function Angulartics2On(elRef, angulartics2, eventManager) {
        this.elRef = elRef;
        this.angulartics2 = angulartics2;
        this.eventManager = eventManager;
        this.el = elRef.nativeElement;
    }
    Angulartics2On.prototype.ngAfterContentInit = function () {
        var _this = this;
        this.eventManager.addEventListener(this.el, this.angulartics2On || 'click', function (event) { return _this.eventTrack(event); });
    };
    Angulartics2On.prototype.eventTrack = function (event) {
        var action = this.angularticsEvent;
        var properties = {
            eventType: event.type
        };
        if (this.angularticsCategory) {
            properties.category = this.angularticsCategory;
        }
        if (this.angularticsProperties) {
            Object.assign(properties, this.angularticsProperties);
        }
        this.angulartics2.eventTrack.next({
            action: action,
            properties: properties
        });
    };
    Angulartics2On.decorators = [
        { type: core_1.Injectable },
        { type: core_1.Directive, args: [{
                    selector: '[angulartics2On]'
                },] },
    ];
    Angulartics2On.ctorParameters = function () { return [
        { type: core_1.ElementRef, },
        { type: angulartics2_1.Angulartics2, },
        { type: platform_browser_1.EventManager, },
    ]; };
    Angulartics2On.propDecorators = {
        'angulartics2On': [{ type: core_1.Input, args: ['angulartics2On',] },],
        'angularticsEvent': [{ type: core_1.Input },],
        'angularticsCategory': [{ type: core_1.Input },],
        'angularticsProperties': [{ type: core_1.Input },],
    };
    return Angulartics2On;
}());
exports.Angulartics2On = Angulartics2On;
