import { Directive, ElementRef, Input, Injectable, Renderer2, } from '@angular/core';
import { Angulartics2 } from './angulartics2';
export class Angulartics2On {
    constructor(elRef, angulartics2, renderer) {
        this.elRef = elRef;
        this.angulartics2 = angulartics2;
        this.renderer = renderer;
        this.angularticsProperties = {};
    }
    ngAfterContentInit() {
        this.renderer.listen(this.elRef.nativeElement, this.angulartics2On || 'click', (event) => this.eventTrack(event));
    }
    eventTrack(event) {
        const action = this.angularticsAction;
        const properties = Object.assign({}, this.angularticsProperties, { eventType: event.type });
        if (this.angularticsCategory) {
            properties.category = this.angularticsCategory;
        }
        if (this.angularticsLabel) {
            properties.label = this.angularticsLabel;
        }
        if (this.angularticsValue) {
            properties.value = this.angularticsValue;
        }
        this.angulartics2.eventTrack.next({
            action,
            properties,
        });
    }
}
Angulartics2On.decorators = [
    { type: Injectable },
    { type: Directive, args: [{
                selector: '[angulartics2On]'
            },] },
];
Angulartics2On.ctorParameters = () => [
    { type: ElementRef, },
    { type: Angulartics2, },
    { type: Renderer2, },
];
Angulartics2On.propDecorators = {
    'angulartics2On': [{ type: Input, args: ['angulartics2On',] },],
    'angularticsAction': [{ type: Input },],
    'angularticsCategory': [{ type: Input },],
    'angularticsLabel': [{ type: Input },],
    'angularticsValue': [{ type: Input },],
    'angularticsProperties': [{ type: Input },],
};
//# sourceMappingURL=angulartics2On.js.map