/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
'use strict';var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value" in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor);}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor;};}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return call&&(typeof call==="object"||typeof call==="function")?call:self;}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass);}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass;}

var AnimatedWithChildren=require('./AnimatedWithChildren');
var InteractionManager=require('./injectable/InteractionManager');
var AnimatedInterpolation=require('./AnimatedInterpolation');
var Interpolation=require('./Interpolation');
var Animation=require('./Animation');
var guid=require('./guid');
var Set=require('es6-set');






/**
 * Animated works by building a directed acyclic graph of dependencies
 * transparently when you render your Animated components.
 *
 *               new Animated.Value(0)
 *     .interpolate()        .interpolate()    new Animated.Value(1)
 *         opacity               translateY      scale
 *          style                         transform
 *         View#234                         style
 *                                         View#123
 *
 * A) Top Down phase
 * When an Animated.Value is updated, we recursively go down through this
 * graph in order to find leaf nodes: the views that we flag as needing
 * an update.
 *
 * B) Bottom Up phase
 * When a view is flagged as needing an update, we recursively go back up
 * in order to build the new value that it needs. The reason why we need
 * this two-phases process is to deal with composite props such as
 * transform which can receive values from multiple parents.
 */
function _flush(rootNode){
var animatedStyles=new Set();
function findAnimatedStyles(node){
if(typeof node.update==='function'){
animatedStyles.add(node);}else 
{
node.__getChildren().forEach(findAnimatedStyles);}}


findAnimatedStyles(rootNode);
animatedStyles.forEach(function(animatedStyle){return animatedStyle.update();});}


/**
 * Standard value for driving animations.  One `Animated.Value` can drive
 * multiple properties in a synchronized fashion, but can only be driven by one
 * mechanism at a time.  Using a new mechanism (e.g. starting a new animation,
 * or calling `setValue`) will stop any previous ones.
 */var 
AnimatedValue=function(_AnimatedWithChildren){_inherits(AnimatedValue,_AnimatedWithChildren);






function AnimatedValue(value){_classCallCheck(this,AnimatedValue);var _this=_possibleConstructorReturn(this,Object.getPrototypeOf(AnimatedValue).call(this));

_this._value=value;
_this._offset=0;
_this._animation=null;
_this._listeners={};return _this;}_createClass(AnimatedValue,[{key:'__detach',value:function __detach()


{
this.stopAnimation();}},{key:'__getValue',value:function __getValue()


{
return this._value+this._offset;}


/**
   * Directly set the value.  This will stop any animations running on the value
   * and update all the bound properties.
   */},{key:'setValue',value:function setValue(
value){
if(this._animation){
this._animation.stop();
this._animation=null;}

this._updateValue(value);}


/**
   * Sets an offset that is applied on top of whatever value is set, whether via
   * `setValue`, an animation, or `Animated.event`.  Useful for compensating
   * things like the start of a pan gesture.
   */},{key:'setOffset',value:function setOffset(
offset){
this._offset=offset;}


/**
   * Merges the offset value into the base value and resets the offset to zero.
   * The final output of the value is unchanged.
   */},{key:'flattenOffset',value:function flattenOffset()
{
this._value+=this._offset;
this._offset=0;}


/**
   * Adds an asynchronous listener to the value so you can observe updates from
   * animations.  This is useful because there is no way to
   * synchronously read the value because it might be driven natively.
   */},{key:'addListener',value:function addListener(
callback){
var id=guid();
this._listeners[id]=callback;
return id;}},{key:'removeListener',value:function removeListener(


id){
delete this._listeners[id];}},{key:'removeAllListeners',value:function removeAllListeners()


{
this._listeners={};}


/**
   * Stops any running animation or tracking.  `callback` is invoked with the
   * final value after stopping the animation, which is useful for updating
   * state to match the animation position with layout.
   */},{key:'stopAnimation',value:function stopAnimation(
callback){
this.stopTracking();
this._animation&&this._animation.stop();
this._animation=null;
callback&&callback(this.__getValue());}


/**
   * Interpolates the value before updating the property, e.g. mapping 0-1 to
   * 0-10.
   */},{key:'interpolate',value:function interpolate(
config){
return new AnimatedInterpolation(this,Interpolation.create(config));}


/**
   * Typically only used internally, but could be used by a custom Animation
   * class.
   */},{key:'animate',value:function animate(
animation,callback){var _this2=this;
var handle=null;
if(animation.__isInteraction){
handle=InteractionManager.current.createInteractionHandle();}

var previousAnimation=this._animation;
this._animation&&this._animation.stop();
this._animation=animation;
animation.start(
this._value,
function(value){
_this2._updateValue(value);},

function(result){
_this2._animation=null;
if(handle!==null){
InteractionManager.current.clearInteractionHandle(handle);}

callback&&callback(result);},

previousAnimation);}



/**
   * Typically only used internally.
   */},{key:'stopTracking',value:function stopTracking()
{
this._tracking&&this._tracking.__detach();
this._tracking=null;}


/**
   * Typically only used internally.
   */},{key:'track',value:function track(
tracking){
this.stopTracking();
this._tracking=tracking;}},{key:'_updateValue',value:function _updateValue(


value){
this._value=value;
_flush(this);
for(var key in this._listeners){
this._listeners[key]({value:this.__getValue()});}}}]);return AnimatedValue;}(AnimatedWithChildren);




module.exports=AnimatedValue;