/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
'use strict';var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key];}}}return target;};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value" in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor);}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor;};}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return call&&(typeof call==="object"||typeof call==="function")?call:self;}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass);}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass;}

var React=require('react');
var AnimatedProps=require('./AnimatedProps');
var ApplyAnimatedValues=require('./injectable/ApplyAnimatedValues');

function createAnimatedComponent(Component){
var refName='node';var 

AnimatedComponent=function(_React$Component){_inherits(AnimatedComponent,_React$Component);function AnimatedComponent(){_classCallCheck(this,AnimatedComponent);return _possibleConstructorReturn(this,Object.getPrototypeOf(AnimatedComponent).apply(this,arguments));}_createClass(AnimatedComponent,[{key:'componentWillUnmount',value:function componentWillUnmount()


{
this._propsAnimated&&this._propsAnimated.__detach();}},{key:'setNativeProps',value:function setNativeProps(


props){
var didUpdate=ApplyAnimatedValues.current(this.refs[refName],props);
if(didUpdate===false){
this.forceUpdate();}}},{key:'componentWillMount',value:function componentWillMount()



{
this.attachProps(this.props);}},{key:'attachProps',value:function attachProps(


nextProps){var _this2=this;
var oldPropsAnimated=this._propsAnimated;

// The system is best designed when setNativeProps is implemented. It is
// able to avoid re-rendering and directly set the attributes that
// changed. However, setNativeProps can only be implemented on leaf
// native components. If you want to animate a composite component, you
// need to re-render it. In this case, we have a fallback that uses
// forceUpdate.
var callback=function(){
var didUpdate=ApplyAnimatedValues.current(_this2.refs[refName],_this2._propsAnimated.__getAnimatedValue());
if(didUpdate===false){
_this2.forceUpdate();}};



this._propsAnimated=new AnimatedProps(
nextProps,
callback);


// When you call detach, it removes the element from the parent list
// of children. If it goes to 0, then the parent also detaches itself
// and so on.
// An optimization is to attach the new elements and THEN detach the old
// ones instead of detaching and THEN attaching.
// This way the intermediate state isn't to go to 0 and trigger
// this expensive recursive detaching to then re-attach everything on
// the very next operation.
oldPropsAnimated&&oldPropsAnimated.__detach();}},{key:'componentWillReceiveProps',value:function componentWillReceiveProps(


nextProps){
this.attachProps(nextProps);}},{key:'render',value:function render()


{
return (
React.createElement(Component,_extends({},
this._propsAnimated.__getValue(),{
ref:refName})));}}]);return AnimatedComponent;}(React.Component);




AnimatedComponent.propTypes={
style:function(props,propName,componentName){
if(!Component.propTypes){
return;}


// TODO(lmr): We will probably bring this back in at some point, but maybe
// just a subset of the proptypes... We should have a common set of props
// that will be used for all platforms.
//
// for (var key in ViewStylePropTypes) {
//   if (!Component.propTypes[key] && props[key] !== undefined) {
//     console.error(
//       'You are setting the style `{ ' + key + ': ... }` as a prop. You ' +
//       'should nest it in a style object. ' +
//       'E.g. `{ style: { ' + key + ': ... } }`'
//     );
//   }
// }
}};


return AnimatedComponent;}


module.exports=createAnimatedComponent;