// If one is stopped, stop all.  default: true





var parallel=function(
animations,
config)
{
var doneCount=0;
// Make sure we only call stop() at most once for each animation
var hasEnded={};
var stopTogether=!(config&&config.stopTogether===false);

var result={
start:function(callback){
if(doneCount===animations.length){
callback&&callback({finished:true});
return;}


animations.forEach(function(animation,idx){
var cb=function(endResult){
hasEnded[idx]=true;
doneCount++;
if(doneCount===animations.length){
doneCount=0;
callback&&callback(endResult);
return;}


if(!endResult.finished&&stopTogether){
result.stop();}};



if(!animation){
cb({finished:true});}else 
{
animation.start(cb);}});},




stop:function(){
animations.forEach(function(animation,idx){
!hasEnded[idx]&&animation.stop();
hasEnded[idx]=true;});}};




return result;};


module.exports=parallel;