/**
 * anime.js - ESM
 * @version v4.1.2
 * @author Julian Garnier
 * @license MIT
 * @copyright (c) 2025 Julian Garnier
 * @see https://animejs.com
 */
const t="undefined"!=typeof window,e=t?window:null,s=t?document:null,i={replace:0,none:1,blend:2},r=Symbol(),n=Symbol(),o=Symbol(),h=Symbol(),a=Symbol(),l=Symbol(),c=1e-11,d=1e12,u=1e3,p="",m=(()=>{const t=new Map;return t.set("x","translateX"),t.set("y","translateY"),t.set("z","translateZ"),t})(),f=["translateX","translateY","translateZ","rotate","rotateX","rotateY","rotateZ","scale","scaleX","scaleY","scaleZ","skew","skewX","skewY","perspective","matrix","matrix3d"],g=f.reduce(((t,e)=>({...t,[e]:e+"("})),{}),_=()=>{},y=/(^#([\da-f]{3}){1,2}$)|(^#([\da-f]{4}){1,2}$)/i,v=/rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/i,b=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(-?\d+|-?\d*.\d+)\s*\)/i,T=/hsl\(\s*(-?\d+|-?\d*.\d+)\s*,\s*(-?\d+|-?\d*.\d+)%\s*,\s*(-?\d+|-?\d*.\d+)%\s*\)/i,w=/hsla\(\s*(-?\d+|-?\d*.\d+)\s*,\s*(-?\d+|-?\d*.\d+)%\s*,\s*(-?\d+|-?\d*.\d+)%\s*,\s*(-?\d+|-?\d*.\d+)\s*\)/i,x=/[-+]?\d*\.?\d+(?:e[-+]?\d)?/gi,S=/^([-+]?\d*\.?\d+(?:e[-+]?\d+)?)([a-z]+|%)$/i,k=/([a-z])([A-Z])/g,$=/(\w+)(\([^)]+\)+)/g,E=/(\*=|\+=|-=)/,C={id:null,keyframes:null,playbackEase:null,playbackRate:1,frameRate:120,loop:0,reversed:!1,alternate:!1,autoplay:!0,duration:u,delay:0,loopDelay:0,ease:"out(2)",composition:i.replace,modifier:t=>t,onBegin:_,onBeforeUpdate:_,onUpdate:_,onLoop:_,onPause:_,onComplete:_,onRender:_},B={current:null,root:s},L={defaults:C,precision:4,timeScale:1,tickThreshold:200},D={version:"4.1.2",engine:null};t&&(e.AnimeJS||(e.AnimeJS=[]),e.AnimeJS.push(D));const N=t=>t.replace(k,"$1-$2").toLowerCase(),A=(t,e)=>0===t.indexOf(e),F=Date.now,O=Array.isArray,P=t=>t&&t.constructor===Object,R=t=>"number"==typeof t&&!isNaN(t),M=t=>"string"==typeof t,Y=t=>"function"==typeof t,X=t=>void 0===t,z=t=>X(t)||null===t,I=e=>t&&e instanceof SVGElement,W=t=>y.test(t),V=t=>A(t,"rgb"),H=t=>A(t,"hsl"),U=t=>!L.defaults.hasOwnProperty(t),q=t=>M(t)?parseFloat(t):t,Q=Math.pow,j=Math.sqrt,G=Math.sin,Z=Math.cos,J=Math.abs,K=Math.exp,tt=Math.ceil,et=Math.floor,st=Math.asin,it=Math.max,rt=Math.atan2,nt=Math.PI,ot=Math.round,ht=(t,e,s)=>t<e?e:t>s?s:t,at={},lt=(t,e)=>{if(e<0)return t;if(!e)return ot(t);let s=at[e];return s||(s=at[e]=10**e),ot(t*s)/s},ct=(t,e)=>O(e)?e.reduce(((e,s)=>J(s-t)<J(e-t)?s:e)):e?ot(t/e)*e:t,dt=(t,e,s)=>t+(e-t)*s,ut=(t,e,s)=>{const i=10**(s||0);return et((Math.random()*(e-t+1/i)+t)*i)/i},pt=t=>{let e,s,i=t.length;for(;i;)s=ut(0,--i),e=t[i],t[i]=t[s],t[s]=e;return t},mt=t=>t===1/0?d:t===-1/0?-1e12:t,ft=t=>t<=c?c:mt(lt(t,11)),gt=t=>O(t)?[...t]:t,_t=(t,e)=>{const s={...t};for(let i in e){const r=t[i];s[i]=X(r)?e[i]:r}return s},yt=(t,e,s,i="_prev",r="_next")=>{let n=t._head,o=r;for(s&&(n=t._tail,o=i);n;){const t=n[o];e(n),n=t}},vt=(t,e,s="_prev",i="_next")=>{const r=e[s],n=e[i];r?r[i]=n:t._head=n,n?n[s]=r:t._tail=r,e[s]=null,e[i]=null},bt=(t,e,s,i="_prev",r="_next")=>{let n=t._tail;for(;n&&s&&s(n,e);)n=n[i];const o=n?n[r]:t._head;n?n[r]=e:t._head=e,o?o[i]=e:t._tail=e,e[i]=n,e[r]=o},Tt=t=>{let e;return(...s)=>{let i,r,n,o;e&&(i=e.currentIteration,r=e.iterationProgress,n=e.reversed,o=e._alternate,e.revert());const h=t(...s);return h&&!Y(h)&&h.revert&&(e=h),X(r)||(e.currentIteration=i,e.iterationProgress=(o&&i%2?!n:n)?1-r:r),h||_}};class wt{constructor(t=0){this.deltaTime=0,this._currentTime=t,this._elapsedTime=t,this._startTime=t,this._lastTime=t,this._scheduledTime=0,this._frameDuration=lt(u/120,0),this._fps=120,this._speed=1,this._hasChildren=!1,this._head=null,this._tail=null}get fps(){return this._fps}set fps(t){const e=this._frameDuration,s=+t,i=s<c?c:s,r=lt(u/i,0);this._fps=i,this._frameDuration=r,this._scheduledTime+=r-e}get speed(){return this._speed}set speed(t){const e=+t;this._speed=e<c?c:e}requestTick(t){const e=this._scheduledTime,s=this._elapsedTime;if(this._elapsedTime+=t-s,s<e)return 0;const i=this._frameDuration,r=s-e;return this._scheduledTime+=r<i?i:r,1}computeDeltaTime(t){const e=t-this._lastTime;return this.deltaTime=e,this._lastTime=t,e}}const xt=(t,e,s,r,n)=>{const o=t.parent,a=t.duration,l=t.completed,d=t.iterationDuration,u=t.iterationCount,m=t._currentIteration,f=t._loopDelay,_=t._reversed,y=t._alternate,v=t._hasChildren,b=t._delay,T=t._currentTime,w=b+d,x=e-b,S=ht(T,-b,a),k=ht(x,-b,a),$=x-T,E=k>0,C=k>=a,B=a<=c,D=2===n;let N=0,A=x,F=0;if(u>1){const e=~~(k/(d+(C?0:f)));t._currentIteration=ht(e,0,u),C&&t._currentIteration--,N=t._currentIteration%2,A=k%(d+f)||0}const O=_^(y&&N),P=t._ease;let R=C?O?0:a:O?d-A:A;P&&(R=d*P(R/d)||0);const M=(o?o.backwards:x<T)?!O:!!O;if(t._currentTime=x,t._iterationTime=R,t.backwards=M,E&&!t.began?(t.began=!0,s||o&&(M||!o.began)||t.onBegin(t)):x<=0&&(t.began=!1),s||v||!E||t._currentIteration===m||t.onLoop(t),D||1===n&&(e>=b&&e<=w||e<=b&&S>b||e>=w&&S!==a)||R>=w&&S!==a||R<=b&&S>0||e<=S&&S===a&&l||C&&!l&&B){if(E&&(t.computeDeltaTime(S),s||t.onBeforeUpdate(t)),!v){const e=D||(M?-1*$:$)>=L.tickThreshold,n=t._offset+(o?o._offset:0)+b+R;let a,l,c,d,u=t._head,m=0;for(;u;){const t=u._composition,s=u._currentTime,o=u._changeDuration,f=u._absoluteStartTime+u._changeDuration,_=u._nextRep,y=u._prevRep,v=t!==i.none;if((e||(s!==o||n<=f+(_?_._delay:0))&&(0!==s||n>=u._absoluteStartTime))&&(!v||!u._isOverridden&&(!u._isOverlapped||n<=f)&&(!_||_._isOverridden||n<=_._absoluteStartTime)&&(!y||y._isOverridden||n>=y._absoluteStartTime+y._changeDuration+u._delay))){const e=u._currentTime=ht(R-u._startTime,0,o),s=u._ease(e/u._updateDuration),n=u._modifier,p=u._valueType,f=u._tweenType,g=0===f,_=0===p,y=_&&g||0===s||1===s?-1:L.precision;let b,T;if(_)b=T=n(lt(dt(u._fromNumber,u._toNumber,s),y));else if(1===p)T=n(lt(dt(u._fromNumber,u._toNumber,s),y)),b=`${T}${u._unit}`;else if(2===p){const t=u._fromNumbers,e=u._toNumbers,i=lt(ht(n(dt(t[0],e[0],s)),0,255),0),r=lt(ht(n(dt(t[1],e[1],s)),0,255),0),o=lt(ht(n(dt(t[2],e[2],s)),0,255),0),h=ht(n(lt(dt(t[3],e[3],s),y)),0,1);if(b=`rgba(${i},${r},${o},${h})`,v){const t=u._numbers;t[0]=i,t[1]=r,t[2]=o,t[3]=h}}else if(3===p){b=u._strings[0];for(let t=0,e=u._toNumbers.length;t<e;t++){const e=n(lt(dt(u._fromNumbers[t],u._toNumbers[t],s),y)),i=u._strings[t+1];b+=`${i?e+i:e}`,v&&(u._numbers[t]=e)}}if(v&&(u._number=T),r||t===i.blend)u._value=b;else{const t=u.property;a=u.target,g?a[t]=b:1===f?a.setAttribute(t,b):(l=a.style,3===f?(a!==c&&(c=a,d=a[h]),d[t]=b,m=1):2===f?l[t]=b:4===f&&l.setProperty(t,b)),E&&(F=1)}}if(m&&u._renderTransforms){let t=p;for(let e in d)t+=`${g[e]}${d[e]}) `;l.transform=t,m=0}u=u._next}!s&&F&&t.onRender(t)}!s&&E&&t.onUpdate(t)}return o&&B?!s&&(o.began&&!M&&x>=a&&!l||M&&x<=c&&l)&&(t.onComplete(t),t.completed=!M):E&&C?u===1/0?t._startTime+=t.duration:t._currentIteration>=u-1&&(t.paused=!0,l||v||(t.completed=!0,s||o&&(M||!o.began)||(t.onComplete(t),t._resolve(t)))):t.completed=!1,F},St=(t,e,s,i,r)=>{const n=t._currentIteration;if(xt(t,e,s,i,r),t._hasChildren){const o=t,h=o.backwards,a=i?e:o._iterationTime,l=F();let d=0,u=!0;if(!i&&o._currentIteration!==n){const t=o.iterationDuration;yt(o,(e=>{if(h){const i=e.duration,r=e._offset+e._delay;s||!(i<=c)||r&&r+i!==t||e.onComplete(e)}else!e.completed&&!e.backwards&&e._currentTime<e.iterationDuration&&xt(e,t,s,1,2),e.began=!1,e.completed=!1})),s||o.onLoop(o)}yt(o,(t=>{const e=lt((a-t._offset)*t._speed,12),n=t._fps<o._fps?t.requestTick(l):r;d+=xt(t,e,s,i,n),!t.completed&&u&&(u=!1)}),h),!s&&d&&o.onRender(o),(u||h)&&o._currentTime>=o.duration&&(o.paused=!0,o.completed||(o.completed=!0,s||(o.onComplete(o),o._resolve(o))))}},kt={animation:null,update:_},$t=(()=>t?requestAnimationFrame:setImmediate)(),Et=(()=>t?cancelAnimationFrame:clearImmediate)();class Ct extends wt{constructor(e){super(e),this.useDefaultMainLoop=!0,this.pauseOnDocumentHidden=!0,this.defaults=C,this.paused=!(!t||!s.hidden),this.reqId=null}update(){const t=this._currentTime=F();if(this.requestTick(t)){this.computeDeltaTime(t);const e=this._speed,s=this._fps;let i=this._head;for(;i;){const r=i._next;i.paused?(vt(this,i),this._hasChildren=!!this._tail,i._running=!1,i.completed&&!i._cancelled&&i.cancel()):St(i,(t-i._startTime)*i._speed*e,0,0,i._fps<s?i.requestTick(t):1),i=r}kt.update()}}wake(){return!this.useDefaultMainLoop||this.reqId||this.paused||(this.reqId=$t(Lt)),this}pause(){return this.paused=!0,Dt()}resume(){if(this.paused)return this.paused=!1,yt(this,(t=>t.resetTime())),this.wake()}get speed(){return this._speed*(1===L.timeScale?1:u)}set speed(t){this._speed=t*L.timeScale,yt(this,(t=>t.speed=t._speed))}get timeUnit(){return 1===L.timeScale?"ms":"s"}set timeUnit(t){const e="s"===t,s=e?.001:1;if(L.timeScale!==s){L.timeScale=s,L.tickThreshold=200*s;const t=e?.001:u;this.defaults.duration*=t,this._speed*=t}}get precision(){return L.precision}set precision(t){L.precision=t}}const Bt=(()=>{const e=new Ct(F());return t&&(D.engine=e,s.addEventListener("visibilitychange",(()=>{e.pauseOnDocumentHidden&&(s.hidden?e.pause():e.resume())}))),e})(),Lt=()=>{Bt._head?(Bt.reqId=$t(Lt),Bt.update()):Bt.reqId=0},Dt=()=>(Et(Bt.reqId),Bt.reqId=0,Bt);function Nt(t){const e=M(t)?B.root.querySelectorAll(t):t;if(e instanceof NodeList||e instanceof HTMLCollection)return e}function At(e){if(z(e))return[];if(O(e)){const t=e.flat(1/0),s=[];for(let e=0,i=t.length;e<i;e++){const i=t[e];if(!z(i)){const t=Nt(i);if(t)for(let e=0,i=t.length;e<i;e++){const i=t[e];if(!z(i)){let t=!1;for(let e=0,r=s.length;e<r;e++)if(s[e]===i){t=!0;break}t||s.push(i)}}else{let t=!1;for(let e=0,r=s.length;e<r;e++)if(s[e]===i){t=!0;break}t||s.push(i)}}}return s}if(!t)return[e];const s=Nt(e);return s?Array.from(s):[e]}function Ft(t){const e=At(t),s=e.length;if(s)for(let t=0;t<s;t++){const s=e[t];if(!s[r]){s[r]=!0;const t=I(s);(s.nodeType||t)&&(s[n]=!0,s[o]=t,s[h]={})}}return e}const Ot=t=>{const e=At(t)[0];if(e&&I(e))return e},Pt=(t,e,s=0)=>t.getPointAtLength(e+s>=1?e+s:0),Rt=(t,e)=>s=>{const i=+t.getTotalLength(),r=s[o],n=t.getCTM();return{from:0,to:i,modifier:s=>{if("a"===e){const e=Pt(t,s,-1),i=Pt(t,s,1);return 180*rt(i.y-e.y,i.x-e.x)/nt}{const i=Pt(t,s,0);return"x"===e?r||!n?i.x:i.x*n.a+i.y*n.c+n.e:r||!n?i.y:i.x*n.b+i.y*n.d+n.f}}}},Mt=["opacity","rotate","overflow","color"],Yt={morphTo:(t,e=.33)=>s=>{const i=Ot(t);if(!i)return;const r="path"===s.tagName,n=r?" ":",",o=s[a];o&&s.setAttribute(r?"d":"points",o);let h="",l="";if(e){const t=s.getTotalLength(),o=i.getTotalLength(),a=Math.max(Math.ceil(t*e),Math.ceil(o*e));for(let e=0;e<a;e++){const c=e/(a-1),d=s.getPointAtLength(t*c),u=i.getPointAtLength(o*c),p=r?0===e?"M":"L":"";h+=p+lt(d.x,3)+n+d.y+" ",l+=p+lt(u.x,3)+n+u.y+" "}}else h=s.getAttribute(r?"d":"points"),l=i.getAttribute(r?"d":"points");return s[a]=l,[h,l]},createMotionPath:t=>{const e=Ot(t);if(e)return{translateX:Rt(e,"x"),translateY:Rt(e,"y"),rotate:Rt(e,"a")}},createDrawable:(t,e=0,s=0)=>At(t).map((t=>((t,e,s)=>{const i=u,r=getComputedStyle(t),n=r.strokeLinecap,o="non-scaling-stroke"===r.vectorEffect?t:null;let h=n;const a=new Proxy(t,{get(t,e){const s=t[e];return e===l?t:"setAttribute"===e?(...e)=>{if("draw"===e[0]){const s=e[1].split(" "),r=+s[0],a=+s[1],l=(t=>{let e=1;if(t&&t.getCTM){const s=t.getCTM();s&&(e=(j(s.a*s.a+s.b*s.b)+j(s.c*s.c+s.d*s.d))/2)}return e})(o),c=-1e3*r*l,d=a*i*l+c,u=i*l+(0===r&&1===a||1===r&&0===a?0:10*l)-d;if("butt"!==n){const e=r===a?"butt":n;h!==e&&(t.style.strokeLinecap=`${e}`,h=e)}t.setAttribute("stroke-dashoffset",`${c}`),t.setAttribute("stroke-dasharray",`${d} ${u}`)}return Reflect.apply(s,t,e)}:Y(s)?(...e)=>Reflect.apply(s,t,e):s}});return"1000"!==t.getAttribute("pathLength")&&(t.setAttribute("pathLength","1000"),a.setAttribute("draw",`${e} ${s}`)),a})(t,e,s)))},Xt=(t,e,s)=>(s<0&&(s+=1),s>1&&(s-=1),s<1/6?t+6*(e-t)*s:s<.5?e:s<2/3?t+(e-t)*(2/3-s)*6:t),zt=(t,e)=>X(t)?e:t,It=(t,e,s,i,r)=>{if(Y(t)){const n=()=>{const r=t(e,s,i);return isNaN(+r)?r||0:+r};return r&&(r.func=n),n()}return t},Wt=(t,e)=>t[n]?t[o]&&((t,e)=>{if(Mt.includes(e))return!1;if(t.getAttribute(e)||e in t){if("scale"===e){const e=t.parentNode;return e&&"filter"===e.tagName}return!0}})(t,e)?1:f.includes(e)||m.get(e)?3:A(e,"--")?4:e in t.style?2:e in t?0:1:0,Vt=(t,e,s)=>{const i=t.style[e];i&&s&&(s[e]=i);const r=i||getComputedStyle(t[l]||t).getPropertyValue(e);return"auto"===r?"0":r},Ht=(t,e,s,i)=>{const r=X(s)?Wt(t,e):s;return 0===r?t[e]||0:1===r?t.getAttribute(e):3===r?((t,e,s)=>{const i=t.style.transform;let r;if(i){const n=t[h];let o;for(;o=$.exec(i);){const t=o[1],i=o[2].slice(1,-1);n[t]=i,t===e&&(r=i,s&&(s[e]=i))}}return i&&!X(r)?r:A(e,"scale")?"1":A(e,"rotate")||A(e,"skew")?"0deg":"0px"})(t,e,i):4===r?Vt(t,e,i).trimStart():Vt(t,e,i)},Ut=(t,e,s)=>"-"===s?t-e:"+"===s?t+e:t*e,qt=(t,e)=>{if(e.t=0,e.n=0,e.u=null,e.o=null,e.d=null,e.s=null,!t)return e;const s=+t;if(isNaN(s)){let s=t;"="===s[1]&&(e.o=s[0],s=s.slice(2));const n=!s.includes(" ")&&S.exec(s);if(n)return e.t=1,e.n=+n[1],e.u=n[2],e;if(e.o)return e.n=+s,e;if(W(r=s)||V(r)||H(r))return e.t=2,e.d=V(i=s)?(t=>{const e=v.exec(t)||b.exec(t),s=X(e[4])?1:+e[4];return[+e[1],+e[2],+e[3],s]})(i):W(i)?(t=>{const e=t.length,s=4===e||5===e;return[+("0x"+t[1]+t[s?1:2]),+("0x"+t[s?2:3]+t[s?2:4]),+("0x"+t[s?3:5]+t[s?3:6]),5===e||9===e?+(+("0x"+t[s?4:7]+t[s?4:8])/255).toFixed(3):1]})(i):H(i)?(t=>{const e=T.exec(t)||w.exec(t),s=+e[1]/360,i=+e[2]/100,r=+e[3]/100,n=X(e[4])?1:+e[4];let o,h,a;if(0===i)o=h=a=r;else{const t=r<.5?r*(1+i):r+i-r*i,e=2*r-t;o=lt(255*Xt(e,t,s+1/3),0),h=lt(255*Xt(e,t,s),0),a=lt(255*Xt(e,t,s-1/3),0)}return[o,h,a,n]})(i):[0,0,0,1],e;{const t=s.match(x);return e.t=3,e.d=t?t.map(Number):[],e.s=s.split(x)||[],e}}var i,r;return e.n=s,e},Qt=(t,e)=>(e.t=t._valueType,e.n=t._toNumber,e.u=t._unit,e.o=null,e.d=gt(t._toNumbers),e.s=gt(t._strings),e),jt={t:0,n:0,u:null,o:null,d:null,s:null},Gt={_rep:new WeakMap,_add:new Map},Zt=(t,e,s="_rep")=>{const i=Gt[s];let r=i.get(t);return r||(r={},i.set(t,r)),r[e]?r[e]:r[e]={_head:null,_tail:null}},Jt=(t,e)=>t._isOverridden||t._absoluteStartTime>e._absoluteStartTime,Kt=t=>{t._isOverlapped=1,t._isOverridden=1,t._changeDuration=c,t._currentTime=c},te=(t,e)=>{const s=t._composition;if(s===i.replace){const s=t._absoluteStartTime;bt(e,t,Jt,"_prevRep","_nextRep");const i=t._prevRep;if(i){const e=i.parent,r=i._absoluteStartTime+i._changeDuration;if(t.parent.id!==e.id&&e.iterationCount>1&&r+(e.duration-e.iterationDuration)>s){Kt(i);let t=i._prevRep;for(;t&&t.parent.id===e.id;)Kt(t),t=t._prevRep}const n=s-t._delay;if(r>n){const t=i._startTime,e=r-(t+i._updateDuration);i._changeDuration=n-e-t,i._currentTime=i._changeDuration,i._isOverlapped=1,i._changeDuration<c&&Kt(i)}let o=!0;if(yt(e,(t=>{t._isOverlapped||(o=!1)})),o){const t=e.parent;if(t){let s=!0;yt(t,(t=>{t!==e&&yt(t,(t=>{t._isOverlapped||(s=!1)}))})),s&&t.cancel()}else e.cancel()}}}else if(s===i.blend){const e=Zt(t.target,t.property,"_add"),s=(t=>{let e=kt.animation;return e||(e={duration:c,computeDeltaTime:_,_offset:0,_delay:0,_head:null,_tail:null},kt.animation=e,kt.update=()=>{t.forEach((t=>{for(let e in t){const s=t[e],i=s._head;if(i){const t=i._valueType,e=3===t||2===t?gt(i._fromNumbers):null;let r=i._fromNumber,n=s._tail;for(;n&&n!==i;){if(e)for(let t=0,s=n._numbers.length;t<s;t++)e[t]+=n._numbers[t];else r+=n._number;n=n._prevAdd}i._toNumber=r,i._toNumbers=e}}})),xt(e,1,1,0,2)}),e})(Gt._add);let r=e._head;r||(r={...t},r._composition=i.replace,r._updateDuration=c,r._startTime=0,r._numbers=gt(t._fromNumbers),r._number=0,r._next=null,r._prev=null,bt(e,r),bt(s,r));const n=t._toNumber;if(t._fromNumber=r._fromNumber-n,t._toNumber=0,t._numbers=gt(t._fromNumbers),t._number=0,r._fromNumber=n,t._toNumbers){const e=gt(t._toNumbers);e&&e.forEach(((e,s)=>{t._fromNumbers[s]=r._fromNumbers[s]-e,t._toNumbers[s]=0})),r._fromNumbers=e}bt(e,t,null,"_prevAdd","_nextAdd")}return t},ee=t=>{const e=t._composition;if(e!==i.none){const s=t.target,r=t.property,n=Gt._rep.get(s)[r];if(vt(n,t,"_prevRep","_nextRep"),e===i.blend){const e=Gt._add,i=e.get(s);if(!i)return;const n=i[r],o=kt.animation;vt(n,t,"_prevAdd","_nextAdd");const h=n._head;if(h&&h===n._tail){vt(n,h,"_prevAdd","_nextAdd"),vt(o,h);let t=!0;for(let e in i)if(i[e]._head){t=!1;break}t&&e.delete(s)}}}return t},se=t=>(t.paused=!0,t.began=!1,t.completed=!1,t),ie=t=>t._cancelled?(t._hasChildren?yt(t,ie):yt(t,(t=>{t._composition!==i.none&&te(t,Zt(t.target,t.property))})),t._cancelled=0,t):t;let re=0;class ne extends wt{constructor(t={},e=null,s=0){super(0);const{id:i,delay:r,duration:n,reversed:o,alternate:h,loop:a,loopDelay:l,autoplay:d,frameRate:u,playbackRate:p,onComplete:m,onLoop:f,onPause:g,onBegin:y,onBeforeUpdate:v,onUpdate:b}=t;B.current&&B.current.register(this);const T=e?0:Bt._elapsedTime,w=e?e.defaults:L.defaults,x=Y(r)||X(r)?w.delay:+r,S=Y(n)||X(n)?1/0:+n,k=zt(a,w.loop),$=zt(l,w.loopDelay),E=!0===k||k===1/0||k<0?1/0:k+1;let C=0;if(e)C=s;else{let t=F();Bt.paused&&(Bt.requestTick(t),t=Bt._elapsedTime),C=t-Bt._startTime}this.id=X(i)?++re:i,this.parent=e,this.duration=mt((S+$)*E-$)||c,this.backwards=!1,this.paused=!0,this.began=!1,this.completed=!1,this.onBegin=y||w.onBegin,this.onBeforeUpdate=v||w.onBeforeUpdate,this.onUpdate=b||w.onUpdate,this.onLoop=f||w.onLoop,this.onPause=g||w.onPause,this.onComplete=m||w.onComplete,this.iterationDuration=S,this.iterationCount=E,this._autoplay=!e&&zt(d,w.autoplay),this._offset=C,this._delay=x,this._loopDelay=$,this._iterationTime=0,this._currentIteration=0,this._resolve=_,this._running=!1,this._reversed=+zt(o,w.reversed),this._reverse=this._reversed,this._cancelled=0,this._alternate=zt(h,w.alternate),this._prev=null,this._next=null,this._elapsedTime=T,this._startTime=T,this._lastTime=T,this._fps=zt(u,w.frameRate),this._speed=zt(p,w.playbackRate)}get cancelled(){return!!this._cancelled}set cancelled(t){t?this.cancel():this.reset(1).play()}get currentTime(){return ht(lt(this._currentTime,L.precision),-this._delay,this.duration)}set currentTime(t){const e=this.paused;this.pause().seek(+t),e||this.resume()}get iterationCurrentTime(){return lt(this._iterationTime,L.precision)}set iterationCurrentTime(t){this.currentTime=this.iterationDuration*this._currentIteration+t}get progress(){return ht(lt(this._currentTime/this.duration,10),0,1)}set progress(t){this.currentTime=this.duration*t}get iterationProgress(){return ht(lt(this._iterationTime/this.iterationDuration,10),0,1)}set iterationProgress(t){const e=this.iterationDuration;this.currentTime=e*this._currentIteration+e*t}get currentIteration(){return this._currentIteration}set currentIteration(t){this.currentTime=this.iterationDuration*ht(+t,0,this.iterationCount-1)}get reversed(){return!!this._reversed}set reversed(t){t?this.reverse():this.play()}get speed(){return super.speed}set speed(t){super.speed=t,this.resetTime()}reset(t=0){return ie(this),this._reversed&&!this._reverse&&(this.reversed=!1),this._iterationTime=this.iterationDuration,St(this,0,1,t,2),se(this),this._hasChildren&&yt(this,se),this}init(t=0){this.fps=this._fps,this.speed=this._speed,!t&&this._hasChildren&&St(this,this.duration,1,t,2),this.reset(t);const e=this._autoplay;return!0===e?this.resume():e&&!X(e.linked)&&e.link(this),this}resetTime(){const t=1/(this._speed*Bt._speed);return this._startTime=F()-(this._currentTime+this._delay)*t,this}pause(){return this.paused||(this.paused=!0,this.onPause(this)),this}resume(){return this.paused?(this.paused=!1,this.duration<=c&&!this._hasChildren?St(this,c,0,0,2):(this._running||(bt(Bt,this),Bt._hasChildren=!0,this._running=!0),this.resetTime(),this._startTime-=12,Bt.wake()),this):this}restart(){return this.reset(0).resume()}seek(t,e=0,s=0){ie(this),this.completed=!1;const i=this.paused;return this.paused=!0,St(this,t+this._delay,~~e,~~s,1),i?this:this.resume()}alternate(){const t=this._reversed,e=this.iterationCount,s=this.iterationDuration,i=e===1/0?et(d/s):e;return this._reversed=+(!this._alternate||i%2?!t:t),e===1/0?this.iterationProgress=this._reversed?1-this.iterationProgress:this.iterationProgress:this.seek(s*i-this._currentTime),this.resetTime(),this}play(){return this._reversed&&this.alternate(),this.resume()}reverse(){return this._reversed||this.alternate(),this.resume()}cancel(){return this._hasChildren?yt(this,(t=>t.cancel()),!0):yt(this,ee),this._cancelled=1,this.pause()}stretch(t){const e=this.duration,s=ft(t);if(e===s)return this;const i=t/e,r=t<=c;return this.duration=r?c:s,this.iterationDuration=r?c:ft(this.iterationDuration*i),this._offset*=i,this._delay*=i,this._loopDelay*=i,this}revert(){St(this,0,1,0,1);const t=this._autoplay;return t&&t.linked&&t.linked===this&&t.revert(),this.cancel()}complete(){return this.seek(this.duration).cancel()}then(t=_){const e=this.then,s=()=>{this.then=null,t(this),this.then=e,this._resolve=_};return new Promise((t=>(this._resolve=()=>t(s()),this.completed&&this._resolve(),this)))}}const oe=t=>new ne(t,null,0).init(),he=t=>t,ae=(t,e,s)=>(((1-3*s+3*e)*t+(3*s-6*e))*t+3*e)*t,le=(t=.5,e=0,s=.5,i=1)=>t===e&&s===i?he:r=>0===r||1===r?r:ae(((t,e,s)=>{let i,r,n=0,o=1,h=0;do{r=n+(o-n)/2,i=ae(r,e,s)-t,i>0?o=r:n=r}while(J(i)>1e-7&&++h<100);return r})(r,t,s),e,i),ce=(t=10,e)=>{const s=e?tt:et;return e=>s(ht(e,0,1)*t)*(1/t)},de=(...t)=>{const e=t.length;if(!e)return he;const s=e-1,i=t[0],r=t[s],n=[0],o=[q(i)];for(let e=1;e<s;e++){const i=t[e],r=M(i)?i.trim().split(" "):[i],h=r[0],a=r[1];n.push(X(a)?e/s:q(a)/100),o.push(q(h))}return o.push(q(r)),n.push(1),function(t){for(let e=1,s=n.length;e<s;e++){const s=n[e];if(t<=s){const i=n[e-1],r=o[e-1];return r+(o[e]-r)*(t-i)/(s-i)}}return o[o.length-1]}},ue=(t=10,e=1)=>{const s=[0],i=t-1;for(let t=1;t<i;t++){const r=s[t-1],n=t/i,o=n*(1-e)+(n+((t+1)/i-n)*Math.random())*e;s.push(ht(o,r,1))}return s.push(1),de(...s)},pe=nt/2,me=2*nt,fe=(t=1.68)=>e=>Q(e,+t),ge={[p]:fe,Quad:fe(2),Cubic:fe(3),Quart:fe(4),Quint:fe(5),Sine:t=>1-Z(t*pe),Circ:t=>1-j(1-t*t),Expo:t=>t?Q(2,10*t-10):0,Bounce:t=>{let e,s=4;for(;t<((e=Q(2,--s))-1)/11;);return 1/Q(4,3-s)-7.5625*Q((3*e-2)/22-t,2)},Back:(t=1.70158)=>e=>(+t+1)*e*e*e-+t*e*e,Elastic:(t=1,e=.3)=>{const s=ht(+t,1,10),i=ht(+e,c,2),r=i/me*st(1/s),n=me/i;return t=>0===t||1===t?t:-s*Q(2,-10*(1-t))*G((1-t-r)*n)}},_e={in:t=>e=>t(e),out:t=>e=>1-t(1-e),inOut:t=>e=>e<.5?t(2*e)/2:1-t(-2*e+2)/2,outIn:t=>e=>e<.5?(1-t(1-2*e))/2:(t(2*e-1)+1)/2},ye=(t,e,s)=>{if(s[t])return s[t];if(t.indexOf("(")<=-1){const i=_e[t]||t.includes("Back")||t.includes("Elastic")?e[t]():e[t];return i?s[t]=i:he}{const i=t.slice(0,-1).split("("),r=e[i[0]];return r?s[t]=r(...i[1].split(",")):he}},ve=(()=>{const t={linear:de,irregular:ue,steps:ce,cubicBezier:le};for(let e in _e)for(let s in ge){const i=ge[s],r=_e[e];t[e+s]=s===p||"Back"===s||"Elastic"===s?(t,e)=>r(i(t,e)):r(i)}return t})(),be={linear:he},Te=t=>Y(t)?t:M(t)?ye(t,ve,be):he,we={},xe=(t,e,s)=>{if(3===s)return m.get(t)||t;if(2===s||1===s&&I(e)&&t in e.style){const e=we[t];if(e)return e;{const e=t?N(t):t;return we[t]=e,e}}return t},Se={deg:1,rad:180/nt,turn:360},ke={},$e=(t,e,i,r=!1)=>{const n=e.u,o=e.n;if(1===e.t&&n===i)return e;const h=o+n+i,a=ke[h];if(X(a)||r){let r;if(n in Se)r=o*Se[n]/Se[i];else{const e=100,h=t.cloneNode(),a=t.parentNode,l=a&&a!==s?a:s.body;l.appendChild(h);const c=h.style;c.width=e+n;const d=h.offsetWidth||e;c.width=e+i;const u=d/(h.offsetWidth||e);l.removeChild(h),r=u*o}e.n=r,ke[h]=r}else e.n=a;return e.t,e.u=i,e},Ee=t=>{if(t._hasChildren)yt(t,Ee,!0);else{const e=t;e.pause(),yt(e,(t=>{const s=t.property,i=t.target;if(i[n]){const r=i.style,n=e._inlineStyles[s];if(3===t._tweenType){const e=i[h];if(X(n)||n===p?delete e[s]:e[s]=n,t._renderTransforms)if(Object.keys(e).length){let t=p;for(let s in e)t+=g[s]+e[s]+") ";r.transform=t}else r.removeProperty("transform")}else X(n)||n===p?r.removeProperty(s):r[s]=n;e._tail===t&&e.targets.forEach((t=>{t.getAttribute&&t.getAttribute("style")===p&&t.removeAttribute("style")}))}}))}return t},Ce={t:0,n:0,u:null,o:null,d:null,s:null},Be={t:0,n:0,u:null,o:null,d:null,s:null},Le={func:null},De=[null],Ne=[null,null],Ae={to:null};let Fe,Oe,Pe=0;class Re extends ne{constructor(t,e,s,r,n=!1,o=0,h=0){super(e,s,r);const a=Ft(t),l=a.length,d=e.keyframes,p=d?_t(((t,e)=>{const s={};if(O(t)){const e=[].concat(...t.map((t=>Object.keys(t)))).filter(U);for(let i=0,r=e.length;i<r;i++){const r=e[i],n=t.map((t=>{const e={};for(let s in t){const i=t[s];U(s)?s===r&&(e.to=i):e[s]=i}return e}));s[r]=n}}else{const i=zt(e.duration,L.defaults.duration),r=Object.keys(t).map((e=>({o:parseFloat(e)/100,p:t[e]}))).sort(((t,e)=>t.o-e.o));r.forEach((t=>{const e=t.o,r=t.p;for(let t in r)if(U(t)){let n=s[t];n||(n=s[t]=[]);const o=e*i;let h=n.length,a=n[h-1];const l={to:r[t]};let c=0;for(let t=0;t<h;t++)c+=n[t].duration;1===h&&(l.from=a.to),r.ease&&(l.ease=r.ease),l.duration=o-(h?c:0),n.push(l)}return t}));for(let t in s){const e=s[t];let i;for(let t=0,s=e.length;t<s;t++){const s=e[t],r=s.ease;s.ease=i||void 0,i=r}e[0].duration||e.shift()}}return s})(d,e),e):e,{delay:m,duration:f,ease:g,playbackEase:_,modifier:y,composition:v,onRender:b}=p,T=s?s.defaults:L.defaults,w=zt(_,T.playbackEase),x=w?Te(w):null,S=!X(g)&&!X(g.ease),k=S?g.ease:zt(g,x?"linear":T.ease),$=S?g.duration:zt(f,T.duration),E=zt(m,T.delay),C=y||T.modifier,B=X(v)&&l>=u?i.none:X(v)?T.composition:v,D={},N=this._offset+(s?s._offset:0);let A=NaN,F=NaN,M=0,Y=0;for(let t=0;t<l;t++){const e=a[t],r=o||t,d=h||l;let u=NaN,m=NaN;for(let t in p)if(U(t)){const o=Wt(e,t),h=xe(t,e,o);let a=p[t];const l=O(a);if(n&&!l&&(Ne[0]=a,Ne[1]=a,a=Ne),l){const t=a.length,e=!P(a[0]);2===t&&e?(Ae.to=a,De[0]=Ae,Fe=De):t>2&&e?(Fe=[],a.forEach(((t,e)=>{e?1===e?(Ne[1]=t,Fe.push(Ne)):Fe.push(t):Ne[0]=t}))):Fe=a}else De[0]=a,Fe=De;let f=null,g=null,_=NaN,y=0,v=0;for(let t=Fe.length;v<t;v++){const n=Fe[v];P(n)?Oe=n:(Ae.to=n,Oe=Ae),Le.func=null;const a=It(Oe.to,e,r,d,Le);let l;P(a)&&!X(a.to)?(Oe=a,l=a.to):l=a;const u=It(Oe.from,e,r,d),p=Oe.ease,m=!X(p)&&!X(p.ease),b=m?p.ease:p||k,T=m?p.duration:It(zt(Oe.duration,t>1?It($,e,r,d)/t:$),e,r,d),w=It(zt(Oe.delay,v?0:E),e,r,d),x=It(zt(Oe.composition,B),e,r,d),S=R(x)?x:i[x],L=Oe.modifier||C,A=!X(u),F=!X(l),z=O(l),I=z||A&&F,W=g?y+w:w,V=N+W;Y||!A&&!z||(Y=1);let H=g;if(S!==i.none){f||(f=Zt(e,h));let t=f._head;for(;t&&!t._isOverridden&&t._absoluteStartTime<=V;)if(H=t,t=t._nextRep,t&&t._absoluteStartTime>=V)for(;t;)Kt(t),t=t._nextRep}if(I?(qt(z?It(l[0],e,r,d):u,Ce),qt(z?It(l[1],e,r,d,Le):l,Be),0===Ce.t&&(H?1===H._valueType&&(Ce.t=1,Ce.u=H._unit):(qt(Ht(e,h,o,D),jt),1===jt.t&&(Ce.t=1,Ce.u=jt.u)))):(F?qt(l,Be):g?Qt(g,Be):qt(s&&H&&H.parent.parent===s?H._value:Ht(e,h,o,D),Be),A?qt(u,Ce):g?Qt(g,Ce):qt(s&&H&&H.parent.parent===s?H._value:Ht(e,h,o,D),Ce)),Ce.o&&(Ce.n=Ut(H?H._toNumber:qt(Ht(e,h,o,D),jt).n,Ce.n,Ce.o)),Be.o&&(Be.n=Ut(Ce.n,Be.n,Be.o)),Ce.t!==Be.t)if(3===Ce.t||3===Be.t){const t=3===Ce.t?Ce:Be,e=3===Ce.t?Be:Ce;e.t=3,e.s=gt(t.s),e.d=t.d.map((()=>e.n))}else if(1===Ce.t||1===Be.t){const t=1===Ce.t?Ce:Be,e=1===Ce.t?Be:Ce;e.t=1,e.u=t.u}else if(2===Ce.t||2===Be.t){const t=2===Ce.t?Ce:Be,e=2===Ce.t?Be:Ce;e.t=2,e.s=t.s,e.d=[0,0,0,1]}if(Ce.u!==Be.u){let t=Be.u?Ce:Be;t=$e(e,t,Be.u?Be.u:Ce.u,!1)}if(Be.d&&Ce.d&&Be.d.length!==Ce.d.length){const t=Ce.d.length>Be.d.length?Ce:Be,e=t===Ce?Be:Ce;e.d=t.d.map(((t,s)=>X(e.d[s])?0:e.d[s])),e.s=gt(t.s)}const U=lt(+T||c,12),q={parent:this,id:Pe++,property:h,target:e,_value:null,_func:Le.func,_ease:Te(b),_fromNumbers:gt(Ce.d),_toNumbers:gt(Be.d),_strings:gt(Be.s),_fromNumber:Ce.n,_toNumber:Be.n,_numbers:gt(Ce.d),_number:Ce.n,_unit:Be.u,_modifier:L,_currentTime:0,_startTime:W,_delay:+w,_updateDuration:U,_changeDuration:U,_absoluteStartTime:V,_tweenType:o,_valueType:Be.t,_composition:S,_isOverlapped:0,_isOverridden:0,_renderTransforms:0,_prevRep:null,_nextRep:null,_prevAdd:null,_nextAdd:null,_prev:null,_next:null};S!==i.none&&te(q,f),isNaN(_)&&(_=q._startTime),y=lt(W+U,12),g=q,M++,bt(this,q)}(isNaN(F)||_<F)&&(F=_),(isNaN(A)||y>A)&&(A=y),3===o&&(u=M-v,m=M)}if(!isNaN(u)){let t=0;yt(this,(e=>{t>=u&&t<m&&(e._renderTransforms=1,e._composition===i.blend&&yt(kt.animation,(t=>{t.id===e.id&&(t._renderTransforms=1)}))),t++}))}}l||console.warn("No target found. Make sure the element you're trying to animate is accessible before creating your animation."),F?(yt(this,(t=>{t._startTime-t._delay||(t._delay-=F),t._startTime-=F})),A-=F):F=0,A||(A=c,this.iterationCount=0),this.targets=a,this.duration=A===c?c:mt((A+this._loopDelay)*this.iterationCount-this._loopDelay)||c,this.onRender=b||T.onRender,this._ease=x,this._delay=F,this.iterationDuration=A,this._inlineStyles=D,!this._autoplay&&Y&&this.onRender(this)}stretch(t){const e=this.duration;if(e===ft(t))return this;const s=t/e;return yt(this,(t=>{t._updateDuration=ft(t._updateDuration*s),t._changeDuration=ft(t._changeDuration*s),t._currentTime*=s,t._startTime*=s,t._absoluteStartTime*=s})),super.stretch(t)}refresh(){return yt(this,(t=>{const e=t._func;if(e){const s=Ht(t.target,t.property,t._tweenType);qt(s,jt),qt(e(),Be),t._fromNumbers=gt(jt.d),t._fromNumber=jt.n,t._toNumbers=gt(Be.d),t._strings=gt(Be.s),t._toNumber=Be.o?Ut(jt.n,Be.n,Be.o):Be.n}})),this}revert(){return super.revert(),Ee(this)}then(t){return super.then(t)}}const Me=(t,e)=>new Re(t,e,null,0,!1).init(),Ye=(t,e=100)=>{const s=[];for(let i=0;i<=e;i++)s.push(t(i/e));return`linear(${s.join(", ")})`},Xe={in:"ease-in",out:"ease-out",inOut:"ease-in-out"},ze=(()=>{const t={};for(let e in _e)t[e]=t=>_e[e](fe(t));return t})(),Ie=t=>{let e=Xe[t];if(e)return e;if(e="linear",M(t)){if(A(t,"linear")||A(t,"cubic-")||A(t,"steps")||A(t,"ease"))e=t;else if(A(t,"cubicB"))e=N(t);else{const s=ye(t,ze,Xe);Y(s)&&(e=s===he?"linear":Ye(s))}Xe[t]=e}else if(Y(t)){const s=Ye(t);s&&(e=s)}else t.ease&&(e=Ye(t.ease));return e},We=["x","y","z"],Ve=["perspective","width","height","margin","padding","top","right","bottom","left","borderWidth","fontSize","borderRadius",...We],He=(()=>[...We,...f.filter((t=>["X","Y","Z"].some((e=>t.endsWith(e)))))])();let Ue=null;const qe={_head:null,_tail:null},Qe=(t,e,s)=>{let i=qe._head;for(;i;){const r=i._next,n=i.$el===t,o=!e||i.property===e,h=!s||i.parent===s;if(n&&o&&h){const t=i.animation;try{t.commitStyles()}catch{}t.cancel(),vt(qe,i);const e=i.parent;e&&(e._completed++,e.animations.length===e._completed&&(e.completed=!0,e.muteCallbacks||(e.paused=!0,e.onComplete(e),e._resolve(e))))}i=r}},je=(t,e,s,i,r)=>{const n=e.animate(i,r),o=r.delay+ +r.duration*r.iterations;n.playbackRate=t._speed,t.paused&&n.pause(),t.duration<o&&(t.duration=o,t.controlAnimation=n),t.animations.push(n),Qe(e,s),bt(qe,{parent:t,animation:n,$el:e,property:s,_next:null,_prev:null});const h=()=>{Qe(e,s,t)};return n.onremove=h,n.onfinish=h,n},Ge=(t,e,s,i,r)=>{let n=It(e,s,i,r);return R(n)?Ve.includes(t)||A(t,"translate")?`${n}px`:A(t,"rotate")||A(t,"skew")?`${n}deg`:`${n}`:n},Ze=(t,e,s,i,r,n)=>{let o="0";const h=X(i)?getComputedStyle(t)[e]:Ge(e,i,t,r,n);return o=X(s)?O(i)?i.map((s=>Ge(e,s,t,r,n))):h:[Ge(e,s,t,r,n),h],o};class Je{constructor(e,s){B.current&&B.current.register(this),z(Ue)&&(!t||!X(CSS)&&Object.hasOwnProperty.call(CSS,"registerProperty")?(f.forEach((t=>{const e=A(t,"skew"),s=A(t,"scale"),i=A(t,"rotate"),r=A(t,"translate"),n=i||e,o=n?"<angle>":s?"<number>":r?"<length-percentage>":"*";try{CSS.registerProperty({name:"--"+t,syntax:o,inherits:!1,initialValue:r?"0px":n?"0deg":s?"1":"0"})}catch{}})),Ue=!0):Ue=!1);const i=Ft(e),r=i.length;r||console.warn("No target found. Make sure the element you're trying to animate is accessible before creating your animation.");const n=zt(s.ease,Ie(L.defaults.ease)),o=n.ease&&n,a=zt(s.autoplay,L.defaults.autoplay),l=!(!a||!a.link)&&a,c=s.alternate&&!0===s.alternate,d=s.reversed&&!0===s.reversed,y=zt(s.loop,L.defaults.loop),v=!0===y||y===1/0?1/0:R(y)?y+1:1,b=c?d?"alternate-reverse":"alternate":d?"reverse":"normal",T=Ie(n),w=1===L.timeScale?1:u;this.targets=i,this.animations=[],this.controlAnimation=null,this.onComplete=s.onComplete||_,this.duration=0,this.muteCallbacks=!1,this.completed=!1,this.paused=!a||!1!==l,this.reversed=d,this.autoplay=a,this._speed=zt(s.playbackRate,L.defaults.playbackRate),this._resolve=_,this._completed=0,this._inlineStyles=i.map((t=>t.getAttribute("style"))),i.forEach(((t,e)=>{const i=t[h],a=He.some((t=>s.hasOwnProperty(t))),l=(o?o.duration:It(zt(s.duration,L.defaults.duration),t,e,r))*w,c=It(zt(s.delay,L.defaults.delay),t,e,r)*w,d=zt(s.composition,"replace");for(let o in s){if(!U(o))continue;const h={},u={iterations:v,direction:b,fill:"forwards",easing:T,duration:l,delay:c,composite:d},p=s[o],g=!!a&&(f.includes(o)?o:m.get(o));let _;if(P(p)){const s=p,a=zt(s.ease,n),m=a.ease&&a,f=s.to,y=s.from;if(u.duration=(m?m.duration:It(zt(s.duration,l),t,e,r))*w,u.delay=It(zt(s.delay,c),t,e,r)*w,u.composite=zt(s.composition,d),u.easing=Ie(a),_=Ze(t,o,y,f,e,r),g?(h[`--${g}`]=_,i[g]=_):h[o]=Ze(t,o,y,f,e,r),je(this,t,o,h,u),!X(y))if(g){const e=`--${g}`;t.style.setProperty(e,h[e][0])}else t.style[o]=h[o][0]}else _=O(p)?p.map((s=>Ge(o,s,t,e,r))):Ge(o,p,t,e,r),g?(h[`--${g}`]=_,i[g]=_):h[o]=_,je(this,t,o,h,u)}if(a){let e=p;for(let t in i)e+=`${g[t]}var(--${t})) `;t.style.transform=e}})),l&&this.autoplay.link(this)}forEach(t){const e=M(t)?e=>e[t]():t;return this.animations.forEach(e),this}get speed(){return this._speed}set speed(t){this._speed=+t,this.forEach((e=>e.playbackRate=t))}get currentTime(){const t=this.controlAnimation,e=L.timeScale;return this.completed?this.duration:t?+t.currentTime*(1===e?1:e):0}set currentTime(t){const e=t*(1===L.timeScale?1:u);this.forEach((t=>{e>=this.duration&&t.play(),t.currentTime=e}))}get progress(){return this.currentTime/this.duration}set progress(t){this.forEach((e=>e.currentTime=t*this.duration||0))}resume(){return this.paused?(this.paused=!1,this.forEach("play")):this}pause(){return this.paused?this:(this.paused=!0,this.forEach("pause"))}alternate(){return this.reversed=!this.reversed,this.forEach("reverse"),this.paused&&this.forEach("pause"),this}play(){return this.reversed&&this.alternate(),this.resume()}reverse(){return this.reversed||this.alternate(),this.resume()}seek(t,e=!1){return e&&(this.muteCallbacks=!0),t<this.duration&&(this.completed=!1),this.currentTime=t,this.muteCallbacks=!1,this.paused&&this.pause(),this}restart(){return this.completed=!1,this.seek(0,!0).resume()}commitStyles(){return this.forEach("commitStyles")}complete(){return this.seek(this.duration)}cancel(){return this.forEach("cancel"),this.pause()}revert(){return this.cancel(),this.targets.forEach(((t,e)=>t.setAttribute("style",this._inlineStyles[e]))),this}then(t=_){const e=this.then,s=()=>{this.then=null,t(this),this.then=e,this._resolve=_};return new Promise((t=>(this._resolve=()=>t(s()),this.completed&&this._resolve(),this)))}}const Ke={animate:(t,e)=>new Je(t,e),convertEase:Ye},ts=(t=_)=>new ne({duration:1*L.timeScale,onComplete:t},null,0).resume();function es(t,e,s){const i=Ft(t);if(!i.length)return;const[r]=i,n=Wt(r,e),o=xe(e,r,n);let h=Ht(r,o);if(X(s))return h;if(qt(h,jt),0===jt.t||1===jt.t){if(!1===s)return jt.n;{const t=$e(r,jt,s,!1);return`${lt(t.n,L.precision)}${t.u}`}}}const ss=(t,e)=>{if(!X(e))return e.duration=c,e.composition=zt(e.composition,i.none),new Re(t,e,null,0,!0).resume()},is=(t,e,s)=>{let i=!1;return yt(e,(r=>{const n=r.target;if(t.includes(n)){const t=r.property,o=r._tweenType,h=xe(s,n,o);(!h||h&&h===t)&&(r.parent._tail===r&&3===r._tweenType&&r._prev&&3===r._prev._tweenType&&(r._prev._renderTransforms=1),vt(e,r),ee(r),i=!0)}}),!0),i},rs=(t,e,s)=>{const i=At(t),r=e||Bt,n=e&&e.controlAnimation&&e;for(let t=0,e=i.length;t<e;t++){const e=i[t];Qe(e,s,n)}let o;if(r._hasChildren){let e=0;yt(r,(n=>{if(!n._hasChildren)if(o=is(i,n,s),o&&!n._head)n.cancel(),vt(r,n);else{const t=n._offset+n._delay+n.duration;t>e&&(e=t)}n._head?rs(t,n,s):n._hasChildren=!1}),!0),X(r.iterationDuration)||(r.iterationDuration=e)}else o=is(i,r,s);return o&&!r._head&&(r._hasChildren=!1,r.cancel&&r.cancel()),i},ns=(t,e,s,i,r)=>i+(t-e)/(s-e)*(r-i),os=(t,e,s,i)=>{let r=u/L.defaults.frameRate;if(!1!==i){const t=i||Bt._hasChildren&&Bt;t&&t.deltaTime&&(r=t.deltaTime)}const n=1-Math.exp(-s*r*.1);return s?1===s?e:(1-n)*t+n*e:t},hs=t=>(...e)=>{const s=t(...e);return new Proxy(_,{apply:(t,e,[i])=>s(i),get:(t,e)=>hs(((...t)=>{const i=ls[e](...t);return t=>i(s(t))}))})},as=(t,e=0)=>(...s)=>(s.length<t.length?hs(((t,e=0)=>(...s)=>e?e=>t(...s,e):e=>t(e,...s))(t,e)):t)(...s),ls={$:Ft,get:es,set:ss,remove:rs,cleanInlineStyles:Ee,random:ut,randomPick:t=>t[ut(0,t.length-1)],shuffle:pt,lerp:os,sync:ts,keepTime:Tt,clamp:as(ht),round:as(lt),snap:as(ct),wrap:as(((t,e,s)=>((t-e)%(s-e)+(s-e))%(s-e)+e)),interpolate:as(dt,1),mapRange:as(ns),roundPad:as(((t,e)=>(+t).toFixed(e))),padStart:as(((t,e,s)=>`${t}`.padStart(e,s))),padEnd:as(((t,e,s)=>`${t}`.padEnd(e,s))),degToRad:as((t=>t*nt/180)),radToDeg:as((t=>180*t/nt))},cs=(t,e)=>{let s=t.iterationDuration;if(s===c&&(s=0),X(e))return s;if(R(+e))return+e;const i=e,r=t?t.labels:null,n=!z(r),o=((t,e)=>{if(A(e,"<")){const s="<"===e[1],i=t._tail,r=i?i._offset+i._delay:0;return s?r:r+i.duration}})(t,i),h=!X(o),a=E.exec(i);if(a){const t=a[0],e=i.split(t),l=n&&e[0]?r[e[0]]:s,c=h?o:n?l:s,d=+e[1];return Ut(c,d,t[0])}return h?o:n?X(r[i])?s:r[i]:s};function ds(t,e,s,i,r,n){const o=R(t.duration)&&t.duration<=c?s-c:s;St(e,o,1,1,1);const h=i?new Re(i,t,e,o,!1,r,n):new ne(t,e,o);return h.init(1),bt(e,h),yt(e,(t=>{const s=t._offset+t._delay+t.duration;s>e.iterationDuration&&(e.iterationDuration=s)})),e.duration=function(t){return mt((t.iterationDuration+t._loopDelay)*t.iterationCount-t._loopDelay)||c}(e),e}class us extends ne{constructor(t={}){super(t,null,0),this.duration=0,this.labels={};const e=t.defaults,s=L.defaults;this.defaults=e?_t(e,s):s,this.onRender=t.onRender||s.onRender;const i=zt(t.playbackEase,s.playbackEase);this._ease=i?Te(i):null,this.iterationDuration=0}add(t,e,s){const i=P(e),r=P(t);if(i||r){if(this._hasChildren=!0,i){const i=e;if(Y(s)){const e=s,r=At(t),n=this.duration,o=this.iterationDuration,h=i.id;let a=0;const l=r.length;r.forEach((t=>{const s={...i};this.duration=n,this.iterationDuration=o,X(h)||(s.id=h+"-"+a),ds(s,this,e(t,a,l,this),t,a,l),a++}))}else ds(i,this,cs(this,s),t)}else ds(t,this,cs(this,e));return this.init(1)}}sync(t,e){if(X(t)||t&&X(t.pause))return this;t.pause();const s=+(t.effect?t.effect.getTiming().duration:t.duration);return this.add(t,{currentTime:[0,s],duration:s,ease:"linear"},e)}set(t,e,s){return X(e)?this:(e.duration=c,e.composition=i.replace,this.add(t,e,s))}call(t,e){return X(t)||t&&!Y(t)?this:this.add({duration:0,onComplete:()=>t(this)},e)}label(t,e){return X(t)||t&&!M(t)||(this.labels[t]=cs(this,e)),this}remove(t,e){return rs(t,this,e),this}stretch(t){const e=this.duration;if(e===ft(t))return this;const s=t/e,i=this.labels;yt(this,(t=>t.stretch(t.duration*s)));for(let t in i)i[t]*=s;return super.stretch(t)}refresh(){return yt(this,(t=>{t.refresh&&t.refresh()})),this}revert(){return super.revert(),yt(this,(t=>t.revert),!0),Ee(this)}then(t){return super.then(t)}}const ps=t=>new us(t).init();class ms{constructor(t,e){B.current&&B.current.register(this);const s={},r={};if(this.targets=[],this.animations={},!X(t)&&!X(e)){for(let t in e){const i=e[t];U(t)?r[t]=i:s[t]=i}for(let e in r){const n=r[e],o=P(n);let h={},a="+=0";if(o){const t=n.unit;M(t)&&(a+=t)}else h.duration=n;h[e]=o?_t({to:a},n):a;const l=_t(s,h);l.composition=i.replace,l.autoplay=!1;const c=this.animations[e]=new Re(t,l,null,0,!1).init();this.targets.length||this.targets.push(...c.targets),this[e]=(t,e,s)=>{const i=c._head;if(X(t)&&i){const t=i._numbers;return t&&t.length?t:i._modifier(i._number)}return yt(c,(e=>{if(O(t))for(let s=0,i=t.length;s<i;s++)X(e._numbers[s])||(e._fromNumbers[s]=e._modifier(e._numbers[s]),e._toNumbers[s]=t[s]);else e._fromNumber=e._modifier(e._number),e._toNumber=t;X(s)||(e._ease=Te(s)),e._currentTime=0})),X(e)||c.stretch(e),c.reset(1).resume(),this}}}}revert(){for(let t in this.animations)this[t]=_,this.animations[t].revert();return this.animations={},this.targets.length=0,this}}const fs=(t,e)=>new ms(t,e);class gs{constructor(t={}){this.timeStep=.02,this.restThreshold=5e-4,this.restDuration=200,this.maxDuration=6e4,this.maxRestSteps=this.restDuration/this.timeStep/u,this.maxIterations=this.maxDuration/this.timeStep/u,this.m=ht(zt(t.mass,1),0,u),this.s=ht(zt(t.stiffness,100),1,u),this.d=ht(zt(t.damping,10),.1,u),this.v=ht(zt(t.velocity,0),-1e3,u),this.w0=0,this.zeta=0,this.wd=0,this.b=0,this.solverDuration=0,this.duration=0,this.compute(),this.ease=t=>0===t||1===t?t:this.solve(t*this.solverDuration)}solve(t){const{zeta:e,w0:s,wd:i,b:r}=this;let n=t;return n=e<1?K(-n*e*s)*(1*Z(i*n)+r*G(i*n)):(1+r*n)*K(-n*s),1-n}compute(){const{maxRestSteps:t,maxIterations:e,restThreshold:s,timeStep:i,m:r,d:n,s:o,v:h}=this,a=this.w0=ht(j(o/r),c,u),l=this.zeta=n/(2*j(o*r)),d=this.wd=l<1?a*j(1-l*l):0;this.b=l<1?(l*a-h)/d:-h+a;let p=0,m=0,f=0;for(;m<t&&f<e;)J(1-this.solve(p))<s?m++:m=0,this.solverDuration=p,p+=i,f++;this.duration=lt(this.solverDuration*u,0)*L.timeScale}get mass(){return this.m}set mass(t){this.m=ht(zt(t,1),0,u),this.compute()}get stiffness(){return this.s}set stiffness(t){this.s=ht(zt(t,100),1,u),this.compute()}get damping(){return this.d}set damping(t){this.d=ht(zt(t,10),.1,u),this.compute()}get velocity(){return this.v}set velocity(t){this.v=ht(zt(t,0),-1e3,u),this.compute()}}const _s=t=>new gs(t),ys=t=>{t.cancelable&&t.preventDefault()};class vs{constructor(t){this.el=t,this.zIndex=0,this.parentElement=null,this.classList={add:_,remove:_}}get x(){return this.el.x||0}set x(t){this.el.x=t}get y(){return this.el.y||0}set y(t){this.el.y=t}get width(){return this.el.width||0}set width(t){this.el.width=t}get height(){return this.el.height||0}set height(t){this.el.height=t}getBoundingClientRect(){return{top:this.y,right:this.x,bottom:this.y+this.height,left:this.x+this.width}}}class bs{constructor(t){this.$el=t,this.inlineTransforms=[],this.point=new DOMPoint,this.inversedMatrix=this.getMatrix().inverse()}normalizePoint(t,e){return this.point.x=t,this.point.y=e,this.point.matrixTransform(this.inversedMatrix)}traverseUp(t){let e=this.$el.parentElement,i=0;for(;e&&e!==s;)t(e,i),e=e.parentElement,i++}getMatrix(){const t=new DOMMatrix;return this.traverseUp((e=>{const s=getComputedStyle(e).transform;if(s){const e=new DOMMatrix(s);t.preMultiplySelf(e)}})),t}remove(){this.traverseUp(((t,e)=>{this.inlineTransforms[e]=t.style.transform,t.style.transform="none"}))}revert(){this.traverseUp(((t,e)=>{const s=this.inlineTransforms[e];""===s?t.style.removeProperty("transform"):t.style.transform=s}))}}const Ts=(t,e)=>t&&Y(t)?t(e):t;let ws=0;class xs{constructor(t,i={}){if(!t)return;B.current&&B.current.register(this);const r=i.x,n=i.y,o=i.trigger,h=i.modifier,a=i.releaseEase,l=a&&Te(a),c=!X(a)&&!X(a.ease),u=P(r)&&!X(r.mapTo)?r.mapTo:"translateX",p=P(n)&&!X(n.mapTo)?n.mapTo:"translateY",m=Ts(i.container,this);this.containerArray=O(m)?m:null,this.$container=m&&!this.containerArray?At(m)[0]:s.body,this.useWin=this.$container===s.body,this.$scrollContainer=this.useWin?e:this.$container,this.$target=P(t)?new vs(t):At(t)[0],this.$trigger=At(o||t)[0],this.fixed="fixed"===es(this.$target,"position"),this.isFinePointer=!0,this.containerPadding=[0,0,0,0],this.containerFriction=0,this.releaseContainerFriction=0,this.snapX=0,this.snapY=0,this.scrollSpeed=0,this.scrollThreshold=0,this.dragSpeed=0,this.maxVelocity=0,this.minVelocity=0,this.velocityMultiplier=0,this.cursor=!1,this.releaseXSpring=c?a:_s({mass:zt(i.releaseMass,1),stiffness:zt(i.releaseStiffness,80),damping:zt(i.releaseDamping,20)}),this.releaseYSpring=c?a:_s({mass:zt(i.releaseMass,1),stiffness:zt(i.releaseStiffness,80),damping:zt(i.releaseDamping,20)}),this.releaseEase=l||ve.outQuint,this.hasReleaseSpring=c,this.onGrab=i.onGrab||_,this.onDrag=i.onDrag||_,this.onRelease=i.onRelease||_,this.onUpdate=i.onUpdate||_,this.onSettle=i.onSettle||_,this.onSnap=i.onSnap||_,this.onResize=i.onResize||_,this.onAfterResize=i.onAfterResize||_,this.disabled=[0,0];const f={};if(h&&(f.modifier=h),X(r)||!0===r)f[u]=0;else if(P(r)){const t=r,e={};t.modifier&&(e.modifier=t.modifier),t.composition&&(e.composition=t.composition),f[u]=e}else!1===r&&(f[u]=0,this.disabled[0]=1);if(X(n)||!0===n)f[p]=0;else if(P(n)){const t=n,e={};t.modifier&&(e.modifier=t.modifier),t.composition&&(e.composition=t.composition),f[p]=e}else!1===n&&(f[p]=0,this.disabled[1]=1);this.animate=new ms(this.$target,f),this.xProp=u,this.yProp=p,this.destX=0,this.destY=0,this.deltaX=0,this.deltaY=0,this.scroll={x:0,y:0},this.coords=[this.x,this.y,0,0],this.snapped=[0,0],this.pointer=[0,0,0,0,0,0,0,0],this.scrollView=[0,0],this.dragArea=[0,0,0,0],this.containerBounds=[-1e12,d,d,-1e12],this.scrollBounds=[0,0,0,0],this.targetBounds=[0,0,0,0],this.window=[0,0],this.velocityStack=[0,0,0],this.velocityStackIndex=0,this.velocityTime=F(),this.velocity=0,this.angle=0,this.cursorStyles=null,this.triggerStyles=null,this.bodyStyles=null,this.targetStyles=null,this.touchActionStyles=null,this.transforms=new bs(this.$target),this.overshootCoords={x:0,y:0},this.overshootXTicker=new ne({autoplay:!1},null,0).init(),this.overshootYTicker=new ne({autoplay:!1},null,0).init(),this.updateTicker=new ne({autoplay:!1},null,0).init(),this.overshootXTicker.onUpdate=()=>{this.disabled[0]||(this.updated=!0,this.manual=!0,this.animate[this.xProp](this.overshootCoords.x,0))},this.overshootXTicker.onComplete=()=>{this.disabled[0]||(this.manual=!1,this.animate[this.xProp](this.overshootCoords.x,0))},this.overshootYTicker.onUpdate=()=>{this.disabled[1]||(this.updated=!0,this.manual=!0,this.animate[this.yProp](this.overshootCoords.y,0))},this.overshootYTicker.onComplete=()=>{this.disabled[1]||(this.manual=!1,this.animate[this.yProp](this.overshootCoords.y,0))},this.updateTicker.onUpdate=()=>this.update(),this.contained=!X(m),this.manual=!1,this.grabbed=!1,this.dragged=!1,this.updated=!1,this.released=!1,this.canScroll=!1,this.enabled=!1,this.initialized=!1,this.activeProp=this.disabled[1]?u:p,this.animate.animations[this.activeProp].onRender=()=>{const t=this.updated,e=!(this.grabbed&&t)&&this.released,s=this.x,i=this.y,r=s-this.coords[2],n=i-this.coords[3];this.deltaX=r,this.deltaY=n,this.coords[2]=s,this.coords[3]=i,t&&(r||n)&&this.onUpdate(this),e?(this.computeVelocity(r,n),this.angle=rt(n,r)):this.updated=!1},this.animate.animations[this.activeProp].onComplete=()=>{!this.grabbed&&this.released&&(this.released=!1),this.manual||(this.deltaX=0,this.deltaY=0,this.velocity=0,this.velocityStack[0]=0,this.velocityStack[1]=0,this.velocityStack[2]=0,this.velocityStackIndex=0,this.onSettle(this))},this.resizeTicker=new ne({autoplay:!1,duration:150*L.timeScale,onComplete:()=>{this.onResize(this),this.refresh(),this.onAfterResize(this)}}).init(),this.parameters=i,this.resizeObserver=new ResizeObserver((()=>{this.initialized?this.resizeTicker.restart():this.initialized=!0})),this.enable(),this.refresh(),this.resizeObserver.observe(this.$container),P(t)||this.resizeObserver.observe(this.$target)}computeVelocity(t,e){const s=this.velocityTime,i=F(),r=i-s;if(r<17)return this.velocity;this.velocityTime=i;const n=this.velocityStack,o=this.velocityMultiplier,h=this.minVelocity,a=this.maxVelocity,l=this.velocityStackIndex;n[l]=lt(ht(j(t*t+e*e)/r*o,h,a),5);const c=it(n[0],n[1],n[2]);return this.velocity=c,this.velocityStackIndex=(l+1)%3,c}setX(t,e=!1){if(this.disabled[0])return;const s=lt(t,5);return this.overshootXTicker.pause(),this.manual=!0,this.updated=!e,this.destX=s,this.snapped[0]=ct(s,this.snapX),this.animate[this.xProp](s,0),this.manual=!1,this}setY(t,e=!1){if(this.disabled[1])return;const s=lt(t,5);return this.overshootYTicker.pause(),this.manual=!0,this.updated=!e,this.destY=s,this.snapped[1]=ct(s,this.snapY),this.animate[this.yProp](s,0),this.manual=!1,this}get x(){return lt(this.animate[this.xProp](),L.precision)}set x(t){this.setX(t,!1)}get y(){return lt(this.animate[this.yProp](),L.precision)}set y(t){this.setY(t,!1)}get progressX(){return ns(this.x,this.containerBounds[3],this.containerBounds[1],0,1)}set progressX(t){this.setX(ns(t,0,1,this.containerBounds[3],this.containerBounds[1]),!1)}get progressY(){return ns(this.y,this.containerBounds[0],this.containerBounds[2],0,1)}set progressY(t){this.setY(ns(t,0,1,this.containerBounds[0],this.containerBounds[2]),!1)}updateScrollCoords(){const t=lt(this.useWin?e.scrollX:this.$container.scrollLeft,0),s=lt(this.useWin?e.scrollY:this.$container.scrollTop,0),[i,r,n,o]=this.containerPadding,h=this.scrollThreshold;this.scroll.x=t,this.scroll.y=s,this.scrollBounds[0]=s-this.targetBounds[0]+i-h,this.scrollBounds[1]=t-this.targetBounds[1]-r+h,this.scrollBounds[2]=s-this.targetBounds[2]-n+h,this.scrollBounds[3]=t-this.targetBounds[3]+o-h}updateBoundingValues(){const t=this.$container,i=this.x,r=this.y,n=this.coords[2],o=this.coords[3];this.coords[2]=0,this.coords[3]=0,this.setX(0,!0),this.setY(0,!0),this.transforms.remove();const h=this.window[0]=e.innerWidth,a=this.window[1]=e.innerHeight,l=this.useWin,c=t.scrollWidth,d=t.scrollHeight,u=this.fixed,p=t.getBoundingClientRect(),[m,f,g,_]=this.containerPadding;this.dragArea[0]=l?0:p.left,this.dragArea[1]=l?0:p.top,this.scrollView[0]=l?ht(c,h,c):c,this.scrollView[1]=l?ht(d,a,d):d,this.updateScrollCoords();const{width:y,height:v,left:b,top:T,right:w,bottom:x}=t.getBoundingClientRect();this.dragArea[2]=lt(l?ht(y,h,h):y,0),this.dragArea[3]=lt(l?ht(v,a,a):v,0);const S=es(t,"overflow"),k="visible"===S,$="hidden"===S;if(this.canScroll=!u&&this.contained&&(t===s.body&&k||!$&&!k)&&(c>this.dragArea[2]+_-f||d>this.dragArea[3]+m-g)&&(!this.containerArray||this.containerArray&&!O(this.containerArray)),this.contained){const e=this.scroll.x,s=this.scroll.y,i=this.canScroll,r=this.$target.getBoundingClientRect(),n=i?l?0:t.scrollLeft:0,o=i?l?0:t.scrollTop:0,c=i?this.scrollView[0]-n-y:0,d=i?this.scrollView[1]-o-v:0;this.targetBounds[0]=lt(r.top+s-(l?0:T),0),this.targetBounds[1]=lt(r.right+e-(l?h:w),0),this.targetBounds[2]=lt(r.bottom+s-(l?a:x),0),this.targetBounds[3]=lt(r.left+e-(l?0:b),0),this.containerArray?(this.containerBounds[0]=this.containerArray[0]+m,this.containerBounds[1]=this.containerArray[1]-f,this.containerBounds[2]=this.containerArray[2]-g,this.containerBounds[3]=this.containerArray[3]+_):(this.containerBounds[0]=-lt(r.top-(u?ht(T,0,a):T)+o-m,0),this.containerBounds[1]=-lt(r.right-(u?ht(w,0,h):w)-c+f,0),this.containerBounds[2]=-lt(r.bottom-(u?ht(x,0,a):x)-d+g,0),this.containerBounds[3]=-lt(r.left-(u?ht(b,0,h):b)+n-_,0))}this.transforms.revert(),this.coords[2]=n,this.coords[3]=o,this.setX(i,!0),this.setY(r,!0)}isOutOfBounds(t,e,s){if(!this.contained)return 0;const[i,r,n,o]=t,[h,a]=this.disabled,l=!h&&e<o||!h&&e>r,c=!a&&s<i||!a&&s>n;return l&&!c?1:!l&&c?2:l&&c?3:0}refresh(){const t=this.parameters,i=t.x,r=t.y,n=Ts(t.container,this),o=Ts(t.containerPadding,this)||0,h=O(o)?o:[o,o,o,o],a=this.x,l=this.y,c=Ts(t.cursor,this),d={onHover:"grab",onGrab:"grabbing"};if(c){const{onHover:t,onGrab:e}=c;t&&(d.onHover=t),e&&(d.onGrab=e)}this.containerArray=O(n)?n:null,this.$container=n&&!this.containerArray?At(n)[0]:s.body,this.useWin=this.$container===s.body,this.$scrollContainer=this.useWin?e:this.$container,this.isFinePointer=matchMedia("(pointer:fine)").matches,this.containerPadding=zt(h,[0,0,0,0]),this.containerFriction=ht(zt(Ts(t.containerFriction,this),.8),0,1),this.releaseContainerFriction=ht(zt(Ts(t.releaseContainerFriction,this),this.containerFriction),0,1),this.snapX=Ts(P(i)&&!X(i.snap)?i.snap:t.snap,this),this.snapY=Ts(P(r)&&!X(r.snap)?r.snap:t.snap,this),this.scrollSpeed=zt(Ts(t.scrollSpeed,this),1.5),this.scrollThreshold=zt(Ts(t.scrollThreshold,this),20),this.dragSpeed=zt(Ts(t.dragSpeed,this),1),this.minVelocity=zt(Ts(t.minVelocity,this),0),this.maxVelocity=zt(Ts(t.maxVelocity,this),50),this.velocityMultiplier=zt(Ts(t.velocityMultiplier,this),1),this.cursor=!1!==c&&d,this.updateBoundingValues();const[u,p,m,f]=this.containerBounds;this.setX(ht(a,f,p),!0),this.setY(ht(l,u,m),!0)}update(){if(this.updateScrollCoords(),this.canScroll){const[t,e,s,i]=this.containerPadding,[r,n]=this.scrollView,o=this.dragArea[2],h=this.dragArea[3],a=this.scroll.x,l=this.scroll.y,c=this.$container.scrollWidth,d=this.$container.scrollHeight,u=this.useWin?ht(c,this.window[0],c):c,p=this.useWin?ht(d,this.window[1],d):d,m=r-u,f=n-p;this.dragged&&m>0&&(this.coords[0]-=m,this.scrollView[0]=u),this.dragged&&f>0&&(this.coords[1]-=f,this.scrollView[1]=p);const g=10*this.scrollSpeed,_=this.scrollThreshold,[y,v]=this.coords,[b,T,w,x]=this.scrollBounds,S=lt(ht((v-b+t)/_,-1,0)*g,0),k=lt(ht((y-T-e)/_,0,1)*g,0),$=lt(ht((v-w-s)/_,0,1)*g,0),E=lt(ht((y-x+i)/_,-1,0)*g,0);if(S||$||E||k){const[t,e]=this.disabled;let s=a,i=l;t||(s=lt(ht(a+(E||k),0,r-o),0),this.coords[0]-=a-s),e||(i=lt(ht(l+(S||$),0,n-h),0),this.coords[1]-=l-i),this.useWin?this.$scrollContainer.scrollBy(-(a-s),-(l-i)):this.$scrollContainer.scrollTo(s,i)}}const[t,e,s,i]=this.containerBounds,[r,n,o,h,a,l]=this.pointer;this.coords[0]+=(r-a)*this.dragSpeed,this.coords[1]+=(n-l)*this.dragSpeed,this.pointer[4]=r,this.pointer[5]=n;const[c,d]=this.coords,[u,p]=this.snapped,m=(1-this.containerFriction)*this.dragSpeed;this.setX(c>e?e+(c-e)*m:c<i?i+(c-i)*m:c,!1),this.setY(d>s?s+(d-s)*m:d<t?t+(d-t)*m:d,!1),this.computeVelocity(r-a,n-l),this.angle=rt(n-h,r-o);const[f,g]=this.snapped;(f!==u&&this.snapX||g!==p&&this.snapY)&&this.onSnap(this)}stop(){this.updateTicker.pause(),this.overshootXTicker.pause(),this.overshootYTicker.pause();for(let t in this.animate.animations)this.animate.animations[t].pause();return rs(this,null,"x"),rs(this,null,"y"),rs(this,null,"progressX"),rs(this,null,"progressY"),rs(this.scroll),rs(this.overshootCoords),this}scrollInView(t,e=0,s=ve.inOutQuad){this.updateScrollCoords();const i=this.destX,r=this.destY,n=this.scroll,o=this.scrollBounds,h=this.canScroll;if(!this.containerArray&&this.isOutOfBounds(o,i,r)){const[a,l,c,u]=o,p=lt(ht(r-a,-1e12,0),0),m=lt(ht(i-l,0,d),0),f=lt(ht(r-c,0,d),0),g=lt(ht(i-u,-1e12,0),0);new Re(n,{x:lt(n.x+(g?g-e:m?m+e:0),0),y:lt(n.y+(p?p-e:f?f+e:0),0),duration:X(t)?350*L.timeScale:t,ease:s,onUpdate:()=>{this.canScroll=!1,this.$scrollContainer.scrollTo(n.x,n.y)}}).init().then((()=>{this.canScroll=h}))}return this}handleHover(){this.isFinePointer&&this.cursor&&!this.cursorStyles&&(this.cursorStyles=ss(this.$trigger,{cursor:this.cursor.onHover}))}animateInView(t,e=0,s=ve.inOutQuad){this.stop(),this.updateBoundingValues();const i=this.x,r=this.y,[n,o,h,a]=this.containerPadding,l=this.scroll.y-this.targetBounds[0]+n+e,c=this.scroll.x-this.targetBounds[1]-o-e,d=this.scroll.y-this.targetBounds[2]-h-e,u=this.scroll.x-this.targetBounds[3]+a+e,p=this.isOutOfBounds([l,c,d,u],i,r);if(p){const[e,n]=this.disabled,o=ht(ct(i,this.snapX),u,c),h=ht(ct(r,this.snapY),l,d),a=X(t)?350*L.timeScale:t;e||1!==p&&3!==p||this.animate[this.xProp](o,a,s),n||2!==p&&3!==p||this.animate[this.yProp](h,a,s)}return this}handleDown(t){const e=t.target;if(this.grabbed||"range"===e.type)return;t.stopPropagation(),this.grabbed=!0,this.released=!1,this.stop(),this.updateBoundingValues();const i=t.changedTouches,r=i?i[0].clientX:t.clientX,n=i?i[0].clientY:t.clientY,{x:o,y:h}=this.transforms.normalizePoint(r,n),[a,l,c,d]=this.containerBounds,u=(1-this.containerFriction)*this.dragSpeed,p=this.x,m=this.y;this.coords[0]=this.coords[2]=u?p>l?l+(p-l)/u:p<d?d+(p-d)/u:p:p,this.coords[1]=this.coords[3]=u?m>c?c+(m-c)/u:m<a?a+(m-a)/u:m:m,this.pointer[0]=o,this.pointer[1]=h,this.pointer[2]=o,this.pointer[3]=h,this.pointer[4]=o,this.pointer[5]=h,this.pointer[6]=o,this.pointer[7]=h,this.deltaX=0,this.deltaY=0,this.velocity=0,this.velocityStack[0]=0,this.velocityStack[1]=0,this.velocityStack[2]=0,this.velocityStackIndex=0,this.angle=0,this.targetStyles&&(this.targetStyles.revert(),this.targetStyles=null);const f=es(this.$target,"zIndex",!1);ws=(f>ws?f:ws)+1,this.targetStyles=ss(this.$target,{zIndex:ws}),this.triggerStyles&&(this.triggerStyles.revert(),this.triggerStyles=null),this.cursorStyles&&(this.cursorStyles.revert(),this.cursorStyles=null),this.isFinePointer&&this.cursor&&(this.bodyStyles=ss(s.body,{cursor:this.cursor.onGrab})),this.scrollInView(100,0,ve.out(3)),this.onGrab(this),s.addEventListener("touchmove",this),s.addEventListener("touchend",this),s.addEventListener("touchcancel",this),s.addEventListener("mousemove",this),s.addEventListener("mouseup",this),s.addEventListener("selectstart",this)}handleMove(t){if(!this.grabbed)return;const e=t.changedTouches,s=e?e[0].clientX:t.clientX,i=e?e[0].clientY:t.clientY,{x:r,y:n}=this.transforms.normalizePoint(s,i),o=r-this.pointer[6],h=n-this.pointer[7];let a=t.target,l=!1,c=!1,d=!1;for(;e&&a&&a!==this.$trigger;){const t=es(a,"overflow-y");if("hidden"!==t&&"visible"!==t){const{scrollTop:t,scrollHeight:e,clientHeight:s}=a;if(e>s){d=!0,l=t<=3,c=t>=e-s-3;break}}a=a.parentNode}d&&(!l&&!c||l&&h<0||c&&h>0)?(this.pointer[0]=r,this.pointer[1]=n,this.pointer[2]=r,this.pointer[3]=n,this.pointer[4]=r,this.pointer[5]=n,this.pointer[6]=r,this.pointer[7]=n):(ys(t),this.triggerStyles||(this.triggerStyles=ss(this.$trigger,{pointerEvents:"none"})),this.$trigger.addEventListener("touchstart",ys,{passive:!1}),this.$trigger.addEventListener("touchmove",ys,{passive:!1}),this.$trigger.addEventListener("touchend",ys),(!this.disabled[0]&&J(o)>3||!this.disabled[1]&&J(h)>3)&&(this.updateTicker.resume(),this.pointer[2]=this.pointer[0],this.pointer[3]=this.pointer[1],this.pointer[0]=r,this.pointer[1]=n,this.dragged=!0,this.released=!1,this.onDrag(this)))}handleUp(){if(!this.grabbed)return;this.updateTicker.pause(),this.triggerStyles&&(this.triggerStyles.revert(),this.triggerStyles=null),this.bodyStyles&&(this.bodyStyles.revert(),this.bodyStyles=null);const[t,e]=this.disabled,[r,n,o,h,a,l]=this.pointer,[c,d,u,p]=this.containerBounds,[m,f]=this.snapped,g=this.releaseXSpring,_=this.releaseYSpring,y=this.releaseEase,v=this.hasReleaseSpring,b=this.overshootCoords,T=this.x,w=this.y,x=this.computeVelocity(r-a,n-l),S=this.angle=rt(n-h,r-o),k=150*x,$=(1-this.releaseContainerFriction)*this.dragSpeed,E=T+Z(S)*k,C=w+G(S)*k,B=E>d?d+(E-d)*$:E<p?p+(E-p)*$:E,D=C>u?u+(C-u)*$:C<c?c+(C-c)*$:C,N=this.destX=ht(lt(ct(B,this.snapX),5),p,d),A=this.destY=ht(lt(ct(D,this.snapY),5),c,u),F=this.isOutOfBounds(this.containerBounds,E,C);let O=0,P=0,R=y,M=y,Y=0;if(b.x=T,b.y=w,!t){const t=N===d?T>d?-1:1:T<p?-1:1,s=lt(T-N,0);g.velocity=e&&v?s?k*t/J(s):0:x;const{ease:i,duration:r,restDuration:n}=g;O=T===N?0:v?r:r-n*L.timeScale,v&&(R=i),O>Y&&(Y=O)}if(!e){const e=A===u?w>u?-1:1:w<c?-1:1,s=lt(w-A,0);_.velocity=t&&v?s?k*e/J(s):0:x;const{ease:i,duration:r,restDuration:n}=_;P=w===A?0:v?r:r-n*L.timeScale,v&&(M=i),P>Y&&(Y=P)}if(!v&&F&&$&&(O||P)){const t=i.blend;new Re(b,{x:{to:B,duration:.65*O},y:{to:D,duration:.65*P},ease:y,composition:t}).init(),new Re(b,{x:{to:N,duration:O},y:{to:A,duration:P},ease:y,composition:t}).init(),this.overshootXTicker.stretch(O).restart(),this.overshootYTicker.stretch(P).restart()}else t||this.animate[this.xProp](N,O,R),e||this.animate[this.yProp](A,P,M);this.scrollInView(Y,this.scrollThreshold,y);let X=!1;N!==m&&(this.snapped[0]=N,this.snapX&&(X=!0)),A!==f&&this.snapY&&(this.snapped[1]=A,this.snapY&&(X=!0)),X&&this.onSnap(this),this.grabbed=!1,this.dragged=!1,this.updated=!0,this.released=!0,this.onRelease(this),this.$trigger.removeEventListener("touchstart",ys),this.$trigger.removeEventListener("touchmove",ys),this.$trigger.removeEventListener("touchend",ys),s.removeEventListener("touchmove",this),s.removeEventListener("touchend",this),s.removeEventListener("touchcancel",this),s.removeEventListener("mousemove",this),s.removeEventListener("mouseup",this),s.removeEventListener("selectstart",this)}reset(){return this.stop(),this.resizeTicker.pause(),this.grabbed=!1,this.dragged=!1,this.updated=!1,this.released=!1,this.canScroll=!1,this.setX(0,!0),this.setY(0,!0),this.coords[0]=0,this.coords[1]=0,this.pointer[0]=0,this.pointer[1]=0,this.pointer[2]=0,this.pointer[3]=0,this.pointer[4]=0,this.pointer[5]=0,this.pointer[6]=0,this.pointer[7]=0,this.velocity=0,this.velocityStack[0]=0,this.velocityStack[1]=0,this.velocityStack[2]=0,this.velocityStackIndex=0,this.angle=0,this}enable(){return this.enabled||(this.enabled=!0,this.$target.classList.remove("is-disabled"),this.touchActionStyles=ss(this.$trigger,{touchAction:this.disabled[0]?"pan-x":this.disabled[1]?"pan-y":"none"}),this.$trigger.addEventListener("touchstart",this,{passive:!0}),this.$trigger.addEventListener("mousedown",this,{passive:!0}),this.$trigger.addEventListener("mouseenter",this)),this}disable(){return this.enabled=!1,this.grabbed=!1,this.dragged=!1,this.updated=!1,this.released=!1,this.canScroll=!1,this.touchActionStyles.revert(),this.cursorStyles&&(this.cursorStyles.revert(),this.cursorStyles=null),this.triggerStyles&&(this.triggerStyles.revert(),this.triggerStyles=null),this.bodyStyles&&(this.bodyStyles.revert(),this.bodyStyles=null),this.targetStyles&&(this.targetStyles.revert(),this.targetStyles=null),this.$target.classList.add("is-disabled"),this.$trigger.removeEventListener("touchstart",this),this.$trigger.removeEventListener("mousedown",this),this.$trigger.removeEventListener("mouseenter",this),s.removeEventListener("touchmove",this),s.removeEventListener("touchend",this),s.removeEventListener("touchcancel",this),s.removeEventListener("mousemove",this),s.removeEventListener("mouseup",this),s.removeEventListener("selectstart",this),this}revert(){return this.reset(),this.disable(),this.$target.classList.remove("is-disabled"),this.updateTicker.revert(),this.overshootXTicker.revert(),this.overshootYTicker.revert(),this.resizeTicker.revert(),this.animate.revert(),this.resizeObserver.disconnect(),this}handleEvent(t){switch(t.type){case"mousedown":case"touchstart":this.handleDown(t);break;case"mousemove":case"touchmove":this.handleMove(t);break;case"mouseup":case"touchend":case"touchcancel":this.handleUp();break;case"mouseenter":this.handleHover();break;case"selectstart":ys(t)}}}const Ss=(t,e)=>new xs(t,e);class ks{constructor(t={}){B.current&&B.current.register(this);const i=t.root;let r=s;i&&(r=i.current||i.nativeElement||At(i)[0]||s);const n=t.defaults,o=L.defaults,h=t.mediaQueries;if(this.defaults=n?_t(n,o):o,this.root=r,this.constructors=[],this.revertConstructors=[],this.revertibles=[],this.constructorsOnce=[],this.revertConstructorsOnce=[],this.revertiblesOnce=[],this.once=!1,this.onceIndex=0,this.methods={},this.matches={},this.mediaQueryLists={},this.data={},h)for(let t in h){const s=e.matchMedia(h[t]);this.mediaQueryLists[t]=s,s.addEventListener("change",this)}}register(t){(this.once?this.revertiblesOnce:this.revertibles).push(t)}execute(t){let e=B.current,s=B.root,i=L.defaults;B.current=this,B.root=this.root,L.defaults=this.defaults;const r=this.mediaQueryLists;for(let t in r)this.matches[t]=r[t].matches;const n=t(this);return B.current=e,B.root=s,L.defaults=i,n}refresh(){return this.onceIndex=0,this.execute((()=>{let t=this.revertibles.length,e=this.revertConstructors.length;for(;t--;)this.revertibles[t].revert();for(;e--;)this.revertConstructors[e](this);this.revertibles.length=0,this.revertConstructors.length=0,this.constructors.forEach((t=>{const e=t(this);Y(e)&&this.revertConstructors.push(e)}))})),this}add(t,e){if(this.once=!1,Y(t)){const e=t;this.constructors.push(e),this.execute((()=>{const t=e(this);Y(t)&&this.revertConstructors.push(t)}))}else this.methods[t]=(...t)=>this.execute((()=>e(...t)));return this}addOnce(t){if(this.once=!0,Y(t)){const e=this.onceIndex++;if(this.constructorsOnce[e])return this;const s=t;this.constructorsOnce[e]=s,this.execute((()=>{const t=s(this);Y(t)&&this.revertConstructorsOnce.push(t)}))}return this}keepTime(t){this.once=!0;const e=this.onceIndex++,s=this.constructorsOnce[e];if(Y(s))return s(this);const i=Tt(t);let r;return this.constructorsOnce[e]=i,this.execute((()=>{r=i(this)})),r}handleEvent(t){"change"===t.type&&this.refresh()}revert(){const t=this.revertibles,e=this.revertConstructors,s=this.revertiblesOnce,i=this.revertConstructorsOnce,r=this.mediaQueryLists;let n=t.length,o=e.length,h=s.length,a=i.length;for(;n--;)t[n].revert();for(;o--;)e[o](this);for(;h--;)s[h].revert();for(;a--;)i[a](this);for(let t in r)r[t].removeEventListener("change",this);t.length=0,e.length=0,this.constructors.length=0,s.length=0,i.length=0,this.constructorsOnce.length=0,this.onceIndex=0,this.matches={},this.methods={},this.mediaQueryLists={},this.data={}}}const $s=t=>new ks(t),Es=(t,e)=>t&&Y(t)?t(e):t,Cs=new Map;class Bs{constructor(t){this.element=t,this.useWin=this.element===s.body,this.winWidth=0,this.winHeight=0,this.width=0,this.height=0,this.left=0,this.top=0,this.zIndex=0,this.scrollX=0,this.scrollY=0,this.prevScrollX=0,this.prevScrollY=0,this.scrollWidth=0,this.scrollHeight=0,this.velocity=0,this.backwardX=!1,this.backwardY=!1,this.scrollTicker=new ne({autoplay:!1,onBegin:()=>this.dataTimer.resume(),onUpdate:()=>{const t=this.backwardX||this.backwardY;yt(this,(t=>t.handleScroll()),t)},onComplete:()=>this.dataTimer.pause()}).init(),this.dataTimer=new ne({autoplay:!1,frameRate:30,onUpdate:t=>{const e=t.deltaTime,s=this.prevScrollX,i=this.prevScrollY,r=this.scrollX,n=this.scrollY,o=s-r,h=i-n;this.prevScrollX=r,this.prevScrollY=n,o&&(this.backwardX=s>r),h&&(this.backwardY=i>n),this.velocity=lt(e>0?Math.sqrt(o*o+h*h)/e:0,5)}}).init(),this.resizeTicker=new ne({autoplay:!1,duration:250*L.timeScale,onComplete:()=>{this.updateWindowBounds(),this.refreshScrollObservers(),this.handleScroll()}}).init(),this.wakeTicker=new ne({autoplay:!1,duration:500*L.timeScale,onBegin:()=>{this.scrollTicker.resume()},onComplete:()=>{this.scrollTicker.pause()}}).init(),this._head=null,this._tail=null,this.updateScrollCoords(),this.updateWindowBounds(),this.updateBounds(),this.refreshScrollObservers(),this.handleScroll(),this.resizeObserver=new ResizeObserver((()=>this.resizeTicker.restart())),this.resizeObserver.observe(this.element),(this.useWin?e:this.element).addEventListener("scroll",this,!1)}updateScrollCoords(){const t=this.useWin,s=this.element;this.scrollX=lt(t?e.scrollX:s.scrollLeft,0),this.scrollY=lt(t?e.scrollY:s.scrollTop,0)}updateWindowBounds(){this.winWidth=e.innerWidth,this.winHeight=(()=>{const t=s.createElement("div");s.body.appendChild(t),t.style.height="100lvh";const e=t.offsetHeight;return s.body.removeChild(t),e})()}updateBounds(){const t=getComputedStyle(this.element),e=this.element;let s,i;if(this.scrollWidth=e.scrollWidth+parseFloat(t.marginLeft)+parseFloat(t.marginRight),this.scrollHeight=e.scrollHeight+parseFloat(t.marginTop)+parseFloat(t.marginBottom),this.updateWindowBounds(),this.useWin)s=this.winWidth,i=this.winHeight;else{const t=e.getBoundingClientRect();s=t.width,i=t.height,this.top=t.top,this.left=t.left}this.width=s,this.height=i}refreshScrollObservers(){yt(this,(t=>{t._debug&&t.removeDebug()})),this.updateBounds(),yt(this,(t=>{t.refresh(),t._debug&&t.debug()}))}refresh(){this.updateWindowBounds(),this.updateBounds(),this.refreshScrollObservers(),this.handleScroll()}handleScroll(){this.updateScrollCoords(),this.wakeTicker.restart()}handleEvent(t){"scroll"===t.type&&this.handleScroll()}revert(){this.scrollTicker.cancel(),this.dataTimer.cancel(),this.resizeTicker.cancel(),this.wakeTicker.cancel(),this.resizeObserver.disconnect(),(this.useWin?e:this.element).removeEventListener("scroll",this),Cs.delete(this.element)}}const Ls=(t,e,s,i,r)=>{const n="min"===e,o="max"===e,h="top"===e||"left"===e||"start"===e||n?0:"bottom"===e||"right"===e||"end"===e||o?"100%":"center"===e?"50%":e,{n:a,u:l}=qt(h,jt);let c=a;return"%"===l?c=a/100*s:l&&(c=$e(t,jt,"px",!0).n),o&&i<0&&(c+=i),n&&r>0&&(c+=r),c},Ds=(t,e,s,i,r)=>{let n;if(M(e)){const o=E.exec(e);if(o){const h=o[0],a=h[0],l=e.split(h),c="min"===l[0],d="max"===l[0],u=Ls(t,l[0],s,i,r),p=Ls(t,l[1],s,i,r);if(c){const e=Ut(Ls(t,"min",s),p,a);n=e<u?u:e}else if(d){const e=Ut(Ls(t,"max",s),p,a);n=e>u?u:e}else n=Ut(u,p,a)}else n=Ls(t,e,s,i,r)}else n=e;return lt(n,0)},Ns=t=>{let e;const s=t.targets;for(let t=0,i=s.length;t<i;t++){const i=s[t];if(i[n]){e=i;break}}return e};let As=0;const Fs=["#FF4B4B","#FF971B","#FFC730","#F9F640","#7AFF5A","#18FF74","#17E09B","#3CFFEC","#05DBE9","#33B3F1","#638CF9","#C563FE","#FF4FCF","#F93F8A"];class Os{constructor(t={}){B.current&&B.current.register(this);const e=zt(t.sync,"play pause"),i=e?Te(e):null,r=e&&("linear"===e||e===he),n=e&&!(i===he&&!r),o=e&&(R(e)||!0===e||r),h=e&&M(e)&&!n&&!o,a=h?e.split(" ").map((t=>()=>{const e=this.linked;return e&&e[t]?e[t]():null})):null,l=h&&a.length>2;this.index=As++,this.id=X(t.id)?this.index:t.id,this.container=(t=>{const e=t&&At(t)[0]||s.body;let i=Cs.get(e);return i||(i=new Bs(e),Cs.set(e,i)),i})(t.container),this.target=null,this.linked=null,this.repeat=null,this.horizontal=null,this.enter=null,this.leave=null,this.sync=n||o||!!a,this.syncEase=n?i:null,this.syncSmooth=o?!0===e||r?1:e:null,this.onSyncEnter=a&&!l&&a[0]?a[0]:_,this.onSyncLeave=a&&!l&&a[1]?a[1]:_,this.onSyncEnterForward=a&&l&&a[0]?a[0]:_,this.onSyncLeaveForward=a&&l&&a[1]?a[1]:_,this.onSyncEnterBackward=a&&l&&a[2]?a[2]:_,this.onSyncLeaveBackward=a&&l&&a[3]?a[3]:_,this.onEnter=t.onEnter||_,this.onLeave=t.onLeave||_,this.onEnterForward=t.onEnterForward||_,this.onLeaveForward=t.onLeaveForward||_,this.onEnterBackward=t.onEnterBackward||_,this.onLeaveBackward=t.onLeaveBackward||_,this.onUpdate=t.onUpdate||_,this.onSyncComplete=t.onSyncComplete||_,this.reverted=!1,this.completed=!1,this.began=!1,this.isInView=!1,this.forceEnter=!1,this.hasEntered=!1,this.offset=0,this.offsetStart=0,this.offsetEnd=0,this.distance=0,this.prevProgress=0,this.thresholds=["start","end","end","start"],this.coords=[0,0,0,0],this.debugStyles=null,this.$debug=null,this._params=t,this._debug=zt(t.debug,!1),this._next=null,this._prev=null,bt(this.container,this),ts((()=>{if(!this.reverted){if(!this.target){const e=At(t.target)[0];this.target=e||s.body,this.refresh()}this._debug&&this.debug()}}))}link(t){if(t&&(t.pause(),this.linked=t,!this._params.target)){let e;X(t.targets)?yt(t,(t=>{t.targets&&!e&&(e=Ns(t))})):e=Ns(t),this.target=e||s.body,this.refresh()}return this}get velocity(){return this.container.velocity}get backward(){return this.horizontal?this.container.backwardX:this.container.backwardY}get scroll(){return this.horizontal?this.container.scrollX:this.container.scrollY}get progress(){const t=(this.scroll-this.offsetStart)/this.distance;return t===1/0||isNaN(t)?0:lt(ht(t,0,1),6)}refresh(){this.reverted=!1;const t=this._params;return this.repeat=zt(Es(t.repeat,this),!0),this.horizontal="x"===zt(Es(t.axis,this),"y"),this.enter=zt(Es(t.enter,this),"end start"),this.leave=zt(Es(t.leave,this),"start end"),this.updateBounds(),this.handleScroll(),this}removeDebug(){return this.$debug&&(this.$debug.parentNode.removeChild(this.$debug),this.$debug=null),this.debugStyles&&(this.debugStyles.revert(),this.$debug=null),this}debug(){this.removeDebug();const t=this.container,e=this.horizontal,i=t.element.querySelector(":scope > .animejs-onscroll-debug"),r=s.createElement("div"),n=s.createElement("div"),o=s.createElement("div"),h=Fs[this.index%Fs.length],a=t.useWin,l=a?t.winWidth:t.width,c=a?t.winHeight:t.height,d=t.scrollWidth,u=t.scrollHeight,p=this.container.width>360?320:260,m=e?0:10,f=e?10:0,g=e?24:p/2,_=e?g:15,y=e?60:g,v=e?y:_,b=e?"repeat-x":"repeat-y",T=t=>e?"0px "+t+"px":t+"px 2px",w=t=>`linear-gradient(${e?90:0}deg, ${t} 2px, transparent 1px)`,x=(t,e,s,i,r)=>`position:${t};left:${e}px;top:${s}px;width:${i}px;height:${r}px;`;r.style.cssText=`${x("absolute",m,f,e?d:p,e?p:u)}\n      pointer-events: none;\n      z-index: ${this.container.zIndex++};\n      display: flex;\n      flex-direction: ${e?"column":"row"};\n      filter: drop-shadow(0px 1px 0px rgba(0,0,0,.75));\n    `,n.style.cssText=`${x("sticky",0,0,e?l:g,e?g:c)}`,i||(n.style.cssText+=`background:\n        ${w("#FFFF")}${T(g-10)} / 100px 100px ${b},\n        ${w("#FFF8")}${T(g-10)} / 10px 10px ${b};\n      `),o.style.cssText=`${x("relative",0,0,e?d:g,e?g:u)}`,i||(o.style.cssText+=`background:\n        ${w("#FFFF")}${T(0)} / ${e?"100px 10px":"10px 100px"} ${b},\n        ${w("#FFF8")}${T(0)} / ${e?"10px 0px":"0px 10px"} ${b};\n      `);const S=[" enter: "," leave: "];this.coords.forEach(((t,i)=>{const r=i>1,a=(r?0:this.offset)+t,m=i%2,f=a<v,g=a>(r?e?l:c:e?d:u)-v,b=(r?m&&!f:!m&&!f)||g,T=s.createElement("div"),w=s.createElement("div"),k=e?b?"right":"left":b?"bottom":"top",$=b?(e?y:_)+(r?e?-1:g?0:-2:e?-1:-2):e?1:0;w.innerHTML=`${this.id}${S[m]}${this.thresholds[i]}`,T.style.cssText=`${x("absolute",0,0,y,_)}\n        display: flex;\n        flex-direction: ${e?"column":"row"};\n        justify-content: flex-${r?"start":"end"};\n        align-items: flex-${b?"end":"start"};\n        border-${k}: 2px solid ${h};\n      `,w.style.cssText=`\n        overflow: hidden;\n        max-width: ${p/2-10}px;\n        height: ${_};\n        margin-${e?b?"right":"left":b?"bottom":"top"}: -2px;\n        padding: 1px;\n        font-family: ui-monospace, monospace;\n        font-size: 10px;\n        letter-spacing: -.025em;\n        line-height: 9px;\n        font-weight: 600;\n        text-align: ${e&&b||!e&&!r?"right":"left"};\n        white-space: pre;\n        text-overflow: ellipsis;\n        color: ${m?h:"rgba(0,0,0,.75)"};\n        background-color: ${m?"rgba(0,0,0,.65)":h};\n        border: 2px solid ${m?h:"transparent"};\n        border-${e?b?"top-left":"top-right":b?"top-left":"bottom-left"}-radius: 5px;\n        border-${e?b?"bottom-left":"bottom-right":b?"top-right":"bottom-right"}-radius: 5px;\n      `,T.appendChild(w);let E=a-$+(e?1:0);T.style[e?"left":"top"]=`${E}px`,(r?n:o).appendChild(T)})),r.appendChild(n),r.appendChild(o),t.element.appendChild(r),i||r.classList.add("animejs-onscroll-debug"),this.$debug=r,"static"===es(t.element,"position")&&(this.debugStyles=ss(t.element,{position:"relative "}))}updateBounds(){let t;this._debug&&this.removeDebug();const e=this.target,i=this.container,r=this.horizontal,n=this.linked;let o,h=e;for(n&&(o=n.currentTime,n.seek(0,!0)),h.parentElement;h&&h!==i.element&&h!==s.body;){const e="sticky"===es(h,"position")&&ss(h,{position:"static"});h=h.parentElement,e&&(t||(t=[]),t.push(e))}const a=e.getBoundingClientRect(),l=r?a.left+i.scrollX-i.left:a.top+i.scrollY-i.top,c=r?a.width:a.height,d=r?i.width:i.height,u=(r?i.scrollWidth:i.scrollHeight)-d,p=this.enter,m=this.leave;let f="start",g="end",_="end",y="start";if(M(p)){const t=p.split(" ");_=t[0],f=t.length>1?t[1]:f}else if(P(p)){const t=p;X(t.container)||(_=t.container),X(t.target)||(f=t.target)}else R(p)&&(_=p);if(M(m)){const t=m.split(" ");y=t[0],g=t.length>1?t[1]:g}else if(P(m)){const t=m;X(t.container)||(y=t.container),X(t.target)||(g=t.target)}else R(m)&&(y=m);const v=Ds(e,f,c),b=Ds(e,g,c),T=v+l-d,w=b+l-u,x=Ds(e,_,d,T,w),S=Ds(e,y,d,T,w),k=v+l-x,$=b+l-S,E=$-k;this.offset=l,this.offsetStart=k,this.offsetEnd=$,this.distance=E<=0?0:E,this.thresholds=[f,g,_,y],this.coords=[v,b,x,S],t&&t.forEach((t=>t.revert())),n&&n.seek(o,!0),this._debug&&this.debug()}handleScroll(){const t=this.linked,e=this.sync,s=this.syncEase,i=this.syncSmooth,r=t&&(s||i),n=this.horizontal,o=this.container,h=this.scroll,a=h<=this.offsetStart,l=h>=this.offsetEnd,c=!a&&!l,d=h===this.offsetStart||h===this.offsetEnd,u=!this.hasEntered&&d,p=this._debug&&this.$debug;let m=!1,f=!1,g=this.progress;if(a&&this.began&&(this.began=!1),g>0&&!this.began&&(this.began=!0),r){const e=t.progress;if(i&&R(i)){if(i<1){const t=e<g&&1===g?1e-4:e>g&&!g?-1e-4:0;g=lt(os(e,g,dt(.01,.2,i),!1)+t,6)}}else s&&(g=s(g));m=g!==this.prevProgress,f=1===e,m&&!f&&i&&e&&o.wakeTicker.restart()}if(p){const t=n?o.scrollY:o.scrollX;p.style[n?"top":"left"]=t+10+"px"}(c&&!this.isInView||u&&!this.forceEnter&&!this.hasEntered)&&(c&&(this.isInView=!0),this.forceEnter&&this.hasEntered?c&&(this.forceEnter=!1):(p&&c&&(p.style.zIndex=""+this.container.zIndex++),this.onSyncEnter(this),this.onEnter(this),this.backward?(this.onSyncEnterBackward(this),this.onEnterBackward(this)):(this.onSyncEnterForward(this),this.onEnterForward(this)),this.hasEntered=!0,u&&(this.forceEnter=!0))),(c||!c&&this.isInView)&&(m=!0),m&&(r&&t.seek(t.duration*g),this.onUpdate(this)),!c&&this.isInView&&(this.isInView=!1,this.onSyncLeave(this),this.onLeave(this),this.backward?(this.onSyncLeaveBackward(this),this.onLeaveBackward(this)):(this.onSyncLeaveForward(this),this.onLeaveForward(this)),e&&!i&&(f=!0)),g>=1&&this.began&&!this.completed&&(e&&f||!e)&&(e&&this.onSyncComplete(this),this.completed=!0,(!this.repeat&&!t||!this.repeat&&t&&t.completed)&&this.revert()),g<1&&this.completed&&(this.completed=!1),this.prevProgress=g}revert(){if(this.reverted)return;const t=this.container;return vt(t,this),t._head||t.revert(),this._debug&&this.removeDebug(),this.reverted=!0,this}}const Ps=(t={})=>new Os(t),Rs=!X(Intl)&&Intl.Segmenter,Ms=/\{value\}/g,Ys=/\{i\}/g,Xs=/(\s+)/,zs=/^\s+$/,Is="line",Ws="word",Vs="char",Hs="data-line";let Us=null,qs=null,Qs=null;const js=t=>t.isWordLike||" "===t.segment||R(+t.segment),Gs=t=>t.setAttribute("aria-hidden","true"),Zs=(t,e)=>[...t.querySelectorAll(`[data-${e}]:not([data-${e}] [data-${e}])`)],Js={line:"#00D672",word:"#FF4B4B",char:"#5A87FF"},Ks=t=>{if(!t.childElementCount&&!t.textContent.trim()){const e=t.parentElement;t.remove(),e&&Ks(e)}},ti=(t,e,s)=>{const i=t.getAttribute(Hs);(null!==i&&+i!==e||"BR"===t.tagName)&&s.add(t);let r=t.childElementCount;for(;r--;)ti(t.children[r],e,s);return s},ei=(t,e={})=>{let s="";const i=M(e.class)?` class="${e.class}"`:"",r=zt(e.clone,!1),n=zt(e.wrap,!1),o=n?!0===n?"clip":n:!!r&&"clip";return n&&(s+=`<span${o?` style="overflow:${o};"`:""}>`),s+=`<span${i}${r?' style="position:relative;"':""} data-${t}="{i}">`,r?(s+="<span>{value}</span>",s+=`<span inert style="position:absolute;top:${"top"===r?"-100%":"bottom"===r?"100%":"0"};left:${"left"===r?"-100%":"right"===r?"100%":"0"};white-space:nowrap;">{value}</span>`):s+="{value}",s+="</span>",n&&(s+="</span>"),s},si=(t,e,s,i,r,n,o,h,a)=>{const l=r===Is,c=r===Vs,d=`_${r}_`,u=Y(t)?t(s):t,p=l?"block":"inline-block";Qs.innerHTML=u.replace(Ms,`<i class="${d}"></i>`).replace(Ys,`${c?a:l?o:h}`);const m=Qs.content,f=m.firstElementChild,g=m.querySelector(`[data-${r}]`)||f,_=m.querySelectorAll(`i.${d}`),y=_.length;if(y){f.style.display=p,g.style.display=p,g.setAttribute(Hs,`${o}`),l||(g.setAttribute("data-word",`${h}`),c&&g.setAttribute("data-char",`${a}`));let t=y;for(;t--;){const e=_[t],i=e.parentElement;i.style.display=p,l?i.innerHTML=s.innerHTML:i.replaceChild(s.cloneNode(!0),e)}e.push(g),i.appendChild(m)}else console.warn('The expression "{value}" is missing from the provided template.');return n&&(f.style.outline=`1px dotted ${Js[r]}`),f};class ii{constructor(e,i={}){Us||(Us=Rs?new Rs([],{granularity:Ws}):{segment:t=>{const e=[],s=t.split(Xs);for(let t=0,i=s.length;t<i;t++){const i=s[t];e.push({segment:i,isWordLike:!zs.test(i)})}return e}}),qs||(qs=Rs?new Rs([],{granularity:"grapheme"}):{segment:t=>[...t].map((t=>({segment:t})))}),!Qs&&t&&(Qs=s.createElement("template")),B.current&&B.current.register(this);const{words:r,chars:n,lines:o,accessible:h,includeSpaces:a,debug:l}=i,c=(e=O(e)?e[0]:e)&&e.nodeType?e:(Nt(e)||[])[0],d=!0===o?{}:o,u=!0===r||X(r)?{}:r,p=!0===n?{}:n;this.debug=zt(l,!1),this.includeSpaces=zt(a,!1),this.accessible=zt(h,!0),this.linesOnly=d&&!u&&!p,this.lineTemplate=P(d)?ei(Is,d):d,this.wordTemplate=P(u)||this.linesOnly?ei(Ws,u):u,this.charTemplate=P(p)?ei(Vs,p):p,this.$target=c,this.html=c&&c.innerHTML,this.lines=[],this.words=[],this.chars=[],this.effects=[],this.effectsCleanups=[],this.cache=null,this.ready=!1,this.width=0,this.resizeTimeout=null;const m=()=>this.html&&(d||u||p)&&this.split();this.resizeObserver=new ResizeObserver((()=>{clearTimeout(this.resizeTimeout),this.resizeTimeout=setTimeout((()=>{const t=c.offsetWidth;t!==this.width&&(this.width=t,m())}),150)})),this.lineTemplate&&!this.ready?s.fonts.ready.then(m):m(),c?this.resizeObserver.observe(c):console.warn("No Text Splitter target found.")}addEffect(t){if(!Y(t))return console.warn("Effect must return a function.");const e=Tt(t);return this.effects.push(e),this.ready&&(this.effectsCleanups[this.effects.length-1]=e(this)),this}revert(){return clearTimeout(this.resizeTimeout),this.lines.length=this.words.length=this.chars.length=0,this.resizeObserver.disconnect(),this.effectsCleanups.forEach((t=>Y(t)?t(this):t.revert&&t.revert())),this.$target.innerHTML=this.html,this}splitNode(t){const e=this.wordTemplate,i=this.charTemplate,r=this.includeSpaces,n=this.debug,o=t.nodeType;if(3===o){const o=t.nodeValue;if(o.trim()){const h=[],a=this.words,l=this.chars,c=Us.segment(o),d=s.createDocumentFragment();let u=null;for(const t of c){const e=t.segment,s=js(t);if(!u||s&&u&&js(u))h.push(e);else{const t=h.length-1;h[t].includes(" ")||e.includes(" ")?h.push(e):h[t]+=e}u=t}for(let t=0,o=h.length;t<o;t++){const o=h[t];if(o.trim()){const c=h[t+1],u=r&&c&&!c.trim(),p=o,m=i?qs.segment(p):null,f=i?s.createDocumentFragment():s.createTextNode(u?o+" ":o);if(i){const t=[...m];for(let e=0,r=t.length;e<r;e++){const o=t[e],h=e===r-1&&u?o.segment+" ":o.segment,c=s.createTextNode(h);si(i,l,c,f,Vs,n,-1,a.length,l.length)}}e?si(e,a,f,d,Ws,n,-1,a.length,l.length):i?d.appendChild(f):d.appendChild(s.createTextNode(o)),u&&t++}else{if(t&&r)continue;d.appendChild(s.createTextNode(o))}}t.parentNode.replaceChild(d,t)}}else if(1===o){const e=[...t.childNodes];for(let t=0,s=e.length;t<s;t++)this.splitNode(e[t])}}split(t=!1){const e=this.$target,i=!!this.cache&&!t,r=this.lineTemplate,n=this.wordTemplate,o=this.charTemplate,h="loading"!==s.fonts.status,a=r&&h;this.ready=!r||h,(a||t)&&this.effectsCleanups.forEach((t=>Y(t)&&t(this))),i||(t&&(e.innerHTML=this.html,this.words.length=this.chars.length=0),this.splitNode(e),this.cache=e.innerHTML),a&&(i&&(e.innerHTML=this.cache),this.lines.length=0,n&&(this.words=Zs(e,Ws))),o&&(a||n)&&(this.chars=Zs(e,Vs));const l=this.words.length?this.words:this.chars;let c,d=0;for(let t=0,e=l.length;t<e;t++){const e=l[t],{top:s,height:i}=e.getBoundingClientRect();c&&s-c>.5*i&&d++,e.setAttribute(Hs,`${d}`);const r=e.querySelectorAll(`[${Hs}]`);let n=r.length;for(;n--;)r[n].setAttribute(Hs,`${d}`);c=s}if(a){const t=s.createDocumentFragment(),i=new Set,h=[];for(let t=0;t<d+1;t++){const s=e.cloneNode(!0);ti(s,t,new Set).forEach((t=>{const e=t.parentElement;e&&i.add(e),t.remove()})),h.push(s)}i.forEach(Ks);for(let e=0,s=h.length;e<s;e++)si(r,this.lines,h[e],t,Is,this.debug,e);e.innerHTML="",e.appendChild(t),n&&(this.words=Zs(e,Ws)),o&&(this.chars=Zs(e,Vs))}if(this.linesOnly){const t=this.words;let e=t.length;for(;e--;){const s=t[e];s.replaceWith(s.textContent)}t.length=0}if(this.accessible&&(a||!i)){const t=s.createElement("span");t.style.cssText="position:absolute;overflow:hidden;clip:rect(0 0 0 0);clip-path:inset(50%);width:1px;height:1px;white-space:nowrap;",t.innerHTML=this.html,e.insertBefore(t,e.firstChild),this.lines.forEach(Gs),this.words.forEach(Gs),this.chars.forEach(Gs)}return this.width=e.offsetWidth,(a||t)&&this.effects.forEach(((t,e)=>this.effectsCleanups[e]=t(this))),this}refresh(){this.split(!0)}}const ri={split:(t,e)=>new ii(t,e)},ni=(t,e={})=>{let s=[],i=0;const r=e.from,n=e.reversed,o=e.ease,h=!X(o),a=h&&!X(o.ease)?o.ease:h?Te(o):null,l=e.grid,c=e.axis,d=e.total,u=X(r)||0===r||"first"===r,m="center"===r,f="last"===r,g="random"===r,_=O(t),y=e.use,v=q(_?t[0]:t),b=_?q(t[1]):0,T=S.exec((_?t[1]:t)+p),w=e.start||0+(_?v:0);let x=u?0:R(r)?r:0;return(t,r,o,h)=>{const[u]=Ft(t),p=X(d)?o:d,S=!X(y)&&(Y(y)?y(u,r,p):Ht(u,y)),k=R(S)||M(S)&&R(+S)?+S:r;if(m&&(x=(p-1)/2),f&&(x=p-1),!s.length){for(let t=0;t<p;t++){if(l){const e=m?(l[0]-1)/2:x%l[0],i=m?(l[1]-1)/2:et(x/l[0]),r=e-t%l[0],n=i-et(t/l[0]);let o=j(r*r+n*n);"x"===c&&(o=-r),"y"===c&&(o=-n),s.push(o)}else s.push(J(x-t));i=it(...s)}a&&(s=s.map((t=>a(t/i)*i))),n&&(s=s.map((t=>c?t<0?-1*t:-t:J(i-t)))),g&&(s=pt(s))}const $=_?(b-v)/i:v;let E=(h?cs(h,X(e.start)?h.iterationDuration:w):w)+($*lt(s[k],2)||0);return e.modifier&&(E=e.modifier(E)),T&&(E=`${E}${T[2]}`),E}};export{ms as Animatable,xs as Draggable,Re as JSAnimation,ks as Scope,Os as ScrollObserver,gs as Spring,ii as TextSplitter,us as Timeline,ne as Timer,Je as WAAPIAnimation,Me as animate,fs as createAnimatable,Ss as createDraggable,$s as createScope,_s as createSpring,ps as createTimeline,oe as createTimer,ve as eases,Bt as engine,Ps as onScroll,Cs as scrollContainers,ni as stagger,Yt as svg,ri as text,ls as utils,Ke as waapi};
