/**
 * anime.js - IIFE
 * @version v4.1.2
 * @author Julian Garnier
 * @license MIT
 * @copyright (c) 2025 Julian Garnier
 * @see https://animejs.com
 */
var anime=function(t){"use strict";const e="undefined"!=typeof window,s=e?window:null,i=e?document:null,r={replace:0,none:1,blend:2},n=Symbol(),o=Symbol(),h=Symbol(),a=Symbol(),l=Symbol(),c=Symbol(),d=1e-11,u=1e12,p=1e3,m="",f=(()=>{const t=new Map;return t.set("x","translateX"),t.set("y","translateY"),t.set("z","translateZ"),t})(),g=["translateX","translateY","translateZ","rotate","rotateX","rotateY","rotateZ","scale","scaleX","scaleY","scaleZ","skew","skewX","skewY","perspective","matrix","matrix3d"],_=g.reduce(((t,e)=>({...t,[e]:e+"("})),{}),y=()=>{},v=/(^#([\da-f]{3}){1,2}$)|(^#([\da-f]{4}){1,2}$)/i,b=/rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/i,T=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(-?\d+|-?\d*.\d+)\s*\)/i,w=/hsl\(\s*(-?\d+|-?\d*.\d+)\s*,\s*(-?\d+|-?\d*.\d+)%\s*,\s*(-?\d+|-?\d*.\d+)%\s*\)/i,S=/hsla\(\s*(-?\d+|-?\d*.\d+)\s*,\s*(-?\d+|-?\d*.\d+)%\s*,\s*(-?\d+|-?\d*.\d+)%\s*,\s*(-?\d+|-?\d*.\d+)\s*\)/i,x=/[-+]?\d*\.?\d+(?:e[-+]?\d)?/gi,k=/^([-+]?\d*\.?\d+(?:e[-+]?\d+)?)([a-z]+|%)$/i,$=/([a-z])([A-Z])/g,C=/(\w+)(\([^)]+\)+)/g,E=/(\*=|\+=|-=)/,B={id:null,keyframes:null,playbackEase:null,playbackRate:1,frameRate:120,loop:0,reversed:!1,alternate:!1,autoplay:!0,duration:p,delay:0,loopDelay:0,ease:"out(2)",composition:r.replace,modifier:t=>t,onBegin:y,onBeforeUpdate:y,onUpdate:y,onLoop:y,onPause:y,onComplete:y,onRender:y},D={current:null,root:i},L={defaults:B,precision:4,timeScale:1,tickThreshold:200},A={version:"4.1.2",engine:null};e&&(s.AnimeJS||(s.AnimeJS=[]),s.AnimeJS.push(A));const N=t=>t.replace($,"$1-$2").toLowerCase(),F=(t,e)=>0===t.indexOf(e),O=Date.now,P=Array.isArray,R=t=>t&&t.constructor===Object,M=t=>"number"==typeof t&&!isNaN(t),Y=t=>"string"==typeof t,X=t=>"function"==typeof t,z=t=>void 0===t,I=t=>z(t)||null===t,W=t=>e&&t instanceof SVGElement,V=t=>v.test(t),H=t=>F(t,"rgb"),U=t=>F(t,"hsl"),q=t=>!L.defaults.hasOwnProperty(t),Q=t=>Y(t)?parseFloat(t):t,j=Math.pow,G=Math.sqrt,Z=Math.sin,J=Math.cos,K=Math.abs,tt=Math.exp,et=Math.ceil,st=Math.floor,it=Math.asin,rt=Math.max,nt=Math.atan2,ot=Math.PI,ht=Math.round,at=(t,e,s)=>t<e?e:t>s?s:t,lt={},ct=(t,e)=>{if(e<0)return t;if(!e)return ht(t);let s=lt[e];return s||(s=lt[e]=10**e),ht(t*s)/s},dt=(t,e)=>P(e)?e.reduce(((e,s)=>K(s-t)<K(e-t)?s:e)):e?ht(t/e)*e:t,ut=(t,e,s)=>t+(e-t)*s,pt=(t,e,s)=>{const i=10**(s||0);return st((Math.random()*(e-t+1/i)+t)*i)/i},mt=t=>{let e,s,i=t.length;for(;i;)s=pt(0,--i),e=t[i],t[i]=t[s],t[s]=e;return t},ft=t=>t===1/0?u:t===-1/0?-1e12:t,gt=t=>t<=d?d:ft(ct(t,11)),_t=t=>P(t)?[...t]:t,yt=(t,e)=>{const s={...t};for(let i in e){const r=t[i];s[i]=z(r)?e[i]:r}return s},vt=(t,e,s,i="_prev",r="_next")=>{let n=t._head,o=r;for(s&&(n=t._tail,o=i);n;){const t=n[o];e(n),n=t}},bt=(t,e,s="_prev",i="_next")=>{const r=e[s],n=e[i];r?r[i]=n:t._head=n,n?n[s]=r:t._tail=r,e[s]=null,e[i]=null},Tt=(t,e,s,i="_prev",r="_next")=>{let n=t._tail;for(;n&&s&&s(n,e);)n=n[i];const o=n?n[r]:t._head;n?n[r]=e:t._head=e,o?o[i]=e:t._tail=e,e[i]=n,e[r]=o},wt=t=>{let e;return(...s)=>{let i,r,n,o;e&&(i=e.currentIteration,r=e.iterationProgress,n=e.reversed,o=e._alternate,e.revert());const h=t(...s);return h&&!X(h)&&h.revert&&(e=h),z(r)||(e.currentIteration=i,e.iterationProgress=(o&&i%2?!n:n)?1-r:r),h||y}};class St{constructor(t=0){this.deltaTime=0,this._currentTime=t,this._elapsedTime=t,this._startTime=t,this._lastTime=t,this._scheduledTime=0,this._frameDuration=ct(p/120,0),this._fps=120,this._speed=1,this._hasChildren=!1,this._head=null,this._tail=null}get fps(){return this._fps}set fps(t){const e=this._frameDuration,s=+t,i=s<d?d:s,r=ct(p/i,0);this._fps=i,this._frameDuration=r,this._scheduledTime+=r-e}get speed(){return this._speed}set speed(t){const e=+t;this._speed=e<d?d:e}requestTick(t){const e=this._scheduledTime,s=this._elapsedTime;if(this._elapsedTime+=t-s,s<e)return 0;const i=this._frameDuration,r=s-e;return this._scheduledTime+=r<i?i:r,1}computeDeltaTime(t){const e=t-this._lastTime;return this.deltaTime=e,this._lastTime=t,e}}const xt=(t,e,s,i,n)=>{const o=t.parent,h=t.duration,l=t.completed,c=t.iterationDuration,u=t.iterationCount,p=t._currentIteration,f=t._loopDelay,g=t._reversed,y=t._alternate,v=t._hasChildren,b=t._delay,T=t._currentTime,w=b+c,S=e-b,x=at(T,-b,h),k=at(S,-b,h),$=S-T,C=k>0,E=k>=h,B=h<=d,D=2===n;let A=0,N=S,F=0;if(u>1){const e=~~(k/(c+(E?0:f)));t._currentIteration=at(e,0,u),E&&t._currentIteration--,A=t._currentIteration%2,N=k%(c+f)||0}const O=g^(y&&A),P=t._ease;let R=E?O?0:h:O?c-N:N;P&&(R=c*P(R/c)||0);const M=(o?o.backwards:S<T)?!O:!!O;if(t._currentTime=S,t._iterationTime=R,t.backwards=M,C&&!t.began?(t.began=!0,s||o&&(M||!o.began)||t.onBegin(t)):S<=0&&(t.began=!1),s||v||!C||t._currentIteration===p||t.onLoop(t),D||1===n&&(e>=b&&e<=w||e<=b&&x>b||e>=w&&x!==h)||R>=w&&x!==h||R<=b&&x>0||e<=x&&x===h&&l||E&&!l&&B){if(C&&(t.computeDeltaTime(x),s||t.onBeforeUpdate(t)),!v){const e=D||(M?-1*$:$)>=L.tickThreshold,n=t._offset+(o?o._offset:0)+b+R;let h,l,c,d,u=t._head,p=0;for(;u;){const t=u._composition,s=u._currentTime,o=u._changeDuration,f=u._absoluteStartTime+u._changeDuration,g=u._nextRep,y=u._prevRep,v=t!==r.none;if((e||(s!==o||n<=f+(g?g._delay:0))&&(0!==s||n>=u._absoluteStartTime))&&(!v||!u._isOverridden&&(!u._isOverlapped||n<=f)&&(!g||g._isOverridden||n<=g._absoluteStartTime)&&(!y||y._isOverridden||n>=y._absoluteStartTime+y._changeDuration+u._delay))){const e=u._currentTime=at(R-u._startTime,0,o),s=u._ease(e/u._updateDuration),n=u._modifier,m=u._valueType,f=u._tweenType,g=0===f,_=0===m,y=_&&g||0===s||1===s?-1:L.precision;let b,T;if(_)b=T=n(ct(ut(u._fromNumber,u._toNumber,s),y));else if(1===m)T=n(ct(ut(u._fromNumber,u._toNumber,s),y)),b=`${T}${u._unit}`;else if(2===m){const t=u._fromNumbers,e=u._toNumbers,i=ct(at(n(ut(t[0],e[0],s)),0,255),0),r=ct(at(n(ut(t[1],e[1],s)),0,255),0),o=ct(at(n(ut(t[2],e[2],s)),0,255),0),h=at(n(ct(ut(t[3],e[3],s),y)),0,1);if(b=`rgba(${i},${r},${o},${h})`,v){const t=u._numbers;t[0]=i,t[1]=r,t[2]=o,t[3]=h}}else if(3===m){b=u._strings[0];for(let t=0,e=u._toNumbers.length;t<e;t++){const e=n(ct(ut(u._fromNumbers[t],u._toNumbers[t],s),y)),i=u._strings[t+1];b+=`${i?e+i:e}`,v&&(u._numbers[t]=e)}}if(v&&(u._number=T),i||t===r.blend)u._value=b;else{const t=u.property;h=u.target,g?h[t]=b:1===f?h.setAttribute(t,b):(l=h.style,3===f?(h!==c&&(c=h,d=h[a]),d[t]=b,p=1):2===f?l[t]=b:4===f&&l.setProperty(t,b)),C&&(F=1)}}if(p&&u._renderTransforms){let t=m;for(let e in d)t+=`${_[e]}${d[e]}) `;l.transform=t,p=0}u=u._next}!s&&F&&t.onRender(t)}!s&&C&&t.onUpdate(t)}return o&&B?!s&&(o.began&&!M&&S>=h&&!l||M&&S<=d&&l)&&(t.onComplete(t),t.completed=!M):C&&E?u===1/0?t._startTime+=t.duration:t._currentIteration>=u-1&&(t.paused=!0,l||v||(t.completed=!0,s||o&&(M||!o.began)||(t.onComplete(t),t._resolve(t)))):t.completed=!1,F},kt=(t,e,s,i,r)=>{const n=t._currentIteration;if(xt(t,e,s,i,r),t._hasChildren){const o=t,h=o.backwards,a=i?e:o._iterationTime,l=O();let c=0,u=!0;if(!i&&o._currentIteration!==n){const t=o.iterationDuration;vt(o,(e=>{if(h){const i=e.duration,r=e._offset+e._delay;s||!(i<=d)||r&&r+i!==t||e.onComplete(e)}else!e.completed&&!e.backwards&&e._currentTime<e.iterationDuration&&xt(e,t,s,1,2),e.began=!1,e.completed=!1})),s||o.onLoop(o)}vt(o,(t=>{const e=ct((a-t._offset)*t._speed,12),n=t._fps<o._fps?t.requestTick(l):r;c+=xt(t,e,s,i,n),!t.completed&&u&&(u=!1)}),h),!s&&c&&o.onRender(o),(u||h)&&o._currentTime>=o.duration&&(o.paused=!0,o.completed||(o.completed=!0,s||(o.onComplete(o),o._resolve(o))))}},$t={animation:null,update:y},Ct=(()=>e?requestAnimationFrame:setImmediate)(),Et=(()=>e?cancelAnimationFrame:clearImmediate)();class Bt extends St{constructor(t){super(t),this.useDefaultMainLoop=!0,this.pauseOnDocumentHidden=!0,this.defaults=B,this.paused=!(!e||!i.hidden),this.reqId=null}update(){const t=this._currentTime=O();if(this.requestTick(t)){this.computeDeltaTime(t);const e=this._speed,s=this._fps;let i=this._head;for(;i;){const r=i._next;i.paused?(bt(this,i),this._hasChildren=!!this._tail,i._running=!1,i.completed&&!i._cancelled&&i.cancel()):kt(i,(t-i._startTime)*i._speed*e,0,0,i._fps<s?i.requestTick(t):1),i=r}$t.update()}}wake(){return!this.useDefaultMainLoop||this.reqId||this.paused||(this.reqId=Ct(Lt)),this}pause(){return this.paused=!0,At()}resume(){if(this.paused)return this.paused=!1,vt(this,(t=>t.resetTime())),this.wake()}get speed(){return this._speed*(1===L.timeScale?1:p)}set speed(t){this._speed=t*L.timeScale,vt(this,(t=>t.speed=t._speed))}get timeUnit(){return 1===L.timeScale?"ms":"s"}set timeUnit(t){const e="s"===t,s=e?.001:1;if(L.timeScale!==s){L.timeScale=s,L.tickThreshold=200*s;const t=e?.001:p;this.defaults.duration*=t,this._speed*=t}}get precision(){return L.precision}set precision(t){L.precision=t}}const Dt=(()=>{const t=new Bt(O());return e&&(A.engine=t,i.addEventListener("visibilitychange",(()=>{t.pauseOnDocumentHidden&&(i.hidden?t.pause():t.resume())}))),t})(),Lt=()=>{Dt._head?(Dt.reqId=Ct(Lt),Dt.update()):Dt.reqId=0},At=()=>(Et(Dt.reqId),Dt.reqId=0,Dt);function Nt(t){const e=Y(t)?D.root.querySelectorAll(t):t;if(e instanceof NodeList||e instanceof HTMLCollection)return e}function Ft(t){if(I(t))return[];if(P(t)){const e=t.flat(1/0),s=[];for(let t=0,i=e.length;t<i;t++){const i=e[t];if(!I(i)){const t=Nt(i);if(t)for(let e=0,i=t.length;e<i;e++){const i=t[e];if(!I(i)){let t=!1;for(let e=0,r=s.length;e<r;e++)if(s[e]===i){t=!0;break}t||s.push(i)}}else{let t=!1;for(let e=0,r=s.length;e<r;e++)if(s[e]===i){t=!0;break}t||s.push(i)}}}return s}if(!e)return[t];const s=Nt(t);return s?Array.from(s):[t]}function Ot(t){const e=Ft(t),s=e.length;if(s)for(let t=0;t<s;t++){const s=e[t];if(!s[n]){s[n]=!0;const t=W(s);(s.nodeType||t)&&(s[o]=!0,s[h]=t,s[a]={})}}return e}const Pt=t=>{const e=Ft(t)[0];if(e&&W(e))return e},Rt=(t,e,s=0)=>t.getPointAtLength(e+s>=1?e+s:0),Mt=(t,e)=>s=>{const i=+t.getTotalLength(),r=s[h],n=t.getCTM();return{from:0,to:i,modifier:s=>{if("a"===e){const e=Rt(t,s,-1),i=Rt(t,s,1);return 180*nt(i.y-e.y,i.x-e.x)/ot}{const i=Rt(t,s,0);return"x"===e?r||!n?i.x:i.x*n.a+i.y*n.c+n.e:r||!n?i.y:i.x*n.b+i.y*n.d+n.f}}}},Yt=["opacity","rotate","overflow","color"],Xt={morphTo:(t,e=.33)=>s=>{const i=Pt(t);if(!i)return;const r="path"===s.tagName,n=r?" ":",",o=s[l];o&&s.setAttribute(r?"d":"points",o);let h="",a="";if(e){const t=s.getTotalLength(),o=i.getTotalLength(),l=Math.max(Math.ceil(t*e),Math.ceil(o*e));for(let e=0;e<l;e++){const c=e/(l-1),d=s.getPointAtLength(t*c),u=i.getPointAtLength(o*c),p=r?0===e?"M":"L":"";h+=p+ct(d.x,3)+n+d.y+" ",a+=p+ct(u.x,3)+n+u.y+" "}}else h=s.getAttribute(r?"d":"points"),a=i.getAttribute(r?"d":"points");return s[l]=a,[h,a]},createMotionPath:t=>{const e=Pt(t);if(e)return{translateX:Mt(e,"x"),translateY:Mt(e,"y"),rotate:Mt(e,"a")}},createDrawable:(t,e=0,s=0)=>Ft(t).map((t=>((t,e,s)=>{const i=p,r=getComputedStyle(t),n=r.strokeLinecap,o="non-scaling-stroke"===r.vectorEffect?t:null;let h=n;const a=new Proxy(t,{get(t,e){const s=t[e];return e===c?t:"setAttribute"===e?(...e)=>{if("draw"===e[0]){const s=e[1].split(" "),r=+s[0],a=+s[1],l=(t=>{let e=1;if(t&&t.getCTM){const s=t.getCTM();s&&(e=(G(s.a*s.a+s.b*s.b)+G(s.c*s.c+s.d*s.d))/2)}return e})(o),c=-1e3*r*l,d=a*i*l+c,u=i*l+(0===r&&1===a||1===r&&0===a?0:10*l)-d;if("butt"!==n){const e=r===a?"butt":n;h!==e&&(t.style.strokeLinecap=`${e}`,h=e)}t.setAttribute("stroke-dashoffset",`${c}`),t.setAttribute("stroke-dasharray",`${d} ${u}`)}return Reflect.apply(s,t,e)}:X(s)?(...e)=>Reflect.apply(s,t,e):s}});return"1000"!==t.getAttribute("pathLength")&&(t.setAttribute("pathLength","1000"),a.setAttribute("draw",`${e} ${s}`)),a})(t,e,s)))},zt=(t,e,s)=>(s<0&&(s+=1),s>1&&(s-=1),s<1/6?t+6*(e-t)*s:s<.5?e:s<2/3?t+(e-t)*(2/3-s)*6:t),It=(t,e)=>z(t)?e:t,Wt=(t,e,s,i,r)=>{if(X(t)){const n=()=>{const r=t(e,s,i);return isNaN(+r)?r||0:+r};return r&&(r.func=n),n()}return t},Vt=(t,e)=>t[o]?t[h]&&((t,e)=>{if(Yt.includes(e))return!1;if(t.getAttribute(e)||e in t){if("scale"===e){const e=t.parentNode;return e&&"filter"===e.tagName}return!0}})(t,e)?1:g.includes(e)||f.get(e)?3:F(e,"--")?4:e in t.style?2:e in t?0:1:0,Ht=(t,e,s)=>{const i=t.style[e];i&&s&&(s[e]=i);const r=i||getComputedStyle(t[c]||t).getPropertyValue(e);return"auto"===r?"0":r},Ut=(t,e,s,i)=>{const r=z(s)?Vt(t,e):s;return 0===r?t[e]||0:1===r?t.getAttribute(e):3===r?((t,e,s)=>{const i=t.style.transform;let r;if(i){const n=t[a];let o;for(;o=C.exec(i);){const t=o[1],i=o[2].slice(1,-1);n[t]=i,t===e&&(r=i,s&&(s[e]=i))}}return i&&!z(r)?r:F(e,"scale")?"1":F(e,"rotate")||F(e,"skew")?"0deg":"0px"})(t,e,i):4===r?Ht(t,e,i).trimStart():Ht(t,e,i)},qt=(t,e,s)=>"-"===s?t-e:"+"===s?t+e:t*e,Qt=(t,e)=>{if(e.t=0,e.n=0,e.u=null,e.o=null,e.d=null,e.s=null,!t)return e;const s=+t;if(isNaN(s)){let s=t;"="===s[1]&&(e.o=s[0],s=s.slice(2));const n=!s.includes(" ")&&k.exec(s);if(n)return e.t=1,e.n=+n[1],e.u=n[2],e;if(e.o)return e.n=+s,e;if(V(r=s)||H(r)||U(r))return e.t=2,e.d=H(i=s)?(t=>{const e=b.exec(t)||T.exec(t),s=z(e[4])?1:+e[4];return[+e[1],+e[2],+e[3],s]})(i):V(i)?(t=>{const e=t.length,s=4===e||5===e;return[+("0x"+t[1]+t[s?1:2]),+("0x"+t[s?2:3]+t[s?2:4]),+("0x"+t[s?3:5]+t[s?3:6]),5===e||9===e?+(+("0x"+t[s?4:7]+t[s?4:8])/255).toFixed(3):1]})(i):U(i)?(t=>{const e=w.exec(t)||S.exec(t),s=+e[1]/360,i=+e[2]/100,r=+e[3]/100,n=z(e[4])?1:+e[4];let o,h,a;if(0===i)o=h=a=r;else{const t=r<.5?r*(1+i):r+i-r*i,e=2*r-t;o=ct(255*zt(e,t,s+1/3),0),h=ct(255*zt(e,t,s),0),a=ct(255*zt(e,t,s-1/3),0)}return[o,h,a,n]})(i):[0,0,0,1],e;{const t=s.match(x);return e.t=3,e.d=t?t.map(Number):[],e.s=s.split(x)||[],e}}var i,r;return e.n=s,e},jt=(t,e)=>(e.t=t._valueType,e.n=t._toNumber,e.u=t._unit,e.o=null,e.d=_t(t._toNumbers),e.s=_t(t._strings),e),Gt={t:0,n:0,u:null,o:null,d:null,s:null},Zt={_rep:new WeakMap,_add:new Map},Jt=(t,e,s="_rep")=>{const i=Zt[s];let r=i.get(t);return r||(r={},i.set(t,r)),r[e]?r[e]:r[e]={_head:null,_tail:null}},Kt=(t,e)=>t._isOverridden||t._absoluteStartTime>e._absoluteStartTime,te=t=>{t._isOverlapped=1,t._isOverridden=1,t._changeDuration=d,t._currentTime=d},ee=(t,e)=>{const s=t._composition;if(s===r.replace){const s=t._absoluteStartTime;Tt(e,t,Kt,"_prevRep","_nextRep");const i=t._prevRep;if(i){const e=i.parent,r=i._absoluteStartTime+i._changeDuration;if(t.parent.id!==e.id&&e.iterationCount>1&&r+(e.duration-e.iterationDuration)>s){te(i);let t=i._prevRep;for(;t&&t.parent.id===e.id;)te(t),t=t._prevRep}const n=s-t._delay;if(r>n){const t=i._startTime,e=r-(t+i._updateDuration);i._changeDuration=n-e-t,i._currentTime=i._changeDuration,i._isOverlapped=1,i._changeDuration<d&&te(i)}let o=!0;if(vt(e,(t=>{t._isOverlapped||(o=!1)})),o){const t=e.parent;if(t){let s=!0;vt(t,(t=>{t!==e&&vt(t,(t=>{t._isOverlapped||(s=!1)}))})),s&&t.cancel()}else e.cancel()}}}else if(s===r.blend){const e=Jt(t.target,t.property,"_add"),s=(t=>{let e=$t.animation;return e||(e={duration:d,computeDeltaTime:y,_offset:0,_delay:0,_head:null,_tail:null},$t.animation=e,$t.update=()=>{t.forEach((t=>{for(let e in t){const s=t[e],i=s._head;if(i){const t=i._valueType,e=3===t||2===t?_t(i._fromNumbers):null;let r=i._fromNumber,n=s._tail;for(;n&&n!==i;){if(e)for(let t=0,s=n._numbers.length;t<s;t++)e[t]+=n._numbers[t];else r+=n._number;n=n._prevAdd}i._toNumber=r,i._toNumbers=e}}})),xt(e,1,1,0,2)}),e})(Zt._add);let i=e._head;i||(i={...t},i._composition=r.replace,i._updateDuration=d,i._startTime=0,i._numbers=_t(t._fromNumbers),i._number=0,i._next=null,i._prev=null,Tt(e,i),Tt(s,i));const n=t._toNumber;if(t._fromNumber=i._fromNumber-n,t._toNumber=0,t._numbers=_t(t._fromNumbers),t._number=0,i._fromNumber=n,t._toNumbers){const e=_t(t._toNumbers);e&&e.forEach(((e,s)=>{t._fromNumbers[s]=i._fromNumbers[s]-e,t._toNumbers[s]=0})),i._fromNumbers=e}Tt(e,t,null,"_prevAdd","_nextAdd")}return t},se=t=>{const e=t._composition;if(e!==r.none){const s=t.target,i=t.property,n=Zt._rep.get(s)[i];if(bt(n,t,"_prevRep","_nextRep"),e===r.blend){const e=Zt._add,r=e.get(s);if(!r)return;const n=r[i],o=$t.animation;bt(n,t,"_prevAdd","_nextAdd");const h=n._head;if(h&&h===n._tail){bt(n,h,"_prevAdd","_nextAdd"),bt(o,h);let t=!0;for(let e in r)if(r[e]._head){t=!1;break}t&&e.delete(s)}}}return t},ie=t=>(t.paused=!0,t.began=!1,t.completed=!1,t),re=t=>t._cancelled?(t._hasChildren?vt(t,re):vt(t,(t=>{t._composition!==r.none&&ee(t,Jt(t.target,t.property))})),t._cancelled=0,t):t;let ne=0;class oe extends St{constructor(t={},e=null,s=0){super(0);const{id:i,delay:r,duration:n,reversed:o,alternate:h,loop:a,loopDelay:l,autoplay:c,frameRate:u,playbackRate:p,onComplete:m,onLoop:f,onPause:g,onBegin:_,onBeforeUpdate:v,onUpdate:b}=t;D.current&&D.current.register(this);const T=e?0:Dt._elapsedTime,w=e?e.defaults:L.defaults,S=X(r)||z(r)?w.delay:+r,x=X(n)||z(n)?1/0:+n,k=It(a,w.loop),$=It(l,w.loopDelay),C=!0===k||k===1/0||k<0?1/0:k+1;let E=0;if(e)E=s;else{let t=O();Dt.paused&&(Dt.requestTick(t),t=Dt._elapsedTime),E=t-Dt._startTime}this.id=z(i)?++ne:i,this.parent=e,this.duration=ft((x+$)*C-$)||d,this.backwards=!1,this.paused=!0,this.began=!1,this.completed=!1,this.onBegin=_||w.onBegin,this.onBeforeUpdate=v||w.onBeforeUpdate,this.onUpdate=b||w.onUpdate,this.onLoop=f||w.onLoop,this.onPause=g||w.onPause,this.onComplete=m||w.onComplete,this.iterationDuration=x,this.iterationCount=C,this._autoplay=!e&&It(c,w.autoplay),this._offset=E,this._delay=S,this._loopDelay=$,this._iterationTime=0,this._currentIteration=0,this._resolve=y,this._running=!1,this._reversed=+It(o,w.reversed),this._reverse=this._reversed,this._cancelled=0,this._alternate=It(h,w.alternate),this._prev=null,this._next=null,this._elapsedTime=T,this._startTime=T,this._lastTime=T,this._fps=It(u,w.frameRate),this._speed=It(p,w.playbackRate)}get cancelled(){return!!this._cancelled}set cancelled(t){t?this.cancel():this.reset(1).play()}get currentTime(){return at(ct(this._currentTime,L.precision),-this._delay,this.duration)}set currentTime(t){const e=this.paused;this.pause().seek(+t),e||this.resume()}get iterationCurrentTime(){return ct(this._iterationTime,L.precision)}set iterationCurrentTime(t){this.currentTime=this.iterationDuration*this._currentIteration+t}get progress(){return at(ct(this._currentTime/this.duration,10),0,1)}set progress(t){this.currentTime=this.duration*t}get iterationProgress(){return at(ct(this._iterationTime/this.iterationDuration,10),0,1)}set iterationProgress(t){const e=this.iterationDuration;this.currentTime=e*this._currentIteration+e*t}get currentIteration(){return this._currentIteration}set currentIteration(t){this.currentTime=this.iterationDuration*at(+t,0,this.iterationCount-1)}get reversed(){return!!this._reversed}set reversed(t){t?this.reverse():this.play()}get speed(){return super.speed}set speed(t){super.speed=t,this.resetTime()}reset(t=0){return re(this),this._reversed&&!this._reverse&&(this.reversed=!1),this._iterationTime=this.iterationDuration,kt(this,0,1,t,2),ie(this),this._hasChildren&&vt(this,ie),this}init(t=0){this.fps=this._fps,this.speed=this._speed,!t&&this._hasChildren&&kt(this,this.duration,1,t,2),this.reset(t);const e=this._autoplay;return!0===e?this.resume():e&&!z(e.linked)&&e.link(this),this}resetTime(){const t=1/(this._speed*Dt._speed);return this._startTime=O()-(this._currentTime+this._delay)*t,this}pause(){return this.paused||(this.paused=!0,this.onPause(this)),this}resume(){return this.paused?(this.paused=!1,this.duration<=d&&!this._hasChildren?kt(this,d,0,0,2):(this._running||(Tt(Dt,this),Dt._hasChildren=!0,this._running=!0),this.resetTime(),this._startTime-=12,Dt.wake()),this):this}restart(){return this.reset(0).resume()}seek(t,e=0,s=0){re(this),this.completed=!1;const i=this.paused;return this.paused=!0,kt(this,t+this._delay,~~e,~~s,1),i?this:this.resume()}alternate(){const t=this._reversed,e=this.iterationCount,s=this.iterationDuration,i=e===1/0?st(u/s):e;return this._reversed=+(!this._alternate||i%2?!t:t),e===1/0?this.iterationProgress=this._reversed?1-this.iterationProgress:this.iterationProgress:this.seek(s*i-this._currentTime),this.resetTime(),this}play(){return this._reversed&&this.alternate(),this.resume()}reverse(){return this._reversed||this.alternate(),this.resume()}cancel(){return this._hasChildren?vt(this,(t=>t.cancel()),!0):vt(this,se),this._cancelled=1,this.pause()}stretch(t){const e=this.duration,s=gt(t);if(e===s)return this;const i=t/e,r=t<=d;return this.duration=r?d:s,this.iterationDuration=r?d:gt(this.iterationDuration*i),this._offset*=i,this._delay*=i,this._loopDelay*=i,this}revert(){kt(this,0,1,0,1);const t=this._autoplay;return t&&t.linked&&t.linked===this&&t.revert(),this.cancel()}complete(){return this.seek(this.duration).cancel()}then(t=y){const e=this.then,s=()=>{this.then=null,t(this),this.then=e,this._resolve=y};return new Promise((t=>(this._resolve=()=>t(s()),this.completed&&this._resolve(),this)))}}const he=t=>t,ae=(t,e,s)=>(((1-3*s+3*e)*t+(3*s-6*e))*t+3*e)*t,le=(t=.5,e=0,s=.5,i=1)=>t===e&&s===i?he:r=>0===r||1===r?r:ae(((t,e,s)=>{let i,r,n=0,o=1,h=0;do{r=n+(o-n)/2,i=ae(r,e,s)-t,i>0?o=r:n=r}while(K(i)>1e-7&&++h<100);return r})(r,t,s),e,i),ce=(t=10,e)=>{const s=e?et:st;return e=>s(at(e,0,1)*t)*(1/t)},de=(...t)=>{const e=t.length;if(!e)return he;const s=e-1,i=t[0],r=t[s],n=[0],o=[Q(i)];for(let e=1;e<s;e++){const i=t[e],r=Y(i)?i.trim().split(" "):[i],h=r[0],a=r[1];n.push(z(a)?e/s:Q(a)/100),o.push(Q(h))}return o.push(Q(r)),n.push(1),function(t){for(let e=1,s=n.length;e<s;e++){const s=n[e];if(t<=s){const i=n[e-1],r=o[e-1];return r+(o[e]-r)*(t-i)/(s-i)}}return o[o.length-1]}},ue=(t=10,e=1)=>{const s=[0],i=t-1;for(let t=1;t<i;t++){const r=s[t-1],n=t/i,o=n*(1-e)+(n+((t+1)/i-n)*Math.random())*e;s.push(at(o,r,1))}return s.push(1),de(...s)},pe=ot/2,me=2*ot,fe=(t=1.68)=>e=>j(e,+t),ge={[m]:fe,Quad:fe(2),Cubic:fe(3),Quart:fe(4),Quint:fe(5),Sine:t=>1-J(t*pe),Circ:t=>1-G(1-t*t),Expo:t=>t?j(2,10*t-10):0,Bounce:t=>{let e,s=4;for(;t<((e=j(2,--s))-1)/11;);return 1/j(4,3-s)-7.5625*j((3*e-2)/22-t,2)},Back:(t=1.70158)=>e=>(+t+1)*e*e*e-+t*e*e,Elastic:(t=1,e=.3)=>{const s=at(+t,1,10),i=at(+e,d,2),r=i/me*it(1/s),n=me/i;return t=>0===t||1===t?t:-s*j(2,-10*(1-t))*Z((1-t-r)*n)}},_e={in:t=>e=>t(e),out:t=>e=>1-t(1-e),inOut:t=>e=>e<.5?t(2*e)/2:1-t(-2*e+2)/2,outIn:t=>e=>e<.5?(1-t(1-2*e))/2:(t(2*e-1)+1)/2},ye=(t,e,s)=>{if(s[t])return s[t];if(t.indexOf("(")<=-1){const i=_e[t]||t.includes("Back")||t.includes("Elastic")?e[t]():e[t];return i?s[t]=i:he}{const i=t.slice(0,-1).split("("),r=e[i[0]];return r?s[t]=r(...i[1].split(",")):he}},ve=(()=>{const t={linear:de,irregular:ue,steps:ce,cubicBezier:le};for(let e in _e)for(let s in ge){const i=ge[s],r=_e[e];t[e+s]=s===m||"Back"===s||"Elastic"===s?(t,e)=>r(i(t,e)):r(i)}return t})(),be={linear:he},Te=t=>X(t)?t:Y(t)?ye(t,ve,be):he,we={},Se=(t,e,s)=>{if(3===s)return f.get(t)||t;if(2===s||1===s&&W(e)&&t in e.style){const e=we[t];if(e)return e;{const e=t?N(t):t;return we[t]=e,e}}return t},xe={deg:1,rad:180/ot,turn:360},ke={},$e=(t,e,s,r=!1)=>{const n=e.u,o=e.n;if(1===e.t&&n===s)return e;const h=o+n+s,a=ke[h];if(z(a)||r){let r;if(n in xe)r=o*xe[n]/xe[s];else{const e=100,h=t.cloneNode(),a=t.parentNode,l=a&&a!==i?a:i.body;l.appendChild(h);const c=h.style;c.width=e+n;const d=h.offsetWidth||e;c.width=e+s;const u=d/(h.offsetWidth||e);l.removeChild(h),r=u*o}e.n=r,ke[h]=r}else e.n=a;return e.t,e.u=s,e},Ce=t=>{if(t._hasChildren)vt(t,Ce,!0);else{const e=t;e.pause(),vt(e,(t=>{const s=t.property,i=t.target;if(i[o]){const r=i.style,n=e._inlineStyles[s];if(3===t._tweenType){const e=i[a];if(z(n)||n===m?delete e[s]:e[s]=n,t._renderTransforms)if(Object.keys(e).length){let t=m;for(let s in e)t+=_[s]+e[s]+") ";r.transform=t}else r.removeProperty("transform")}else z(n)||n===m?r.removeProperty(s):r[s]=n;e._tail===t&&e.targets.forEach((t=>{t.getAttribute&&t.getAttribute("style")===m&&t.removeAttribute("style")}))}}))}return t},Ee={t:0,n:0,u:null,o:null,d:null,s:null},Be={t:0,n:0,u:null,o:null,d:null,s:null},De={func:null},Le=[null],Ae=[null,null],Ne={to:null};let Fe,Oe,Pe=0;class Re extends oe{constructor(t,e,s,i,n=!1,o=0,h=0){super(e,s,i);const a=Ot(t),l=a.length,c=e.keyframes,u=c?yt(((t,e)=>{const s={};if(P(t)){const e=[].concat(...t.map((t=>Object.keys(t)))).filter(q);for(let i=0,r=e.length;i<r;i++){const r=e[i],n=t.map((t=>{const e={};for(let s in t){const i=t[s];q(s)?s===r&&(e.to=i):e[s]=i}return e}));s[r]=n}}else{const i=It(e.duration,L.defaults.duration),r=Object.keys(t).map((e=>({o:parseFloat(e)/100,p:t[e]}))).sort(((t,e)=>t.o-e.o));r.forEach((t=>{const e=t.o,r=t.p;for(let t in r)if(q(t)){let n=s[t];n||(n=s[t]=[]);const o=e*i;let h=n.length,a=n[h-1];const l={to:r[t]};let c=0;for(let t=0;t<h;t++)c+=n[t].duration;1===h&&(l.from=a.to),r.ease&&(l.ease=r.ease),l.duration=o-(h?c:0),n.push(l)}return t}));for(let t in s){const e=s[t];let i;for(let t=0,s=e.length;t<s;t++){const s=e[t],r=s.ease;s.ease=i||void 0,i=r}e[0].duration||e.shift()}}return s})(c,e),e):e,{delay:m,duration:f,ease:g,playbackEase:_,modifier:y,composition:v,onRender:b}=u,T=s?s.defaults:L.defaults,w=It(_,T.playbackEase),S=w?Te(w):null,x=!z(g)&&!z(g.ease),k=x?g.ease:It(g,S?"linear":T.ease),$=x?g.duration:It(f,T.duration),C=It(m,T.delay),E=y||T.modifier,B=z(v)&&l>=p?r.none:z(v)?T.composition:v,D={},A=this._offset+(s?s._offset:0);let N=NaN,F=NaN,O=0,Y=0;for(let t=0;t<l;t++){const e=a[t],i=o||t,c=h||l;let p=NaN,m=NaN;for(let t in u)if(q(t)){const o=Vt(e,t),h=Se(t,e,o);let a=u[t];const l=P(a);if(n&&!l&&(Ae[0]=a,Ae[1]=a,a=Ae),l){const t=a.length,e=!R(a[0]);2===t&&e?(Ne.to=a,Le[0]=Ne,Fe=Le):t>2&&e?(Fe=[],a.forEach(((t,e)=>{e?1===e?(Ae[1]=t,Fe.push(Ae)):Fe.push(t):Ae[0]=t}))):Fe=a}else Le[0]=a,Fe=Le;let f=null,g=null,_=NaN,y=0,v=0;for(let t=Fe.length;v<t;v++){const n=Fe[v];R(n)?Oe=n:(Ne.to=n,Oe=Ne),De.func=null;const a=Wt(Oe.to,e,i,c,De);let l;R(a)&&!z(a.to)?(Oe=a,l=a.to):l=a;const u=Wt(Oe.from,e,i,c),p=Oe.ease,m=!z(p)&&!z(p.ease),b=m?p.ease:p||k,T=m?p.duration:Wt(It(Oe.duration,t>1?Wt($,e,i,c)/t:$),e,i,c),w=Wt(It(Oe.delay,v?0:C),e,i,c),S=Wt(It(Oe.composition,B),e,i,c),x=M(S)?S:r[S],L=Oe.modifier||E,N=!z(u),F=!z(l),X=P(l),I=X||N&&F,W=g?y+w:w,V=A+W;Y||!N&&!X||(Y=1);let H=g;if(x!==r.none){f||(f=Jt(e,h));let t=f._head;for(;t&&!t._isOverridden&&t._absoluteStartTime<=V;)if(H=t,t=t._nextRep,t&&t._absoluteStartTime>=V)for(;t;)te(t),t=t._nextRep}if(I?(Qt(X?Wt(l[0],e,i,c):u,Ee),Qt(X?Wt(l[1],e,i,c,De):l,Be),0===Ee.t&&(H?1===H._valueType&&(Ee.t=1,Ee.u=H._unit):(Qt(Ut(e,h,o,D),Gt),1===Gt.t&&(Ee.t=1,Ee.u=Gt.u)))):(F?Qt(l,Be):g?jt(g,Be):Qt(s&&H&&H.parent.parent===s?H._value:Ut(e,h,o,D),Be),N?Qt(u,Ee):g?jt(g,Ee):Qt(s&&H&&H.parent.parent===s?H._value:Ut(e,h,o,D),Ee)),Ee.o&&(Ee.n=qt(H?H._toNumber:Qt(Ut(e,h,o,D),Gt).n,Ee.n,Ee.o)),Be.o&&(Be.n=qt(Ee.n,Be.n,Be.o)),Ee.t!==Be.t)if(3===Ee.t||3===Be.t){const t=3===Ee.t?Ee:Be,e=3===Ee.t?Be:Ee;e.t=3,e.s=_t(t.s),e.d=t.d.map((()=>e.n))}else if(1===Ee.t||1===Be.t){const t=1===Ee.t?Ee:Be,e=1===Ee.t?Be:Ee;e.t=1,e.u=t.u}else if(2===Ee.t||2===Be.t){const t=2===Ee.t?Ee:Be,e=2===Ee.t?Be:Ee;e.t=2,e.s=t.s,e.d=[0,0,0,1]}if(Ee.u!==Be.u){let t=Be.u?Ee:Be;t=$e(e,t,Be.u?Be.u:Ee.u,!1)}if(Be.d&&Ee.d&&Be.d.length!==Ee.d.length){const t=Ee.d.length>Be.d.length?Ee:Be,e=t===Ee?Be:Ee;e.d=t.d.map(((t,s)=>z(e.d[s])?0:e.d[s])),e.s=_t(t.s)}const U=ct(+T||d,12),q={parent:this,id:Pe++,property:h,target:e,_value:null,_func:De.func,_ease:Te(b),_fromNumbers:_t(Ee.d),_toNumbers:_t(Be.d),_strings:_t(Be.s),_fromNumber:Ee.n,_toNumber:Be.n,_numbers:_t(Ee.d),_number:Ee.n,_unit:Be.u,_modifier:L,_currentTime:0,_startTime:W,_delay:+w,_updateDuration:U,_changeDuration:U,_absoluteStartTime:V,_tweenType:o,_valueType:Be.t,_composition:x,_isOverlapped:0,_isOverridden:0,_renderTransforms:0,_prevRep:null,_nextRep:null,_prevAdd:null,_nextAdd:null,_prev:null,_next:null};x!==r.none&&ee(q,f),isNaN(_)&&(_=q._startTime),y=ct(W+U,12),g=q,O++,Tt(this,q)}(isNaN(F)||_<F)&&(F=_),(isNaN(N)||y>N)&&(N=y),3===o&&(p=O-v,m=O)}if(!isNaN(p)){let t=0;vt(this,(e=>{t>=p&&t<m&&(e._renderTransforms=1,e._composition===r.blend&&vt($t.animation,(t=>{t.id===e.id&&(t._renderTransforms=1)}))),t++}))}}l||console.warn("No target found. Make sure the element you're trying to animate is accessible before creating your animation."),F?(vt(this,(t=>{t._startTime-t._delay||(t._delay-=F),t._startTime-=F})),N-=F):F=0,N||(N=d,this.iterationCount=0),this.targets=a,this.duration=N===d?d:ft((N+this._loopDelay)*this.iterationCount-this._loopDelay)||d,this.onRender=b||T.onRender,this._ease=S,this._delay=F,this.iterationDuration=N,this._inlineStyles=D,!this._autoplay&&Y&&this.onRender(this)}stretch(t){const e=this.duration;if(e===gt(t))return this;const s=t/e;return vt(this,(t=>{t._updateDuration=gt(t._updateDuration*s),t._changeDuration=gt(t._changeDuration*s),t._currentTime*=s,t._startTime*=s,t._absoluteStartTime*=s})),super.stretch(t)}refresh(){return vt(this,(t=>{const e=t._func;if(e){const s=Ut(t.target,t.property,t._tweenType);Qt(s,Gt),Qt(e(),Be),t._fromNumbers=_t(Gt.d),t._fromNumber=Gt.n,t._toNumbers=_t(Be.d),t._strings=_t(Be.s),t._toNumber=Be.o?qt(Gt.n,Be.n,Be.o):Be.n}})),this}revert(){return super.revert(),Ce(this)}then(t){return super.then(t)}}const Me=(t,e=100)=>{const s=[];for(let i=0;i<=e;i++)s.push(t(i/e));return`linear(${s.join(", ")})`},Ye={in:"ease-in",out:"ease-out",inOut:"ease-in-out"},Xe=(()=>{const t={};for(let e in _e)t[e]=t=>_e[e](fe(t));return t})(),ze=t=>{let e=Ye[t];if(e)return e;if(e="linear",Y(t)){if(F(t,"linear")||F(t,"cubic-")||F(t,"steps")||F(t,"ease"))e=t;else if(F(t,"cubicB"))e=N(t);else{const s=ye(t,Xe,Ye);X(s)&&(e=s===he?"linear":Me(s))}Ye[t]=e}else if(X(t)){const s=Me(t);s&&(e=s)}else t.ease&&(e=Me(t.ease));return e},Ie=["x","y","z"],We=["perspective","width","height","margin","padding","top","right","bottom","left","borderWidth","fontSize","borderRadius",...Ie],Ve=(()=>[...Ie,...g.filter((t=>["X","Y","Z"].some((e=>t.endsWith(e)))))])();let He=null;const Ue={_head:null,_tail:null},qe=(t,e,s)=>{let i=Ue._head;for(;i;){const r=i._next,n=i.$el===t,o=!e||i.property===e,h=!s||i.parent===s;if(n&&o&&h){const t=i.animation;try{t.commitStyles()}catch{}t.cancel(),bt(Ue,i);const e=i.parent;e&&(e._completed++,e.animations.length===e._completed&&(e.completed=!0,e.muteCallbacks||(e.paused=!0,e.onComplete(e),e._resolve(e))))}i=r}},Qe=(t,e,s,i,r)=>{const n=e.animate(i,r),o=r.delay+ +r.duration*r.iterations;n.playbackRate=t._speed,t.paused&&n.pause(),t.duration<o&&(t.duration=o,t.controlAnimation=n),t.animations.push(n),qe(e,s),Tt(Ue,{parent:t,animation:n,$el:e,property:s,_next:null,_prev:null});const h=()=>{qe(e,s,t)};return n.onremove=h,n.onfinish=h,n},je=(t,e,s,i,r)=>{let n=Wt(e,s,i,r);return M(n)?We.includes(t)||F(t,"translate")?`${n}px`:F(t,"rotate")||F(t,"skew")?`${n}deg`:`${n}`:n},Ge=(t,e,s,i,r,n)=>{let o="0";const h=z(i)?getComputedStyle(t)[e]:je(e,i,t,r,n);return o=z(s)?P(i)?i.map((s=>je(e,s,t,r,n))):h:[je(e,s,t,r,n),h],o};class Ze{constructor(t,s){D.current&&D.current.register(this),I(He)&&(!e||!z(CSS)&&Object.hasOwnProperty.call(CSS,"registerProperty")?(g.forEach((t=>{const e=F(t,"skew"),s=F(t,"scale"),i=F(t,"rotate"),r=F(t,"translate"),n=i||e,o=n?"<angle>":s?"<number>":r?"<length-percentage>":"*";try{CSS.registerProperty({name:"--"+t,syntax:o,inherits:!1,initialValue:r?"0px":n?"0deg":s?"1":"0"})}catch{}})),He=!0):He=!1);const i=Ot(t),r=i.length;r||console.warn("No target found. Make sure the element you're trying to animate is accessible before creating your animation.");const n=It(s.ease,ze(L.defaults.ease)),o=n.ease&&n,h=It(s.autoplay,L.defaults.autoplay),l=!(!h||!h.link)&&h,c=s.alternate&&!0===s.alternate,d=s.reversed&&!0===s.reversed,u=It(s.loop,L.defaults.loop),v=!0===u||u===1/0?1/0:M(u)?u+1:1,b=c?d?"alternate-reverse":"alternate":d?"reverse":"normal",T=ze(n),w=1===L.timeScale?1:p;this.targets=i,this.animations=[],this.controlAnimation=null,this.onComplete=s.onComplete||y,this.duration=0,this.muteCallbacks=!1,this.completed=!1,this.paused=!h||!1!==l,this.reversed=d,this.autoplay=h,this._speed=It(s.playbackRate,L.defaults.playbackRate),this._resolve=y,this._completed=0,this._inlineStyles=i.map((t=>t.getAttribute("style"))),i.forEach(((t,e)=>{const i=t[a],h=Ve.some((t=>s.hasOwnProperty(t))),l=(o?o.duration:Wt(It(s.duration,L.defaults.duration),t,e,r))*w,c=Wt(It(s.delay,L.defaults.delay),t,e,r)*w,d=It(s.composition,"replace");for(let o in s){if(!q(o))continue;const a={},u={iterations:v,direction:b,fill:"forwards",easing:T,duration:l,delay:c,composite:d},p=s[o],m=!!h&&(g.includes(o)?o:f.get(o));let _;if(R(p)){const s=p,h=It(s.ease,n),f=h.ease&&h,g=s.to,y=s.from;if(u.duration=(f?f.duration:Wt(It(s.duration,l),t,e,r))*w,u.delay=Wt(It(s.delay,c),t,e,r)*w,u.composite=It(s.composition,d),u.easing=ze(h),_=Ge(t,o,y,g,e,r),m?(a[`--${m}`]=_,i[m]=_):a[o]=Ge(t,o,y,g,e,r),Qe(this,t,o,a,u),!z(y))if(m){const e=`--${m}`;t.style.setProperty(e,a[e][0])}else t.style[o]=a[o][0]}else _=P(p)?p.map((s=>je(o,s,t,e,r))):je(o,p,t,e,r),m?(a[`--${m}`]=_,i[m]=_):a[o]=_,Qe(this,t,o,a,u)}if(h){let e=m;for(let t in i)e+=`${_[t]}var(--${t})) `;t.style.transform=e}})),l&&this.autoplay.link(this)}forEach(t){const e=Y(t)?e=>e[t]():t;return this.animations.forEach(e),this}get speed(){return this._speed}set speed(t){this._speed=+t,this.forEach((e=>e.playbackRate=t))}get currentTime(){const t=this.controlAnimation,e=L.timeScale;return this.completed?this.duration:t?+t.currentTime*(1===e?1:e):0}set currentTime(t){const e=t*(1===L.timeScale?1:p);this.forEach((t=>{e>=this.duration&&t.play(),t.currentTime=e}))}get progress(){return this.currentTime/this.duration}set progress(t){this.forEach((e=>e.currentTime=t*this.duration||0))}resume(){return this.paused?(this.paused=!1,this.forEach("play")):this}pause(){return this.paused?this:(this.paused=!0,this.forEach("pause"))}alternate(){return this.reversed=!this.reversed,this.forEach("reverse"),this.paused&&this.forEach("pause"),this}play(){return this.reversed&&this.alternate(),this.resume()}reverse(){return this.reversed||this.alternate(),this.resume()}seek(t,e=!1){return e&&(this.muteCallbacks=!0),t<this.duration&&(this.completed=!1),this.currentTime=t,this.muteCallbacks=!1,this.paused&&this.pause(),this}restart(){return this.completed=!1,this.seek(0,!0).resume()}commitStyles(){return this.forEach("commitStyles")}complete(){return this.seek(this.duration)}cancel(){return this.forEach("cancel"),this.pause()}revert(){return this.cancel(),this.targets.forEach(((t,e)=>t.setAttribute("style",this._inlineStyles[e]))),this}then(t=y){const e=this.then,s=()=>{this.then=null,t(this),this.then=e,this._resolve=y};return new Promise((t=>(this._resolve=()=>t(s()),this.completed&&this._resolve(),this)))}}const Je={animate:(t,e)=>new Ze(t,e),convertEase:Me},Ke=(t=y)=>new oe({duration:1*L.timeScale,onComplete:t},null,0).resume();function ts(t,e,s){const i=Ot(t);if(!i.length)return;const[r]=i,n=Vt(r,e),o=Se(e,r,n);let h=Ut(r,o);if(z(s))return h;if(Qt(h,Gt),0===Gt.t||1===Gt.t){if(!1===s)return Gt.n;{const t=$e(r,Gt,s,!1);return`${ct(t.n,L.precision)}${t.u}`}}}const es=(t,e)=>{if(!z(e))return e.duration=d,e.composition=It(e.composition,r.none),new Re(t,e,null,0,!0).resume()},ss=(t,e,s)=>{let i=!1;return vt(e,(r=>{const n=r.target;if(t.includes(n)){const t=r.property,o=r._tweenType,h=Se(s,n,o);(!h||h&&h===t)&&(r.parent._tail===r&&3===r._tweenType&&r._prev&&3===r._prev._tweenType&&(r._prev._renderTransforms=1),bt(e,r),se(r),i=!0)}}),!0),i},is=(t,e,s)=>{const i=Ft(t),r=e||Dt,n=e&&e.controlAnimation&&e;for(let t=0,e=i.length;t<e;t++){const e=i[t];qe(e,s,n)}let o;if(r._hasChildren){let e=0;vt(r,(n=>{if(!n._hasChildren)if(o=ss(i,n,s),o&&!n._head)n.cancel(),bt(r,n);else{const t=n._offset+n._delay+n.duration;t>e&&(e=t)}n._head?is(t,n,s):n._hasChildren=!1}),!0),z(r.iterationDuration)||(r.iterationDuration=e)}else o=ss(i,r,s);return o&&!r._head&&(r._hasChildren=!1,r.cancel&&r.cancel()),i},rs=(t,e,s,i,r)=>i+(t-e)/(s-e)*(r-i),ns=(t,e,s,i)=>{let r=p/L.defaults.frameRate;if(!1!==i){const t=i||Dt._hasChildren&&Dt;t&&t.deltaTime&&(r=t.deltaTime)}const n=1-Math.exp(-s*r*.1);return s?1===s?e:(1-n)*t+n*e:t},os=t=>(...e)=>{const s=t(...e);return new Proxy(y,{apply:(t,e,[i])=>s(i),get:(t,e)=>os(((...t)=>{const i=as[e](...t);return t=>i(s(t))}))})},hs=(t,e=0)=>(...s)=>(s.length<t.length?os(((t,e=0)=>(...s)=>e?e=>t(...s,e):e=>t(e,...s))(t,e)):t)(...s),as={$:Ot,get:ts,set:es,remove:is,cleanInlineStyles:Ce,random:pt,randomPick:t=>t[pt(0,t.length-1)],shuffle:mt,lerp:ns,sync:Ke,keepTime:wt,clamp:hs(at),round:hs(ct),snap:hs(dt),wrap:hs(((t,e,s)=>((t-e)%(s-e)+(s-e))%(s-e)+e)),interpolate:hs(ut,1),mapRange:hs(rs),roundPad:hs(((t,e)=>(+t).toFixed(e))),padStart:hs(((t,e,s)=>`${t}`.padStart(e,s))),padEnd:hs(((t,e,s)=>`${t}`.padEnd(e,s))),degToRad:hs((t=>t*ot/180)),radToDeg:hs((t=>180*t/ot))},ls=(t,e)=>{let s=t.iterationDuration;if(s===d&&(s=0),z(e))return s;if(M(+e))return+e;const i=e,r=t?t.labels:null,n=!I(r),o=((t,e)=>{if(F(e,"<")){const s="<"===e[1],i=t._tail,r=i?i._offset+i._delay:0;return s?r:r+i.duration}})(t,i),h=!z(o),a=E.exec(i);if(a){const t=a[0],e=i.split(t),l=n&&e[0]?r[e[0]]:s,c=h?o:n?l:s,d=+e[1];return qt(c,d,t[0])}return h?o:n?z(r[i])?s:r[i]:s};function cs(t,e,s,i,r,n){const o=M(t.duration)&&t.duration<=d?s-d:s;kt(e,o,1,1,1);const h=i?new Re(i,t,e,o,!1,r,n):new oe(t,e,o);return h.init(1),Tt(e,h),vt(e,(t=>{const s=t._offset+t._delay+t.duration;s>e.iterationDuration&&(e.iterationDuration=s)})),e.duration=function(t){return ft((t.iterationDuration+t._loopDelay)*t.iterationCount-t._loopDelay)||d}(e),e}class ds extends oe{constructor(t={}){super(t,null,0),this.duration=0,this.labels={};const e=t.defaults,s=L.defaults;this.defaults=e?yt(e,s):s,this.onRender=t.onRender||s.onRender;const i=It(t.playbackEase,s.playbackEase);this._ease=i?Te(i):null,this.iterationDuration=0}add(t,e,s){const i=R(e),r=R(t);if(i||r){if(this._hasChildren=!0,i){const i=e;if(X(s)){const e=s,r=Ft(t),n=this.duration,o=this.iterationDuration,h=i.id;let a=0;const l=r.length;r.forEach((t=>{const s={...i};this.duration=n,this.iterationDuration=o,z(h)||(s.id=h+"-"+a),cs(s,this,e(t,a,l,this),t,a,l),a++}))}else cs(i,this,ls(this,s),t)}else cs(t,this,ls(this,e));return this.init(1)}}sync(t,e){if(z(t)||t&&z(t.pause))return this;t.pause();const s=+(t.effect?t.effect.getTiming().duration:t.duration);return this.add(t,{currentTime:[0,s],duration:s,ease:"linear"},e)}set(t,e,s){return z(e)?this:(e.duration=d,e.composition=r.replace,this.add(t,e,s))}call(t,e){return z(t)||t&&!X(t)?this:this.add({duration:0,onComplete:()=>t(this)},e)}label(t,e){return z(t)||t&&!Y(t)||(this.labels[t]=ls(this,e)),this}remove(t,e){return is(t,this,e),this}stretch(t){const e=this.duration;if(e===gt(t))return this;const s=t/e,i=this.labels;vt(this,(t=>t.stretch(t.duration*s)));for(let t in i)i[t]*=s;return super.stretch(t)}refresh(){return vt(this,(t=>{t.refresh&&t.refresh()})),this}revert(){return super.revert(),vt(this,(t=>t.revert),!0),Ce(this)}then(t){return super.then(t)}}class us{constructor(t,e){D.current&&D.current.register(this);const s={},i={};if(this.targets=[],this.animations={},!z(t)&&!z(e)){for(let t in e){const r=e[t];q(t)?i[t]=r:s[t]=r}for(let e in i){const n=i[e],o=R(n);let h={},a="+=0";if(o){const t=n.unit;Y(t)&&(a+=t)}else h.duration=n;h[e]=o?yt({to:a},n):a;const l=yt(s,h);l.composition=r.replace,l.autoplay=!1;const c=this.animations[e]=new Re(t,l,null,0,!1).init();this.targets.length||this.targets.push(...c.targets),this[e]=(t,e,s)=>{const i=c._head;if(z(t)&&i){const t=i._numbers;return t&&t.length?t:i._modifier(i._number)}return vt(c,(e=>{if(P(t))for(let s=0,i=t.length;s<i;s++)z(e._numbers[s])||(e._fromNumbers[s]=e._modifier(e._numbers[s]),e._toNumbers[s]=t[s]);else e._fromNumber=e._modifier(e._number),e._toNumber=t;z(s)||(e._ease=Te(s)),e._currentTime=0})),z(e)||c.stretch(e),c.reset(1).resume(),this}}}}revert(){for(let t in this.animations)this[t]=y,this.animations[t].revert();return this.animations={},this.targets.length=0,this}}class ps{constructor(t={}){this.timeStep=.02,this.restThreshold=5e-4,this.restDuration=200,this.maxDuration=6e4,this.maxRestSteps=this.restDuration/this.timeStep/p,this.maxIterations=this.maxDuration/this.timeStep/p,this.m=at(It(t.mass,1),0,p),this.s=at(It(t.stiffness,100),1,p),this.d=at(It(t.damping,10),.1,p),this.v=at(It(t.velocity,0),-1e3,p),this.w0=0,this.zeta=0,this.wd=0,this.b=0,this.solverDuration=0,this.duration=0,this.compute(),this.ease=t=>0===t||1===t?t:this.solve(t*this.solverDuration)}solve(t){const{zeta:e,w0:s,wd:i,b:r}=this;let n=t;return n=e<1?tt(-n*e*s)*(1*J(i*n)+r*Z(i*n)):(1+r*n)*tt(-n*s),1-n}compute(){const{maxRestSteps:t,maxIterations:e,restThreshold:s,timeStep:i,m:r,d:n,s:o,v:h}=this,a=this.w0=at(G(o/r),d,p),l=this.zeta=n/(2*G(o*r)),c=this.wd=l<1?a*G(1-l*l):0;this.b=l<1?(l*a-h)/c:-h+a;let u=0,m=0,f=0;for(;m<t&&f<e;)K(1-this.solve(u))<s?m++:m=0,this.solverDuration=u,u+=i,f++;this.duration=ct(this.solverDuration*p,0)*L.timeScale}get mass(){return this.m}set mass(t){this.m=at(It(t,1),0,p),this.compute()}get stiffness(){return this.s}set stiffness(t){this.s=at(It(t,100),1,p),this.compute()}get damping(){return this.d}set damping(t){this.d=at(It(t,10),.1,p),this.compute()}get velocity(){return this.v}set velocity(t){this.v=at(It(t,0),-1e3,p),this.compute()}}const ms=t=>new ps(t),fs=t=>{t.cancelable&&t.preventDefault()};class gs{constructor(t){this.el=t,this.zIndex=0,this.parentElement=null,this.classList={add:y,remove:y}}get x(){return this.el.x||0}set x(t){this.el.x=t}get y(){return this.el.y||0}set y(t){this.el.y=t}get width(){return this.el.width||0}set width(t){this.el.width=t}get height(){return this.el.height||0}set height(t){this.el.height=t}getBoundingClientRect(){return{top:this.y,right:this.x,bottom:this.y+this.height,left:this.x+this.width}}}class _s{constructor(t){this.$el=t,this.inlineTransforms=[],this.point=new DOMPoint,this.inversedMatrix=this.getMatrix().inverse()}normalizePoint(t,e){return this.point.x=t,this.point.y=e,this.point.matrixTransform(this.inversedMatrix)}traverseUp(t){let e=this.$el.parentElement,s=0;for(;e&&e!==i;)t(e,s),e=e.parentElement,s++}getMatrix(){const t=new DOMMatrix;return this.traverseUp((e=>{const s=getComputedStyle(e).transform;if(s){const e=new DOMMatrix(s);t.preMultiplySelf(e)}})),t}remove(){this.traverseUp(((t,e)=>{this.inlineTransforms[e]=t.style.transform,t.style.transform="none"}))}revert(){this.traverseUp(((t,e)=>{const s=this.inlineTransforms[e];""===s?t.style.removeProperty("transform"):t.style.transform=s}))}}const ys=(t,e)=>t&&X(t)?t(e):t;let vs=0;class bs{constructor(t,e={}){if(!t)return;D.current&&D.current.register(this);const r=e.x,n=e.y,o=e.trigger,h=e.modifier,a=e.releaseEase,l=a&&Te(a),c=!z(a)&&!z(a.ease),d=R(r)&&!z(r.mapTo)?r.mapTo:"translateX",p=R(n)&&!z(n.mapTo)?n.mapTo:"translateY",m=ys(e.container,this);this.containerArray=P(m)?m:null,this.$container=m&&!this.containerArray?Ft(m)[0]:i.body,this.useWin=this.$container===i.body,this.$scrollContainer=this.useWin?s:this.$container,this.$target=R(t)?new gs(t):Ft(t)[0],this.$trigger=Ft(o||t)[0],this.fixed="fixed"===ts(this.$target,"position"),this.isFinePointer=!0,this.containerPadding=[0,0,0,0],this.containerFriction=0,this.releaseContainerFriction=0,this.snapX=0,this.snapY=0,this.scrollSpeed=0,this.scrollThreshold=0,this.dragSpeed=0,this.maxVelocity=0,this.minVelocity=0,this.velocityMultiplier=0,this.cursor=!1,this.releaseXSpring=c?a:ms({mass:It(e.releaseMass,1),stiffness:It(e.releaseStiffness,80),damping:It(e.releaseDamping,20)}),this.releaseYSpring=c?a:ms({mass:It(e.releaseMass,1),stiffness:It(e.releaseStiffness,80),damping:It(e.releaseDamping,20)}),this.releaseEase=l||ve.outQuint,this.hasReleaseSpring=c,this.onGrab=e.onGrab||y,this.onDrag=e.onDrag||y,this.onRelease=e.onRelease||y,this.onUpdate=e.onUpdate||y,this.onSettle=e.onSettle||y,this.onSnap=e.onSnap||y,this.onResize=e.onResize||y,this.onAfterResize=e.onAfterResize||y,this.disabled=[0,0];const f={};if(h&&(f.modifier=h),z(r)||!0===r)f[d]=0;else if(R(r)){const t=r,e={};t.modifier&&(e.modifier=t.modifier),t.composition&&(e.composition=t.composition),f[d]=e}else!1===r&&(f[d]=0,this.disabled[0]=1);if(z(n)||!0===n)f[p]=0;else if(R(n)){const t=n,e={};t.modifier&&(e.modifier=t.modifier),t.composition&&(e.composition=t.composition),f[p]=e}else!1===n&&(f[p]=0,this.disabled[1]=1);this.animate=new us(this.$target,f),this.xProp=d,this.yProp=p,this.destX=0,this.destY=0,this.deltaX=0,this.deltaY=0,this.scroll={x:0,y:0},this.coords=[this.x,this.y,0,0],this.snapped=[0,0],this.pointer=[0,0,0,0,0,0,0,0],this.scrollView=[0,0],this.dragArea=[0,0,0,0],this.containerBounds=[-1e12,u,u,-1e12],this.scrollBounds=[0,0,0,0],this.targetBounds=[0,0,0,0],this.window=[0,0],this.velocityStack=[0,0,0],this.velocityStackIndex=0,this.velocityTime=O(),this.velocity=0,this.angle=0,this.cursorStyles=null,this.triggerStyles=null,this.bodyStyles=null,this.targetStyles=null,this.touchActionStyles=null,this.transforms=new _s(this.$target),this.overshootCoords={x:0,y:0},this.overshootXTicker=new oe({autoplay:!1},null,0).init(),this.overshootYTicker=new oe({autoplay:!1},null,0).init(),this.updateTicker=new oe({autoplay:!1},null,0).init(),this.overshootXTicker.onUpdate=()=>{this.disabled[0]||(this.updated=!0,this.manual=!0,this.animate[this.xProp](this.overshootCoords.x,0))},this.overshootXTicker.onComplete=()=>{this.disabled[0]||(this.manual=!1,this.animate[this.xProp](this.overshootCoords.x,0))},this.overshootYTicker.onUpdate=()=>{this.disabled[1]||(this.updated=!0,this.manual=!0,this.animate[this.yProp](this.overshootCoords.y,0))},this.overshootYTicker.onComplete=()=>{this.disabled[1]||(this.manual=!1,this.animate[this.yProp](this.overshootCoords.y,0))},this.updateTicker.onUpdate=()=>this.update(),this.contained=!z(m),this.manual=!1,this.grabbed=!1,this.dragged=!1,this.updated=!1,this.released=!1,this.canScroll=!1,this.enabled=!1,this.initialized=!1,this.activeProp=this.disabled[1]?d:p,this.animate.animations[this.activeProp].onRender=()=>{const t=this.updated,e=!(this.grabbed&&t)&&this.released,s=this.x,i=this.y,r=s-this.coords[2],n=i-this.coords[3];this.deltaX=r,this.deltaY=n,this.coords[2]=s,this.coords[3]=i,t&&(r||n)&&this.onUpdate(this),e?(this.computeVelocity(r,n),this.angle=nt(n,r)):this.updated=!1},this.animate.animations[this.activeProp].onComplete=()=>{!this.grabbed&&this.released&&(this.released=!1),this.manual||(this.deltaX=0,this.deltaY=0,this.velocity=0,this.velocityStack[0]=0,this.velocityStack[1]=0,this.velocityStack[2]=0,this.velocityStackIndex=0,this.onSettle(this))},this.resizeTicker=new oe({autoplay:!1,duration:150*L.timeScale,onComplete:()=>{this.onResize(this),this.refresh(),this.onAfterResize(this)}}).init(),this.parameters=e,this.resizeObserver=new ResizeObserver((()=>{this.initialized?this.resizeTicker.restart():this.initialized=!0})),this.enable(),this.refresh(),this.resizeObserver.observe(this.$container),R(t)||this.resizeObserver.observe(this.$target)}computeVelocity(t,e){const s=this.velocityTime,i=O(),r=i-s;if(r<17)return this.velocity;this.velocityTime=i;const n=this.velocityStack,o=this.velocityMultiplier,h=this.minVelocity,a=this.maxVelocity,l=this.velocityStackIndex;n[l]=ct(at(G(t*t+e*e)/r*o,h,a),5);const c=rt(n[0],n[1],n[2]);return this.velocity=c,this.velocityStackIndex=(l+1)%3,c}setX(t,e=!1){if(this.disabled[0])return;const s=ct(t,5);return this.overshootXTicker.pause(),this.manual=!0,this.updated=!e,this.destX=s,this.snapped[0]=dt(s,this.snapX),this.animate[this.xProp](s,0),this.manual=!1,this}setY(t,e=!1){if(this.disabled[1])return;const s=ct(t,5);return this.overshootYTicker.pause(),this.manual=!0,this.updated=!e,this.destY=s,this.snapped[1]=dt(s,this.snapY),this.animate[this.yProp](s,0),this.manual=!1,this}get x(){return ct(this.animate[this.xProp](),L.precision)}set x(t){this.setX(t,!1)}get y(){return ct(this.animate[this.yProp](),L.precision)}set y(t){this.setY(t,!1)}get progressX(){return rs(this.x,this.containerBounds[3],this.containerBounds[1],0,1)}set progressX(t){this.setX(rs(t,0,1,this.containerBounds[3],this.containerBounds[1]),!1)}get progressY(){return rs(this.y,this.containerBounds[0],this.containerBounds[2],0,1)}set progressY(t){this.setY(rs(t,0,1,this.containerBounds[0],this.containerBounds[2]),!1)}updateScrollCoords(){const t=ct(this.useWin?s.scrollX:this.$container.scrollLeft,0),e=ct(this.useWin?s.scrollY:this.$container.scrollTop,0),[i,r,n,o]=this.containerPadding,h=this.scrollThreshold;this.scroll.x=t,this.scroll.y=e,this.scrollBounds[0]=e-this.targetBounds[0]+i-h,this.scrollBounds[1]=t-this.targetBounds[1]-r+h,this.scrollBounds[2]=e-this.targetBounds[2]-n+h,this.scrollBounds[3]=t-this.targetBounds[3]+o-h}updateBoundingValues(){const t=this.$container,e=this.x,r=this.y,n=this.coords[2],o=this.coords[3];this.coords[2]=0,this.coords[3]=0,this.setX(0,!0),this.setY(0,!0),this.transforms.remove();const h=this.window[0]=s.innerWidth,a=this.window[1]=s.innerHeight,l=this.useWin,c=t.scrollWidth,d=t.scrollHeight,u=this.fixed,p=t.getBoundingClientRect(),[m,f,g,_]=this.containerPadding;this.dragArea[0]=l?0:p.left,this.dragArea[1]=l?0:p.top,this.scrollView[0]=l?at(c,h,c):c,this.scrollView[1]=l?at(d,a,d):d,this.updateScrollCoords();const{width:y,height:v,left:b,top:T,right:w,bottom:S}=t.getBoundingClientRect();this.dragArea[2]=ct(l?at(y,h,h):y,0),this.dragArea[3]=ct(l?at(v,a,a):v,0);const x=ts(t,"overflow"),k="visible"===x,$="hidden"===x;if(this.canScroll=!u&&this.contained&&(t===i.body&&k||!$&&!k)&&(c>this.dragArea[2]+_-f||d>this.dragArea[3]+m-g)&&(!this.containerArray||this.containerArray&&!P(this.containerArray)),this.contained){const e=this.scroll.x,s=this.scroll.y,i=this.canScroll,r=this.$target.getBoundingClientRect(),n=i?l?0:t.scrollLeft:0,o=i?l?0:t.scrollTop:0,c=i?this.scrollView[0]-n-y:0,d=i?this.scrollView[1]-o-v:0;this.targetBounds[0]=ct(r.top+s-(l?0:T),0),this.targetBounds[1]=ct(r.right+e-(l?h:w),0),this.targetBounds[2]=ct(r.bottom+s-(l?a:S),0),this.targetBounds[3]=ct(r.left+e-(l?0:b),0),this.containerArray?(this.containerBounds[0]=this.containerArray[0]+m,this.containerBounds[1]=this.containerArray[1]-f,this.containerBounds[2]=this.containerArray[2]-g,this.containerBounds[3]=this.containerArray[3]+_):(this.containerBounds[0]=-ct(r.top-(u?at(T,0,a):T)+o-m,0),this.containerBounds[1]=-ct(r.right-(u?at(w,0,h):w)-c+f,0),this.containerBounds[2]=-ct(r.bottom-(u?at(S,0,a):S)-d+g,0),this.containerBounds[3]=-ct(r.left-(u?at(b,0,h):b)+n-_,0))}this.transforms.revert(),this.coords[2]=n,this.coords[3]=o,this.setX(e,!0),this.setY(r,!0)}isOutOfBounds(t,e,s){if(!this.contained)return 0;const[i,r,n,o]=t,[h,a]=this.disabled,l=!h&&e<o||!h&&e>r,c=!a&&s<i||!a&&s>n;return l&&!c?1:!l&&c?2:l&&c?3:0}refresh(){const t=this.parameters,e=t.x,r=t.y,n=ys(t.container,this),o=ys(t.containerPadding,this)||0,h=P(o)?o:[o,o,o,o],a=this.x,l=this.y,c=ys(t.cursor,this),d={onHover:"grab",onGrab:"grabbing"};if(c){const{onHover:t,onGrab:e}=c;t&&(d.onHover=t),e&&(d.onGrab=e)}this.containerArray=P(n)?n:null,this.$container=n&&!this.containerArray?Ft(n)[0]:i.body,this.useWin=this.$container===i.body,this.$scrollContainer=this.useWin?s:this.$container,this.isFinePointer=matchMedia("(pointer:fine)").matches,this.containerPadding=It(h,[0,0,0,0]),this.containerFriction=at(It(ys(t.containerFriction,this),.8),0,1),this.releaseContainerFriction=at(It(ys(t.releaseContainerFriction,this),this.containerFriction),0,1),this.snapX=ys(R(e)&&!z(e.snap)?e.snap:t.snap,this),this.snapY=ys(R(r)&&!z(r.snap)?r.snap:t.snap,this),this.scrollSpeed=It(ys(t.scrollSpeed,this),1.5),this.scrollThreshold=It(ys(t.scrollThreshold,this),20),this.dragSpeed=It(ys(t.dragSpeed,this),1),this.minVelocity=It(ys(t.minVelocity,this),0),this.maxVelocity=It(ys(t.maxVelocity,this),50),this.velocityMultiplier=It(ys(t.velocityMultiplier,this),1),this.cursor=!1!==c&&d,this.updateBoundingValues();const[u,p,m,f]=this.containerBounds;this.setX(at(a,f,p),!0),this.setY(at(l,u,m),!0)}update(){if(this.updateScrollCoords(),this.canScroll){const[t,e,s,i]=this.containerPadding,[r,n]=this.scrollView,o=this.dragArea[2],h=this.dragArea[3],a=this.scroll.x,l=this.scroll.y,c=this.$container.scrollWidth,d=this.$container.scrollHeight,u=this.useWin?at(c,this.window[0],c):c,p=this.useWin?at(d,this.window[1],d):d,m=r-u,f=n-p;this.dragged&&m>0&&(this.coords[0]-=m,this.scrollView[0]=u),this.dragged&&f>0&&(this.coords[1]-=f,this.scrollView[1]=p);const g=10*this.scrollSpeed,_=this.scrollThreshold,[y,v]=this.coords,[b,T,w,S]=this.scrollBounds,x=ct(at((v-b+t)/_,-1,0)*g,0),k=ct(at((y-T-e)/_,0,1)*g,0),$=ct(at((v-w-s)/_,0,1)*g,0),C=ct(at((y-S+i)/_,-1,0)*g,0);if(x||$||C||k){const[t,e]=this.disabled;let s=a,i=l;t||(s=ct(at(a+(C||k),0,r-o),0),this.coords[0]-=a-s),e||(i=ct(at(l+(x||$),0,n-h),0),this.coords[1]-=l-i),this.useWin?this.$scrollContainer.scrollBy(-(a-s),-(l-i)):this.$scrollContainer.scrollTo(s,i)}}const[t,e,s,i]=this.containerBounds,[r,n,o,h,a,l]=this.pointer;this.coords[0]+=(r-a)*this.dragSpeed,this.coords[1]+=(n-l)*this.dragSpeed,this.pointer[4]=r,this.pointer[5]=n;const[c,d]=this.coords,[u,p]=this.snapped,m=(1-this.containerFriction)*this.dragSpeed;this.setX(c>e?e+(c-e)*m:c<i?i+(c-i)*m:c,!1),this.setY(d>s?s+(d-s)*m:d<t?t+(d-t)*m:d,!1),this.computeVelocity(r-a,n-l),this.angle=nt(n-h,r-o);const[f,g]=this.snapped;(f!==u&&this.snapX||g!==p&&this.snapY)&&this.onSnap(this)}stop(){this.updateTicker.pause(),this.overshootXTicker.pause(),this.overshootYTicker.pause();for(let t in this.animate.animations)this.animate.animations[t].pause();return is(this,null,"x"),is(this,null,"y"),is(this,null,"progressX"),is(this,null,"progressY"),is(this.scroll),is(this.overshootCoords),this}scrollInView(t,e=0,s=ve.inOutQuad){this.updateScrollCoords();const i=this.destX,r=this.destY,n=this.scroll,o=this.scrollBounds,h=this.canScroll;if(!this.containerArray&&this.isOutOfBounds(o,i,r)){const[a,l,c,d]=o,p=ct(at(r-a,-1e12,0),0),m=ct(at(i-l,0,u),0),f=ct(at(r-c,0,u),0),g=ct(at(i-d,-1e12,0),0);new Re(n,{x:ct(n.x+(g?g-e:m?m+e:0),0),y:ct(n.y+(p?p-e:f?f+e:0),0),duration:z(t)?350*L.timeScale:t,ease:s,onUpdate:()=>{this.canScroll=!1,this.$scrollContainer.scrollTo(n.x,n.y)}}).init().then((()=>{this.canScroll=h}))}return this}handleHover(){this.isFinePointer&&this.cursor&&!this.cursorStyles&&(this.cursorStyles=es(this.$trigger,{cursor:this.cursor.onHover}))}animateInView(t,e=0,s=ve.inOutQuad){this.stop(),this.updateBoundingValues();const i=this.x,r=this.y,[n,o,h,a]=this.containerPadding,l=this.scroll.y-this.targetBounds[0]+n+e,c=this.scroll.x-this.targetBounds[1]-o-e,d=this.scroll.y-this.targetBounds[2]-h-e,u=this.scroll.x-this.targetBounds[3]+a+e,p=this.isOutOfBounds([l,c,d,u],i,r);if(p){const[e,n]=this.disabled,o=at(dt(i,this.snapX),u,c),h=at(dt(r,this.snapY),l,d),a=z(t)?350*L.timeScale:t;e||1!==p&&3!==p||this.animate[this.xProp](o,a,s),n||2!==p&&3!==p||this.animate[this.yProp](h,a,s)}return this}handleDown(t){const e=t.target;if(this.grabbed||"range"===e.type)return;t.stopPropagation(),this.grabbed=!0,this.released=!1,this.stop(),this.updateBoundingValues();const s=t.changedTouches,r=s?s[0].clientX:t.clientX,n=s?s[0].clientY:t.clientY,{x:o,y:h}=this.transforms.normalizePoint(r,n),[a,l,c,d]=this.containerBounds,u=(1-this.containerFriction)*this.dragSpeed,p=this.x,m=this.y;this.coords[0]=this.coords[2]=u?p>l?l+(p-l)/u:p<d?d+(p-d)/u:p:p,this.coords[1]=this.coords[3]=u?m>c?c+(m-c)/u:m<a?a+(m-a)/u:m:m,this.pointer[0]=o,this.pointer[1]=h,this.pointer[2]=o,this.pointer[3]=h,this.pointer[4]=o,this.pointer[5]=h,this.pointer[6]=o,this.pointer[7]=h,this.deltaX=0,this.deltaY=0,this.velocity=0,this.velocityStack[0]=0,this.velocityStack[1]=0,this.velocityStack[2]=0,this.velocityStackIndex=0,this.angle=0,this.targetStyles&&(this.targetStyles.revert(),this.targetStyles=null);const f=ts(this.$target,"zIndex",!1);vs=(f>vs?f:vs)+1,this.targetStyles=es(this.$target,{zIndex:vs}),this.triggerStyles&&(this.triggerStyles.revert(),this.triggerStyles=null),this.cursorStyles&&(this.cursorStyles.revert(),this.cursorStyles=null),this.isFinePointer&&this.cursor&&(this.bodyStyles=es(i.body,{cursor:this.cursor.onGrab})),this.scrollInView(100,0,ve.out(3)),this.onGrab(this),i.addEventListener("touchmove",this),i.addEventListener("touchend",this),i.addEventListener("touchcancel",this),i.addEventListener("mousemove",this),i.addEventListener("mouseup",this),i.addEventListener("selectstart",this)}handleMove(t){if(!this.grabbed)return;const e=t.changedTouches,s=e?e[0].clientX:t.clientX,i=e?e[0].clientY:t.clientY,{x:r,y:n}=this.transforms.normalizePoint(s,i),o=r-this.pointer[6],h=n-this.pointer[7];let a=t.target,l=!1,c=!1,d=!1;for(;e&&a&&a!==this.$trigger;){const t=ts(a,"overflow-y");if("hidden"!==t&&"visible"!==t){const{scrollTop:t,scrollHeight:e,clientHeight:s}=a;if(e>s){d=!0,l=t<=3,c=t>=e-s-3;break}}a=a.parentNode}d&&(!l&&!c||l&&h<0||c&&h>0)?(this.pointer[0]=r,this.pointer[1]=n,this.pointer[2]=r,this.pointer[3]=n,this.pointer[4]=r,this.pointer[5]=n,this.pointer[6]=r,this.pointer[7]=n):(fs(t),this.triggerStyles||(this.triggerStyles=es(this.$trigger,{pointerEvents:"none"})),this.$trigger.addEventListener("touchstart",fs,{passive:!1}),this.$trigger.addEventListener("touchmove",fs,{passive:!1}),this.$trigger.addEventListener("touchend",fs),(!this.disabled[0]&&K(o)>3||!this.disabled[1]&&K(h)>3)&&(this.updateTicker.resume(),this.pointer[2]=this.pointer[0],this.pointer[3]=this.pointer[1],this.pointer[0]=r,this.pointer[1]=n,this.dragged=!0,this.released=!1,this.onDrag(this)))}handleUp(){if(!this.grabbed)return;this.updateTicker.pause(),this.triggerStyles&&(this.triggerStyles.revert(),this.triggerStyles=null),this.bodyStyles&&(this.bodyStyles.revert(),this.bodyStyles=null);const[t,e]=this.disabled,[s,n,o,h,a,l]=this.pointer,[c,d,u,p]=this.containerBounds,[m,f]=this.snapped,g=this.releaseXSpring,_=this.releaseYSpring,y=this.releaseEase,v=this.hasReleaseSpring,b=this.overshootCoords,T=this.x,w=this.y,S=this.computeVelocity(s-a,n-l),x=this.angle=nt(n-h,s-o),k=150*S,$=(1-this.releaseContainerFriction)*this.dragSpeed,C=T+J(x)*k,E=w+Z(x)*k,B=C>d?d+(C-d)*$:C<p?p+(C-p)*$:C,D=E>u?u+(E-u)*$:E<c?c+(E-c)*$:E,A=this.destX=at(ct(dt(B,this.snapX),5),p,d),N=this.destY=at(ct(dt(D,this.snapY),5),c,u),F=this.isOutOfBounds(this.containerBounds,C,E);let O=0,P=0,R=y,M=y,Y=0;if(b.x=T,b.y=w,!t){const t=A===d?T>d?-1:1:T<p?-1:1,s=ct(T-A,0);g.velocity=e&&v?s?k*t/K(s):0:S;const{ease:i,duration:r,restDuration:n}=g;O=T===A?0:v?r:r-n*L.timeScale,v&&(R=i),O>Y&&(Y=O)}if(!e){const e=N===u?w>u?-1:1:w<c?-1:1,s=ct(w-N,0);_.velocity=t&&v?s?k*e/K(s):0:S;const{ease:i,duration:r,restDuration:n}=_;P=w===N?0:v?r:r-n*L.timeScale,v&&(M=i),P>Y&&(Y=P)}if(!v&&F&&$&&(O||P)){const t=r.blend;new Re(b,{x:{to:B,duration:.65*O},y:{to:D,duration:.65*P},ease:y,composition:t}).init(),new Re(b,{x:{to:A,duration:O},y:{to:N,duration:P},ease:y,composition:t}).init(),this.overshootXTicker.stretch(O).restart(),this.overshootYTicker.stretch(P).restart()}else t||this.animate[this.xProp](A,O,R),e||this.animate[this.yProp](N,P,M);this.scrollInView(Y,this.scrollThreshold,y);let X=!1;A!==m&&(this.snapped[0]=A,this.snapX&&(X=!0)),N!==f&&this.snapY&&(this.snapped[1]=N,this.snapY&&(X=!0)),X&&this.onSnap(this),this.grabbed=!1,this.dragged=!1,this.updated=!0,this.released=!0,this.onRelease(this),this.$trigger.removeEventListener("touchstart",fs),this.$trigger.removeEventListener("touchmove",fs),this.$trigger.removeEventListener("touchend",fs),i.removeEventListener("touchmove",this),i.removeEventListener("touchend",this),i.removeEventListener("touchcancel",this),i.removeEventListener("mousemove",this),i.removeEventListener("mouseup",this),i.removeEventListener("selectstart",this)}reset(){return this.stop(),this.resizeTicker.pause(),this.grabbed=!1,this.dragged=!1,this.updated=!1,this.released=!1,this.canScroll=!1,this.setX(0,!0),this.setY(0,!0),this.coords[0]=0,this.coords[1]=0,this.pointer[0]=0,this.pointer[1]=0,this.pointer[2]=0,this.pointer[3]=0,this.pointer[4]=0,this.pointer[5]=0,this.pointer[6]=0,this.pointer[7]=0,this.velocity=0,this.velocityStack[0]=0,this.velocityStack[1]=0,this.velocityStack[2]=0,this.velocityStackIndex=0,this.angle=0,this}enable(){return this.enabled||(this.enabled=!0,this.$target.classList.remove("is-disabled"),this.touchActionStyles=es(this.$trigger,{touchAction:this.disabled[0]?"pan-x":this.disabled[1]?"pan-y":"none"}),this.$trigger.addEventListener("touchstart",this,{passive:!0}),this.$trigger.addEventListener("mousedown",this,{passive:!0}),this.$trigger.addEventListener("mouseenter",this)),this}disable(){return this.enabled=!1,this.grabbed=!1,this.dragged=!1,this.updated=!1,this.released=!1,this.canScroll=!1,this.touchActionStyles.revert(),this.cursorStyles&&(this.cursorStyles.revert(),this.cursorStyles=null),this.triggerStyles&&(this.triggerStyles.revert(),this.triggerStyles=null),this.bodyStyles&&(this.bodyStyles.revert(),this.bodyStyles=null),this.targetStyles&&(this.targetStyles.revert(),this.targetStyles=null),this.$target.classList.add("is-disabled"),this.$trigger.removeEventListener("touchstart",this),this.$trigger.removeEventListener("mousedown",this),this.$trigger.removeEventListener("mouseenter",this),i.removeEventListener("touchmove",this),i.removeEventListener("touchend",this),i.removeEventListener("touchcancel",this),i.removeEventListener("mousemove",this),i.removeEventListener("mouseup",this),i.removeEventListener("selectstart",this),this}revert(){return this.reset(),this.disable(),this.$target.classList.remove("is-disabled"),this.updateTicker.revert(),this.overshootXTicker.revert(),this.overshootYTicker.revert(),this.resizeTicker.revert(),this.animate.revert(),this.resizeObserver.disconnect(),this}handleEvent(t){switch(t.type){case"mousedown":case"touchstart":this.handleDown(t);break;case"mousemove":case"touchmove":this.handleMove(t);break;case"mouseup":case"touchend":case"touchcancel":this.handleUp();break;case"mouseenter":this.handleHover();break;case"selectstart":fs(t)}}}class Ts{constructor(t={}){D.current&&D.current.register(this);const e=t.root;let r=i;e&&(r=e.current||e.nativeElement||Ft(e)[0]||i);const n=t.defaults,o=L.defaults,h=t.mediaQueries;if(this.defaults=n?yt(n,o):o,this.root=r,this.constructors=[],this.revertConstructors=[],this.revertibles=[],this.constructorsOnce=[],this.revertConstructorsOnce=[],this.revertiblesOnce=[],this.once=!1,this.onceIndex=0,this.methods={},this.matches={},this.mediaQueryLists={},this.data={},h)for(let t in h){const e=s.matchMedia(h[t]);this.mediaQueryLists[t]=e,e.addEventListener("change",this)}}register(t){(this.once?this.revertiblesOnce:this.revertibles).push(t)}execute(t){let e=D.current,s=D.root,i=L.defaults;D.current=this,D.root=this.root,L.defaults=this.defaults;const r=this.mediaQueryLists;for(let t in r)this.matches[t]=r[t].matches;const n=t(this);return D.current=e,D.root=s,L.defaults=i,n}refresh(){return this.onceIndex=0,this.execute((()=>{let t=this.revertibles.length,e=this.revertConstructors.length;for(;t--;)this.revertibles[t].revert();for(;e--;)this.revertConstructors[e](this);this.revertibles.length=0,this.revertConstructors.length=0,this.constructors.forEach((t=>{const e=t(this);X(e)&&this.revertConstructors.push(e)}))})),this}add(t,e){if(this.once=!1,X(t)){const e=t;this.constructors.push(e),this.execute((()=>{const t=e(this);X(t)&&this.revertConstructors.push(t)}))}else this.methods[t]=(...t)=>this.execute((()=>e(...t)));return this}addOnce(t){if(this.once=!0,X(t)){const e=this.onceIndex++;if(this.constructorsOnce[e])return this;const s=t;this.constructorsOnce[e]=s,this.execute((()=>{const t=s(this);X(t)&&this.revertConstructorsOnce.push(t)}))}return this}keepTime(t){this.once=!0;const e=this.onceIndex++,s=this.constructorsOnce[e];if(X(s))return s(this);const i=wt(t);let r;return this.constructorsOnce[e]=i,this.execute((()=>{r=i(this)})),r}handleEvent(t){"change"===t.type&&this.refresh()}revert(){const t=this.revertibles,e=this.revertConstructors,s=this.revertiblesOnce,i=this.revertConstructorsOnce,r=this.mediaQueryLists;let n=t.length,o=e.length,h=s.length,a=i.length;for(;n--;)t[n].revert();for(;o--;)e[o](this);for(;h--;)s[h].revert();for(;a--;)i[a](this);for(let t in r)r[t].removeEventListener("change",this);t.length=0,e.length=0,this.constructors.length=0,s.length=0,i.length=0,this.constructorsOnce.length=0,this.onceIndex=0,this.matches={},this.methods={},this.mediaQueryLists={},this.data={}}}const ws=(t,e)=>t&&X(t)?t(e):t,Ss=new Map;class xs{constructor(t){this.element=t,this.useWin=this.element===i.body,this.winWidth=0,this.winHeight=0,this.width=0,this.height=0,this.left=0,this.top=0,this.zIndex=0,this.scrollX=0,this.scrollY=0,this.prevScrollX=0,this.prevScrollY=0,this.scrollWidth=0,this.scrollHeight=0,this.velocity=0,this.backwardX=!1,this.backwardY=!1,this.scrollTicker=new oe({autoplay:!1,onBegin:()=>this.dataTimer.resume(),onUpdate:()=>{const t=this.backwardX||this.backwardY;vt(this,(t=>t.handleScroll()),t)},onComplete:()=>this.dataTimer.pause()}).init(),this.dataTimer=new oe({autoplay:!1,frameRate:30,onUpdate:t=>{const e=t.deltaTime,s=this.prevScrollX,i=this.prevScrollY,r=this.scrollX,n=this.scrollY,o=s-r,h=i-n;this.prevScrollX=r,this.prevScrollY=n,o&&(this.backwardX=s>r),h&&(this.backwardY=i>n),this.velocity=ct(e>0?Math.sqrt(o*o+h*h)/e:0,5)}}).init(),this.resizeTicker=new oe({autoplay:!1,duration:250*L.timeScale,onComplete:()=>{this.updateWindowBounds(),this.refreshScrollObservers(),this.handleScroll()}}).init(),this.wakeTicker=new oe({autoplay:!1,duration:500*L.timeScale,onBegin:()=>{this.scrollTicker.resume()},onComplete:()=>{this.scrollTicker.pause()}}).init(),this._head=null,this._tail=null,this.updateScrollCoords(),this.updateWindowBounds(),this.updateBounds(),this.refreshScrollObservers(),this.handleScroll(),this.resizeObserver=new ResizeObserver((()=>this.resizeTicker.restart())),this.resizeObserver.observe(this.element),(this.useWin?s:this.element).addEventListener("scroll",this,!1)}updateScrollCoords(){const t=this.useWin,e=this.element;this.scrollX=ct(t?s.scrollX:e.scrollLeft,0),this.scrollY=ct(t?s.scrollY:e.scrollTop,0)}updateWindowBounds(){this.winWidth=s.innerWidth,this.winHeight=(()=>{const t=i.createElement("div");i.body.appendChild(t),t.style.height="100lvh";const e=t.offsetHeight;return i.body.removeChild(t),e})()}updateBounds(){const t=getComputedStyle(this.element),e=this.element;let s,i;if(this.scrollWidth=e.scrollWidth+parseFloat(t.marginLeft)+parseFloat(t.marginRight),this.scrollHeight=e.scrollHeight+parseFloat(t.marginTop)+parseFloat(t.marginBottom),this.updateWindowBounds(),this.useWin)s=this.winWidth,i=this.winHeight;else{const t=e.getBoundingClientRect();s=t.width,i=t.height,this.top=t.top,this.left=t.left}this.width=s,this.height=i}refreshScrollObservers(){vt(this,(t=>{t._debug&&t.removeDebug()})),this.updateBounds(),vt(this,(t=>{t.refresh(),t._debug&&t.debug()}))}refresh(){this.updateWindowBounds(),this.updateBounds(),this.refreshScrollObservers(),this.handleScroll()}handleScroll(){this.updateScrollCoords(),this.wakeTicker.restart()}handleEvent(t){"scroll"===t.type&&this.handleScroll()}revert(){this.scrollTicker.cancel(),this.dataTimer.cancel(),this.resizeTicker.cancel(),this.wakeTicker.cancel(),this.resizeObserver.disconnect(),(this.useWin?s:this.element).removeEventListener("scroll",this),Ss.delete(this.element)}}const ks=(t,e,s,i,r)=>{const n="min"===e,o="max"===e,h="top"===e||"left"===e||"start"===e||n?0:"bottom"===e||"right"===e||"end"===e||o?"100%":"center"===e?"50%":e,{n:a,u:l}=Qt(h,Gt);let c=a;return"%"===l?c=a/100*s:l&&(c=$e(t,Gt,"px",!0).n),o&&i<0&&(c+=i),n&&r>0&&(c+=r),c},$s=(t,e,s,i,r)=>{let n;if(Y(e)){const o=E.exec(e);if(o){const h=o[0],a=h[0],l=e.split(h),c="min"===l[0],d="max"===l[0],u=ks(t,l[0],s,i,r),p=ks(t,l[1],s,i,r);if(c){const e=qt(ks(t,"min",s),p,a);n=e<u?u:e}else if(d){const e=qt(ks(t,"max",s),p,a);n=e>u?u:e}else n=qt(u,p,a)}else n=ks(t,e,s,i,r)}else n=e;return ct(n,0)},Cs=t=>{let e;const s=t.targets;for(let t=0,i=s.length;t<i;t++){const i=s[t];if(i[o]){e=i;break}}return e};let Es=0;const Bs=["#FF4B4B","#FF971B","#FFC730","#F9F640","#7AFF5A","#18FF74","#17E09B","#3CFFEC","#05DBE9","#33B3F1","#638CF9","#C563FE","#FF4FCF","#F93F8A"];class Ds{constructor(t={}){D.current&&D.current.register(this);const e=It(t.sync,"play pause"),s=e?Te(e):null,r=e&&("linear"===e||e===he),n=e&&!(s===he&&!r),o=e&&(M(e)||!0===e||r),h=e&&Y(e)&&!n&&!o,a=h?e.split(" ").map((t=>()=>{const e=this.linked;return e&&e[t]?e[t]():null})):null,l=h&&a.length>2;this.index=Es++,this.id=z(t.id)?this.index:t.id,this.container=(t=>{const e=t&&Ft(t)[0]||i.body;let s=Ss.get(e);return s||(s=new xs(e),Ss.set(e,s)),s})(t.container),this.target=null,this.linked=null,this.repeat=null,this.horizontal=null,this.enter=null,this.leave=null,this.sync=n||o||!!a,this.syncEase=n?s:null,this.syncSmooth=o?!0===e||r?1:e:null,this.onSyncEnter=a&&!l&&a[0]?a[0]:y,this.onSyncLeave=a&&!l&&a[1]?a[1]:y,this.onSyncEnterForward=a&&l&&a[0]?a[0]:y,this.onSyncLeaveForward=a&&l&&a[1]?a[1]:y,this.onSyncEnterBackward=a&&l&&a[2]?a[2]:y,this.onSyncLeaveBackward=a&&l&&a[3]?a[3]:y,this.onEnter=t.onEnter||y,this.onLeave=t.onLeave||y,this.onEnterForward=t.onEnterForward||y,this.onLeaveForward=t.onLeaveForward||y,this.onEnterBackward=t.onEnterBackward||y,this.onLeaveBackward=t.onLeaveBackward||y,this.onUpdate=t.onUpdate||y,this.onSyncComplete=t.onSyncComplete||y,this.reverted=!1,this.completed=!1,this.began=!1,this.isInView=!1,this.forceEnter=!1,this.hasEntered=!1,this.offset=0,this.offsetStart=0,this.offsetEnd=0,this.distance=0,this.prevProgress=0,this.thresholds=["start","end","end","start"],this.coords=[0,0,0,0],this.debugStyles=null,this.$debug=null,this._params=t,this._debug=It(t.debug,!1),this._next=null,this._prev=null,Tt(this.container,this),Ke((()=>{if(!this.reverted){if(!this.target){const e=Ft(t.target)[0];this.target=e||i.body,this.refresh()}this._debug&&this.debug()}}))}link(t){if(t&&(t.pause(),this.linked=t,!this._params.target)){let e;z(t.targets)?vt(t,(t=>{t.targets&&!e&&(e=Cs(t))})):e=Cs(t),this.target=e||i.body,this.refresh()}return this}get velocity(){return this.container.velocity}get backward(){return this.horizontal?this.container.backwardX:this.container.backwardY}get scroll(){return this.horizontal?this.container.scrollX:this.container.scrollY}get progress(){const t=(this.scroll-this.offsetStart)/this.distance;return t===1/0||isNaN(t)?0:ct(at(t,0,1),6)}refresh(){this.reverted=!1;const t=this._params;return this.repeat=It(ws(t.repeat,this),!0),this.horizontal="x"===It(ws(t.axis,this),"y"),this.enter=It(ws(t.enter,this),"end start"),this.leave=It(ws(t.leave,this),"start end"),this.updateBounds(),this.handleScroll(),this}removeDebug(){return this.$debug&&(this.$debug.parentNode.removeChild(this.$debug),this.$debug=null),this.debugStyles&&(this.debugStyles.revert(),this.$debug=null),this}debug(){this.removeDebug();const t=this.container,e=this.horizontal,s=t.element.querySelector(":scope > .animejs-onscroll-debug"),r=i.createElement("div"),n=i.createElement("div"),o=i.createElement("div"),h=Bs[this.index%Bs.length],a=t.useWin,l=a?t.winWidth:t.width,c=a?t.winHeight:t.height,d=t.scrollWidth,u=t.scrollHeight,p=this.container.width>360?320:260,m=e?0:10,f=e?10:0,g=e?24:p/2,_=e?g:15,y=e?60:g,v=e?y:_,b=e?"repeat-x":"repeat-y",T=t=>e?"0px "+t+"px":t+"px 2px",w=t=>`linear-gradient(${e?90:0}deg, ${t} 2px, transparent 1px)`,S=(t,e,s,i,r)=>`position:${t};left:${e}px;top:${s}px;width:${i}px;height:${r}px;`;r.style.cssText=`${S("absolute",m,f,e?d:p,e?p:u)}\n      pointer-events: none;\n      z-index: ${this.container.zIndex++};\n      display: flex;\n      flex-direction: ${e?"column":"row"};\n      filter: drop-shadow(0px 1px 0px rgba(0,0,0,.75));\n    `,n.style.cssText=`${S("sticky",0,0,e?l:g,e?g:c)}`,s||(n.style.cssText+=`background:\n        ${w("#FFFF")}${T(g-10)} / 100px 100px ${b},\n        ${w("#FFF8")}${T(g-10)} / 10px 10px ${b};\n      `),o.style.cssText=`${S("relative",0,0,e?d:g,e?g:u)}`,s||(o.style.cssText+=`background:\n        ${w("#FFFF")}${T(0)} / ${e?"100px 10px":"10px 100px"} ${b},\n        ${w("#FFF8")}${T(0)} / ${e?"10px 0px":"0px 10px"} ${b};\n      `);const x=[" enter: "," leave: "];this.coords.forEach(((t,s)=>{const r=s>1,a=(r?0:this.offset)+t,m=s%2,f=a<v,g=a>(r?e?l:c:e?d:u)-v,b=(r?m&&!f:!m&&!f)||g,T=i.createElement("div"),w=i.createElement("div"),k=e?b?"right":"left":b?"bottom":"top",$=b?(e?y:_)+(r?e?-1:g?0:-2:e?-1:-2):e?1:0;w.innerHTML=`${this.id}${x[m]}${this.thresholds[s]}`,T.style.cssText=`${S("absolute",0,0,y,_)}\n        display: flex;\n        flex-direction: ${e?"column":"row"};\n        justify-content: flex-${r?"start":"end"};\n        align-items: flex-${b?"end":"start"};\n        border-${k}: 2px solid ${h};\n      `,w.style.cssText=`\n        overflow: hidden;\n        max-width: ${p/2-10}px;\n        height: ${_};\n        margin-${e?b?"right":"left":b?"bottom":"top"}: -2px;\n        padding: 1px;\n        font-family: ui-monospace, monospace;\n        font-size: 10px;\n        letter-spacing: -.025em;\n        line-height: 9px;\n        font-weight: 600;\n        text-align: ${e&&b||!e&&!r?"right":"left"};\n        white-space: pre;\n        text-overflow: ellipsis;\n        color: ${m?h:"rgba(0,0,0,.75)"};\n        background-color: ${m?"rgba(0,0,0,.65)":h};\n        border: 2px solid ${m?h:"transparent"};\n        border-${e?b?"top-left":"top-right":b?"top-left":"bottom-left"}-radius: 5px;\n        border-${e?b?"bottom-left":"bottom-right":b?"top-right":"bottom-right"}-radius: 5px;\n      `,T.appendChild(w);let C=a-$+(e?1:0);T.style[e?"left":"top"]=`${C}px`,(r?n:o).appendChild(T)})),r.appendChild(n),r.appendChild(o),t.element.appendChild(r),s||r.classList.add("animejs-onscroll-debug"),this.$debug=r,"static"===ts(t.element,"position")&&(this.debugStyles=es(t.element,{position:"relative "}))}updateBounds(){let t;this._debug&&this.removeDebug();const e=this.target,s=this.container,r=this.horizontal,n=this.linked;let o,h=e;for(n&&(o=n.currentTime,n.seek(0,!0)),h.parentElement;h&&h!==s.element&&h!==i.body;){const e="sticky"===ts(h,"position")&&es(h,{position:"static"});h=h.parentElement,e&&(t||(t=[]),t.push(e))}const a=e.getBoundingClientRect(),l=r?a.left+s.scrollX-s.left:a.top+s.scrollY-s.top,c=r?a.width:a.height,d=r?s.width:s.height,u=(r?s.scrollWidth:s.scrollHeight)-d,p=this.enter,m=this.leave;let f="start",g="end",_="end",y="start";if(Y(p)){const t=p.split(" ");_=t[0],f=t.length>1?t[1]:f}else if(R(p)){const t=p;z(t.container)||(_=t.container),z(t.target)||(f=t.target)}else M(p)&&(_=p);if(Y(m)){const t=m.split(" ");y=t[0],g=t.length>1?t[1]:g}else if(R(m)){const t=m;z(t.container)||(y=t.container),z(t.target)||(g=t.target)}else M(m)&&(y=m);const v=$s(e,f,c),b=$s(e,g,c),T=v+l-d,w=b+l-u,S=$s(e,_,d,T,w),x=$s(e,y,d,T,w),k=v+l-S,$=b+l-x,C=$-k;this.offset=l,this.offsetStart=k,this.offsetEnd=$,this.distance=C<=0?0:C,this.thresholds=[f,g,_,y],this.coords=[v,b,S,x],t&&t.forEach((t=>t.revert())),n&&n.seek(o,!0),this._debug&&this.debug()}handleScroll(){const t=this.linked,e=this.sync,s=this.syncEase,i=this.syncSmooth,r=t&&(s||i),n=this.horizontal,o=this.container,h=this.scroll,a=h<=this.offsetStart,l=h>=this.offsetEnd,c=!a&&!l,d=h===this.offsetStart||h===this.offsetEnd,u=!this.hasEntered&&d,p=this._debug&&this.$debug;let m=!1,f=!1,g=this.progress;if(a&&this.began&&(this.began=!1),g>0&&!this.began&&(this.began=!0),r){const e=t.progress;if(i&&M(i)){if(i<1){const t=e<g&&1===g?1e-4:e>g&&!g?-1e-4:0;g=ct(ns(e,g,ut(.01,.2,i),!1)+t,6)}}else s&&(g=s(g));m=g!==this.prevProgress,f=1===e,m&&!f&&i&&e&&o.wakeTicker.restart()}if(p){const t=n?o.scrollY:o.scrollX;p.style[n?"top":"left"]=t+10+"px"}(c&&!this.isInView||u&&!this.forceEnter&&!this.hasEntered)&&(c&&(this.isInView=!0),this.forceEnter&&this.hasEntered?c&&(this.forceEnter=!1):(p&&c&&(p.style.zIndex=""+this.container.zIndex++),this.onSyncEnter(this),this.onEnter(this),this.backward?(this.onSyncEnterBackward(this),this.onEnterBackward(this)):(this.onSyncEnterForward(this),this.onEnterForward(this)),this.hasEntered=!0,u&&(this.forceEnter=!0))),(c||!c&&this.isInView)&&(m=!0),m&&(r&&t.seek(t.duration*g),this.onUpdate(this)),!c&&this.isInView&&(this.isInView=!1,this.onSyncLeave(this),this.onLeave(this),this.backward?(this.onSyncLeaveBackward(this),this.onLeaveBackward(this)):(this.onSyncLeaveForward(this),this.onLeaveForward(this)),e&&!i&&(f=!0)),g>=1&&this.began&&!this.completed&&(e&&f||!e)&&(e&&this.onSyncComplete(this),this.completed=!0,(!this.repeat&&!t||!this.repeat&&t&&t.completed)&&this.revert()),g<1&&this.completed&&(this.completed=!1),this.prevProgress=g}revert(){if(this.reverted)return;const t=this.container;return bt(t,this),t._head||t.revert(),this._debug&&this.removeDebug(),this.reverted=!0,this}}const Ls=!z(Intl)&&Intl.Segmenter,As=/\{value\}/g,Ns=/\{i\}/g,Fs=/(\s+)/,Os=/^\s+$/,Ps="line",Rs="word",Ms="char",Ys="data-line";let Xs=null,zs=null,Is=null;const Ws=t=>t.isWordLike||" "===t.segment||M(+t.segment),Vs=t=>t.setAttribute("aria-hidden","true"),Hs=(t,e)=>[...t.querySelectorAll(`[data-${e}]:not([data-${e}] [data-${e}])`)],Us={line:"#00D672",word:"#FF4B4B",char:"#5A87FF"},qs=t=>{if(!t.childElementCount&&!t.textContent.trim()){const e=t.parentElement;t.remove(),e&&qs(e)}},Qs=(t,e,s)=>{const i=t.getAttribute(Ys);(null!==i&&+i!==e||"BR"===t.tagName)&&s.add(t);let r=t.childElementCount;for(;r--;)Qs(t.children[r],e,s);return s},js=(t,e={})=>{let s="";const i=Y(e.class)?` class="${e.class}"`:"",r=It(e.clone,!1),n=It(e.wrap,!1),o=n?!0===n?"clip":n:!!r&&"clip";return n&&(s+=`<span${o?` style="overflow:${o};"`:""}>`),s+=`<span${i}${r?' style="position:relative;"':""} data-${t}="{i}">`,r?(s+="<span>{value}</span>",s+=`<span inert style="position:absolute;top:${"top"===r?"-100%":"bottom"===r?"100%":"0"};left:${"left"===r?"-100%":"right"===r?"100%":"0"};white-space:nowrap;">{value}</span>`):s+="{value}",s+="</span>",n&&(s+="</span>"),s},Gs=(t,e,s,i,r,n,o,h,a)=>{const l=r===Ps,c=r===Ms,d=`_${r}_`,u=X(t)?t(s):t,p=l?"block":"inline-block";Is.innerHTML=u.replace(As,`<i class="${d}"></i>`).replace(Ns,`${c?a:l?o:h}`);const m=Is.content,f=m.firstElementChild,g=m.querySelector(`[data-${r}]`)||f,_=m.querySelectorAll(`i.${d}`),y=_.length;if(y){f.style.display=p,g.style.display=p,g.setAttribute(Ys,`${o}`),l||(g.setAttribute("data-word",`${h}`),c&&g.setAttribute("data-char",`${a}`));let t=y;for(;t--;){const e=_[t],i=e.parentElement;i.style.display=p,l?i.innerHTML=s.innerHTML:i.replaceChild(s.cloneNode(!0),e)}e.push(g),i.appendChild(m)}else console.warn('The expression "{value}" is missing from the provided template.');return n&&(f.style.outline=`1px dotted ${Us[r]}`),f};class Zs{constructor(t,s={}){Xs||(Xs=Ls?new Ls([],{granularity:Rs}):{segment:t=>{const e=[],s=t.split(Fs);for(let t=0,i=s.length;t<i;t++){const i=s[t];e.push({segment:i,isWordLike:!Os.test(i)})}return e}}),zs||(zs=Ls?new Ls([],{granularity:"grapheme"}):{segment:t=>[...t].map((t=>({segment:t})))}),!Is&&e&&(Is=i.createElement("template")),D.current&&D.current.register(this);const{words:r,chars:n,lines:o,accessible:h,includeSpaces:a,debug:l}=s,c=(t=P(t)?t[0]:t)&&t.nodeType?t:(Nt(t)||[])[0],d=!0===o?{}:o,u=!0===r||z(r)?{}:r,p=!0===n?{}:n;this.debug=It(l,!1),this.includeSpaces=It(a,!1),this.accessible=It(h,!0),this.linesOnly=d&&!u&&!p,this.lineTemplate=R(d)?js(Ps,d):d,this.wordTemplate=R(u)||this.linesOnly?js(Rs,u):u,this.charTemplate=R(p)?js(Ms,p):p,this.$target=c,this.html=c&&c.innerHTML,this.lines=[],this.words=[],this.chars=[],this.effects=[],this.effectsCleanups=[],this.cache=null,this.ready=!1,this.width=0,this.resizeTimeout=null;const m=()=>this.html&&(d||u||p)&&this.split();this.resizeObserver=new ResizeObserver((()=>{clearTimeout(this.resizeTimeout),this.resizeTimeout=setTimeout((()=>{const t=c.offsetWidth;t!==this.width&&(this.width=t,m())}),150)})),this.lineTemplate&&!this.ready?i.fonts.ready.then(m):m(),c?this.resizeObserver.observe(c):console.warn("No Text Splitter target found.")}addEffect(t){if(!X(t))return console.warn("Effect must return a function.");const e=wt(t);return this.effects.push(e),this.ready&&(this.effectsCleanups[this.effects.length-1]=e(this)),this}revert(){return clearTimeout(this.resizeTimeout),this.lines.length=this.words.length=this.chars.length=0,this.resizeObserver.disconnect(),this.effectsCleanups.forEach((t=>X(t)?t(this):t.revert&&t.revert())),this.$target.innerHTML=this.html,this}splitNode(t){const e=this.wordTemplate,s=this.charTemplate,r=this.includeSpaces,n=this.debug,o=t.nodeType;if(3===o){const o=t.nodeValue;if(o.trim()){const h=[],a=this.words,l=this.chars,c=Xs.segment(o),d=i.createDocumentFragment();let u=null;for(const t of c){const e=t.segment,s=Ws(t);if(!u||s&&u&&Ws(u))h.push(e);else{const t=h.length-1;h[t].includes(" ")||e.includes(" ")?h.push(e):h[t]+=e}u=t}for(let t=0,o=h.length;t<o;t++){const o=h[t];if(o.trim()){const c=h[t+1],u=r&&c&&!c.trim(),p=o,m=s?zs.segment(p):null,f=s?i.createDocumentFragment():i.createTextNode(u?o+" ":o);if(s){const t=[...m];for(let e=0,r=t.length;e<r;e++){const o=t[e],h=e===r-1&&u?o.segment+" ":o.segment,c=i.createTextNode(h);Gs(s,l,c,f,Ms,n,-1,a.length,l.length)}}e?Gs(e,a,f,d,Rs,n,-1,a.length,l.length):s?d.appendChild(f):d.appendChild(i.createTextNode(o)),u&&t++}else{if(t&&r)continue;d.appendChild(i.createTextNode(o))}}t.parentNode.replaceChild(d,t)}}else if(1===o){const e=[...t.childNodes];for(let t=0,s=e.length;t<s;t++)this.splitNode(e[t])}}split(t=!1){const e=this.$target,s=!!this.cache&&!t,r=this.lineTemplate,n=this.wordTemplate,o=this.charTemplate,h="loading"!==i.fonts.status,a=r&&h;this.ready=!r||h,(a||t)&&this.effectsCleanups.forEach((t=>X(t)&&t(this))),s||(t&&(e.innerHTML=this.html,this.words.length=this.chars.length=0),this.splitNode(e),this.cache=e.innerHTML),a&&(s&&(e.innerHTML=this.cache),this.lines.length=0,n&&(this.words=Hs(e,Rs))),o&&(a||n)&&(this.chars=Hs(e,Ms));const l=this.words.length?this.words:this.chars;let c,d=0;for(let t=0,e=l.length;t<e;t++){const e=l[t],{top:s,height:i}=e.getBoundingClientRect();c&&s-c>.5*i&&d++,e.setAttribute(Ys,`${d}`);const r=e.querySelectorAll(`[${Ys}]`);let n=r.length;for(;n--;)r[n].setAttribute(Ys,`${d}`);c=s}if(a){const t=i.createDocumentFragment(),s=new Set,h=[];for(let t=0;t<d+1;t++){const i=e.cloneNode(!0);Qs(i,t,new Set).forEach((t=>{const e=t.parentElement;e&&s.add(e),t.remove()})),h.push(i)}s.forEach(qs);for(let e=0,s=h.length;e<s;e++)Gs(r,this.lines,h[e],t,Ps,this.debug,e);e.innerHTML="",e.appendChild(t),n&&(this.words=Hs(e,Rs)),o&&(this.chars=Hs(e,Ms))}if(this.linesOnly){const t=this.words;let e=t.length;for(;e--;){const s=t[e];s.replaceWith(s.textContent)}t.length=0}if(this.accessible&&(a||!s)){const t=i.createElement("span");t.style.cssText="position:absolute;overflow:hidden;clip:rect(0 0 0 0);clip-path:inset(50%);width:1px;height:1px;white-space:nowrap;",t.innerHTML=this.html,e.insertBefore(t,e.firstChild),this.lines.forEach(Vs),this.words.forEach(Vs),this.chars.forEach(Vs)}return this.width=e.offsetWidth,(a||t)&&this.effects.forEach(((t,e)=>this.effectsCleanups[e]=t(this))),this}refresh(){this.split(!0)}}const Js={split:(t,e)=>new Zs(t,e)};return t.Animatable=us,t.Draggable=bs,t.JSAnimation=Re,t.Scope=Ts,t.ScrollObserver=Ds,t.Spring=ps,t.TextSplitter=Zs,t.Timeline=ds,t.Timer=oe,t.WAAPIAnimation=Ze,t.animate=(t,e)=>new Re(t,e,null,0,!1).init(),t.createAnimatable=(t,e)=>new us(t,e),t.createDraggable=(t,e)=>new bs(t,e),t.createScope=t=>new Ts(t),t.createSpring=ms,t.createTimeline=t=>new ds(t).init(),t.createTimer=t=>new oe(t,null,0).init(),t.eases=ve,t.engine=Dt,t.onScroll=(t={})=>new Ds(t),t.scrollContainers=Ss,t.stagger=(t,e={})=>{let s=[],i=0;const r=e.from,n=e.reversed,o=e.ease,h=!z(o),a=h&&!z(o.ease)?o.ease:h?Te(o):null,l=e.grid,c=e.axis,d=e.total,u=z(r)||0===r||"first"===r,p="center"===r,f="last"===r,g="random"===r,_=P(t),y=e.use,v=Q(_?t[0]:t),b=_?Q(t[1]):0,T=k.exec((_?t[1]:t)+m),w=e.start||0+(_?v:0);let S=u?0:M(r)?r:0;return(t,r,o,h)=>{const[u]=Ot(t),m=z(d)?o:d,x=!z(y)&&(X(y)?y(u,r,m):Ut(u,y)),k=M(x)||Y(x)&&M(+x)?+x:r;if(p&&(S=(m-1)/2),f&&(S=m-1),!s.length){for(let t=0;t<m;t++){if(l){const e=p?(l[0]-1)/2:S%l[0],i=p?(l[1]-1)/2:st(S/l[0]),r=e-t%l[0],n=i-st(t/l[0]);let o=G(r*r+n*n);"x"===c&&(o=-r),"y"===c&&(o=-n),s.push(o)}else s.push(K(S-t));i=rt(...s)}a&&(s=s.map((t=>a(t/i)*i))),n&&(s=s.map((t=>c?t<0?-1*t:-t:K(i-t)))),g&&(s=mt(s))}const $=_?(b-v)/i:v;let C=(h?ls(h,z(e.start)?h.iterationDuration:w):w)+($*ct(s[k],2)||0);return e.modifier&&(C=e.modifier(C)),T&&(C=`${C}${T[2]}`),C}},t.svg=Xt,t.text=Js,t.utils=as,t.waapi=Je,t}({});
