import _mergeJSXProps from 'babel-helper-vue-jsx-merge-props';
import _defineProperty from 'babel-runtime/helpers/defineProperty';
import warning from 'warning';
import PropTypes from '../../_util/vue-types';
import BaseMixin from '../../_util/BaseMixin';
import { getOptionProps, getComponentFromProp } from '../../_util/props-util';
import { isVertical } from './utils';
function noop() {}
export default {
  name: 'TabBarTabsNode',
  mixins: [BaseMixin],
  props: {
    activeKey: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    panels: PropTypes.any.def([]),
    prefixCls: PropTypes.string.def(''),
    tabBarGutter: PropTypes.any.def(null),
    onTabClick: PropTypes.func,
    saveRef: PropTypes.func.def(noop),
    getRef: PropTypes.func.def(noop),
    renderTabBarNode: PropTypes.func,
    tabBarPosition: PropTypes.string,
    direction: PropTypes.string
  },
  render: function render() {
    var _this = this;

    var h = arguments[0];
    var _$props = this.$props,
        children = _$props.panels,
        activeKey = _$props.activeKey,
        prefixCls = _$props.prefixCls,
        tabBarGutter = _$props.tabBarGutter,
        saveRef = _$props.saveRef,
        tabBarPosition = _$props.tabBarPosition,
        direction = _$props.direction;

    var rst = [];
    var renderTabBarNode = this.renderTabBarNode || this.$scopedSlots.renderTabBarNode;
    children.forEach(function (child, index) {
      if (!child) {
        return;
      }
      var props = getOptionProps(child);
      var key = child.key;
      var cls = activeKey === key ? prefixCls + '-tab-active' : '';
      cls += ' ' + prefixCls + '-tab';
      var events = { on: {} };
      var disabled = props.disabled || props.disabled === '';
      if (disabled) {
        cls += ' ' + prefixCls + '-tab-disabled';
      } else {
        events.on.click = function () {
          _this.__emit('tabClick', key);
        };
      }
      var directives = [];
      if (activeKey === key) {
        directives.push({
          name: 'ant-ref',
          value: saveRef('activeTab')
        });
      }
      var tab = getComponentFromProp(child, 'tab');
      var gutter = tabBarGutter && index === children.length - 1 ? 0 : tabBarGutter;
      gutter = typeof gutter === 'number' ? gutter + 'px' : gutter;
      var marginProperty = direction === 'rtl' ? 'marginLeft' : 'marginRight';
      var style = _defineProperty({}, isVertical(tabBarPosition) ? 'marginBottom' : marginProperty, gutter);
      warning(tab !== undefined, 'There must be `tab` property or slot on children of Tabs.');
      var node = h(
        'div',
        _mergeJSXProps([{
          attrs: {
            role: 'tab',
            'aria-disabled': disabled ? 'true' : 'false',
            'aria-selected': activeKey === key ? 'true' : 'false'
          }
        }, events, {
          'class': cls,
          key: key,
          style: style
        }, { directives: directives }]),
        [tab]
      );
      if (renderTabBarNode) {
        node = renderTabBarNode(node);
      }

      rst.push(node);
    });

    return h(
      'div',
      {
        directives: [{
          name: 'ant-ref',
          value: this.saveRef('navTabsContainer')
        }]
      },
      [rst]
    );
  }
};