'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _vueTypes = require('../_util/vue-types');

var _vueTypes2 = _interopRequireDefault(_vueTypes);

var _configProvider = require('../config-provider');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

exports['default'] = {
  name: 'ACheckableTag',
  model: {
    prop: 'checked'
  },
  props: {
    prefixCls: _vueTypes2['default'].string,
    checked: Boolean
  },
  inject: {
    configProvider: { 'default': function _default() {
        return _configProvider.ConfigConsumerProps;
      } }
  },
  computed: {
    classes: function classes() {
      var _ref;

      var checked = this.checked,
          customizePrefixCls = this.prefixCls;

      var getPrefixCls = this.configProvider.getPrefixCls;
      var prefixCls = getPrefixCls('tag', customizePrefixCls);
      return _ref = {}, (0, _defineProperty3['default'])(_ref, '' + prefixCls, true), (0, _defineProperty3['default'])(_ref, prefixCls + '-checkable', true), (0, _defineProperty3['default'])(_ref, prefixCls + '-checkable-checked', checked), _ref;
    }
  },
  methods: {
    handleClick: function handleClick() {
      var checked = this.checked;

      this.$emit('input', !checked);
      this.$emit('change', !checked);
    }
  },
  render: function render() {
    var h = arguments[0];
    var classes = this.classes,
        handleClick = this.handleClick,
        $slots = this.$slots;

    return h(
      'div',
      { 'class': classes, on: {
          'click': handleClick
        }
      },
      [$slots['default']]
    );
  }
};