import _mergeJSXProps from 'babel-helper-vue-jsx-merge-props';
import _defineProperty from 'babel-runtime/helpers/defineProperty';
import PropTypes from '../../_util/vue-types';
import { setTransform, isTransform3dSupported, getLeft, getStyle, getTop, getActiveIndex } from './utils';
import BaseMixin from '../../_util/BaseMixin';

function componentDidUpdate(component, init) {
  var _component$$props = component.$props,
      _component$$props$sty = _component$$props.styles,
      styles = _component$$props$sty === undefined ? {} : _component$$props$sty,
      panels = _component$$props.panels,
      activeKey = _component$$props.activeKey,
      direction = _component$$props.direction;

  var rootNode = component.getRef('root');
  var wrapNode = component.getRef('nav') || rootNode;
  var inkBarNode = component.getRef('inkBar');
  var activeTab = component.getRef('activeTab');
  var inkBarNodeStyle = inkBarNode.style;
  var tabBarPosition = component.$props.tabBarPosition;
  var activeIndex = getActiveIndex(panels, activeKey);
  if (init) {
    // prevent mount animation
    inkBarNodeStyle.display = 'none';
  }
  if (activeTab) {
    var tabNode = activeTab;
    var transformSupported = isTransform3dSupported(inkBarNodeStyle);

    // Reset current style
    setTransform(inkBarNodeStyle, '');
    inkBarNodeStyle.width = '';
    inkBarNodeStyle.height = '';
    inkBarNodeStyle.left = '';
    inkBarNodeStyle.top = '';
    inkBarNodeStyle.bottom = '';
    inkBarNodeStyle.right = '';

    if (tabBarPosition === 'top' || tabBarPosition === 'bottom') {
      var left = getLeft(tabNode, wrapNode);
      var width = tabNode.offsetWidth;
      // If tabNode'width width equal to wrapNode'width when tabBarPosition is top or bottom
      // It means no css working, then ink bar should not have width until css is loaded
      // Fix https://github.com/ant-design/ant-design/issues/7564
      if (width === rootNode.offsetWidth) {
        width = 0;
      } else if (styles.inkBar && styles.inkBar.width !== undefined) {
        width = parseFloat(styles.inkBar.width, 10);
        if (width) {
          left += (tabNode.offsetWidth - width) / 2;
        }
      }
      if (direction === 'rtl') {
        left = getStyle(tabNode, 'margin-left') - left;
      }
      // use 3d gpu to optimize render
      if (transformSupported) {
        setTransform(inkBarNodeStyle, 'translate3d(' + left + 'px,0,0)');
      } else {
        inkBarNodeStyle.left = left + 'px';
      }
      inkBarNodeStyle.width = width + 'px';
    } else {
      var top = getTop(tabNode, wrapNode, true);
      var height = tabNode.offsetHeight;
      if (styles.inkBar && styles.inkBar.height !== undefined) {
        height = parseFloat(styles.inkBar.height, 10);
        if (height) {
          top += (tabNode.offsetHeight - height) / 2;
        }
      }
      if (transformSupported) {
        setTransform(inkBarNodeStyle, 'translate3d(0,' + top + 'px,0)');
        inkBarNodeStyle.top = '0';
      } else {
        inkBarNodeStyle.top = top + 'px';
      }
      inkBarNodeStyle.height = height + 'px';
    }
  }
  inkBarNodeStyle.display = activeIndex !== -1 ? 'block' : 'none';
}

export default {
  name: 'InkTabBarNode',
  mixins: [BaseMixin],
  props: {
    inkBarAnimated: {
      type: Boolean,
      'default': true
    },
    direction: PropTypes.string,
    prefixCls: String,
    styles: Object,
    tabBarPosition: String,
    saveRef: PropTypes.func.def(function () {}),
    getRef: PropTypes.func.def(function () {}),
    panels: PropTypes.array,
    activeKey: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
  },
  updated: function updated() {
    this.$nextTick(function () {
      componentDidUpdate(this);
    });
  },
  mounted: function mounted() {
    this.$nextTick(function () {
      componentDidUpdate(this, true);
    });
  },
  render: function render() {
    var _classes;

    var h = arguments[0];
    var prefixCls = this.prefixCls,
        _styles = this.styles,
        styles = _styles === undefined ? {} : _styles,
        inkBarAnimated = this.inkBarAnimated;

    var className = prefixCls + '-ink-bar';
    var classes = (_classes = {}, _defineProperty(_classes, className, true), _defineProperty(_classes, inkBarAnimated ? className + '-animated' : className + '-no-animated', true), _classes);
    return h('div', _mergeJSXProps([{
      style: styles.inkBar,
      'class': classes,
      key: 'inkBar'
    }, {
      directives: [{
        name: 'ant-ref',
        value: this.saveRef('inkBar')
      }]
    }]));
  }
};