import { withDirectives as _withDirectives, vShow as _vShow, createVNode as _createVNode, isVNode as _isVNode } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { inject, cloneVNode, defineComponent } from 'vue';
import CloseOutlined from '@ant-design/icons-vue/CloseOutlined';
import CheckCircleOutlined from '@ant-design/icons-vue/CheckCircleOutlined';
import ExclamationCircleOutlined from '@ant-design/icons-vue/ExclamationCircleOutlined';
import InfoCircleOutlined from '@ant-design/icons-vue/InfoCircleOutlined';
import CloseCircleOutlined from '@ant-design/icons-vue/CloseCircleOutlined';
import CheckCircleFilled from '@ant-design/icons-vue/CheckCircleFilled';
import ExclamationCircleFilled from '@ant-design/icons-vue/ExclamationCircleFilled';
import InfoCircleFilled from '@ant-design/icons-vue/InfoCircleFilled';
import CloseCircleFilled from '@ant-design/icons-vue/CloseCircleFilled';
import classNames from '../_util/classNames';
import BaseMixin from '../_util/BaseMixin';
import PropTypes from '../_util/vue-types';
import { getTransitionProps, Transition } from '../_util/transition';
import { getComponent, isValidElement, findDOMNode } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import { tuple, withInstall } from '../_util/type';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

function noop() {}

var iconMapFilled = {
  success: CheckCircleFilled,
  info: InfoCircleFilled,
  error: CloseCircleFilled,
  warning: ExclamationCircleFilled
};
var iconMapOutlined = {
  success: CheckCircleOutlined,
  info: InfoCircleOutlined,
  error: CloseCircleOutlined,
  warning: ExclamationCircleOutlined
};
export var AlertProps = {
  /**
   * Type of Alert styles, options: `success`, `info`, `warning`, `error`
   */
  type: PropTypes.oneOf(tuple('success', 'info', 'warning', 'error')),

  /** Whether Alert can be closed */
  closable: PropTypes.looseBool,

  /** Close text to show */
  closeText: PropTypes.VNodeChild,

  /** Content of Alert */
  message: PropTypes.VNodeChild,

  /** Additional content of Alert */
  description: PropTypes.VNodeChild,

  /** Callback when close Alert */
  // onClose?: React.MouseEventHandler<HTMLAnchorElement>;

  /** Trigger when animation ending of Alert */
  afterClose: PropTypes.func.def(noop),

  /** Whether to show icon */
  showIcon: PropTypes.looseBool,
  prefixCls: PropTypes.string,
  banner: PropTypes.looseBool,
  icon: PropTypes.VNodeChild,
  onClose: PropTypes.VNodeChild
};
var Alert = defineComponent({
  name: 'AAlert',
  mixins: [BaseMixin],
  inheritAttrs: false,
  props: AlertProps,
  emits: ['close'],
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  data: function data() {
    return {
      closing: false,
      closed: false
    };
  },
  methods: {
    handleClose: function handleClose(e) {
      e.preventDefault();
      var dom = findDOMNode(this);
      dom.style.height = "".concat(dom.offsetHeight, "px"); // Magic code
      // 重复一次后才能正确设置 height

      dom.style.height = "".concat(dom.offsetHeight, "px");
      this.setState({
        closing: true
      });
      this.$emit('close', e);
    },
    animationEnd: function animationEnd() {
      this.setState({
        closing: false,
        closed: true
      });
      this.afterClose();
    }
  },
  render: function render() {
    var _slot;

    var _classNames;

    var customizePrefixCls = this.prefixCls,
        banner = this.banner,
        closing = this.closing,
        closed = this.closed,
        $attrs = this.$attrs;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('alert', customizePrefixCls);
    var closable = this.closable,
        type = this.type,
        showIcon = this.showIcon;
    var closeText = getComponent(this, 'closeText');
    var description = getComponent(this, 'description');
    var message = getComponent(this, 'message');
    var icon = getComponent(this, 'icon'); // banner模式默认有 Icon

    showIcon = banner && showIcon === undefined ? true : showIcon; // banner模式默认为警告

    type = banner && type === undefined ? 'warning' : type || 'info';
    var IconType = (description ? iconMapOutlined : iconMapFilled)[type] || null; // closeable when closeText is assigned

    if (closeText) {
      closable = true;
    }

    var alertCls = classNames(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-").concat(type), true), _defineProperty(_classNames, "".concat(prefixCls, "-closing"), closing), _defineProperty(_classNames, "".concat(prefixCls, "-with-description"), !!description), _defineProperty(_classNames, "".concat(prefixCls, "-no-icon"), !showIcon), _defineProperty(_classNames, "".concat(prefixCls, "-banner"), !!banner), _defineProperty(_classNames, "".concat(prefixCls, "-closable"), closable), _classNames));
    var closeIcon = closable ? _createVNode("button", {
      "type": "button",
      "onClick": this.handleClose,
      "class": "".concat(prefixCls, "-close-icon"),
      "tabindex": 0
    }, [closeText ? _createVNode("span", {
      "class": "".concat(prefixCls, "-close-text")
    }, _isSlot(closeText) ? closeText : {
      default: function _default() {
        return [closeText];
      }
    }) : _createVNode(CloseOutlined, null, null)]) : null;

    var iconNode = icon && (isValidElement(icon) ? cloneVNode(icon, {
      class: "".concat(prefixCls, "-icon")
    }) : _createVNode("span", {
      "class": "".concat(prefixCls, "-icon")
    }, _isSlot(icon) ? icon : {
      default: function _default() {
        return [icon];
      }
    })) || _createVNode(IconType, {
      "class": "".concat(prefixCls, "-icon")
    }, null); // h(iconType, { class: `${prefixCls}-icon` });


    var transitionProps = getTransitionProps("".concat(prefixCls, "-slide-up"), {
      appear: false,
      onAfterLeave: this.animationEnd
    });
    return closed ? null : _createVNode(Transition, transitionProps, _isSlot(_slot = _withDirectives(_createVNode("div", _objectSpread(_objectSpread({}, $attrs), {}, {
      "class": [$attrs.class, alertCls],
      "data-show": !closing
    }), [showIcon ? iconNode : null, _createVNode("span", {
      "class": "".concat(prefixCls, "-message")
    }, _isSlot(message) ? message : {
      default: function _default() {
        return [message];
      }
    }), _createVNode("span", {
      "class": "".concat(prefixCls, "-description")
    }, _isSlot(description) ? description : {
      default: function _default() {
        return [description];
      }
    }), closeIcon]), [[_vShow, !closing]])) ? _slot : {
      default: function _default() {
        return [_slot];
      }
    });
  }
});
export default withInstall(Alert);