import { isVNode as _isVNode, createVNode as _createVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { defineComponent, inject, nextTick } from 'vue';
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import backTopTypes from './backTopTypes';
import addEventListener from '../vc-util/Dom/addEventListener';
import getScroll from '../_util/getScroll';
import BaseMixin from '../_util/BaseMixin';
import { getTransitionProps, Transition } from '../_util/transition';
import { defaultConfigProvider } from '../config-provider';
import scrollTo from '../_util/scrollTo';
import { withInstall } from '../_util/type';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

function getDefaultTarget() {
  return window;
}

var props = backTopTypes();
var BackTop = defineComponent({
  name: 'ABackTop',
  mixins: [BaseMixin],
  inheritAttrs: false,
  props: _extends(_extends({}, props), {
    visibilityHeight: PropTypes.number.def(400)
  }),
  emits: ['click'],
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  data: function data() {
    return {
      visible: false,
      scrollEvent: null
    };
  },
  mounted: function mounted() {
    var _this = this;

    nextTick(function () {
      var getTarget = _this.target || getDefaultTarget;
      _this.scrollEvent = addEventListener(getTarget(), 'scroll', _this.handleScroll);

      _this.handleScroll();
    });
  },
  beforeUnmount: function beforeUnmount() {
    if (this.scrollEvent) {
      this.scrollEvent.remove();
    }
  },
  methods: {
    getCurrentScrollTop: function getCurrentScrollTop() {
      var getTarget = this.target || getDefaultTarget;
      var targetNode = getTarget();

      if (targetNode === window) {
        return window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop;
      }

      return targetNode.scrollTop;
    },
    scrollToTop: function scrollToTop(e) {
      var _this$target = this.target,
          target = _this$target === void 0 ? getDefaultTarget : _this$target;
      scrollTo(0, {
        getContainer: target
      });
      this.$emit('click', e);
    },
    handleScroll: function handleScroll() {
      var visibilityHeight = this.visibilityHeight,
          _this$target2 = this.target,
          target = _this$target2 === void 0 ? getDefaultTarget : _this$target2;
      var scrollTop = getScroll(target(), true);
      this.setState({
        visible: scrollTop > visibilityHeight
      });
    }
  },
  render: function render() {
    var _a;

    var customizePrefixCls = this.prefixCls,
        $slots = this.$slots;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('back-top', customizePrefixCls);
    var classString = classNames(prefixCls, this.$attrs.class);

    var defaultElement = _createVNode("div", {
      "class": "".concat(prefixCls, "-content")
    }, [_createVNode("div", {
      "class": "".concat(prefixCls, "-icon")
    }, null)]);

    var divProps = _extends(_extends({}, this.$attrs), {
      onClick: this.scrollToTop,
      class: classString
    });

    var backTopBtn = this.visible ? _createVNode("div", divProps, [((_a = $slots.default) === null || _a === void 0 ? void 0 : _a.call($slots)) || defaultElement]) : null;
    var transitionProps = getTransitionProps('fade');
    return _createVNode(Transition, transitionProps, _isSlot(backTopBtn) ? backTopBtn : {
      default: function _default() {
        return [backTopBtn];
      }
    });
  }
});
export default withInstall(BackTop);