import { isVNode as _isVNode, createVNode as _createVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import BaseMixin from '../_util/BaseMixin';
import omit from 'omit.js';
import { cloneElement } from '../_util/vnode';
import { defaultConfigProvider } from '../config-provider';
import { defineComponent, inject } from 'vue';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

function getNumberArray(num) {
  return num ? num.toString().split('').reverse().map(function (i) {
    var current = Number(i);
    return isNaN(current) ? i : current;
  }) : [];
}

var ScrollNumberProps = {
  prefixCls: PropTypes.string,
  count: PropTypes.any,
  component: PropTypes.string,
  title: PropTypes.oneOfType([PropTypes.number, PropTypes.string, null]),
  displayComponent: PropTypes.any,
  onAnimated: PropTypes.func
};
export default defineComponent({
  name: 'ScrollNumber',
  mixins: [BaseMixin],
  inheritAttrs: false,
  props: ScrollNumberProps,
  emits: ['animated'],
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider),
      lastCount: undefined,
      timeout: undefined
    };
  },
  data: function data() {
    return {
      animateStarted: true,
      sCount: this.count
    };
  },
  watch: {
    count: function count() {
      this.lastCount = this.sCount;
      this.setState({
        animateStarted: true
      });
    }
  },
  updated: function updated() {
    var _this = this;

    var animateStarted = this.animateStarted,
        count = this.count;

    if (animateStarted) {
      this.clearTimeout(); // Let browser has time to reset the scroller before actually
      // performing the transition.

      this.timeout = setTimeout(function () {
        _this.setState({
          animateStarted: false,
          sCount: count
        }, _this.handleAnimated);
      });
    }
  },
  beforeUnmount: function beforeUnmount() {
    this.clearTimeout();
  },
  methods: {
    clearTimeout: function (_clearTimeout) {
      function clearTimeout() {
        return _clearTimeout.apply(this, arguments);
      }

      clearTimeout.toString = function () {
        return _clearTimeout.toString();
      };

      return clearTimeout;
    }(function () {
      if (this.timeout) {
        clearTimeout(this.timeout);
        this.timeout = undefined;
      }
    }),
    getPositionByNum: function getPositionByNum(num, i) {
      var sCount = this.sCount;
      var currentCount = Math.abs(Number(sCount));
      var lastCount = Math.abs(Number(this.lastCount));
      var currentDigit = Math.abs(getNumberArray(sCount)[i]);
      var lastDigit = Math.abs(getNumberArray(this.lastCount)[i]);

      if (this.animateStarted) {
        return 10 + num;
      } // 同方向则在同一侧切换数字


      if (currentCount > lastCount) {
        if (currentDigit >= lastDigit) {
          return 10 + num;
        }

        return 20 + num;
      }

      if (currentDigit <= lastDigit) {
        return 10 + num;
      }

      return num;
    },
    handleAnimated: function handleAnimated() {
      this.$emit('animated');
    },
    renderNumberList: function renderNumberList(position, className) {
      var childrenToReturn = [];

      for (var i = 0; i < 30; i++) {
        childrenToReturn.push(_createVNode("p", {
          "key": i.toString(),
          "class": classNames(className, {
            current: position === i
          })
        }, [i % 10]));
      }

      return childrenToReturn;
    },
    renderCurrentNumber: function renderCurrentNumber(prefixCls, num, i) {
      if (typeof num === 'number') {
        var position = this.getPositionByNum(num, i);
        var removeTransition = this.animateStarted || getNumberArray(this.lastCount)[i] === undefined;
        var style = {
          transition: removeTransition ? 'none' : undefined,
          msTransform: "translateY(".concat(-position * 100, "%)"),
          WebkitTransform: "translateY(".concat(-position * 100, "%)"),
          transform: "translateY(".concat(-position * 100, "%)")
        };
        return _createVNode("span", {
          "class": "".concat(prefixCls, "-only"),
          "style": style,
          "key": i
        }, [this.renderNumberList(position, "".concat(prefixCls, "-only-unit"))]);
      }

      return _createVNode("span", {
        "key": "symbol",
        "class": "".concat(prefixCls, "-symbol")
      }, _isSlot(num) ? num : {
        default: function _default() {
          return [num];
        }
      });
    },
    renderNumberElement: function renderNumberElement(prefixCls) {
      var _this2 = this;

      var sCount = this.sCount;

      if (sCount && Number(sCount) % 1 === 0) {
        return getNumberArray(sCount).map(function (num, i) {
          return _this2.renderCurrentNumber(prefixCls, num, i);
        }).reverse();
      }

      return sCount;
    }
  },
  render: function render() {
    var _slot;

    var customizePrefixCls = this.prefixCls,
        title = this.title,
        _this$component = this.component,
        Tag = _this$component === void 0 ? 'sup' : _this$component,
        displayComponent = this.displayComponent;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('scroll-number', customizePrefixCls);
    var _this$$attrs = this.$attrs,
        className = _this$$attrs.class,
        _this$$attrs$style = _this$$attrs.style,
        style = _this$$attrs$style === void 0 ? {} : _this$$attrs$style;

    if (displayComponent) {
      return cloneElement(displayComponent, {
        class: classNames("".concat(prefixCls, "-custom-component"), displayComponent.props && displayComponent.props.class)
      });
    } // fix https://fb.me/react-unknown-prop


    var restProps = omit(_extends(_extends({}, this.$props), this.$attrs), ['count', 'onAnimated', 'component', 'prefixCls', 'displayComponent']);

    var tempStyle = _extends({}, style);

    var newProps = _extends(_extends({}, restProps), {
      title: title,
      style: tempStyle,
      class: classNames(prefixCls, className)
    }); // allow specify the border
    // mock border-color by box-shadow for compatible with old usage:
    // <Badge count={4} style={{ backgroundColor: '#fff', color: '#999', borderColor: '#d9d9d9' }} />


    if (style && style.borderColor) {
      newProps.style.boxShadow = "0 0 0 1px ".concat(style.borderColor, " inset");
    }

    return _createVNode(Tag, newProps, _isSlot(_slot = this.renderNumberElement(prefixCls)) ? _slot : {
      default: function _default() {
        return [_slot];
      }
    });
  }
});