import { isVNode as _isVNode, createVNode as _createVNode } from "vue";
import { defineComponent, inject } from 'vue';
import PropTypes from '../_util/vue-types';
import { hasProp, getComponent, getSlot } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import DropDown from '../dropdown/dropdown';
import DownOutlined from '@ant-design/icons-vue/DownOutlined';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export default defineComponent({
  name: 'ABreadcrumbItem',
  __ANT_BREADCRUMB_ITEM: true,
  props: {
    prefixCls: PropTypes.string,
    href: PropTypes.string,
    separator: PropTypes.VNodeChild.def('/'),
    overlay: PropTypes.VNodeChild
  },
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  methods: {
    /**
     * if overlay is have
     * Wrap a DropDown
     */
    renderBreadcrumbNode: function renderBreadcrumbNode(breadcrumbItem, prefixCls) {
      var overlay = getComponent(this, 'overlay');

      if (overlay) {
        var _slot;

        return _createVNode(DropDown, {
          "overlay": overlay,
          "placement": "bottomCenter"
        }, _isSlot(_slot = _createVNode("span", {
          "class": "".concat(prefixCls, "-overlay-link")
        }, [breadcrumbItem, _createVNode(DownOutlined, null, null)])) ? _slot : {
          default: function _default() {
            return [_slot];
          }
        });
      }

      return breadcrumbItem;
    }
  },
  render: function render() {
    var customizePrefixCls = this.prefixCls;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('breadcrumb', customizePrefixCls);
    var separator = getComponent(this, 'separator');
    var children = getSlot(this);
    var link;

    if (hasProp(this, 'href')) {
      link = _createVNode("a", {
        "class": "".concat(prefixCls, "-link")
      }, _isSlot(children) ? children : {
        default: function _default() {
          return [children];
        }
      });
    } else {
      link = _createVNode("span", {
        "class": "".concat(prefixCls, "-link")
      }, _isSlot(children) ? children : {
        default: function _default() {
          return [children];
        }
      });
    } // wrap to dropDown


    link = this.renderBreadcrumbNode(link, prefixCls);

    if (children) {
      return _createVNode("span", null, [link, separator && separator !== '' && _createVNode("span", {
        "class": "".concat(prefixCls, "-separator")
      }, _isSlot(separator) ? separator : {
        default: function _default() {
          return [separator];
        }
      })]);
    }

    return null;
  }
});