import { createVNode as _createVNode, isVNode as _isVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { defineComponent, inject } from 'vue';
import PropTypes from '../_util/vue-types';
import { getComponent } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export default defineComponent({
  name: 'ACardMeta',
  props: {
    prefixCls: PropTypes.string,
    title: PropTypes.VNodeChild,
    description: PropTypes.VNodeChild,
    avatar: PropTypes.VNodeChild
  },
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  render: function render() {
    var customizePrefixCls = this.$props.prefixCls;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('card', customizePrefixCls);

    var classString = _defineProperty({}, "".concat(prefixCls, "-meta"), true);

    var avatar = getComponent(this, 'avatar');
    var title = getComponent(this, 'title');
    var description = getComponent(this, 'description');
    var avatarDom = avatar ? _createVNode("div", {
      "class": "".concat(prefixCls, "-meta-avatar")
    }, _isSlot(avatar) ? avatar : {
      default: function _default() {
        return [avatar];
      }
    }) : null;
    var titleDom = title ? _createVNode("div", {
      "class": "".concat(prefixCls, "-meta-title")
    }, _isSlot(title) ? title : {
      default: function _default() {
        return [title];
      }
    }) : null;
    var descriptionDom = description ? _createVNode("div", {
      "class": "".concat(prefixCls, "-meta-description")
    }, _isSlot(description) ? description : {
      default: function _default() {
        return [description];
      }
    }) : null;
    var MetaDetail = titleDom || descriptionDom ? _createVNode("div", {
      "class": "".concat(prefixCls, "-meta-detail")
    }, [titleDom, descriptionDom]) : null;
    return _createVNode("div", {
      "class": classString
    }, [avatarDom, MetaDetail]);
  }
});