import { createVNode as _createVNode, isVNode as _isVNode } from "vue";
import { defineComponent, inject } from 'vue';
import PropsTypes from '../_util/vue-types';
import { getComponent, getSlot } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import { withInstall } from '../_util/type';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export var CommentProps = {
  actions: PropsTypes.array,

  /** The element to display as the comment author. */
  author: PropsTypes.VNodeChild,

  /** The element to display as the comment avatar - generally an antd Avatar */
  avatar: PropsTypes.VNodeChild,

  /** The main content of the comment */
  content: PropsTypes.VNodeChild,

  /** Comment prefix defaults to '.ant-comment' */
  prefixCls: PropsTypes.string,

  /** A datetime element containing the time to be displayed */
  datetime: PropsTypes.VNodeChild
};
var Comment = defineComponent({
  name: 'AComment',
  props: CommentProps,
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  methods: {
    getAction: function getAction(actions) {
      if (!actions || !actions.length) {
        return null;
      }

      var actionList = actions.map(function (action, index) {
        return _createVNode("li", {
          "key": "action-".concat(index)
        }, _isSlot(action) ? action : {
          default: function _default() {
            return [action];
          }
        });
      });
      return actionList;
    },
    renderNested: function renderNested(prefixCls, children) {
      return _createVNode("div", {
        "class": "".concat(prefixCls, "-nested")
      }, _isSlot(children) ? children : {
        default: function _default() {
          return [children];
        }
      });
    }
  },
  render: function render() {
    var customizePrefixCls = this.$props.prefixCls;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('comment', customizePrefixCls);
    var actions = getComponent(this, 'actions');
    var author = getComponent(this, 'author');
    var avatar = getComponent(this, 'avatar');
    var content = getComponent(this, 'content');
    var datetime = getComponent(this, 'datetime');

    var avatarDom = _createVNode("div", {
      "class": "".concat(prefixCls, "-avatar")
    }, [typeof avatar === 'string' ? _createVNode("img", {
      "src": avatar,
      "alt": "comment-avatar"
    }, null) : avatar]);

    var actionDom = actions ? _createVNode("ul", {
      "class": "".concat(prefixCls, "-actions")
    }, [this.getAction(Array.isArray(actions) ? actions : [actions])]) : null;

    var authorContent = _createVNode("div", {
      "class": "".concat(prefixCls, "-content-author")
    }, [author && _createVNode("span", {
      "class": "".concat(prefixCls, "-content-author-name")
    }, _isSlot(author) ? author : {
      default: function _default() {
        return [author];
      }
    }), datetime && _createVNode("span", {
      "class": "".concat(prefixCls, "-content-author-time")
    }, _isSlot(datetime) ? datetime : {
      default: function _default() {
        return [datetime];
      }
    })]);

    var contentDom = _createVNode("div", {
      "class": "".concat(prefixCls, "-content")
    }, [authorContent, _createVNode("div", {
      "class": "".concat(prefixCls, "-content-detail")
    }, _isSlot(content) ? content : {
      default: function _default() {
        return [content];
      }
    }), actionDom]);

    var comment = _createVNode("div", {
      "class": "".concat(prefixCls, "-inner")
    }, [avatarDom, contentDom]);

    var children = getSlot(this);
    return _createVNode("div", {
      "class": prefixCls
    }, [comment, children && children.length ? this.renderNested(prefixCls, children) : null]);
  }
});
export default withInstall(Comment);