import { createVNode as _createVNode, isVNode as _isVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

import { inject, ref, defineComponent, onMounted, onBeforeUnmount } from 'vue';
import warning from '../_util/warning';
import ResponsiveObserve, { responsiveArray } from '../_util/responsiveObserve';
import { defaultConfigProvider } from '../config-provider';
import Row from './Row';
import PropTypes from '../_util/vue-types';
import { tuple } from '../_util/type';
import { cloneElement } from '../_util/vnode';
import { filterEmpty } from '../_util/props-util';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export var DescriptionsItemProps = {
  prefixCls: PropTypes.string,
  label: PropTypes.any,
  span: PropTypes.number
};
export var DescriptionsItem = defineComponent({
  name: 'ADescriptionsItem',
  props: {
    prefixCls: PropTypes.string,
    label: PropTypes.VNodeChild,
    span: PropTypes.number.def(1)
  },
  render: function render() {
    return null;
  }
});
var DEFAULT_COLUMN_MAP = {
  xxl: 3,
  xl: 3,
  lg: 3,
  md: 3,
  sm: 2,
  xs: 1
};

function getColumn(column, screens) {
  if (typeof column === 'number') {
    return column;
  }

  if (_typeof(column) === 'object') {
    for (var i = 0; i < responsiveArray.length; i++) {
      var breakpoint = responsiveArray[i];

      if (screens[breakpoint] && column[breakpoint] !== undefined) {
        return column[breakpoint] || DEFAULT_COLUMN_MAP[breakpoint];
      }
    }
  }

  return 3;
}

function getFilledItem(node, span, rowRestCol) {
  var clone = node;

  if (span === undefined || span > rowRestCol) {
    clone = cloneElement(node, {
      span: rowRestCol
    });
    warning(span === undefined, 'Descriptions', 'Sum of column `span` in a line not match `column` of Descriptions.');
  }

  return clone;
}

function getRows(children, column) {
  var childNodes = filterEmpty(children);
  var rows = [];
  var tmpRow = [];
  var rowRestCol = column;
  childNodes.forEach(function (node, index) {
    var _a;

    var span = (_a = node.props) === null || _a === void 0 ? void 0 : _a.span;
    var mergedSpan = span || 1; // Additional handle last one

    if (index === childNodes.length - 1) {
      tmpRow.push(getFilledItem(node, span, rowRestCol));
      rows.push(tmpRow);
      return;
    }

    if (mergedSpan < rowRestCol) {
      rowRestCol -= mergedSpan;
      tmpRow.push(node);
    } else {
      tmpRow.push(getFilledItem(node, mergedSpan, rowRestCol));
      rows.push(tmpRow);
      rowRestCol = column;
      tmpRow = [];
    }
  });
  return rows;
}

var descriptionsProps = {
  prefixCls: PropTypes.string,
  bordered: PropTypes.looseBool,
  size: PropTypes.oneOf(tuple('default', 'middle', 'small')).def('default'),
  title: PropTypes.VNodeChild,
  extra: PropTypes.VNodeChild,
  column: {
    type: [Number, Object],
    default: function _default() {
      return DEFAULT_COLUMN_MAP;
    }
  },
  layout: PropTypes.oneOf(tuple('horizontal', 'vertical')),
  colon: PropTypes.looseBool
};
var Descriptions = defineComponent({
  name: 'ADescriptions',
  Item: DescriptionsItem,
  setup: function setup(props, _ref) {
    var slots = _ref.slots;

    var _inject = inject('configProvider', defaultConfigProvider),
        getPrefixCls = _inject.getPrefixCls;

    var token;
    var screens = ref({});
    onMounted(function () {
      token = ResponsiveObserve.subscribe(function (screen) {
        if (_typeof(props.column) !== 'object') {
          return;
        }

        screens.value = screen;
      });
    });
    onBeforeUnmount(function () {
      ResponsiveObserve.unsubscribe(token);
    });
    return function () {
      var _ref2;

      var _a, _b, _c;

      var customizePrefixCls = props.prefixCls,
          column = props.column,
          size = props.size,
          _props$bordered = props.bordered,
          bordered = _props$bordered === void 0 ? false : _props$bordered,
          _props$layout = props.layout,
          layout = _props$layout === void 0 ? 'horizontal' : _props$layout,
          _props$colon = props.colon,
          colon = _props$colon === void 0 ? true : _props$colon,
          _props$title = props.title,
          title = _props$title === void 0 ? (_a = slots.title) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$title,
          _props$extra = props.extra,
          extra = _props$extra === void 0 ? (_b = slots.extra) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$extra;
      var prefixCls = getPrefixCls('descriptions', customizePrefixCls);
      var mergeColumn = getColumn(column, screens.value);
      var children = (_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots);
      var rows = getRows(children, mergeColumn);
      return _createVNode("div", {
        "class": [prefixCls, (_ref2 = {}, _defineProperty(_ref2, "".concat(prefixCls, "-").concat(size), size !== 'default'), _defineProperty(_ref2, "".concat(prefixCls, "-bordered"), !!bordered), _ref2)]
      }, [(title || extra) && _createVNode("div", {
        "class": "".concat(prefixCls, "-header")
      }, [_createVNode("div", {
        "class": "".concat(prefixCls, "-title")
      }, _isSlot(title) ? title : {
        default: function _default() {
          return [title];
        }
      }), _createVNode("div", {
        "class": "".concat(prefixCls, "-extra")
      }, _isSlot(extra) ? extra : {
        default: function _default() {
          return [extra];
        }
      })]), _createVNode("div", {
        "class": "".concat(prefixCls, "-view")
      }, [_createVNode("table", null, [_createVNode("tbody", null, [rows.map(function (row, index) {
        return _createVNode(Row, {
          "key": index,
          "index": index,
          "colon": colon,
          "prefixCls": prefixCls,
          "vertical": layout === 'vertical',
          "bordered": bordered,
          "row": row
        }, null);
      })])])])]);
    };
  }
});
Descriptions.props = descriptionsProps;

Descriptions.install = function (app) {
  app.component(Descriptions.name, Descriptions);
  app.component(Descriptions.Item.name, Descriptions.Item);
  return app;
};

export default Descriptions;