import { createVNode as _createVNode, isVNode as _isVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { flattenChildren } from '../_util/props-util';
import { computed, defineComponent, inject } from 'vue';
import { defaultConfigProvider } from '../config-provider';
import { withInstall } from '../_util/type';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

var Divider = defineComponent({
  name: 'ADivider',
  props: {
    prefixCls: String,
    type: {
      type: String,
      default: 'horizontal'
    },
    dashed: {
      type: Boolean,
      default: false
    },
    orientation: {
      type: String,
      default: 'center'
    }
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots;

    var _inject = inject('configProvider', defaultConfigProvider),
        getPrefixCls = _inject.getPrefixCls;

    var prefixCls = computed(function () {
      return getPrefixCls('divider', props.prefixCls);
    });
    var classString = computed(function () {
      var _ref2;

      var type = props.type,
          dashed = props.dashed,
          orientation = props.orientation;
      var orientationPrefix = orientation.length > 0 ? '-' + orientation : orientation;
      var prefixClsRef = prefixCls.value;
      return _ref2 = {}, _defineProperty(_ref2, prefixClsRef, true), _defineProperty(_ref2, "".concat(prefixClsRef, "-").concat(type), true), _defineProperty(_ref2, "".concat(prefixClsRef, "-with-text").concat(orientationPrefix), slots.default), _defineProperty(_ref2, "".concat(prefixClsRef, "-dashed"), !!dashed), _ref2;
    });
    return function () {
      var _a;

      var children = flattenChildren((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots));
      return _createVNode("div", {
        "class": classString.value,
        "role": "separator"
      }, [children.length ? _createVNode("span", {
        "class": "".concat(prefixCls.value, "-inner-text")
      }, _isSlot(children) ? children : {
        default: function _default() {
          return [children];
        }
      }) : null]);
    };
  }
});
export default withInstall(Divider);